//
// Timer class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package
package ptc;



public class Timer implements ptc.base.Timer
{
    public Timer() throws Error
    {
        // initialize factory
        Factory.initialize();

        // create timer object
        timer = Factory.timer();
    }

    public Timer(double time) throws Error
    {
        // initialize factory
        Factory.initialize();

        // create timer
        timer = Factory.timer();

        // set time
        timer.set(time);
    }
    
    protected void finalize() throws Error
    {
        // free factory
        Factory.free();

        // null timer
        timer = null;
    }

    public void set(double time) throws Error
    {
        // set time
        timer.set(time);
    }

    public void start() throws Error
    {
        // start timer
        timer.start();
    }

    public void stop() throws Error
    {
        // stop timer
        timer.stop();
    }

    public double time() throws Error
    {
        // get timer time
        return timer.time();
    }

    public double delta() throws Error
    {
        // get timer delta
        return timer.delta();
    }

    public double resolution() throws Error
    {
        // get timer resolution
        return timer.resolution();
    }

    // internal timer object
    private ptc.base.Timer timer;
}
