/*
 * Decompiled with CFR 0.152.
 */
package gl4java.awt;

import gl4java.awt.GLCanvas;
import gl4java.utils.Tool;
import gl4java.utils.textures.AWTTextureLoader;
import gl4java.utils.textures.PPMAsciiTextureLoader;
import gl4java.utils.textures.PngTextureLoader;
import gl4java.utils.textures.TGATextureLoader;
import gl4java.utils.textures.TextureGrabber;
import gl4java.utils.textures.TextureLoader;
import java.awt.Dimension;
import java.awt.Window;
import java.net.URL;

public class GLImageCanvas
extends GLCanvas {
    int[] texName = new int[1];
    TextureLoader txtLoader = null;
    boolean newText = false;
    boolean keepAspect = true;
    boolean zoomImg = true;
    TextureGrabber textGrab4Snapshot = null;
    String textGrab4SnapshotFName = null;
    URL textGrab4SnapshotURL = null;
    String textGrab4SnapshotURI = null;
    private int reshape_resize_sema = 1;

    public GLImageCanvas(int n, int n2) {
        super(n, n2);
    }

    protected void DrawObj(boolean bl) {
        this.gl.glPushMatrix();
        if (bl) {
            this.gl.glEnable(3042);
            this.gl.glBlendFunc(770, 771);
        }
        this.gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.txtLoader != null && this.txtLoader.isOk()) {
            this.gl.glEnable(3553);
            this.gl.glBegin(7);
            this.gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this.gl.glTexCoord2f(0.0f, 0.0f);
            this.gl.glVertex2f(0.0f, 0.0f);
            this.gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this.gl.glTexCoord2f(0.0f, 1.0f);
            this.gl.glVertex2f(0.0f, 1.0f);
            this.gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this.gl.glTexCoord2f(1.0f, 1.0f);
            this.gl.glVertex2f(1.0f, 1.0f);
            this.gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this.gl.glTexCoord2f(1.0f, 0.0f);
            this.gl.glVertex2f(1.0f, 0.0f);
            this.gl.glEnd();
            this.gl.glDisable(3553);
        }
        if (bl) {
            this.gl.glDisable(3042);
        }
        this.gl.glPopMatrix();
    }

    protected void SetCamera() {
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.txtLoader != null && this.txtLoader.isOk()) {
            Dimension dimension = new Dimension(this.txtLoader.getImageWidth(), this.txtLoader.getImageHeight());
            Dimension dimension2 = new Dimension(this.txtLoader.getTextureWidth(), this.txtLoader.getTextureHeight());
            f = (float)dimension.width / (float)dimension2.width;
            f2 = (float)dimension.height / (float)dimension2.height;
        }
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, f, 0.0, f2);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
    }

    public void display() {
        if (!this.glj.gljMakeCurrent()) {
            System.out.println("problem in use() method");
            return;
        }
        this.SetCamera();
        this.gl.glClear(16640);
        this.DrawObj(false);
        if (this.textGrab4Snapshot != null) {
            this.textGrab4Snapshot.grabPixels(1029, 0, 0, this.cvsGetWidth(), this.cvsGetHeight());
            if (this.textGrab4SnapshotFName != null) {
                this.textGrab4Snapshot.write2File(this.textGrab4SnapshotFName);
            } else {
                this.textGrab4Snapshot.write2File(this.textGrab4SnapshotURL, this.textGrab4SnapshotURI);
            }
            this.textGrab4Snapshot = null;
            this.textGrab4SnapshotFName = null;
            this.textGrab4SnapshotURL = null;
            this.textGrab4SnapshotURI = null;
        }
        this.glj.gljSwap();
        this.glj.gljCheckGL();
        this.glj.gljFree();
    }

    public boolean getKeepAspectRatio() {
        return this.keepAspect;
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public TextureLoader getTextureLoader() {
        return this.txtLoader;
    }

    public boolean getZoomAble() {
        return this.zoomImg;
    }

    public void init() {
        this.gl.glEnable(3553);
        this.gl.glGenTextures(1, this.texName);
        this.gl.glBindTexture(3553, this.texName[0]);
        this.gl.glTexParameteri(3553, 10242, 10496);
        this.gl.glTexParameteri(3553, 10243, 10496);
        this.gl.glTexParameteri(3553, 10240, 9729);
        this.gl.glTexParameteri(3553, 10241, 9729);
        this.gl.glTexEnvf(8960, 8704, 8448.0f);
        this.gl.glShadeModel(7425);
        this.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        this.reshape(this.getSize().width, this.getSize().height);
    }

    protected void internalSetSize(int n, int n2) {
        this.setSize(n, n2);
        this.invalidate();
        Window window = Tool.getWindow(this);
        if (window != null) {
            window.invalidate();
            window.pack();
            window.repaint();
        }
    }

    public boolean loadTexture(String string, String string2) {
        return this.loadTexture(string, null, null, string2);
    }

    protected boolean loadTexture(String string, URL uRL, String string2, String string3) {
        boolean bl = true;
        if (!this.glj.gljMakeCurrent()) {
            System.out.println("problem in use() method");
            return false;
        }
        if (string3.equals("png")) {
            this.txtLoader = new PngTextureLoader(this.gl, this.glu);
        } else if (string3.equals("ppm")) {
            this.txtLoader = new PPMAsciiTextureLoader(this.gl, this.glu);
        } else if (string3.equals("tga")) {
            this.txtLoader = new TGATextureLoader(this.gl, this.glu);
        } else if (string3.equals("any")) {
            this.txtLoader = new AWTTextureLoader(this, this.gl, this.glu);
        } else {
            System.out.println("Imagetype: " + string3 + " is currently not supported !");
            bl = false;
        }
        if (bl) {
            try {
                if (string != null) {
                    this.txtLoader.readTexture(string);
                } else {
                    this.txtLoader.readTexture(uRL, string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl && this.txtLoader.isOk()) {
            this.gl.glEnable(3553);
            this.txtLoader.texImage2DNonScaled(true);
            this.gl.glDisable(3553);
            System.out.println("texture succesfully loaded !");
            System.out.println("texture: " + this.txtLoader);
        }
        this.glj.gljCheckGL();
        this.glj.gljFree();
        if (bl) {
            this.internalSetSize(this.txtLoader.getImageWidth(), this.txtLoader.getImageHeight());
        }
        return bl;
    }

    public boolean loadTexture(URL uRL, String string, String string2) {
        return this.loadTexture(null, uRL, string, string2);
    }

    public void preInit() {
    }

    public void reshape(int n, int n2) {
        if (this.reshape_resize_sema > 0 && this.keepAspect && this.txtLoader != null && this.txtLoader.isOk()) {
            --this.reshape_resize_sema;
            int n3 = n;
            int n4 = n2;
            if (this.zoomImg) {
                double d = (double)this.txtLoader.getImageWidth() / (double)this.txtLoader.getImageHeight();
                if (n3 < n4) {
                    n2 = (int)((double)n3 / d + 0.5);
                } else {
                    n = (int)((double)n4 * d + 0.5);
                }
            } else {
                n = this.txtLoader.getImageWidth();
                n2 = this.txtLoader.getImageHeight();
            }
            if (n3 != n || n4 != n2) {
                this.internalSetSize(n, n2);
                return;
            }
        }
        this.reshape_resize_sema = 1;
        this.gl.glViewport(0, 0, n, n2);
        this.SetCamera();
    }

    public void setKeepAspectRatio(boolean bl) {
        this.keepAspect = bl;
    }

    public void setOriginalSize() {
        if (this.txtLoader != null && this.txtLoader.isOk()) {
            this.internalSetSize(this.txtLoader.getImageWidth(), this.txtLoader.getImageHeight());
        }
    }

    public void setZoomAble(boolean bl) {
        this.zoomImg = bl;
    }

    public void snapshot(TextureGrabber textureGrabber, String string) {
        this.textGrab4Snapshot = textureGrabber;
        this.textGrab4SnapshotFName = string;
        this.repaint();
    }

    public void snapshot(TextureGrabber textureGrabber, URL uRL, String string) {
        this.textGrab4Snapshot = textureGrabber;
        this.textGrab4SnapshotURL = uRL;
        this.textGrab4SnapshotURI = string;
        this.repaint();
    }
}

