;            ͻ
;                  USS.ASM          
;                                                               
;                           Useless Sound System                
;            ĺ
;               by Freddy Vtel (FreddyV/Useless)              
;                                                               
;               Code starts .................. 13/03/1996       
;               Last Update .................. 27/07/1997       
;            ͼ
.386p
INCLUDE OS.INC

CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32

INCLUDE SETUP.INC

INCLUDE USS.INC
INCLUDE ERR_CODE.INC

INCLUDE USSVAR.INC

INCLUDE HARDWARE.INC ; Used in SETUP for the ZeroOffset definition.
INCLUDE MEMORY.INC   ; Used in the SETUP proc.
INCLUDE UTILS.INC    ; All display functions (can be remove if no debug

                     ;                        display is used           )

FullControl Equ No   ; Control all parameters (for debug)

; ********** DEVICES LIST **********
If UseIW  Eq Yes
   EXTRN IW_DEVICE
EndIf
If UseGUS Eq Yes
   EXTRN GUS_DEVICE
EndIf
If UseSB Eq Yes
   EXTRN SB_DEVICE
EndIf
If UseHP Eq Yes
   EXTRN HP_DEVICE
EndIf
If UseNoSnd Eq Yes
   EXTRN NOSND_DEVICE
EndIf

NoDev_Name DB 'No device',0,'$'

DEVList Label Dword
If UseIW  Eq Yes
        DD Offset IW_DEVICE
EndIf
If UseGUS Eq Yes
        DD Offset GUS_DEVICE
EndIf
If UseSB Eq Yes
        DD Offset SB_DEVICE
EndIf
If UseHP Eq Yes
        DD Offset HP_DEVICE
EndIf
If UseNoSnd Eq Yes
        DD Offset NOSND_DEVICE
EndIf
        DD 0

; ********** DEVICES LIST ********** (End)

;=============================================================================

DEVICE_DRIVER Struc
              D_Init        DD ?
              D_LoadSample  DD ?
              D_FreeSample  DD ?
              D_SetAmpli    DD ?
              D_StartOutput DD ?
              D_StopOutput  DD ?
              D_UpdateSound DD ?

              D_TotalDev    DW ?
              D_PortList    DD ?
              D_DevName     DD ?
DEVICE_DRIVER Ends

DevOffset DD 0

BestDev  DW 0
TotalDev DW 0

SS_Started DB 0  ; 1 if sound output is started.

USS_PeriodicProc DD 0

SinTab  DB   0,  6, 12, 18, 24, 31, 37, 43, 49, 55, 61, 68, 74, 79, 85, 91
        DB  97,103,109,114,120,125,131,136,141,146,151,156,161,166,171,175
        DB 180,184,188,193,197,201,204,208,212,215,218,221,224,227,230,233
        DB 235,237,240,242,244,245,247,248,250,251,252,253,253,254,254,254
        DB 255,254,245,254,253,253,252,251,250,248,247,245,244,242,240,237
        DB 235,233,230,227,224,221,218,215,212,208,204,201,197,193,188,184
        DB 180,175,171,166,161,156,151,146,141,136,131,125,120,114,109,103
        DB  97, 91, 85, 79 ,74, 68, 61, 55, 49, 43, 37, 31, 24, 18, 12,  6

;=============================================================================
;=                        USS Setup variables
;=============================================================================

If UseSetup Eq Yes

SelectBuffer DD 0

MAXLines EQU 18
NbLines          DW 0
SelectLinePos    DD 0
SelectStrPos     DD 0
CurrentSize      DW 0
SDEV_Number      DW 0

CenterAttrib EQU 23*256

TopStr    DB 'Useless Sound System v',USMP_Version,' setup',0
TopStrPos EQU (25)*2
TopAttrib EQU 49*256

BStr    DB '(c) 1996-1997 FreddyV/Useless',0
BStrPos EQU (24*80)*2
BAttrib EQU 49*256

SelectAttrib    EQU 113*256
HighlightAttrib EQU 49*256

SOutputPos       EQU (24+3*80)*2
SOutputSize      EQU 32
SOutputStr       DB  'Select sound output',0
SOutputStrPos    EQU (SOutputPos+80*2)+7*2
SOutputSelectPos EQU (2)*2

SPortPos       EQU (32+3*80)*2
SPortSize      EQU 13
SPortStr       DB  'Select port',0
SPortStrPos    EQU (SPortPos+80*2)+2*2
SPortSelectPos EQU (5)*2

SIRQPos       EQU (32+3*80)*2
SIRQSize      EQU 12
SIRQStr       DB  'Select IRQ',0
SIRQStrPos    EQU (SIRQPos+80*2)+2*2
SIRQSelectPos EQU (5)*2

SDMAPos       EQU (32+3*80)*2
SDMAStr       DB  'Select DMA',0
SDMAStrPos    EQU (SDMAPos+80*2)+2*2
SDMASelectPos EQU (5)*2

SFreqPos       EQU (29+3*80)*2
SFreqStr       DB  'Select mixing rate',0
SFreqStrPos    EQU (SFreqPos+80*2)+2*2
SFreqSelectPos EQU (7)*2

SModePos       EQU (27+3*80)*2
SModeSize      EQU 24
SModeStr       DB  'Select output mode',0
SModeStrPos    EQU (SModePos+80*2)+4*2
SModeSelectPos EQU (2)*2

SAutodetectStr DB 'Autodetect best device',0
SMono    DB 'Mono',0
SStereo  DB 'Stereo',0
SMonoO   DB 'Mono oversampling',0
SStereoO DB 'Stereo oversampling',0

IRQList  DW 2,3,4,5,7,9,10,11,12,15,-1
DMAList  DW 0,1,3,5,6,7,-1
FreqList DW 8000,11025,16000,22050,32000,38000,44100,-1

EndIf
;=============================================================================


;͸
; USS_Setup: Useless sound System Setup interface                         
;                                                                         
; Input: --                                                               
;                                                                         
; Output: CF Set=> Error or quit                                          
;                                                                         
;

If UseSetup Eq Yes
if _WATCOM
USS_Setup_ Proc
else
USS_Setup  Proc
endif
        push ds
        pop es

        cls

        HideCursor

        cld

; ** Draw the setup screen

        mov ax,TopAttrib
        mov ecx,80
        mov edi,0
        call DrawLine

        mov esi,Offset TopStr
        mov edi,TopStrPos
        mov ax,TopAttrib
        call PrintStr

	mov ax,BAttrib
	mov ecx,80
	mov edi,(24*80)*2
	call DrawLine

        mov esi,Offset BStr
        mov edi,BStrPos
        mov ax,BAttrib
        call PrintStr

; ** Do the setup

        call USS_DetectDev      ; Detect the best device
        mov SDEV_Number,bx      ; Default selected device

        U_Malloc 32*20          ; Alloc Memory for 20 selections
        mov SelectBuffer,eax

; 1- Select device

SelectOutput:

        call Setup_ClearCenter

        call PrepareBuffer_Output

        mov NbLines,cx

        mov ax,SelectAttrib
        mov ebx,SOutputSize
        mov CurrentSize,SOutputSize
        mov edx,ecx
        mov edi,SOutputPos
        mov SelectLinePos,edi
        call DrawWindow

        mov esi,Offset SOutputStr
        mov edi,SOutputStrPos
        mov ax,SelectAttrib
        call PrintStr

        mov eax,SOutputSelectPos
        call PrintChoices

        movzx ecx,SDEV_Number
        call DoSelection
        jc USS_NoDev           ; ESC => End

        cmp ecx,0
        jne SelectOutputEnd
        movzx eax,SDEV_Number
        call USS_SelectDev
        jmp USS_SetupEnd

SelectOutputEnd:
        movzx eax,cx
        call USS_SelectDev
        jc SelectOutput

; 2- Select Base Port

SelectPort:

        cmp _DEV_BasePort,-1
        je  SelectDMA

        call Setup_ClearCenter

        mov esi,DEVOffset
        mov esi,D_PortList[esi]
        call PrepareBuffer_Hex

        mov NbLines,cx

        mov ax,SelectAttrib
        mov ebx,SPortSize
        mov CurrentSize,SPortSize
        mov edx,ecx
        mov edi,SPortPos
        mov SelectLinePos,edi
        call DrawWindow

        mov esi,Offset SPortStr
        mov edi,SPortStrPos
        mov ax,SelectAttrib
        call PrintStr

        mov eax,SPortSelectPos
        call PrintChoices

        mov esi,DEVOffset
        mov esi,D_PortList[esi]
        movzx eax,_DEV_BasePort
        call GetNumberPos

        call DoSelection
        jnc SelectPortEnd

        jmp SelectOutput

SelectPortEnd:

        mov esi,DEVOffset
        mov esi,D_PortList[esi]
        mov ax,[esi+2*ecx]
        mov _DEV_BasePort,ax


; 3- Select IRQ number

SelectIRQ:

        cmp _DEV_IRQ,-1
        je  SelectDMA

        call Setup_ClearCenter

        mov esi,Offset IRQList
        call PrepareBuffer_DEC

        mov NbLines,cx

        mov ax,SelectAttrib
        mov ebx,SIRQSize
        mov CurrentSize,SIRQSize
        mov edx,ecx
        mov edi,SIRQPos
        mov SelectLinePos,edi
        call DrawWindow

        mov esi,Offset SIRQStr
        mov edi,SIRQStrPos
        mov ax,SelectAttrib
        call PrintStr

        mov eax,SIRQSelectPos
        call PrintChoices

        movzx eax,_DEV_IRQ
        mov esi,Offset IRQList
        call GetNumberPos

        call DoSelection
        jnc SelectIRQEnd

        jmp SelectOutput

SelectIRQEnd:

        mov ax,IRQList[2*ecx]
        mov _DEV_IRQ,al

; 4- Select DMA number

SelectDMA:
        cmp _DEV_DMA,-1
        je  SelectFreq

        call Setup_ClearCenter

        mov esi,Offset DMAList
        call PrepareBuffer_DEC

        mov NbLines,cx

        mov ax,SelectAttrib
        mov ebx,12
        mov CurrentSize,12
        mov edx,ecx
        mov edi,SDMAPos
        mov SelectLinePos,edi
        call DrawWindow

        mov esi,Offset SDMAStr
        mov edi,SDMAStrPos
        mov ax,SelectAttrib
        call PrintStr

        mov eax,SDMASelectPos
        call PrintChoices

        movzx eax,_DEV_DMA
        mov esi,Offset DMAList
        call GetNumberPos

        call DoSelection
        jnc SelectDMAEnd

        jmp SelectOutput

SelectDMAEnd:

        mov ax,DMAList[2*ecx]
        mov _DEV_DMA,al

; 5- Select mixing rate

SelectFreq:

        cmp _DEV_Freq,-1
        je  SelectMode

        call Setup_ClearCenter

        mov esi,Offset FreqList
        call PrepareBuffer_DEC

        mov NbLines,cx

        mov ax,SelectAttrib
        mov ebx,20
        mov CurrentSize,20
        mov edx,ecx
        mov edi,SFreqPos
        mov SelectLinePos,edi
        call DrawWindow

        mov esi,Offset SFreqStr
        mov edi,SFreqStrPos
        mov ax,SelectAttrib
        call PrintStr

        mov eax,SFreqSelectPos
        call PrintChoices

        movzx eax,_DEV_Freq
        mov esi,Offset FreqList
        call GetNumberPos

        call DoSelection
        jnc SelectFreqEnd

        jmp SelectOutput

SelectFreqEnd:

        mov ax,FreqList[2*ecx]
        mov _DEV_Freq,ax

; Select Output Mode (Mono/Stereo)

SelectMode:

        cmp _DEV_Mode,-1
        je USS_SetupEnd

        test _DEV_Mode,DM_Mixed   ; Select the Mixing Mode only for mixed DEV.
        jz USS_SetupEnd

        call Setup_ClearCenter

        call PrepareBuffer_Mode

        mov NbLines,cx

        mov ax,SelectAttrib
        mov ebx,SModeSize
        mov CurrentSize,SModeSize
        mov edx,ecx
        mov edi,SModePos
        mov SelectLinePos,edi
        call DrawWindow

        mov esi,Offset SModeStr
        mov edi,SModeStrPos
        mov ax,SelectAttrib
        call PrintStr

        mov eax,SModeSelectPos
        call PrintChoices

        mov ecx,0
        test _DEV_Mode,DM_Stereo
        jz SelectDefMono
        inc ecx
SelectDefMono:
        call DoSelection
        jnc SelectModeEnd

        jmp SelectOutput

SelectModeEnd:
        test _DEV_Mode,DM_Stereo
        jnz NoChangeSelection
        shl ecx,1
NoChangeSelection:
        test ecx,1
        jz SetMono
        and _DEV_Mode,Not DM_Mono
        or  _DEV_Mode,DM_Stereo      ; Set Stereo Mode
        jmp SetMonoEnd
SetMono:
        and _DEV_Mode,Not DM_Stereo
        or  _DEV_Mode,DM_Mono        ; Set Mono mode
SetMonoEnd:
        cmp ecx,1
        jbe NoSetOversampling
        or _DEV_Mode,DM_Interp       ; Set Oversampling On
NoSetOverSampling:


USS_SetupEnd:

        U_Free SelectBuffer
        cls
if _WATCOM
        mov _Error_Number,0
Endif
        clc
        ret
USS_NoDev:
        U_Free SelectBuffer
        cls
If _WATCOM
        mov _Error_Number,SE_NoDevice
Endif
        mov _DEV_Number,-1
        stc
        ret
If _WATCOM
USS_Setup_ Endp
else
USS_Setup  Endp
endif

EndIf

;͸
; USS_AutoSetup: Useless sound System Auto Setup                          
;                                                                         
; Input: --                                                               
;                                                                         
; Output: CF Set=> Error                                                  
;                                                                         
;
If UseAutoSetup Eq Yes
if _WATCOM
USS_AutoSetup_ Proc
else
USS_AutoSetup  Proc
endif

        call USS_DetectDev
        mov eax,ebx
        call USS_SelectDev
        ret

if _WATCOM
USS_AutoSetup_ Endp
else
USS_AutoSetup  Endp
endif

EndIf

;͸
; USS_Init                                                                
;                                                                         
; Input: --                                                               
;                                                                         
; Output: --                                                              
;                                                                         
;
USS_Init Proc
        cmp SS_Started,1
        je USS_InitEnd

; ** Clear the USS Variables **

        mov edi,Offset USSVarStart
        mov ecx,Offset USSVarEnd
        sub ecx,edi
        push ds
        pop es
        cld
        xor eax,eax
        rep stosb
USS_InitEnd:
        ret
USS_Init Endp

;͸
; USS_SetActiveChannels                                                   
;                                                                         
; Input: EAX Number of channels to use.                                   
;                                                                         
; Output: CF Set => Error code in EAX.                                    
;                                                                         
;
USS_SetActiveChannels Proc
        cmp eax,MAX_SSCHANNELS
        ja USS_SetActiveChannelsErr

        mov SSActiveChannels,eax

        clc
        ret
USS_SetActiveChannelsErr:
        mov eax,SE_Channels
        stc
        ret
USS_SetActiveChannels Endp

;͸
; USS_StartOutput                                                         
;                                                                         
; Input: ESI Periodic function to call                                    
;                                                                         
; Output: CF Set => Error code in EAX.                                    
;                                                                         
;

USS_StartOutput Proc
        mov eax,SE_NoDevice
        cmp _DEV_Number,-1
        je USS_StartOutputError

        mov eax,SE_Started
        cmp SS_Started,0
        jne USS_StartOutputError

        mov SS_Started,1

; ** Start the Output **

        mov USS_PeriodicProc,esi
        mov edx,DevOffset
        call D_StartOutput[edx]
        jc USS_StartOutputError

USS_StartOutputEnd:
        clc
        ret
USS_StartOutputError:
        stc
        ret
USS_StartOutput Endp

;͸
; USS_StopOutput                                                          
;                                                                         
; Input: --                                                               
;                                                                         
; Output: CF Set => Error in EAX                                          
;                                                                         
;

USS_StopOutput Proc
        mov eax,SE_NoDevice
        cmp _DEV_Number,-1
        je USS_StartOutputError

        cmp SS_Started,1
        jne USS_StartOutputEnd

        mov SS_Started,0

        mov esi,USS_PeriodicProc
        mov edx,DevOffset
        call D_StopOutput[edx]
        jc USS_StopOutputError

USS_StopOutputEnd:
        clc
        ret
USS_StopOutputError:
        stc
        ret
USS_StopOutput Endp

;͸
; USS_LoadSample                                                          
;                                                                         
; Input: EDI Sample structure Offset                                      
;        ESI Sample data Offset                                           
;                                                                         
; Output: CF Set => Error in EAX                                          
;                                                                         
; Warning: it musn't change ebp.                                          
;                                                                         
;

USS_LoadSample Proc
        cmp _DEV_Number,-1
        je USS_LoadSampleEnd
        mov edx,DevOffset
        call D_LoadSample[edx]
USS_LoadSampleEnd:
        ret
USS_LoadSample EndP

;͸
; USS_FreeSample                                                          
;                                                                         
; Input: EDI Sample structure offset                                      
;                                                                         
; Output: --                                                              
;                                                                         
; Change: ?                                                               
;                                                                         
;

USS_FreeSample Proc
        cmp _DEV_Number,-1
        je USS_FreeSampleEnd
        mov edx,DevOffset
        call D_FreeSample[edx]
USS_FreeSampleEnd:
        ret
USS_FreeSample EndP

;͸
; USS_SetAmpli                                                            
;                                                                         
; Input: EAX Amplification value                                          
;                                                                         
; Output: --                                                              
;                                                                         
; Change: ?                                                               
;                                                                         
;

if _WATCOM
USS_SetAmpli_ Proc
else
USS_SetAmpli Proc
endif
        cmp _DEV_Number,-1
        je USS_SetAmpliEnd
        mov edx,DevOffset
        call D_SetAmpli[edx]
USS_SetAmpliEnd:
        ret
if _WATCOM
USS_SetAmpli_ Endp
else
USS_SetAmpli EndP
endif

;͸
; USS_GetGlobalVolume                                                     
;                                                                         
; Input: --                                                               
;                                                                         
; Output: EAX Global Volume                                               
;                                                                         
;

USS_GetGlobalVolume Proc
        movzx eax,SSGlobalVol
        ret
USS_GetGlobalVolume Endp

;͸
; USS_SetGlobalVolume                                                     
;                                                                         
; Input: AL Global Volume (0-64)                                          
;                                                                         
; Output: --                                                              
;                                                                         
; Change: eax                                                             
;                                                                         
;! Warning: SSActiveChannels must be correctly set before (default=32)   !
;

USS_SetGlobalVolume Proc
        cmp al,80h
        jbe GVolOk
        mov al,80h
GVolOk:
        mov SSGlobalVol,al

; ** Ask to change all Channel volume **
        push edx
        xor edx,edx
USS_SetGlobalVolumeLoop:
        or VChControl[2*edx],CC_ChVolume
        inc edx
        cmp edx,SSActiveChannels
        jne USS_SetGlobalVolumeLoop
        pop edx
        ret
USS_SetGlobalVolume Endp

;͸
; USS_GetChannelVolume: Read global channel volume                        
;                                                                         
; Input: EBP Channel Number                                               
;                                                                         
; Output: AL Volume                                                       
;                                                                         
; Change: eax                                                             
;                                                                         
;

If UseChannelVolume eq Yes

USS_GetChannelVolume Proc
        mov al,VChannelVol[ebp]
        ret
USS_GetChannelVolume Endp

EndIf

;͸
; USS_SetChannelVolume: Write global channel volume                       
;                                                                         
; Input: EBP Channel Number                                               
;        AL  Channel Volume                                               
;                                                                         
; Output: --                                                              
;                                                                         
; Change: eax                                                             
;                                                                         
;

If UseChannelVolume eq Yes

USS_SetChannelVolume Proc

If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
        jae USS_SetChannelVolumeEnd
Endif
        cmp al,40h
        jbe ChVolumeOk
;       dwrite 'Wrong volume'
;       call _dprint_dec
        mov al,40h
ChVolumeOk:
        mov VChannelVol[ebp],al

        or VChControl[2*ebp],CC_ChVolume
USS_SetChannelVolumeEnd:
        clc
        ret
USS_SetChannelVolume Endp

EndIf


;͸
; USS_StartInstrument: Starts an instrument in instrument mode or a sample
;                                                                         
; Input:  EBP Channel Number                                              
;         EAX Instrument/Sample Number (0->MAX-1)                         
;         EBX Note (1->120)                                               
;                                                                         
; Output: --                                                              
;                                                                         
; Change: eax ebx esi                                                     
;                                                                         
;

USS_StartInstrument Proc

If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
        jae USS_StartInstrumentErr
Endif

        or VChControl[2*ebp],CC_StopVoice ; Stop Prev sound before starting one

        or ebx,ebx                      ; ebx = 0 ?
        je USS_StartInstrumentErr       ; Err: Incorrect Note
        cmp ebx,120
        ja USS_StartInstrumentErr       ; Err: Incorrect Note

                                        ; Note in 1-120 => Ok
if UseInstrumentMode Eq Yes     ;*
        cmp SSInstrumentMode,1          ; Sample or Instrument mode ?
        jne _SampleMode

;** Get Instrument Address **
        cmp eax,MAX_Instruments         ; Is Instrument Number correct ?
        jae USS_StartInstrumentErr      ; Err: Incorrect instrument number
        
        mov esi,SSInstrOffsetT
        mov esi,[esi+4*eax]

        or esi,esi                      ; esi=0 ?
        jz USS_StartInstrumentErr       ; Err: No Instrument (Address=0)
        mov VChInsAdress[4*ebp],esi

;** Get Sample Number **
        movzx eax,ISNumber[esi+ebx-1-12] ; @@ a vrifier pour .IT !
        or eax,eax                      ; eax=0 ?
        jz USS_StartInstrumentErr       ; Err: No Sample for this note
        dec eax
endif

;** Get Sample Address **
_SampleMode:
        cmp eax,MAX_Samples             ; Is Sample number correct ?
        jae USS_StartInstrumentErr      ; Err: Incorrect sample number

        mov esi,SSSampleOffsetT
        mov esi,[esi+4*eax]

        or esi,esi                      ; esi=0 ?
        jz USS_StartInstrumentErr       ; Err: No sample (Address=0)
        mov VChSmpAdress[4*ebp],esi     ; Sample Address @@ Verifier les consequences

        call Get_NotePeriod             ; Get note period
        jc USS_StartInstrumentErr       ; Err: can't get the period

        call USS_SetPeriod              ; Set channel period

        test SFlag[esi],SF_Loaded       ; Is sample loaded ?
        jz USS_StartInstrumentErr       ; Err: Sample data not loaded

; ** Get Sample data Offset **
        mov eax,SPointer[esi]           ; eax <- Sample data pointer
        mov VChSmpOffset[4*ebp],eax


        or VChControl[2*ebp],CC_ChSample+CC_ChVolume+CC_Playing

        clc
        ret

USS_StartInstrumentErr:
        stc
        ret
USS_StartInstrument Endp

;͸
; USS_InitInstrEnv                                                        
;                                                                         
; Input: --                                                               
;                                                                         
; Output: --                                                              
;                                                                         
;

USS_InitInstrEnv Proc
        xor eax,eax
        mov VChFadeoutVol[2*ebp],08000h
        mov VChVolEnvPos[2*ebp],ax
        mov VChVolEnvSegPos[2*ebp],ax
        mov VChEnvVol[ebp],al
        mov VChPanEnvPos[2*ebp],ax
        mov VChPanEnvSegPos[2*ebp],ax
        mov VChEnvPan[ebp],al

        mov VChAVibPos[ebp],al
        mov VChAVibSwpPos[ebp],al

        and VChControl[2*ebp],Not CC_FadeVol
        ret
USS_InitInstrEnv Endp

;͸
; USS_SetEnvPos: Set instrument envelope position                         
;                                                                         
; Input: EBP Channel number                                               
;        AL Envelope position                                             
;                                                                         
; Output: --                                                              
;                                                                         
;

USS_SetEnvPos Proc

If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
	jae USS_SetPanningEnd
Endif

        mov edi,VChInsAdress[4*ebp]
	or edi,edi                      ; edi=0 ?
	jz USS_SetEnvPosEnd             ; No instrument -> No Set pos

        movzx eax,al

        test IVType[edi],E_On   ; ** Set Vol Pos **
	jz  Set_PanningPos

        movzx ecx,IVPoints[edi]
V_SetEnvPosLoop:
        movzx edx,word ptr IVEnvelope[edi+4*(ecx-1)]
        cmp edx,eax
        ja VPos_NotFound
        sub edx,eax
        neg edx
        dec ecx
        jmp VPos_Found
VPos_NotFound:
        dec ecx
        jnz V_SetEnvPosLoop

VPos_Found:
        mov VChVolEnvPos[2*ebp],cx
        mov VChVolEnvSegPos[2*ebp],dx

Set_PanningPos:                 ; ** Set panning Pos **
        test IPType[edi],E_On
	jnz  USS_SetEnvPosEnd

        movzx ecx,IPPoints[edi]
P_SetEnvPosLoop:
        movzx edx,word ptr IPEnvelope[edi+4*(ecx-1)]
        cmp edx,eax
        ja PPos_NotFound
        sub edx,eax
        neg edx
        dec ecx
        jmp PPos_Found
PPos_NotFound:
        dec ecx
        jnz P_SetEnvPosLoop

PPos_Found:
        mov VChPanEnvPos[2*ebp],cx
        mov VChPanEnvSegPos[2*ebp],dx

USS_SetEnvPosEnd:
        ret
USS_SetEnvPos Endp

;͸
; USS_GetSampleVolume: Get the Volume of the current channel sample.      
;                                                                         
; Input:  EBP Channel Number                                              
;                                                                         
; Output: CF Set -> There is no sample on this channel.                   
;         EAX Sample Volume                                               
;                                                                         
; Change: eax                                                             
;                                                                         
;

USS_GetSampleVolume Proc
        mov esi,VChSmpAdress[4*ebp]
        or esi,esi
        je USS_GetSampleVolumeErr       ; Err: No sample

        movzx eax,SDefVolume[esi]
        
        clc
        ret
USS_GetSampleVolumeErr:
        stc
        ret
USS_GetSampleVolume Endp

;͸
; USS_GetSamplePanning: Get the Panning of the current channel sample.    
;                                                                         
; Input:  EBP Channel Number                                              
;                                                                         
; Output: CF Set -> There is no sample on this channel or no sample pann. 
;         EAX Sample Volume                                               
;                                                                         
; Change: eax                                                             
;                                                                         
;

USS_GetSamplePanning Proc
        mov esi,VChSmpAdress[4*ebp]
        or esi,esi
        je USS_GetSamplePanningErr      ; Err: No sample

        test SFlag[esi],SF_UseIPanning
        jnz USS_Get_InstrPanning

        test SFlag[esi],SF_UsePanning
        jz USS_GetSamplePanningErr      ; Err: sample panning turned off
                                        ; (in MOD files, for example)
        movzx eax,SDefPanning[esi]

        jmp USS_GetSamplePanningEnd

USS_Get_InstrPanning:   ;Get Instrument default panning instead of sample one.

USS_GetSamplePanningEnd:        
        clc
        ret
USS_GetSamplePanningErr:
        stc
        ret
USS_GetSamplePanning Endp

;͸
; USS_SetSampleOffset                                                     
;                                                                         
; Input: EBP Channel Number                                               
;        EAX Sample Offset                                                
;                                                                         
; Output: --                                                              
;                                                                         
; Change: eax esi                                                         
;                                                                         
;

USS_SetSampleOffset Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
        jae USS_SetSampleOffsetEnd
Endif

; Get Sample data Offset
        mov esi,VChSmpAdress[4*ebp]
        or esi,esi                      ; esi=0 ?
        jz USS_SetSampleOffsetEnd       ; Err: No sample (Address=0)

        test SFlag[esi],SF_Loaded       ; Is sample loaded ?
        jz   USS_SetsampleOffsetEnd     ; Err: Sample data not loaded

        add eax,SPointer[esi]           ; eax <- Sample data pointer
        mov VChSmpOffset[4*ebp],eax

;@@ Pas de test sur la position du SetSampleOffset !

        or VChControl[2*ebp],CC_StopVoice+CC_ChSample+CC_ChVolume+CC_Playing
USS_SetSampleOffsetEnd:
        ret
USS_SetSampleOffset Endp

;͸
; USS_SetNote : Change the note for the current channel.                  
;                                                                         
; Input: EBP Channel Number                                               
;        AL  Note                                                         
;                                                                         
; Output: --                                                              
;                                                                         
; Change: eax ebx esi                                                     
;                                                                         
;

USS_SetNote Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
        jae USS_SetNoteEnd
Endif
        mov bl,al

; ** Get Sample Address **
        mov esi,VChSmpAdress[4*ebp]

; ** Get Periode **
        call Get_NotePeriod
        jc USS_SetNoteEnd

        mov VChPeriod[2*ebp],ax
        or  VChControl[2*ebp],CC_ChPeriod
USS_SetNoteEnd:
        ret
USS_SetNote Endp

;͸
; USS_GetPeriod                                                           
;                                                                         
; Input: EBP Channel Number                                               
;                                                                         
; Output: AX Period                                                       
;                                                                         
; Change: eax                                                             
;                                                                         
;

USS_GetPeriod Proc
	movzx eax,VChPeriod[2*ebp]
	ret
USS_GetPeriod Endp

;͸
; USS_SetPeriod                                                           
;                                                                         
; Input: EBP Channel Number                                               
;        AX New Periode                                                   
;                                                                         
; Output: AX, New period with range limitation.                           
;         CF Set -> Period was out of range.                              
;                                                                         
; Change: EAX EBX                                                         
;                                                                         
;

USS_SetPeriod Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
        jae USS_SetPeriodEnd
Endif

; * Test period limits **

        mov bx,SSPeriodMin
        cmp ax,bx
        jge NotTooLow
        mov bl,1
        mov ax,bx
        jmp ChangePeriod
NotTooLow:
        mov bx,SSPeriodMax
        cmp ax,bx
        jle NotTooHigh
        mov bl,1
        mov ax,bx
        jmp ChangePeriod
NotTooHigh:
        xor ebx,ebx
ChangePeriod:

        cmp VChSmpAdress[4*ebp],0
        je USS_SetPeriodEnd

        mov VChPeriod[2*ebp],ax

        or VChControl[2*ebp],CC_ChPeriod

        or ebx,ebx
        jnz USS_SetPeriodErr
        
USS_SetPeriodEnd:
        clc
        ret
USS_SetPeriodErr:
        stc
        ret
USS_SetPeriod Endp

;͸
; USS_GetNotePeriod : Get the period from the note and channel number.    
;                                                                         
; Input: EBP Channel Number                                               
;        BX  Note Number                                                  
;                                                                         
; Output: EAX Period                                                      
;                                                                         
; Change: eax ebx esi                                                     
;                                                                         
;

USS_GetNotePeriod Proc
        mov esi,VChSmpAdress[4*ebp]     ; Get the current sample Address
        call Get_NotePeriod
        ret
USS_GetNotePeriod Endp

;͸
; USS_GetVolume: Read channel volume                                      
;                                                                         
; Input: EBP Channel Number                                               
;                                                                         
; Output: AL Volume                                                       
;                                                                         
; Change: eax                                                             
;                                                                         
;
USS_GetVolume Proc
        mov al,VChVolume[ebp]
        ret
USS_GetVolume Endp

;͸
; USS_SetVolume: Write channel volume                                     
;                                                                         
; Input: EBP Channel Number                                               
;        AL  Channel Volume                                               
;                                                                         
; Output: --                                                              
;                                                                         
;

USS_SetVolume Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
        jae USS_SetVolumeEnd
Endif
        cmp al,40h
        jbe VolumeOk
;       dwrite 'Wrong volume'
;       call _dprint_dec
        mov al,40h
VolumeOk:
        mov VChVolume[ebp],al

        or VChControl[2*ebp],CC_ChVolume
USS_SetVolumeEnd:
        clc
        ret
USS_SetVolume Endp

;͸
; USS_GetPanning                                                          
;                                                                         
; Input: EBP Channel Number                                               
;                                                                         
; Output: AL Panning                                                      
;                                                                         
;
USS_GetPanning Proc
        mov al,VChPanning[ebp]
        ret
USS_GetPanning Endp

;͸
; USS_SetPanning                                                          
;                                                                         
; Input: EBP Channel Number                                               
;        AL  Channel Panning                                              
;                                                                         
; Output: --                                                              
;                                                                         
;

USS_SetPanning Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
        jae USS_SetPanningEnd
Endif

        mov VChPanning[ebp],al

        or VChControl[2*ebp],CC_ChPanning
USS_SetPanningEnd:
        clc
        ret
USS_SetPanning Endp

;͸
; USS_NoteCut : Cut the note.                                             
;                                                                         
; Input: EBP Channel Number                                               
;                                                                         
; Output: --                                                              
;                                                                         
;

USS_NoteCut Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
	jae USS_SetPanningEnd
Endif
;        write ' NCt'

        or VChControl[2*ebp],CC_StopVoice ; @@ Temporaire !! (Ah bon ?)
	clc
	ret
USS_NoteCut Endp

;͸
; USS_NoteFade : Fade the note.                                           
;                                                                         
; Input: EBP Channel Number                                               
;                                                                         
; Output: --                                                              
;                                                                         
;

USS_NoteFade Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
	jae USS_SetPanningEnd
Endif
;        write ' NFd'

	mov edi,VChInsAdress[4*ebp]
	or edi,edi                      ; edi=0 ?
	jz No_FadeNote                  ; No instrument -> Do a note cut

;       test IVType[edi],E_On           ; If there is a volume envelope,
;       jnz  KO_FadeVolume              ; do fadeout

        or VChControl[2*ebp],CC_FadeVol

No_FadeNote:
        ret
USS_NoteFade Endp

;͸
; USS_KeyOff : Release the note.                                          
;                                                                         
; Input: EBP Channel Number                                               
;                                                                         
; Output: --                                                              
;                                                                         
;

USS_KeyOff Proc
If FullControl eq Yes
        cmp ebp,MAX_SSCHANNELS
	jae USS_SetPanningEnd
Endif
;        dwrite ' KeyOff '
	mov edi,VChInsAdress[4*ebp]
	or edi,edi                      ; edi=0 ?
	jz KO_CuteNote                  ; No instrument -> Do a note cut

        test IVType[edi],E_On           ; If there is a volume envelope,
	jnz  KO_FadeVolume              ; do fadeout

KO_CuteNote:

        or VChControl[2*ebp],CC_StopVoice ; @@ Temporaire !! (Ah bon ?)
	clc
	ret
KO_FadeVolume:

        or VChControl[2*ebp],CC_FadeVol
	clc
	ret
USS_KeyOff Endp

;͸
; USS_UpdateInstr: Do KeyOff, fadeout and envelopes                       
;                                                                         
; Input: --                                                               
;                                                                         
; Output: --                                                              
;                                                                         
;

Po    EQU Word Ptr
Vo    EQU Word Ptr 2
Pann0 EQU Word Ptr 2
P1    EQU Word Ptr 4
V1    EQU Word Ptr 6
Pann1 EQU Word Ptr 6
DPos  DW 0

USS_UpdateInstr proc

if UseInstrumentMode Eq Yes     ;*
        mov ebp,0
ProCInstrLoop:
	mov edi,VChInsAdress[4*ebp]
	or edi,edi                      ;edi=0 ?
	jz ProcNextInstr
	
	test VChControl[2*ebp],CC_Playing
        jz ProcNextInstr
	
        test IVType[edi],E_On           ;Is there a volume envelope ?
        jz NoVEnv

;                      ****** Do Fadeout ******
if UseFadeout Eq Yes            ;*
        test VChControl[2*ebp],CC_FadeVol
        jz  NoFadeOut
	
        mov ax,VChFadeoutVol[2*ebp]
        mov bx,IVFadeOut[edi]
        sub ax,bx
        jnc FadeOutEnd
        xor eax,eax                     ;eax=0
	or VChControl[2*ebp],CC_StopVoice   ;Fade End => Stop voice
FadeOutEnd:
	mov VChFadeOutVol[2*ebp],ax
NoFadeOut:
endif

;                   ****** Do Volume Envelope ******
;
;
;   V1              /
;                 /  |
;               /    |
;   Vol       /      |
;           / |      |
;         /   |      |
;   Vo  /     |      |
;      |------|------|
;      |      |      |
;      |      |      |
;      |     pos     |
;      |             |
;      |<----------->|
;      Po   DPos    P1
;
;Thales => (Vol-Vo)*DPos = (V1-Vo)*pos
;       =>  Vol          =  Vo + ((V1-Vo)*pos)/DPos
;
; edi, Instrument Offset ebp, Instrument number

if UseVolumeEnv Eq Yes  ;*
        cmp VChVolEnvSegPos[2*ebp],0
        jne @VNoLoop

        movzx edx,VChVolEnvPos[2*ebp]

; ** Do Sustain **

        test IVType[edi],E_Sustain ;Sustain Off => Always do loop
        jz @VDoLoop

        cmp dl,IVSustain[edi]      ;When fade is on, do not loop if sustain
        jne @VDoLoop               ;point is Loop end point

        test VChControl[2*ebp],CC_FadeVol ;Don't loop when fade is on
        jnz @VNoLoop                      ;and current point is sustain

; ** Do Loop **
@VDoLoop:
        test IVtype[edi],E_Loop
        jz @VNoLoop
	
        cmp dl,IVLoopEnd[edi]
        jne @VNoLoop
        mov dl,IVLoopStart[edi]
        mov VChVolEnvPos[2*ebp],dx
@VNoLoop:

; ** Get Envelope volume **
        movzx eax,VChVolEnvPos[2*ebp]
        lea esi,IVEnvelope[edi+4*eax]
        inc al
        cmp al,IVPoints[edi]            ;Is it the envelope End ?
        je @Venvlast
        mov ax,Po[esi]
        mov bx,P1[esi]
        sub bx,ax
        mov DPos,bx
        mov ax,V1[esi]
        mov dx,Vo[esi]
        sub eax,edx
        imul VChVolEnvSegPos[2*ebp]
        idiv DPos
        add ax,Vo[esi]              ; al=Vo+((V1-Vo)*chVolEnvSegPos)/DPos

        mov VChEnvVol[ebp],al

; ** Process Sustain if no KeyOff **
	cmp VChVolEnvSegPos[2*ebp],0
	jne @Vnosustain
        test IVType[edi],E_Sustain
        jz @Vnosustain
        test VChControl[2*ebp],CC_FadeVol ; (KeyOff for FT2)
        jnz @Vnosustain                   ; If KeyOff, No sustain
        movzx edx,VChVolEnvPos[2*ebp]
        cmp dl,IVSustain[edi]
        je @Venvend                     ;Do volume Sustain

@Vnosustain:
        movzx eax,VChVolEnvSegPos[2*ebp]
        inc eax
        cmp ax,DPos
        jb @Venvnostep
        xor eax,eax                     ;Envelope Pos is at an envelope point
        inc VChVolEnvPos[2*ebp]
@Venvnostep:
        mov VChVolEnvSegPos[2*ebp],ax
        jmp @venvend

@Venvlast:
        mov ax,Vo[esi]                  ;
        mov VChEnvVol[ebp],al
@Venvend:

	or VChControl[2*ebp],CC_ChVolume
endif
NoVEnv:

;                 ****** Do Panning Envelope ******

if UsePannEnv Eq Yes    ;*
	test IPType[edi],E_On
	jz NoPEnv

	cmp VChPanEnvSegPos[2*ebp],0
	jne @Pnoloop
	
	movzx edx,VChPanEnvPos[2*ebp]
; ** Do Sustain **
	test IPType[edi],E_Sustain
	jz @PDoLoop

	cmp dl,IPSustain[edi]
	jne @PDoLoop
	test VChControl[2*ebp],CC_FadeVol
	jnz @Pnoloop            ; If KeyOff, no loop
; ** Do Loop **
@PDoLoop:
        test IPType[edi],E_Loop
        jz @Pnoloop

        cmp dl,IPLoopEnd[edi]
        jne @Pnoloop
        mov dl,IPLoopStart[edi]
        mov VChPanEnvPos[2*ebp],dx
@Pnoloop:

; ** Get Envelope panning **
        movzx eax,VChPanEnvPos[2*ebp]
        lea esi,IPEnvelope[edi+4*eax]
        inc al
        cmp al,IPPoints[edi]
        je @Penvlast
        mov ax,Po[esi]
        mov bx,P1[esi]
        sub bx,ax
        mov DPos,bx
        mov ax,Pann1[esi]
        mov dx,Pann0[esi]
        sub eax,edx
        imul VChPanEnvSegPos[2*ebp]
        idiv DPos
        add ax,Pann0[esi]

        mov VChEnvPan[ebp],al

; ** Process Sustain if no KeyOff **
	cmp VChPanEnvSegPos[2*ebp],0
	jne @Pnosustain
        test IPType[edi],E_Sustain
        jz @Pnosustain
        test VChControl[2*ebp],CC_FadeVol
        jnz @Pnosustain         ; If KeyOff, No sustain
        movzx edx,VChPanEnvPos[2*ebp]
        cmp dl,IPSustain[edi]
        je @Penvend             ; Do panning sustain

@Pnosustain:
        movzx eax,VChPanEnvSegPos[2*ebp]
        inc eax
        cmp ax,DPos
        jb @Penvnostep
        xor eax,eax
        inc VChPanEnvPos[2*ebp]
@Penvnostep:
        mov VChPanEnvSegPos[2*ebp],ax
        jmp @Penvend

@Penvlast:
        mov ax,Pann0[esi]
        mov VChEnvPan[ebp],al
@Penvend:

        or VChControl[2*ebp],CC_ChPanning ; Change panning !
endif
NoPEnv:

ProcNextInstr:                   ; Channels Loop
        inc ebp
        cmp ebp,SSActiveChannels
        jne ProcInstrLoop
endif

; Process Samples auto vibrato

if UseAutoVibrato Eq Yes
        mov ebp,0
ProcSampleLoop:
        mov edi,VChSmpAdress[4*ebp]
        or edi,edi              ; edi=0 ?
        jz ProcNextSample
	
        test VChControl[2*ebp],CC_Playing
        jz ProcNextSample

;                   ****** Do Auto Vibrato ******

        movzx edx,SVibdepth[edi]
        or edx,edx
        jz NoAVib

        mov ch,SVibrate[edi]
        mov cl,SVibType[edi]

        movzx ebx,VChAVibPos[ebp]
        call GetVibData
        mov VChAVibPos[ebp],bl

        movzx cx,VChAVibSwpPos[ebp]  ; Apparently, this vib sweep is faster
        cmp cl,SVibSweep[edi]        ; than FT2 one... (?????)
        jae NoAVSweep                ; I'm too lazy to correct this ;-)
        imul cx
        movzx cx,SVibSweep[edi]
        idiv cx
        inc VChAVibSwpPos[ebp]
NoAVSweep:
        sar ax,8
        neg ax
        mov VChaVibPitch[2*ebp],ax

        or VChControl[2*ebp],CC_ChPeriod

NoAVib:

ProcNextSample:                  ; Channels Loop
        inc ebp
        cmp ebp,SSActiveChannels
        jne ProcSampleLoop
endif

        clc
        ret
USS_UpdateInstr endp

;͸
; USS_UpdateOutput                                                        
;                                                                         
; Input: -                                                                
;                                                                         
; Output: -                                                               
;                                                                         
;
USS_UpdateOutput Proc

	mov ebp,0
ChannelLoop:
	mov edi,VChInsAdress[4*ebp]
	
	test VChControl[2*ebp],CC_ChPeriod
	jz   NoChPeriod

        movzx eax,VChPeriod[2*ebp]

; ** Add auto vibrato pitch **

if UseAutoVibrato Eq Yes        ;*
        add ax,VChAVibPitch[2*ebp]
endif

; ** Set Frequency (Hz) **

	call SetFrequency

NoChPeriod:

	test VChControl[2*ebp],CC_ChVolume
	jz   NoChVolume

; ** Process the final volume calculation.
;
; I try to keep the maximum precision for volume processing.

	xor ecx,ecx
	xor edx,edx
        movzx eax,VChVolume[ebp]      ; vol = Sample volume (0-40h)

        movzx ecx,SSGlobalVol
        mul ecx                       ; vol * GlobalVol (0-80h)
        mov bl,7

If UseChannelVolume eq Yes
        movzx ecx,VChannelVol[ebp]
        mul ecx                       ; vol * ChannelVol (0-40h)
        add bl,6
endif

        test VChControl[2*ebp],CC_FadeVol
        jz  NoFadeVol

        movzx ecx,VChFadeOutVol[2*ebp]
        mul ecx                       ; vol * fadeVol (0-8000h)
         
        shrd eax,edx,9
        add bl,6
NoFadeVol:

        or edi,edi                    ; Is it an instrument ?
        jz NoEnvVol                   ; No => No envelope volume
        test IVType[edi],E_On         ; Is volume envelope on ?
        jz NoEnvVol                   ; No => No envelope volume

        movzx ecx,VChEnvVol[ebp]
	mul ecx                       ; vol * EnvelopeVol (0-40h)
	add bl,6

NoEnvVol:

        ; edx-eax=Vol*CV*GV*EnvV*FadeV

        sub bl,6
        mov cl,bl
        shrd eax,edx,cl
        mov bl,6

        mov esi,VChSmpAdress[4*ebp]
        or esi,esi
        jz NoSampleVolume
        movzx ecx,SVolume[esi]
	mul ecx                       ; vol * SampleVol (0-40h)
	add bl,6
NoSampleVolume:        

        
        ; edx-eax=Vol*CV*GV*EnvV*FadeV*(SV)
        
        mov cl,bl
        shrd eax,edx,cl        

        mov VChFVolume[ebp],al  ;Set Final Volume

NoChVolume:

        test VChControl[2*ebp],CC_ChPanning
        jz   NoChPanning

        movsx edx,VChPanning[ebp]
		
        or edi,edi
        jz NoEnvPann
        test IPType[edi],E_On
        jz NoEnvPann

        mov al,VChEnvPan[ebp]   ;FPan=Pan+(EnvPan-32)*(128-abs(Pan-128))/32
        sub al,32
        xor dl,dh
        imul dl
        shr eax,5
        add al,VChPanning[ebp]
        mov dl,al

NoEnvPann:

        mov VChFPanning[ebp],dl
	
NoChPanning:

        inc ebp
        cmp ebp,SSActiveChannels
        jne ChannelLoop

	
        mov edx,DevOffset
        call D_UpdateSound[edx]

        clc
        ret
USS_UpdateOutput endp

;͸
; GetVibData :                                                            
;                                                                         
; Input: EBX Vibrato Pos                                                  
;        CH Vibrato Speed                                                 
;        CL Vibrato Wave                                                  
;        DX Vibrato Depth                                                 
;                                                                         
; Output: AX and CX Vibrato Data                                          
;         BL New Vibrato Pos                                              
;                                                                         
;

; 0,sine 1,ramp down 2,square 3,square 4,ramp up
; 3 should be random, but FT2 plays it as square...

if (UseAutoVibrato Eq Yes) or (UseVibrato Eq Yes) or (UseVVolumeSlide Eq Yes)
GetVibData Proc
        xor eax,eax

        cmp cl,0
        jne NoSinWave
        movzx eax,bl          ;1, Sine
        and eax,7Fh
        mov al,SinTab[eax]
        jmp GetVibDataEnd
NoSinWave:
        cmp cl,1
        jne NoRampDown
        mov ax,bx             ;1, Ramp down
        cmp bl,127
        ja RD2
        sal ax,1
        jmp GetVibDataEnd
RD2:
        sub ax,256
        sal ax,1
        neg eax
        jmp GetVibDataEnd
NoRampDown:
        cmp cl,4
        je NoSquare
        mov al,255            ;2 and 3, Square => +255/-255
        jmp GetVibDataEnd
NoSquare:
        mov al,bl             ;4, Ramp Up
        cmp bl,127
        ja RU2
        sal ax,1
        neg ax
        jmp GetVibDataEnd
RU2:
        sub ax,256
        sal ax,1
GetVibDataEnd:
        cmp bl,127
        jbe VibDataOk
        neg ax
VibDataOk:
        add bl,ch

        imul dx

        mov cx,ax
        ret
GetVibData Endp
endif

;͸
; Get_NotePeriod: Get the period from the note and the sample definition  
;                                                                         
; Input: BL Note                                                          
;        ESI Sample Address                                               
;                                                                         
; Output: CF Set -> Incorrect Note/Sample                                 
;         EAX Period                                                      
;                                                                         
; Change: eax ebx                                                         
;                                                                         
;
Get_NotePeriod Proc
	xor eax,eax

        cmp esi,0
	je _NoPeriod
	cmp bl,0
	je _NoPeriod
	dec bl

        mov al,SRelNote[esi]            ; Sample Relative Note
	add al,bl
	cmp al,11*12
	jae _NoPeriod

        test SFlag[esi],SF_Linear
        jz GetAmigaPeriod

if UseLinearPeriod Eq Yes
; ** Linear period **

	;Per=11*12*16*4-Note*16*4-Fine/2 (FineTune is done at the End)
	
	mov ebx,11*12*16*4
	shl eax,6
	sub ebx,eax

; ** Do FineTune **

       mov eax,SFine[esi]            ; Sample FineTune/2
       sub ebx,eax
	
       mov eax,ebx

       jmp GetNotePeriodEnd
endif

GetAmigaPeriod:

if UseAmigaPeriod Eq Yes
; ** Amiga period **

        movzx eax,Period_Table[2*eax]

; ** Do FineTune **

        push edx
        push ecx
        mov ebx,SFine[esi]
        cmp bx,100              ; Marge de 100 (qui digitalise  100 Hz ?)
        jb NoFine
        cmp bx,8363
        je NoFine
                                ; - Ajuster la priode - ( Frq pour C-4 )
        mov ecx,8363
        mul ecx
        div ebx
NoFine:
        pop ecx
        pop edx
endif

GetNotePeriodEnd:

        clc
        ret
_NoPeriod:
        xor eax,eax
        stc
        ret
Get_NotePeriod Endp

;***************************************************************************
;**************************  Internal functions ****************************
;***************************************************************************

;͸
; exp768                                                                  
;                                                                         
; Input: EAX                                                              
;                                                                         
; Output: EAX=32768*2^(EAX/768)                                           
;                                                                         
;

if UseLinearPeriod Eq Yes
exp0    dw 32768,32798,32827,32857,32887,32916,32946,32976
        dw 33005,33035,33065,33094,33125,33155,33185,33215
exp1    dw 32768,33245,33728,34219,34716,35221,35733,36254
        dw 36781,37315,37859,38409,38968,39535,40110,40693
exp2    dd 32768,41285,52016,65536,82570,104032,131072,165140
        dd 208063,262144,330281,416128,524288,660561,832255,1048576
exp3    dd 32768,1321123,53264341,2147483648


exp768 proc
        mov edx,eax
        mov ebx,eax
        mov ecx,eax

        shr eax,12
        shr edx,8
        shr ebx,4

        and eax,3
        and ebx,15
        and ecx,15
        and edx,15

        mov eax,exp3[4*eax]
        mov edx,exp2[4*edx]
        movzx ebx,exp1[2*ebx]
        movzx ecx,exp0[2*ecx]
        mul edx
        shrd eax,edx,15
        mul ebx
        shrd eax,edx,15
        mul ecx
        shrd eax,edx,15
        ret
exp768 endp
endif

;͸
; SetFrequency: Set the channel frequency from the channel period.        
;                                                                         
; Input: EAX Channel Period.                                              
;        EBP Channel number (Get Period from ChPeriod[2*ebp])             
;                                                                         
; Output: AX Channel sample Frequency                                     
;                                                                         
;

SetFrequency Proc

        mov ecx,eax

        mov esi,VChSmpAdress[4*ebp]
        or esi,esi
        jz SetFreqError
        
        test SFlag[esi],SF_Linear
        jz GetAmigaFrequence

if UseLinearPeriod Eq Yes

        mov eax,11*12*16*4
        sub eax,ecx

        call exp768

        mov ecx,8363
        mul ecx
        shrd eax,edx,20  ; Old, 19
endif
        jmp GetFreqEnd
GetAmigaFrequence:

if UseAmigaPeriod Eq Yes
        xor edx,edx
        mov eax,14317456 ; =C-4 Period*C-4 Frequency (1712*8636)
        cmp ecx,10
        jbe SetFreqError ; It's just to avoid DIV 0 errors.
        div ecx
endif
GetFreqEnd:

        mov VChFreq[4*ebp],eax	

        clc
        ret
SetFreqError:

        stc
        ret
SetFrequency Endp

;               *****************************************
;               ***** Procedures used for the SETUP *****
;               *****************************************

;͸
; USS_DetectDev: Returns the first device detected.                       
;                                                                         
; Input: --                                                               
;                                                                         
; Output: EAX, Total devices number                                       
;         EBX, first detected device number                               
;                                                                         
;

USS_DetectDev proc
	
	mov BestDev,0
	mov TotalDev,0
	xor edx,edx
DevLoop:
	mov esi,DEVList[4*edx]
	cmp esi,0
	je DevLoopEnd

	push edx
	movzx ecx,D_TotalDev[esi]
	
	cmp BestDev,0
	jne DevNotDetected

	push ecx
	call Clear_DEV         ; Clear actual device definition
	call D_Init[esi]       ; Detect device
	pop ecx
	jc DevNotDetected
	add ax,TotalDev
	mov BestDev,ax
	
DevNotDetected:
	pop edx
	
	add TotalDev,cx
	inc edx
	jmp DevLoop
DevLoopEnd:
	movzx eax,TotalDev
	movzx ebx,BestDev

	ret
USS_DetectDev Endp

;͸
; USS_SelectDev                                                           
;                                                                         
; Input: EAX Device number                                                
;                                                                         
; Output: CF Set=> Error                                                  
;                                                                         
;
USS_SelectDev Proc
	xor edx,edx
	xor ecx,ecx
SelectDevLoop:
	mov esi,DEVList[4*edx]
	cmp esi,0
	je SelectDevError

	movzx ebx,D_TotalDev[esi]
	add cx,bx
	cmp cx,ax
	jb  NotSelectedDev

	sub cx,bx
	sub ax,cx

	mov DevOffset,esi

;	push esi
	push edx
	call Clear_DEV
	mov _DEV_Number,ax
	call D_Init[esi]        ; Init device
	pop edx
;	pop esi
	jc SelectDevError
	

	clc
	ret
NotSelectedDev:
	inc edx
	jmp SelectDevLoop

SelectDevError:
	stc
	ret
USS_SelectDev Endp

;͸
; Clear_Dev: Delete all device definitions                                
;                                                                         
;
Clear_DEV Proc
        mov _DEV_Number,-1
        mov _DEV_Name,Offset NoDev_Name
        mov _DEV_BasePort,-1
        mov _DEV_IRQ,-1
        mov _DEV_DMA,-1
        mov _DEV_Freq,-1
        mov _DEV_Mode,-1
        ret
Clear_DEV Endp

If UseSetup Eq Yes

;͸
; PrintStr                                                                
;                                                                         
;
PrintStr Proc
	add edi,ZeroOffset
	add edi,0B8000h
PrintStrLoop:
	lodsb
	or al,al
	jz PrintStrEnd
	stosw
	jmp PrintStrLoop
PrintStrEnd:
	ret
PrintStr Endp

;͸
; DrawLine                                                                
;                                                                         
;
DrawLine Proc
	add edi,ZeroOffset
	add edi,0B8000h
	cld
	rep stosw
	ret
DrawLine Endp

;͸
; NextWindowLine                                                          
;                                                                         
;
NextWindowLine Proc
	mov ecx,80-2
	sub ecx,ebx
	shl ecx,1
	add edi,ecx
	ret
NextWindowLine Endp

;͸
; DrawWindowLine                                                          
;                                                                         
;
DrawWindowLine Proc
	mov ecx,ebx
	mov al,''
	stosw
	mov al,' '
	rep stosw
	mov al,''
	stosw
	
	call NextWindowLine

	ret
DrawWindowLine Endp

;͸
; DrawWindow                                                              
;                                                                         
;
DrawWindow Proc
	add edi,ZeroOffset
	add edi,0B8000h
	
	mov ecx,ebx
	mov al,''
	stosw
	mov al,''
	rep stosw
	mov al,''
	stosw

	call NextWindowLine
	
	call DrawWindowLine

	mov ecx,ebx
	mov al,''
	stosw
	mov al,''
	rep stosw
	mov al,''
	stosw
	
	call NextWindowLine
	
DrawWLinesLoop:
	call DrawWindowLine
	dec edx
	jne DrawWLinesLoop

	mov ecx,ebx
	mov al,''
	stosw
	mov al,''
	rep stosw
	mov al,''
	stosw

	ret
DrawWindow Endp

;͸
; Setup_ClearCenter                                                       
;                                                                         
;
Setup_ClearCenter Proc
	mov edi,ZeroOffset
	add edi,0B8000h+80*2
	mov ax,''+CenterAttrib
	mov ecx,80*23
	cld
	rep stosw
	ret
Setup_ClearCenter Endp

;͸
; PrepareBuffer_Output                                                    
;                                                                         
;
PrepareBuffer_Output Proc

	mov edi,SelectBuffer

	push edi
	mov esi,Offset SAutodetectStr ; 1st choice, Autodetect
	mov ecx,23
	rep movsb
	pop edi
	add edi,32
	
	xor edx,edx                   ; Other choices, devices names
	mov ecx,1
PBOutLoop:
	mov ebx,DEVList[4*edx]
	inc edx
	cmp ebx,0
	je PBOutEnd
	
	movzx eax,D_TotalDev[ebx]
	add ecx,eax
	cmp cx,MAXLines
	ja PBOutEnd

	add ebx,D_DevName
CopyNextName:
	mov esi,[ebx]
	push edi
	push eax

CopyNameLoop:
	mov al,[esi]
	inc esi
	mov [edi],al
	inc edi
	or al,al
	jnz CopyNameLoop

	pop eax
	pop edi
	add edi,32
	mov Byte Ptr [edi-1],0
	add ebx,4
	dec eax
	jnz CopyNextName
	jmp PBOutLoop
	
PBOutEnd:
	ret
PrepareBuffer_Output Endp

;͸
; PrepareBuffer_Mode                                                      
;                                                                         
;
PrepareBuffer_Mode Proc

        mov edi,SelectBuffer

        push edi
        mov esi,Offset SMono    ; 1st choice, Mono
        mov ecx,23
        rep movsb
        pop edi
        add edi,32

        test _DEV_Mode,DM_Stereo
        jz NoAffStereo

        push edi
        mov esi,Offset SStereo  ; 2nd choice, Stereo
        mov ecx,23
        rep movsb
        pop edi
        add edi,32

NoAffStereo:

        push edi
        mov esi,Offset SMonoO   ; 3rd choice, Mono Oversampling
        mov ecx,23
        rep movsb
        pop edi
        add edi,32

        mov ecx,2

        test _DEV_Mode,DM_Stereo
        jz NoAffStereoO

        push edi
        mov esi,Offset SStereoO ; 4th choice, Stereo Oversampling
        mov ecx,23
        rep movsb
        pop edi
        add edi,32

        mov ecx,4
NoAffStereoO:

        ret
PrepareBuffer_Mode Endp

;͸
; DecToAscii                                                              
;                                                                         
;
DecToAscii Proc
        xor ebx,ebx
        mov cx,10

        push ax
GetNbDigitDECLoop:
        inc ebx
        xor edx,edx
        div cx
        or ax,ax
        jnz GetNbDigitDECLoop
        pop ax

        add edi,ebx
        mov Byte Ptr [edi],0
WriteDecLoop:
        dec edi
        xor edx,edx
        div cx
        add dl,'0'
        mov [edi],dl
        dec ebx
        jne WriteDecLoop

        ret
DecToAscii Endp

;͸
; HexToAscii                                                              
;                                                                         
;
HexToAscii Proc
        xor ebx,ebx
        mov cx,10

        push ax
GetNbDigitHEXLoop:
        inc ebx
        shr ax,4
        or ax,ax
        jnz GetNbDigitHEXLoop
        pop ax

        add edi,ebx
        mov Byte Ptr [edi],0
WriteHexLoop:
        dec edi
        mov dx,ax
        and dx,0Fh
        add dl,'0'
        cmp dl,'9'
        jbe WriteHexStr
        add dl,'A'-'0'
WriteHexStr:
        mov [edi],dl
        shr eax,4
        dec ebx
        jne WriteHexLoop

        ret
HexToAscii Endp

;͸
; PrepareBuffer_Dec                                                       
;                                                                         
;
PrepareBuffer_Dec Proc
        xor ecx,ecx
        mov edi,SelectBuffer
PrepareBuffer_DecLoop:
        movzx eax,Word Ptr [esi]
        add esi,2
        cmp ax,-1
        je PrepareBufferEnd
        inc ecx

        push ecx
        call DecToAscii
        pop ecx
        add edi,32
        jmp PrepareBuffer_DecLoop
PrepareBufferEnd:
        ret
PrepareBuffer_Dec Endp

;͸
; PrepareBuffer_Hex                                                       
;                                                                         
;
PrepareBuffer_Hex Proc
        xor ecx,ecx
        mov edi,SelectBuffer
PrepareBuffer_HexLoop:
        movzx eax,Word Ptr [esi]
        add esi,2
        cmp ax,-1
        je PrepareBufferHexEnd
        inc ecx

        push ecx
        call HexToAscii
        pop ecx
        add edi,32
        jmp PrepareBuffer_HexLoop
PrepareBufferHexEnd:
        ret
PrepareBuffer_Hex Endp

;͸
; GetNumberPos                                                            
;                                                                         
;
GetNumberPos Proc
        xor ecx,ecx
GetNumberPosLoop:
        cmp ax,[esi]
        je GetNumberPosEnd
        add esi,2
        inc ecx
        cmp Word Ptr[esi],-1
        jne GetNumberPosLoop
        xor ecx,ecx
GetNumberPosEnd:
        ret
GetNumberPos Endp

;͸
; PrintChoice                                                             
;                                                                         
;
PrintChoice Proc
PrintChoiceLoop:
        lodsb
        cmp al,0
        je PrintChoiceEnd
        stosw
        jmp PrintChoiceLoop
PrintChoiceEnd:
        ret
PrintChoice Endp

;͸
; PrintChoices                                                            
;                                                                         
;
PrintChoices Proc
        mov edi,ZeroOffset
        add edi,0B8000h+(1+3*80)*2
        add edi,SelectLinePos
        mov SelectLinePos,edi   ;Position of the first selection line
        add edi,eax
        mov SelectStrPos,edi    ;Position of the first selection string
        mov esi,SelectBuffer
        mov ax,SelectAttrib
        movzx ecx,NbLines

PrintChoicesLoop:
        push esi
        push edi
        call PrintChoice
        pop edi
        pop esi
        add edi,80*2        ; Next line
        add esi,32          ; Next device name
        dec ecx
        jnz PrintChoicesLoop

        ret
PrintChoices Endp

;͸
; PrintHighLight                                                          
;                                                                         
;
PrintHighLight Proc
        mov edx,ecx

        mov edi,SelectLinePos
        mov eax,ecx
        imul eax,80*2
        add edi,eax
        mov ebx,eax
        mov ax,HighlightAttrib

        mov al,16
        stosw
        mov al,' '
        movzx ecx,CurrentSize
        sub ecx,2
        rep stosw
        mov al,17
        stosw

; ** Print the selection string

        mov edi,SelectStrPos
        add edi,ebx
        mov esi,SelectBuffer
        mov eax,edx
        shl eax,5
        add esi,eax
        mov ax,HighlightAttrib
        call PrintStrLoop

        mov ecx,edx
        ret
PrintHighLight Endp

;͸
; CleanHighLight                                                          
;                                                                         
;
CleanHighLight Proc
        mov edx,ecx

        mov edi,SelectLinePos
        mov eax,ecx
        imul eax,80*2
        add edi,eax
        mov ebx,eax
        mov ax,SelectAttrib

        mov al,' '
        movzx ecx,CurrentSize
        rep stosw

; ** Print the selection string

        mov edi,SelectStrPos
        add edi,ebx
        mov esi,SelectBuffer
        mov eax,edx
        shl eax,5
        add esi,eax
        mov ax,SelectAttrib
        call PrintStrLoop

        mov ecx,edx
        ret
CleanHighLight Endp

;͸
; DoSelection                                                             
;                                                                         
;
KUp    EQU 72
KDown  EQU 80
KPUp   EQU 73
KPDown EQU 81

DoSelection Proc
        dec NbLines

        call PrintHighLight

DoSelectionLoop:

;If ((OS EQ EOS) or (OS EQ EOS3))
;        xor eax,eax
;        DosInt 16h
;else
;        xor eax,eax
;        int 16h
;Endif
        WaitKey
        
        cmp al,27
        je EscPressed

        cmp al,13
        je ReturnPressed

        cmp al,0
        jne DoSelectionLoop

        cmp ah,KUp
        jne NoKUp
        call CleanHighLight
        cmp cx,0
        je DoPrintHighLight
        dec ecx
        jmp DoPrintHighLight
NoKUp:
        cmp ah,KDown
        jne NoKDown
        call CleanHighLight
        cmp cx,NbLines
        je DoPrintHighLight
        inc ecx
        jmp DoPrintHighLight
NoKDown:
        cmp ah,KPUp
        jne NoKPUp
        call CleanHighLight
        mov cx,0
        jmp DoPrintHighLight
NoKPUp:
        cmp ah,KPDown
        jne NoKPDown
        call CleanHighLight
        mov cx,NbLines
        jmp DoPrintHighLight
NoKPDown:

DoPrintHighLight:

        call PrintHighLight

        jmp DoSelectionLoop

ReturnPressed:

        clc
        ret
EscPressed:
        stc
        ret
DoSelection Endp

EndIf                   ; UseSetup Eq Yes

CODE32 ENDS
;==============================================================================
End
; USS.ASM (c) 1997 FreddyV/Useless
