.386
.model flat,prolog
locals

public bumpPolygon
public shadowPolygon
public lightPolygon
public initAlpha, txtAlphaPhongPolygon
public txtPhongPolygon
public txtaddPolygon

public xres
public screenBuf
public divTab

w equ word ptr
d equ dword ptr

numLights = 2

;
;struc
;

;vector
Vector struc
 v_x            dd ?
 v_y            dd ?
 v_z            dd ?
ends

ParamPoint struc
 p_x            dd ?
 p_y            dd ?
 p_z            dd ?
 p_dist         dd ?
 p_clip         dd ?
 p_u label dword
 p_param        dd ?
 p_v label dword
ends

mappsize = size ParamPoint + 2*4
shadowpsize = size ParamPoint

;
.data
;

xres dd ?
screenBuf dd ?
divTab dd ?

.data?

redMul dd 1024*256 dup(?)
greenMul dd 1024*256 dup(?)
blueMul dd 1024*256 dup(?)

;
.code
;

bumpPolygon proc pascal
arg     startPtr, endPtr, bumpMap, bInfos

local   rb, lb, endPoint
local   y, x_y, lc, rc
local   lx, ldx, rx, rdx
local   lu, ldu, lv, ldv, ru, rdu, rv, rdv
local   txt_x, txt_y, xa, xe

        mov     esi,startPtr
        mov     lb,esi
        mov     rb,esi
        mov     endPoint,esi

        fld     [esi].p_y               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        add     esi,mappsize
@@max_l:

        fld     [esi].p_y
        fcom    st(1)                   ;compare with ymax
        fstsw   ax
        sahf
        jb      @@max
        mov     endPoint,esi
        fst     st(1)                   ;store new ymax
        jmp     @@min
@@max:
        fcom    st(2)                   ;compare with ymin
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,esi
        mov     rb,esi
        fst     st(2)                   ;store new ymin
@@min:  fstp    st

        add     esi,mappsize
        cmp     esi,endPtr
        jne     @@max_l
        fstp    st                      ;remove ymax

        fistp   y                       ;y = floor(ymin)


        mov     edi,xres
        imul    edi,y
        shl     edi,2
        add     edi,screenBuf
        mov     x_y,edi

        xor     eax,eax
        mov     lc,eax
        mov     rc,eax
@@y_l:
        inc     y

                ;l
        dec     lc
        jns     @@l_step

        mov     esi,lb
        mov     ecx,y                   ;ecx = y
@@l_do:
        cmp     esi,endPoint
        je      @@l_finish
        mov     ebx,esi                 ;a = lb
        cmp     esi,startPtr
        jne     @@l0
        mov     esi,endPtr
@@l0:   sub     esi,mappsize
        fld     [esi].p_y
        fistp   lc
        sub     lc,ecx                  ;lc = floor(lb->y) - y
        js      @@l_do
        mov     lb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = lb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_u               ;ldu = (lb->u - a->u)/dy
        fsub    [ebx].p_u
        fdiv    st,st(1)
        fst     ldu

        fmul    st,st(2)                ;lu = ldu*sy + a->u;
        fadd    [ebx].p_u
       fist    txt_x
        fstp    lu

        fld     [esi].p_v               ;ldv = (lb->v - a->v)/dy
        fsub    [ebx].p_v
        fdiv    st,st(1)
        fst     ldv

        fmul    st,st(2)                ;lv = ldv*sy + a->v;
        fadd    [ebx].p_v
       fist    txt_y
        fstp    lv

        fld     [esi].p_x               ;ldx = (lb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     ldx

        fmulp   st(1),st                ;lx = ldx*sy + a->x
        fadd    [ebx].p_x
        fst     lx

        jmp     @@l_end
@@l_step:
        fld     lu
        fadd    ldu
       fist    txt_x
        fstp    lu

        fld     lv
        fadd    ldv
       fist    txt_y
        fstp    lv

        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_end:
                ;r
        dec     rc
        jns     @@r_step

        mov     esi,rb
        mov     ecx,y                   ;ecx = y
@@r_do:
        cmp     esi,endPoint
        je      @@r_finish
        mov     ebx,esi                 ;a = rb
        add     esi,mappsize
        cmp     esi,endPtr
        jne     @@r0
        mov     esi,startPtr
@@r0:   fld     [esi].p_y
        fistp   rc
        sub     rc,ecx                  ;rc = floor(rb->y) - y
        js      @@r_do
        mov     rb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = rb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_u               ;rdu = (rb->u - a->u)/dy
        fsub    [ebx].p_u
        fdiv    st,st(1)
        fst     rdu

        fmul    st,st(2)                ;ru = rdu*sy + a->u;
        fadd    [ebx].p_u
        fstp    ru

        fld     [esi].p_v               ;rdv = (rb->v - a->v)/dy
        fsub    [ebx].p_v
        fdiv    st,st(1)
        fst     rdv

        fmul    st,st(2)                ;rv = rdv*sy + a->v;
        fadd    [ebx].p_v
        fstp    rv

        fld     [esi].p_x               ;rdx = (rb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     rdx

        fmulp   st(1),st                ;rx = rdx*sy + a->x
        fadd    [ebx].p_x
        fst     rx

        jmp     @@r_end
@@r_step:
        fld     ru
        fadd    rdu
        fstp    ru

        fld     rv
        fadd    rdv
        fstp    rv

        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_end:

        fistp   xe                      ;xe = (int) floor(lx)
        fistp   xa                      ;xa = (int) floor(rx)

                                        ;ebx  = x0Yy
                                        ;ecx  = 000U
                                        ;edx  = BB*X   * <- Y
                                        ;esi  = PongMap + BumpOffset
                                        ;edi  = screenBuffer (end)
                                        ;[esp]= u0Vv
                                        ;ebp  = Counter (negative)

        mov     edi,xe
        mov     ecx,edi
        sub     ecx,xa
        jle     @@w
        shl     edi,2
        add     edi,x_y

        mov     edx,bumpMap             ;edx = BB00
        shr     edx,1
        mov     ebx,txt_x               ;ebx = 00Xx
        mov     dl,bh                   ;edx = BB0X
        shl     ebx,24                  ;ebx = x000
        mov     bx,word ptr txt_y       ;ebx = x0Yy

        mov     esi,divTab

        fld     ru
        fsub    lu
        fmul    dword ptr[esi+ecx*4]
        fistp   txt_x
        fld     rv
        fsub    lv
        fmul    dword ptr[esi+ecx*4]
        fistp   txt_y

        mov     eax,txt_x               ;eax = 00Uu
        mov     dh,ah                   ;dh  = U
        shl     eax,24                  ;eax = u000
        mov     ax,word ptr txt_y       ;eax = u0Vv

        push    ebx ecx edx
        ;1st loop
        mov     esi,bInfos
        mov     esi,[esi]

        push    ebp
        push    eax                     ;[esp] = u0Vv
        mov     ebp,ecx
        mov     cl,dh                   ;cl    = u
        neg     ebp

        mov     dh,bh
@@inner:
        add     ebx,[esp]               ;x0Yy += u0Vv
        movzx   eax,word ptr [edx*2]
        adc     dl,cl                   ;X += U
        mov     eax,[esi+eax*4]
        mov     dh,bh
        mov     [edi+ebp*4],eax
        inc     ebp
        jnz     @@inner

        pop     eax
        pop     ebp

        pop     edx ecx ebx

        ;2nd to last loop
        mov     esi,bInfos
        mov     esi,[esi+4]

        push    ebp
        push    eax                     ;[esp] = u0Vv
        mov     ebp,ecx
        mov     cl,dh                   ;cl    = u
        neg     ebp

        mov     dh,bh
@@inner2:
        add     ebx,[esp]               ;x0Yy += u0Vv
        movzx   eax,word ptr [edx*2]
        adc     dl,cl                   ;X += U
        mov     eax,[esi+eax*4]
        mov     dh,bh
        add     [edi+ebp*4],eax
        inc     ebp
        jnz     @@inner2

        pop     eax
        pop     ebp

@@w:
        mov     eax,xres
        shl     eax,2
        add     x_y,eax
        jmp     @@y_l

@@r_finish:
        fstp    st
@@l_finish:
        ret
endp


shadowPolygon proc pascal
arg     startPtr, endPtr

local   rb, lb, endPoint
local   y, lc, rc
local   lx, ldx, rx, rdx
local   xa, xe

        mov     esi,startPtr
        mov     lb,esi
        mov     rb,esi
        mov     endPoint,esi

        fld     [esi].p_y               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        add     esi,shadowpsize
@@max_l:

        fld     [esi].p_y
        fcom    st(1)                   ;compare with ymax
        fstsw   ax
        sahf
        jb      @@max
        mov     endPoint,esi
        fst     st(1)                   ;store new ymax
        jmp     @@min
@@max:
        fcom    st(2)                   ;compare with ymin
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,esi
        mov     rb,esi
        fst     st(2)                   ;store new ymin
@@min:  fstp    st

        add     esi,shadowpsize
        cmp     esi,endPtr
        jne     @@max_l
        fstp    st                      ;remove ymax

        fistp   y                       ;y = floor(ymin)


        mov     edi,xres
        imul    edi,y
        shl     edi,2
        add     edi,screenBuf
        mov     edx,edi                 ;edx = x_y

        xor     eax,eax
        mov     lc,eax
        mov     rc,eax

        mov     eax,xres
        shl     eax,2
@@y_l:
        inc     y

                ;l
        dec     lc
        jns     @@l_step

        mov     esi,lb
        mov     ecx,y                   ;ecx = y
@@l_do:
        cmp     esi,endPoint
        je      @@l_finish
        mov     ebx,esi                 ;a = lb
        cmp     esi,startPtr
        jne     @@l0
        mov     esi,endPtr
@@l0:   sub     esi,shadowpsize
        fld     [esi].p_y
        fistp   lc
        sub     lc,ecx                  ;lc = floor(lb->y) - y
        js      @@l_do
        mov     lb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = lb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_x               ;ldx = (lb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     ldx

        fmulp   st(1),st                ;lx = ldx*sy + a->x
        fadd    [ebx].p_x
        fst     lx

        jmp     @@l_end
@@l_step:
        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_end:
                ;r
        dec     rc
        jns     @@r_step

        mov     esi,rb
        mov     ecx,y                   ;ecx = y
@@r_do:
        cmp     esi,endPoint
        je      @@r_finish
        mov     ebx,esi                 ;a = rb
        add     esi,shadowpsize
        cmp     esi,endPtr
        jne     @@r0
        mov     esi,startPtr
@@r0:   fld     [esi].p_y
        fistp   rc
        sub     rc,ecx                  ;rc = floor(rb->y) - y
        js      @@r_do
        mov     rb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = rb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_x               ;rdx = (rb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     rdx

        fmulp   st(1),st                ;rx = rdx*sy + a->x
        fadd    [ebx].p_x
        fst     rx

        jmp     @@r_end
@@r_step:
        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_end:

        fistp   xe                      ;xe = (int) floor(lx)
        fistp   xa                      ;xa = (int) floor(rx)

                                        ;ecx  = Counter
                                        ;edi  = screenBuffer (end)

        mov     edi,xe
        mov     ecx,xa
        sub     ecx,edi
        jz      @@w
        jl      @@0
        add     edi,ecx
        neg     ecx
@@0:
        shl     edi,2
        add     edi,edx                 ;edx = x_y

@@inner:
        shr     dword ptr [edi+ecx*4],2
        and     dword ptr [edi+ecx*4],0FFh*(1 + (1 shl 11) + (1 shl 22))
        inc     ecx
        jnz     @@inner
@@w:
        add     edx,eax
        jmp     @@y_l

@@r_finish:
        fstp    st
@@l_finish:
        ret
endp


lightPolygon proc pascal
arg     startPtr, endPtr, colVec

local   col
local   rb, lb, endPoint
local   y, x_y, lc, rc
local   lx, ldx, rx, rdx
local   xa, xe

        mov     esi,colVec
        fld     [esi].v_z
        fistp   col
        fld     [esi].v_y
        mov     edx,col
        fistp   col
        shl     edx,11
        or      edx,col
        fld     [esi].v_x
        fistp   col
        shl     edx,11
        or      edx,col

        mov     esi,startPtr
        mov     lb,esi
        mov     rb,esi
        mov     endPoint,esi

        fld     [esi].p_y               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        add     esi,shadowpsize
@@max_l:

        fld     [esi].p_y
        fcom    st(1)                   ;compare with ymax
        fstsw   ax
        sahf
        jb      @@max
        mov     endPoint,esi
        fst     st(1)                   ;store new ymax
        jmp     @@min
@@max:
        fcom    st(2)                   ;compare with ymin
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,esi
        mov     rb,esi
        fst     st(2)                   ;store new ymin
@@min:  fstp    st

        add     esi,shadowpsize
        cmp     esi,endPtr
        jne     @@max_l
        fstp    st                      ;remove ymax

        fistp   y                       ;y = floor(ymin)


        mov     edi,xres
        imul    edi,y
        shl     edi,2
        add     edi,screenBuf
        mov     x_y,edi

        xor     eax,eax
        mov     lc,eax
        mov     rc,eax

        mov     eax,xres
        shl     eax,2
@@y_l:
        inc     y

                ;l
        dec     lc
        jns     @@l_step

        mov     esi,lb
        mov     ecx,y                   ;ecx = y
@@l_do:
        cmp     esi,endPoint
        je      @@l_finish
        mov     ebx,esi                 ;a = lb
        cmp     esi,startPtr
        jne     @@l0
        mov     esi,endPtr
@@l0:   sub     esi,shadowpsize
        fld     [esi].p_y
        fistp   lc
        sub     lc,ecx                  ;lc = floor(lb->y) - y
        js      @@l_do
        mov     lb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = lb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_x               ;ldx = (lb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     ldx

        fmulp   st(1),st                ;lx = ldx*sy + a->x
        fadd    [ebx].p_x
        fst     lx

        jmp     @@l_end
@@l_step:
        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_end:
                ;r
        dec     rc
        jns     @@r_step

        mov     esi,rb
        mov     ecx,y                   ;ecx = y
@@r_do:
        cmp     esi,endPoint
        je      @@r_finish
        mov     ebx,esi                 ;a = rb
        add     esi,shadowpsize
        cmp     esi,endPtr
        jne     @@r0
        mov     esi,startPtr
@@r0:   fld     [esi].p_y
        fistp   rc
        sub     rc,ecx                  ;rc = floor(rb->y) - y
        js      @@r_do
        mov     rb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = rb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_x               ;rdx = (rb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     rdx

        fmulp   st(1),st                ;rx = rdx*sy + a->x
        fadd    [ebx].p_x
        fst     rx

        jmp     @@r_end
@@r_step:
        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_end:

        fistp   xe                      ;xe = (int) floor(lx)
        fistp   xa                      ;xa = (int) floor(rx)

                                        ;ecx  = Counter
                                        ;edi  = screenBuffer (end)

        mov     edi,xe
        mov     ecx,xa
        sub     ecx,edi
        jz      @@w
        jl      @@0
        add     edi,ecx
        neg     ecx
@@0:
        shl     edi,2
        add     edi,x_y

@@inner:
        add     [edi+ecx*4],edx
        inc     ecx
        jnz     @@inner
@@w:
        add     x_y,eax
        jmp     @@y_l

@@r_finish:
        fstp    st
@@l_finish:
        ret
endp


initAlpha proc near

        mov     ecx,1024*256 -1
@@l:
        mov     eax,ecx
        shr     eax,8
        movzx   edx,cl
        mul     edx
        mov     ebx,255
        div     ebx

        cmp     eax,255
        jle     @@0
        mov     eax,255
@@0:
        mov     redMul[ecx*4],eax
        shl     eax,11
        mov     greenMul[ecx*4],eax
        shl     eax,11
        mov     blueMul[ecx*4],eax

        dec     ecx
        jns     @@l

        ret
endp

txtAlphaPhongPolygon proc pascal
arg     startPtr, endPtr, nParams1, strucSize, map, pMaps

local   rb, lb, endPoint
local   y, x_y, lc, rc
local   lx, ldx, rx, rdx
local   lp:dword:(3 + 2*numLights)
local   ldp:dword:(3 + 2*numLights)
local   rp:dword:(3 + 2*numLights)
local   rdp:dword:(3 + 2*numLights)
local   intp:dword:(3 + 2*numLights)
local   xa, xe
local   i, txt_u, txt_v

        mov     esi,startPtr
        mov     lb,esi
        mov     rb,esi
        mov     endPoint,esi

        fld     [esi].p_y               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        add     esi,strucSize
@@max_l:

        fld     [esi].p_y
        fcom    st(1)                   ;compare with ymax
        fstsw   ax
        sahf
        jb      @@max
        mov     endPoint,esi
        fst     st(1)                   ;store new ymax
        jmp     @@min
@@max:
        fcom    st(2)                   ;compare with ymin
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,esi
        mov     rb,esi
        fst     st(2)                   ;store new ymin
@@min:  fstp    st

        add     esi,strucSize
        cmp     esi,endPtr
        jne     @@max_l
        fstp    st                      ;remove ymax

        fistp   y                       ;y = floor(ymin)


        mov     edi,xres
        imul    edi,y
        shl     edi,2
        add     edi,screenBuf
        mov     x_y,edi

        xor     eax,eax
        mov     lc,eax
        mov     rc,eax
@@y_l:
        inc     y

                ;l
        dec     lc
        jns     @@l_step

        mov     esi,lb
        mov     ecx,y                   ;ecx = y
@@l_do:
        cmp     esi,endPoint
        je      @@l_finish
        mov     ebx,esi                 ;a = lb
        cmp     esi,startPtr
        jne     @@l0
        mov     esi,endPtr
@@l0:   sub     esi,strucSize
        fld     [esi].p_y
        fistp   lc
        sub     lc,ecx                  ;lc = floor(lb->y) - y
        js      @@l_do
        mov     lb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = lb->y - a->y
        fsub    [ebx].p_y


        mov     ecx,nParams1
@@l_params0:
        fld     [esi].p_param[ecx*4]    ;ldp[z] = (lb->param[z] - a->param[z])/dy
        fsub    [ebx].p_param[ecx*4]
        fdiv    st,st(1)
        fst     ldp[ecx*4]

        fmul    st,st(2)                ;lp[z] = ldp[z]*sy + a->param[z];
        fadd    [ebx].p_param[ecx*4]
       fist    intp[ecx*4]
        fstp    lp[ecx*4]

        dec     ecx
        jns     @@l_params0

        fld     [esi].p_x               ;ldx = (lb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     ldx

        fmulp   st(1),st                ;lx = ldx*sy + a->x
        fadd    [ebx].p_x
        fst     lx

        jmp     @@l_end
@@l_step:
        mov     ecx,nParams1
@@l_params1:
        fld     lp[ecx*4]
        fadd    ldp[ecx*4]
       fist    intp[ecx*4]
        fstp    lp[ecx*4]
        dec     ecx
        jns     @@l_params1

        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_end:
                ;r
        dec     rc
        jns     @@r_step

        mov     esi,rb
        mov     ecx,y                   ;ecx = y
@@r_do:
        cmp     esi,endPoint
        je      @@r_finish
        mov     ebx,esi                 ;a = rb
        add     esi,strucSize
        cmp     esi,endPtr
        jne     @@r0
        mov     esi,startPtr
@@r0:   fld     [esi].p_y
        fistp   rc
        sub     rc,ecx                  ;rc = floor(rb->y) - y
        js      @@r_do
        mov     rb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = rb->y - a->y
        fsub    [ebx].p_y


        mov     ecx,nParams1
@@r_params0:
        fld     [esi].p_param[ecx*4]    ;rdp[z] = (rb->param[z] - a->param[z])/dy
        fsub    [ebx].p_param[ecx*4]
        fdiv    st,st(1)
        fst     rdp[ecx*4]

        fmul    st,st(2)                ;rp[z] = rdp[z]*sy + a->param[z];
        fadd    [ebx].p_param[ecx*4]
        fstp    rp[ecx*4]

        dec     ecx
        jns     @@r_params0

        fld     [esi].p_x               ;rdx = (rb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     rdx

        fmulp   st(1),st                ;rx = rdx*sy + a->x
        fadd    [ebx].p_x
        fst     rx

        jmp     @@r_end
@@r_step:
        mov     ecx,nParams1
@@r_params1:
        fld     rp[ecx*4]
        fadd    rdp[ecx*4]
        fstp    rp[ecx*4]
        dec     ecx
        jns     @@r_params1

        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_end:

        fistp   xe                      ;xe = (int) floor(lx)
        fistp   xa                      ;xa = (int) floor(rx)

        mov     edi,xe
        mov     ecx,edi
        sub     ecx,xa
        jle     @@w
        shl     edi,2
        add     edi,x_y

                                        ;eax = 00Aa (alpha channel)
                                        ;ebx = x0Yy
                                        ;edx = TT*X   * <- Y
                                        ;esi = Counter (negative)
                                        ;edi = screenBuffer (end)
                                        ;[esp] = u0Vv
                                        ;[esp+5] = U
                                        ;[esp+8] = 00Bb (alpha delta)

        mov     edx,map                 ;edx = TT00
        shr     edx,2
        mov     ebx,intp[0]             ;ebx = 00Xx
        mov     dl,bh                   ;edx = TT0X
        shl     ebx,24                  ;ebx = x000
        mov     bx,word ptr intp[4]     ;ebx = x0Yy
        mov     eax,intp[8]             ;eax = 00Aa

        mov     esi,divTab
        fld     rp[0]
        fsub    lp[0]
        fmul    dword ptr[esi+ecx*4]
        fistp   intp[0]
        fld     rp[4]
        fsub    lp[4]
        fmul    dword ptr[esi+ecx*4]
        fistp   intp[4]
        fld     rp[8]
        fsub    lp[8]
        fmul    dword ptr[esi+ecx*4]
        fistp   intp[8]

        push    ecx
        mov     esi,ecx
        neg     esi

        push    ebp

        push    intp[8]                 ;[esp+8] = 00Bb (alpha delta)

        mov     ecx,intp[0]             ;ecx = 00Uu
        push    ecx                     ;[esp+5] = U
        shl     ecx,24                  ;eax = u000
        mov     cx,word ptr intp[4]     ;eax = u0Vv
        push    ecx

@@inner:
        mov     ecx,[edi+esi*4]
      not ah
        shl     ecx,8
        and     ecx,3FF00h
        mov     cl,ah
      mov     dh,bh
        mov     ebp,redMul[ecx*4]

        mov     ecx,[edi+esi*4]
        shr     ecx,11 - 8
        and     ecx,3FF00h
        mov     cl,ah
        or      ebp,greenMul[ecx*4]

        mov     ecx,[edi+esi*4]
        shr     ecx,22 - 8
        and     ecx,3FF00h
        mov     cl,ah
        or      ebp,blueMul[ecx*4]

        mov     ecx,[edx*4]
      not     ah
        shl     ecx,8
        and     ecx,3FF00h
        mov     cl,ah
        add     ebp,redMul[ecx*4]

        mov     ecx,[edx*4]
        shr     ecx,11 - 8
        and     ecx,3FF00h
        mov     cl,ah
        add     ebp,greenMul[ecx*4]

        mov     ecx,[edx*4]
        shr     ecx,22 - 8
        and     ecx,3FF00h
      add     ebx,[esp]               ;x0Yy += u0Vv
        mov     cl,ah
      adc     dl,[esp+5]              ;X += U
        add     ebp,blueMul[ecx*4]

        add     eax,[esp+8]             ;00Aa += 00Bb

        mov     [edi+esi*4],ebp

        inc     esi
        jnz     @@inner
        pop     ecx ecx eax ebp ecx

        mov     i,0
@@phong:
        mov     eax,i
        mov     edx,nParams1
        sub     edx,3
        cmp     eax,edx
        jge     @@w

                                        ;eax = u0Vv
                                        ;ebx = x0Yy
                                        ;ecx = 000U
                                        ;edx = TT*X   * <- Y
                                        ;esi = counter (negative)
                                        ;edi = screenBuffer (end)
                                        ;ebp = transfer-reg

        mov     esi,pMaps
        mov     edx,[esi+eax*2]         ;edx = TT00
        shr     edx,2
        mov     ebx,intp[3*4+eax*4]     ;ebx = 00Xx
        mov     dl,bh                   ;edx = TT0X
        shl     ebx,24                  ;ebx = x000
        mov     bx,word ptr intp[4*4+eax*4] ;ebx = x0Yy

        mov     esi,divTab
        fld     rp[3*4+eax*4]
        fsub    lp[3*4+eax*4]
        fmul    dword ptr [esi+ecx*4]
        fistp   txt_u
        fld     rp[4*4+eax*4]
        fsub    lp[4*4+eax*4]
        fmul    dword ptr [esi+ecx*4]
        fistp   txt_v

        push    ecx
        mov     esi,ecx
        neg     esi

        mov     eax,txt_u               ;eax = 00Uu
        mov     cl,ah                   ;cl  = U
        shl     eax,24                  ;eax = u000
        mov     ax,word ptr txt_v       ;eax = u0Vv

        push    ebp
        mov     dh,bh
@@inner2:
        add     ebx,eax                 ;x0Yy += u0Vv
        mov     ebp,[edx*4]
        adc     dl,cl                   ;X += U
        mov     dh,bh
        add     [edi+esi*4],ebp
        inc     esi
        jnz     @@inner2
        pop     ebp ecx

        add     i,2
        jmp     @@phong

@@w:
        mov     eax,xres
        shl     eax,2
        add     x_y,eax
        jmp     @@y_l

@@r_finish:
        fstp    st
@@l_finish:
        ret
endp

txtPhongPolygon proc pascal
arg     startPtr, endPtr, nParams1, strucSize, map, pMaps

local   rb, lb, endPoint
local   y, x_y, lc, rc
local   lx, ldx, rx, rdx
local   lp:dword:(2 + 2*numLights)
local   ldp:dword:(2 + 2*numLights)
local   rp:dword:(2 + 2*numLights)
local   rdp:dword:(2 + 2*numLights)
local   intp:dword:(2 + 2*numLights)
local   xa, xe
local   i, txt_u, txt_v

        mov     esi,startPtr
        mov     lb,esi
        mov     rb,esi
        mov     endPoint,esi

        fld     [esi].p_y               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        add     esi,strucSize
@@max_l:

        fld     [esi].p_y
        fcom    st(1)                   ;compare with ymax
        fstsw   ax
        sahf
        jb      @@max
        mov     endPoint,esi
        fst     st(1)                   ;store new ymax
        jmp     @@min
@@max:
        fcom    st(2)                   ;compare with ymin
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,esi
        mov     rb,esi
        fst     st(2)                   ;store new ymin
@@min:  fstp    st

        add     esi,strucSize
        cmp     esi,endPtr
        jne     @@max_l
        fstp    st                      ;remove ymax

        fistp   y                       ;y = floor(ymin)


        mov     edi,xres
        imul    edi,y
        shl     edi,2
        add     edi,screenBuf
        mov     x_y,edi

        xor     eax,eax
        mov     lc,eax
        mov     rc,eax
@@y_l:
        inc     y

                ;l
        dec     lc
        jns     @@l_step

        mov     esi,lb
        mov     ecx,y                   ;ecx = y
@@l_do:
        cmp     esi,endPoint
        je      @@l_finish
        mov     ebx,esi                 ;a = lb
        cmp     esi,startPtr
        jne     @@l0
        mov     esi,endPtr
@@l0:   sub     esi,strucSize
        fld     [esi].p_y
        fistp   lc
        sub     lc,ecx                  ;lc = floor(lb->y) - y
        js      @@l_do
        mov     lb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = lb->y - a->y
        fsub    [ebx].p_y


        mov     ecx,nParams1
@@l_params0:
        fld     [esi].p_param[ecx*4]    ;ldp[z] = (lb->param[z] - a->param[z])/dy
        fsub    [ebx].p_param[ecx*4]
        fdiv    st,st(1)
        fst     ldp[ecx*4]

        fmul    st,st(2)                ;lp[z] = ldp[z]*sy + a->param[z];
        fadd    [ebx].p_param[ecx*4]
       fist    intp[ecx*4]
        fstp    lp[ecx*4]

        dec     ecx
        jns     @@l_params0

        fld     [esi].p_x               ;ldx = (lb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     ldx

        fmulp   st(1),st                ;lx = ldx*sy + a->x
        fadd    [ebx].p_x
        fst     lx

        jmp     @@l_end
@@l_step:
        mov     ecx,nParams1
@@l_params1:
        fld     lp[ecx*4]
        fadd    ldp[ecx*4]
       fist    intp[ecx*4]
        fstp    lp[ecx*4]
        dec     ecx
        jns     @@l_params1

        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_end:
                ;r
        dec     rc
        jns     @@r_step

        mov     esi,rb
        mov     ecx,y                   ;ecx = y
@@r_do:
        cmp     esi,endPoint
        je      @@r_finish
        mov     ebx,esi                 ;a = rb
        add     esi,strucSize
        cmp     esi,endPtr
        jne     @@r0
        mov     esi,startPtr
@@r0:   fld     [esi].p_y
        fistp   rc
        sub     rc,ecx                  ;rc = floor(rb->y) - y
        js      @@r_do
        mov     rb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = rb->y - a->y
        fsub    [ebx].p_y


        mov     ecx,nParams1
@@r_params0:
        fld     [esi].p_param[ecx*4]    ;rdp[z] = (rb->param[z] - a->param[z])/dy
        fsub    [ebx].p_param[ecx*4]
        fdiv    st,st(1)
        fst     rdp[ecx*4]

        fmul    st,st(2)                ;rp[z] = rdp[z]*sy + a->param[z];
        fadd    [ebx].p_param[ecx*4]
        fstp    rp[ecx*4]

        dec     ecx
        jns     @@r_params0

        fld     [esi].p_x               ;rdx = (rb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     rdx

        fmulp   st(1),st                ;rx = rdx*sy + a->x
        fadd    [ebx].p_x
        fst     rx

        jmp     @@r_end
@@r_step:
        mov     ecx,nParams1
@@r_params1:
        fld     rp[ecx*4]
        fadd    rdp[ecx*4]
        fstp    rp[ecx*4]
        dec     ecx
        jns     @@r_params1

        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_end:

        fistp   xe                      ;xe = (int) floor(lx)
        fistp   xa                      ;xa = (int) floor(rx)

        mov     edi,xe
        mov     ecx,edi
        sub     ecx,xa
        jle     @@w
        shl     edi,2
        add     edi,x_y

                                        ;eax = u0Vv
                                        ;ebx = x0Yy
                                        ;ecx = 000U
                                        ;edx = TT*X   * <- Y
                                        ;esi = counter (negative)
                                        ;edi = screenBuffer (end)
                                        ;ebp = transfer-reg

        mov     edx,map                 ;edx = TT00
        shr     edx,2
        mov     ebx,intp[0]             ;ebx = 00Xx
        mov     dl,bh                   ;edx = TT0X
        shl     ebx,24                  ;ebx = x000
        mov     bx,word ptr intp[4]     ;ebx = x0Yy

        mov     esi,divTab
        fld     rp[0]
        fsub    lp[0]
        fmul    dword ptr [esi+ecx*4]
        fistp   txt_u
        fld     rp[4]
        fsub    lp[4]
        fmul    dword ptr [esi+ecx*4]
        fistp   txt_v

        push    ecx
        mov     esi,ecx
        neg     esi

        mov     eax,txt_u               ;eax = 00Uu
        mov     cl,ah                   ;cl  = U
        shl     eax,24                  ;eax = u000
        mov     ax,word ptr txt_v       ;eax = u0Vv

        push    ebp
        mov     dh,bh
@@inner:
        add     ebx,eax                 ;x0Yy += u0Vv
        mov     ebp,[edx*4]
        adc     dl,cl                   ;X += U
        mov     dh,bh
        mov     [edi+esi*4],ebp
        inc     esi
        jnz     @@inner
        pop     ebp ecx


        mov     i,0
@@phong:
        mov     eax,i
        mov     edx,nParams1
        sub     edx,2
        cmp     eax,edx
        jge     @@w

                                        ;eax = u0Vv
                                        ;ebx = x0Yy
                                        ;ecx = 000U
                                        ;edx = TT*X   * <- Y
                                        ;esi = counter (negative)
                                        ;edi = screenBuffer (end)
                                        ;ebp = transfer-reg

        mov     esi,pMaps
        mov     edx,[esi+eax*2]         ;edx = TT00
        shr     edx,2
        mov     ebx,intp[2*4+eax*4]     ;ebx = 00Xx
        mov     dl,bh                   ;edx = TT0X
        shl     ebx,24                  ;ebx = x000
        mov     bx,word ptr intp[3*4+eax*4] ;ebx = x0Yy

        mov     esi,divTab
        fld     rp[2*4+eax*4]
        fsub    lp[2*4+eax*4]
        fmul    dword ptr [esi+ecx*4]
        fistp   txt_u
        fld     rp[3*4+eax*4]
        fsub    lp[3*4+eax*4]
        fmul    dword ptr [esi+ecx*4]
        fistp   txt_v

        push    ecx
        mov     esi,ecx
        neg     esi

        mov     eax,txt_u               ;eax = 00Uu
        mov     cl,ah                   ;cl  = U
        shl     eax,24                  ;eax = u000
        mov     ax,word ptr txt_v       ;eax = u0Vv

        push    ebp
        mov     dh,bh
@@inner2:
        add     ebx,eax                 ;x0Yy += u0Vv
        mov     ebp,[edx*4]
        adc     dl,cl                   ;X += U
        mov     dh,bh
        add     [edi+esi*4],ebp
        inc     esi
        jnz     @@inner2
        pop     ebp ecx

        add     i,2
        jmp     @@phong

@@w:
        mov     eax,xres
        shl     eax,2
        add     x_y,eax
        jmp     @@y_l

@@r_finish:
        fstp    st
@@l_finish:
        ret
endp

txtaddPolygon proc pascal
arg     startPtr, endPtr, map

local   rb, lb, endPoint
local   y, x_y, lc, rc
local   lx, ldx, rx, rdx
local   lu, ldu, lv, ldv, ru, rdu, rv, rdv
local   txt_x, txt_y, xa, xe

        mov     esi,startPtr
        mov     lb,esi
        mov     rb,esi
        mov     endPoint,esi

        fld     [esi].p_y               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        add     esi,mappsize
@@max_l:

        fld     [esi].p_y
        fcom    st(1)                   ;compare with ymax
        fstsw   ax
        sahf
        jb      @@max
        mov     endPoint,esi
        fst     st(1)                   ;store new ymax
        jmp     @@min
@@max:
        fcom    st(2)                   ;compare with ymin
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,esi
        mov     rb,esi
        fst     st(2)                   ;store new ymin
@@min:  fstp    st

        add     esi,mappsize
        cmp     esi,endPtr
        jne     @@max_l
        fstp    st                      ;remove ymax

        fistp   y                       ;y = floor(ymin)


        mov     edi,xres
        imul    edi,y
        shl     edi,2
        add     edi,screenBuf
        mov     x_y,edi

        xor     eax,eax
        mov     lc,eax
        mov     rc,eax
@@y_l:
        inc     y

                ;l
        dec     lc
        jns     @@l_step

        mov     esi,lb
        mov     ecx,y                   ;ecx = y
@@l_do:
        cmp     esi,endPoint
        je      @@l_finish
        mov     ebx,esi                 ;a = lb
        cmp     esi,startPtr
        jne     @@l0
        mov     esi,endPtr
@@l0:   sub     esi,mappsize
        fld     [esi].p_y
        fistp   lc
        sub     lc,ecx                  ;lc = floor(lb->y) - y
        js      @@l_do
        mov     lb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = lb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_u               ;ldu = (lb->u - a->u)/dy
        fsub    [ebx].p_u
        fdiv    st,st(1)
        fst     ldu

        fmul    st,st(2)                ;lu = ldu*sy + a->u;
        fadd    [ebx].p_u
       fist    txt_x
        fstp    lu

        fld     [esi].p_v               ;ldv = (lb->v - a->v)/dy
        fsub    [ebx].p_v
        fdiv    st,st(1)
        fst     ldv

        fmul    st,st(2)                ;lv = ldv*sy + a->v;
        fadd    [ebx].p_v
       fist    txt_y
        fstp    lv

        fld     [esi].p_x               ;ldx = (lb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     ldx

        fmulp   st(1),st                ;lx = ldx*sy + a->x
        fadd    [ebx].p_x
        fst     lx

        jmp     @@l_end
@@l_step:
        fld     lu
        fadd    ldu
       fist    txt_x
        fstp    lu

        fld     lv
        fadd    ldv
       fist    txt_y
        fstp    lv

        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_end:
                ;r
        dec     rc
        jns     @@r_step

        mov     esi,rb
        mov     ecx,y                   ;ecx = y
@@r_do:
        cmp     esi,endPoint
        je      @@r_finish
        mov     ebx,esi                 ;a = rb
        add     esi,mappsize
        cmp     esi,endPtr
        jne     @@r0
        mov     esi,startPtr
@@r0:   fld     [esi].p_y
        fistp   rc
        sub     rc,ecx                  ;rc = floor(rb->y) - y
        js      @@r_do
        mov     rb,esi

        fild    y                       ;sy = y - a->y
        fsub    [ebx].p_y

        fld     [esi].p_y               ;dy = rb->y - a->y
        fsub    [ebx].p_y


        fld     [esi].p_u               ;rdu = (rb->u - a->u)/dy
        fsub    [ebx].p_u
        fdiv    st,st(1)
        fst     rdu

        fmul    st,st(2)                ;ru = rdu*sy + a->u;
        fadd    [ebx].p_u
        fstp    ru

        fld     [esi].p_v               ;rdv = (rb->v - a->v)/dy
        fsub    [ebx].p_v
        fdiv    st,st(1)
        fst     rdv

        fmul    st,st(2)                ;rv = rdv*sy + a->v;
        fadd    [ebx].p_v
        fstp    rv

        fld     [esi].p_x               ;rdx = (rb->x - a->x)/dy
        fsub    [ebx].p_x
        fdivrp  st(1),st
        fst     rdx

        fmulp   st(1),st                ;rx = rdx*sy + a->x
        fadd    [ebx].p_x
        fst     rx

        jmp     @@r_end
@@r_step:
        fld     ru
        fadd    rdu
        fstp    ru

        fld     rv
        fadd    rdv
        fstp    rv

        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_end:

        fistp   xe                      ;xe = (int) floor(lx)
        fistp   xa                      ;xa = (int) floor(rx)

                                        ;eax = u0Vv
                                        ;ebx = x0Yy
                                        ;ecx = 000U
                                        ;edx = TT*X   * <- Y
                                        ;esi = counter (negative)
                                        ;edi = screenBuffer (end)
                                        ;ebp = transfer-reg
        mov     edi,xe
        mov     ecx,edi
        sub     ecx,xa
        jle     @@w
        shl     edi,2
        add     edi,x_y

        mov     edx,map                 ;edx = TT00
        shr     edx,2
        mov     ebx,txt_x               ;ebx = 00Xx
        mov     dl,bh                   ;edx = TT0X
        shl     ebx,24                  ;ebx = x000
        mov     bx,word ptr txt_y       ;ebx = x0Yy

        mov     esi,divTab
        fld     ru
        fsub    lu
        fmul    dword ptr[esi+ecx*4]
        fistp   txt_x
        fld     rv
        fsub    lv
        fmul    dword ptr[esi+ecx*4]
        fistp   txt_y

        mov     esi,ecx
        neg     esi

        mov     eax,txt_x               ;eax = 00Uu
        mov     cl,ah                   ;cl  = U
        shl     eax,24                  ;eax = u000
        mov     ax,word ptr txt_y       ;eax = u0Vv

        push    ebp
        mov     dh,bh
@@inner:
        add     ebx,eax                 ;x0Yy += u0Vv
        mov     ebp,[edx*4]
        adc     dl,cl                   ;X += U
        mov     dh,bh
        add     [edi+esi*4],ebp
        inc     esi
        jnz     @@inner

        pop     ebp

@@w:
        mov     eax,xres
        shl     eax,2
        add     x_y,eax
        jmp     @@y_l

@@r_finish:
        fstp    st
@@l_finish:
        ret
endp


end

