#ifndef _REMIX_H_
#define _REMIX_H_

#include "types.h"
#include "vector.h"

#define numLights 2
#define sortListLen 1024

#define STEP 256
#define LD_STEP 8

typedef struct {
  float x;
  float y;
} Point;

//--- vector 2
typedef struct {
  double x;
  double y;
} Vector2;

//--- tracks
/*
typedef struct {
  float P;
  int frame;
} Key1;

typedef struct {
  Key1 *key;
  int startFrame;
  int endFrame;
  float P1;
  float R1;
  float P2;
  float R2;
} Track1;
*/
typedef struct {
  Vector P;
  int frame;
} Key3;

typedef struct {
  Key3 *key;
  int startFrame;
  int endFrame;
  Vector P1;
  Vector R1;
  float adj1;
  Vector P2;
  Vector R2;
  float adj2;
  float nextAdj;
} Track3;
/*
typedef struct {
  int *key;
  int state;
} SwitchTrack;
*/

typedef struct {
  double value;
  int frame;
} DKey1;

typedef struct {
  DKey1 *key;
} STrack1;


//--- camera
typedef struct {
  Vector p;
  Vector lx;
  Vector ly;
  Vector lz;
} Camera;

//--- texture map generator
typedef struct {
  unsigned char *r;
//  unsigned char *g;
//  unsigned char *b;
  int shift;
  int mask;
  float *filter;
  uchar *result;
} MapInfo;

//--- wall
typedef struct {
  float u;
  float v;
} WVertexAttr;

typedef struct {
  int idx[4];
} WFace;

typedef struct {
  int nVerts;
  Vector *verts;
  WVertexAttr *attribs;
  int nFaces;
  WFace *faces;
  Vector p; // position
  Vector u; // u vector in plane
  Vector v; // v vector in plane
  Vector n; // normal
  float xscale;
  float yscale;
  uint *binfo[numLights];
} Wall;

typedef struct {
  float x;
  float y;
  float u;
  float v;
} WScreenPoint;

//--- physical stuff

typedef struct {
  DVector p;
  DVector v;
  Vector tp;
} Mass;

typedef struct { // collision edge
  Mass *ma;
  Mass *mb;
} CEdge;


typedef struct { // collision face
  Mass *ma;
  Mass *mb;
  Mass *mc;
  DVector n; //normal with length = 1.0
  //vertex weight calculation for collision
  int orientation; //0: xy, 1: yz, 2: zx
  //inverse matrix
  DVector M1;
  DVector M2;
  DVector M3;
} CFace;


//--- engine structures ---

//--- geometry
typedef struct {
  int a;
  int b;
  int c;
  int light;
} Face;

typedef struct {
  float u;
  float v;
} Mapping;

typedef struct {
  char *vTags;        //vertex tags
  Vector *sVerts;     //shadow vertices
  Vector *lVerts;     //light vertices
  char *fTags;        //face tags
  float *lIntensities;//light face intensity
//  Vector lightDir;    //direction vector to light
} LightInfo;

typedef struct {
  char *vTags;
  Mapping *mapping;
} PhongInfo;

typedef struct {
  float *mapping;
} AnisoInfo;

typedef struct {
  int nMasses;
  Mass *masses;

  int nCEdges;
  CEdge *cEdges;
  int nCFaces;
  CFace *cFaces;

  int nVerts;
  Vector *verts;
  Vector *normals;
  Mapping *mapping;
  float *alpha;
  int nFaces;
  Face *faces;

  DVector bound1;
  DVector bound2;
  Vector center;

  LightInfo linfo[numLights];
  PhongInfo pinfo[numLights];
} Object;

//lamp
typedef struct {
  int numFrames;
  Vector2 p;
} LKey;

typedef struct {
//  double zFloor;
  int numKeys;
  LKey *key;
  Vector2 rLast;
} LTrack;

typedef struct {
  Vector2 p1;
  Vector2 r1;
  Vector2 r2;
  Vector2 p2;
} LState;

typedef struct {
  int nVerts;
  Vector *verts;
  Vector *normals;

  int nFaces;
  Face *faces;

  AnisoInfo ainfo[numLights];
} LSubObject;

typedef struct {
  LSubObject *subObject;
  Camera matrix;
} LNode;

typedef struct {
  bool onFloor;
  bool first;

  Mass m1;
  Mass m2;
  Mass mH;
  Mass mF;

  int numTracks;
  LTrack *track;
  int countpos;
  int numFrames; // number of frames for current section
  LState state;
  Vector2 nextR1;

  STrack1 orientTrack;
  Vector2 orient;

  STrack1 headTrack;
  Vector2 head;

  int nNodes;
  LNode *nodes;

  int nLightVerts;
  Point *lPoints;
  Vector *lVerts;     //light vertices
  float *lIntensities;//light face intensity
  int nLightFaces;
  Face *lFaces;
} Lamp;

//chain
typedef struct {
  Mass *m1;
  Mass *m2;
  DVector lx;
  DVector lz;
} ChainLocal;

typedef struct {

  int nMasses;
  Mass *masses;

  Mass *anchor1;
  Mass *anchor2;

  double elementLen;

  ChainLocal *local;

  int nRotations;
  Point *ring;

  int nVerts;
  Vector *verts;
  Vector *normals;

  int nFaces;
  Face *faces;

  AnisoInfo ainfo[numLights];
} Chain;

/*
typedef struct {
  Mass m;
  int state;
} Particle;


typedef struct {
  int nMasses;
  Mass *masses;

  int nVerts;
  Vector *verts;
  Vector *normals;
  Mapping *mapping;

  int nFaces;
  Face *faces;

  Vector center;

  PhongInfo pinfo[numLights];
} Cloth;
*/

//--- clip
typedef struct {
  float x;
  float y;
  float z;
  float dist; // for clipping
  int clip;   // tag for clipping
  float param[1];
} ParamPoint;

typedef struct {
  int nParams;
  int size;
  ParamPoint *start;
  ParamPoint *end;
} ClipInfo;


//--- texture mapping & rgb shading
/*typedef struct {
  float x;
  float y;
  int r, g, b;
} RgbPoint;*/

//--- visualization ---

//--- sorting
typedef struct List {
  struct List *next;
  void (*paint)(struct List *, ParamPoint *, ParamPoint *);
} List;

typedef struct {
  List head;
  Vector *v[3];
  Mapping *mapping;
  float *alpha;
  Face *face;
  PhongInfo *pinfo;
} SortFace;

typedef struct {
  List head;
  Camera camera;
  float minDist;
  Vector *v[4];
  Object *obj;
} SortMirror;

typedef struct {
  List head;
  Vector *v[3];
  Face *face;
  AnisoInfo *ainfo;
} SortAniso;

typedef struct {
  List head;
  Vector *v[3];
  Face *face;
  int col;
} SortPlain;

typedef struct {
  List head;
  float x;
  float y;
  uint *map;
  float size;
} SortLight;

typedef struct {
  int x;
  int y;
  int w;
  int h;
  int ow;
  int oh;
} Rectangle;


void initTrack3(Track3 *track, Key3 *key);
void doTrack3(Track3 *track, int frame, Vector *p);
/*void initSwitchTrack(SwitchTrack *track, int *key);
int doSwitchTrack(SwitchTrack *track, int frame);
*/

void step();
void render();
//void initTracks();
void setLocations();
void initIntro(int xres, int yres);

#endif