#include <stdio.h>

#include "mapread.h"
#include "cdata.h"


int main(int argn, char **argv) {
  char *arg;
  char s[100];
  GifRead mapRead;
  Color *pal;
  int z, xres, yres, x, y;

  arg = (argn > 1) ? argv[1] : "laby";
  sprintf(s, "%s.gif", arg);
  Reader r(s);
  if (!mapRead.readMap(r)) {
    printf("Error reading Bitmap\n");
    return 1;
  }
  sprintf(s, "%s.cpp", arg);
  CData data(s);

  xres = mapRead.getXRes();
  yres = mapRead.getYRes();
printf("xres %d yres %d\n", xres, yres);

  // resolution
  sprintf(s, "int %sRes[]", arg);
  data.setLabel(s);
  data.putValue(xres);
  data.putValue(yres);

  // palette
  sprintf(s, "unsigned char %sPal[]", arg);
  data.setLabel(s);

  pal = mapRead.getPalette();
  for (z = 0; z < 256; z++) {
    data.putValue(pal[z].c[0]);
    data.putValue(pal[z].c[1]);
    data.putValue(pal[z].c[2]);
  }

  // data
  sprintf(s, "unsigned char %sPic[]", arg);
  data.setLabel(s);

  for (y = 0; y < yres; y++) {
    for (x = 0; x < xres; x++) {
      data.putValue(mapRead.getPPixel(x, y));
    }
  }
  return 0;
}