/* Simon Frankau, and Now3d's demo doodah. Woah. */

#include <stdlib.h>
#include <sys/types.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#include "Addrs.h"

#define FIRE_COUNT 2000

static LINE_F2 star;

/* Lines! */
struct {
	int x, y, vx, vy;
	int r, g, b;
   int active;
} fires[FIRE_COUNT];

static int cnt;

void add_firework(int i);

void do_firework(void)
{
	int i, x, y;

	for (i=0; i<cnt; i++) {
		if (!fires[i].active)
      	continue;
		x = fires[i].x;
		y = fires[i].y;
		fires[i].x += fires[i].vx;
		fires[i].y += fires[i].vy;
		fires[i].vy -= 1;
		setRGB0(&star, fires[i].r, fires[i].g, fires[i].b);
		setXY2(&star, x, 256-y, fires[i].x, 256-fires[i].y);
		fires[i].r -= 8;
		if (fires[i].r < 0)
			fires[i].r = 0;
		fires[i].g -= 8;
		if (fires[i].g < 0)
			fires[i].g = 0;
		fires[i].b -= 8;
		if (fires[i].b < 0)
			fires[i].b = 0;
		if ((fires[i].y < 256) || (y < 256))
			DrawPrim(&star);
		if (fires[i].y < 0) {
			if (cnt < FIRE_COUNT) {
				add_firework(i);
				add_firework(cnt++);
			} else {
         	fires[i].active = 0;
			}
		}
	}
}

void add_firework(int i)
{
	fires[i].active = 1;
	fires[i].x = 160;
	fires[i].y = 0;
	fires[i].vx = (rand()*20)/RAND_MAX - 10;
	fires[i].vy = (rand()*20)/RAND_MAX + 10;
	fires[i].r = (rand()*128)/RAND_MAX + 128;
	fires[i].g = (rand()*128)/RAND_MAX + 128;
	fires[i].b = (rand()*128)/RAND_MAX + 128;
}

void init_firework_stuff(void)
{
	setLineF2(&star);
	cnt = 1;
	add_firework(0);
}

