//
//  SOLID 3.ds test example
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <time.h>

#include        "newtypes.h"

#include    "genesis\vesa.h"
#include    "genesis\vga.h"

#include    "genesis\solid3.h"/*
#include    "..\src\solid3.h"
#include    "..\src\engine.h"
#include    "..\src\scene.h"
#include    "..\src\bin_3ds.h"
#include    "..\src\bin_asc.h"
#include    "..\src\bin_scn.h"
#include    "..\src\vector.h"
#include    "..\src\matrix.h"
#include    "..\src\render.h"
#include    "..\src\flares.h"
#include    "..\src\psys.h"
*/
#include    "command.h"


//#define ASC_SAVE
//#define SCN_LOAD
#define _PAUSE
#define DISPLAY
#define FRAME_STEP  1.0

int X_RES = 320;
int Y_RES = 200;

#define DEBUG

WORD    * pVideo = NULL;

void RGB_blend15x( long amount, void * src, void * dst );
#pragma aux RGB_blend15x = \
    "shr    ecx, 1" \
"again:" \
    "mov    eax, DWORD PTR [esi]" \
    "mov    ebx, DWORD PTR [edi]" \
    "and    eax, 01111011110111100111101111011110b" \
    "and    ebx, 01111011110111100111101111011110b" \
    "add    eax, ebx" \
    "shr    eax, 1" \
    "mov    DWORD PTR [edi], eax" \
    "add    esi, 4" \
    "add    edi, 4" \
    "dec    ecx" \
    "jnz    again" \
    parm [ecx] [esi] [edi];

int main( int argc, char * argv[] )
{
    SLD_SCENE   * scn1, * scn2, * scn3, * scn4;
    SLD_CAMERA  * cam;
    char        op, * ext, asc = 0, name[16], map_dir[128];
    WORD        * pVir, * pVir2;
    int         error, i, fps = 0, solid_options = SOLID_MORPH;
    int         vbe_debug = 0, blur = 0, psys = 0;
    clock_t     start_time, end_time;
    float       frame = 0;
#ifdef ENLAR
    int         oldmode = 0;
#endif

    pVir = (WORD *)malloc( X_RES * Y_RES * sizeof( WORD ) );
    pVir2 = (WORD *)malloc( X_RES * Y_RES * sizeof( WORD ) );

    SOLID_initParticles( 20000L );

    SOLID_load_SCN( "data\\fw1\\fw12.scn", &scn1 );puts("1");
    SOLID_load_SCN( "data\\fw2\\fw24.scn", &scn2 );puts("2");
    SOLID_load_SCN( "data\\mw2\\mw2.scn", &scn3 );puts("3");
    SOLID_load_SCN( "data\\fw3\\fw3.scn", &scn4 );puts("4");    
       
    SOLID_initEngine( SOLID_HIERARCHY | SOLID_USENORMS | SOLID_PARTICLESYS | SOLID_MORPH, 320, 200 );    
    SOLID_initFlares();    
    puts( "\nSOLID initialized." );
    getch();
    
    SOLID_initScene( scn1, "data\\fw1", 100, 0 );
    SOLID_initScene( scn2, "data\\fw2", 100, 0 );
    SOLID_initScene( scn3, "data\\mw2", 100, 0 );
    SOLID_initScene( scn4, "data\\fw3", 100, 0 );
    puts( "\nSCENEs initialized." );
    getch();

    cam = (SLD_CAMERA *)scn1->cam_list->data;
    if( cam == NULL ) {
        puts( "\nNO CAMERA DEFINED!" );
        goto fire_exit;
    }
    cam->screen_x = (float)320;
    cam->screen_y = (float)200;
    cam->aspect_ratio = 0.75;//(float)Y_RES/(float)X_RES;
    SOLID_setActiveCamera( scn1, cam );
    
    cam = (SLD_CAMERA *)scn2->cam_list->data;
    if( cam == NULL ) {
        puts( "\nNO CAMERA DEFINED!" );
        goto fire_exit;
    }
    cam->screen_x = (float)320;
    cam->screen_y = (float)200;
    cam->aspect_ratio = 0.75;//(float)Y_RES/(float)X_RES;
    SOLID_setActiveCamera( scn2, cam );

    cam = (SLD_CAMERA *)scn3->cam_list->data;
    if( cam == NULL ) {
        puts( "\nNO CAMERA DEFINED!" );
        goto fire_exit;
    }
    cam->screen_x = (float)320;
    cam->screen_y = (float)200;
    cam->aspect_ratio = 0.75;//(float)Y_RES/(float)X_RES;
    SOLID_setActiveCamera( scn3, cam );

    cam = (SLD_CAMERA *)scn4->cam_list->data;
    if( cam == NULL ) {
        puts( "\nNO CAMERA DEFINED!" );
        goto fire_exit;
    }
    cam->screen_x = (float)320;
    cam->screen_y = (float)200;
    cam->aspect_ratio = 0.75;//(float)Y_RES/(float)X_RES;
    SOLID_setActiveCamera( scn4, cam );

    puts( "\nClaiming God EnLar's VESA Kernel not to crash.\nPress the last key..." );
    getch();
    VESA_init( VESA_FLAG_QUIET );
    VESA_setMode( X_RES, Y_RES, 15 );

    for( scn1->f_current = scn1->f_start; scn1->f_current < scn1->f_end; scn1->f_current += 1.0 ) {
        SOLID_updateKeyframer( scn1, scn1->f_current, 0 );    // 1 para detencion de particulas
        SOLID_updateWorld( scn1 );

        memset( pVir, 0, 320 * 200 * sizeof( WORD ) );
        SOLID_renderScene( scn1, pVir );

        VESA_copyBuffer( 0, (UBYTE*)pVir, X_RES * Y_RES * sizeof( WORD ) );
    }
    SOLID_resetParticles();
    SOLID_freeScene( scn1 );

    for( scn2->f_current = scn2->f_start; scn2->f_current < scn2->f_end; scn2->f_current += 1 ) {
        SOLID_updateKeyframer( scn2, scn2->f_current, 0 );    // 1 para detencion de particulas
        SOLID_updateWorld( scn2 );

        memset( pVir, 0, 320 * 200 * sizeof( WORD ) );
        SOLID_renderScene( scn2, pVir );

        VESA_copyBuffer( 0, (UBYTE*)pVir, X_RES * Y_RES * sizeof( WORD ) );
    }
    SOLID_resetParticles();
    SOLID_freeScene( scn2 );

    for( scn3->f_current = scn3->f_start; scn3->f_current < scn3->f_end; scn3->f_current += 1.0 ) {
        SOLID_updateKeyframer( scn3, scn3->f_current, 0 );    // 1 para detencion de particulas
        SOLID_updateWorld( scn3 );

        memset( pVir, 0, 320 * 200 * sizeof( WORD ) );
        SOLID_renderScene( scn3, pVir );

        VESA_copyBuffer( 0, (UBYTE*)pVir, X_RES * Y_RES * sizeof( WORD ) );
    }
    SOLID_resetParticles();
    SOLID_freeScene( scn3 );

    for( scn4->f_current = scn4->f_start; scn4->f_current < scn4->f_end; scn4->f_current += 1.0 ) {
        SOLID_updateKeyframer( scn4, scn4->f_current, 0 );    // 1 para detencion de particulas
        SOLID_updateWorld( scn4 );

        memset( pVir, 0, 320 * 200 * sizeof( WORD ) );
        SOLID_renderScene( scn4, pVir );

        VESA_copyBuffer( 0, (UBYTE*)pVir, X_RES * Y_RES * sizeof( WORD ) );
    }

fire_exit:
    
    SOLID_freeScene( scn4 );
    SOLID_freeParticles();
    puts( "SCENE memory free." );

    VGA_setMode( 0x03 );
    VESA_finish();

    free( pVir );

    puts( "\nDoes God exist?" );
    return( 0 );
}

