/*
 Ŀ
  FILE        : render.c                 VERSION : 1.3     DATE : 12/07/1998 
  DESCRIPTION : IceClimber DrawFunctions                                     
                                                                             
 Ĵ
  Copyright (C) 1998 by Yannick Suter aka AsC/Nowadays                       
 
*/

#include "libs/header.h"


//*******************************************************rENDERfUNCTION!

void drawPAUSE(GsOT *ot)
{
    pause_pic.x = 110;
    pause_pic.y = 100;

    GsSortFastSprite(&pause_pic,ot,0);
}

void drawSTAR(GsOT *ot)
{
    star_pic.x = GLOBAL_x + 120;
    star_pic.y = GLOBAL_y + 40;

    if(!star_delay) {
        star_ind++; star_ind = (star_ind == 3) ? 0: star_ind;
        star_delay = starDELAY;
    } else star_delay--;

    star_pic.v = star_ind * 16;

    GsSortFastSprite(&star_pic,ot,0);
}

void drawLIVES(GsOT *ot,int ind)
{
    int x;

    lives.u = 32;
    lives.v = 10+8*ind;
    lives.y = 30;
    lives.x = 60+180*ind;

    for(x=0;x<harry[ind].numLIVES;x++){
        GsSortFastSprite(&lives,ot,0);
        lives.x += 12;
    }
}

void reset_wolke(int l,int min,int max,int x_min,int x_max,int ind)
{
    int dmin = min>>3;
    int dmax = max>>3;

    for(;dmin<dmax;dmin++){
        level[l].status[0][dmin]  = 0;
    }

    dmin = x_min>>3;
    dmax = x_max>>3;

    for(;dmin<dmax;dmin++){
        level[l].status[0][dmin]  = ind + 10;
    }
}

void drawWOLKE(GsOT *ot)
{
    int x;
    for(x=0;x<numWOLKE;x++){
 
        wolke.x = GLOBAL_x + d_wolke[x].x;
        wolke.y = GLOBAL_y + d_wolke[x].y;

        GsSortFastSprite(&wolke,ot,0);

        reset_wolke(d_wolke[x].level,d_wolke[x].min_x,d_wolke[x].max_x,d_wolke[x].x,d_wolke[x].x+35,x);
    }
}


//********************************************************** All Harry Fncts

void drawHARRY(int ind,GsOT *ot,int prio,int ref)
{
    int d;

    // setup HarrySprite infos
    harry_sp.r = 128;
    harry_sp.g = 128;
    harry_sp.b = 128;

    showCHAR(ind);

    if(harry[ind].init){
        d = harry[ind].init % 2;
        harry[ind].init--;
        if(!d){ harry_sp.r = 0;harry_sp.g = 0;harry_sp.b = 0;}
    }

    GsSortFastSprite(&harry_sp,ot,prio);
}

void showCHAR(int ind)
{
    int ind_u,ind_v;

    ind_u = (harry[ind].jump | harry[ind].hit);
    ind_v = harry[ind].direction * 4 + ((harry[ind].walk & !harry[ind].jump & !harry[ind].hit) * harry[ind].walkframe) + (harry[ind].jump * harry[ind].jumpframe) + (harry[ind].hit * harry[ind].hitframe);

    harry_sp.x = GLOBAL_x + harry[ind].x + coorect_x[ind_v][ind_u];
    harry_sp.y = GLOBAL_y + harry[ind].y - jump_h[harry[ind].jumpind];

    if(!harry[ind].knok) {
        harry_sp.u = (ind_u * 21) + ind * 42;
    } else {

         if(harry[ind].delay%2)
         {
            harry_sp.r = 0;
            harry_sp.g = 0;
            harry_sp.b = 0;
         }

         harry_sp.u = (ind_u * 21) + 2 * 42;
    }

    harry_sp.v = ind_v * 28;
}

//********************************************************** Draw Levels

void drawLevels(GsOT *ot)
{
    int x;
    for(x=0;x<numLEVEL;x++)
    {
        tile->x = GLOBAL_x;
        tile->y = GLOBAL_y + level[x].offs_y;
        tile->v = level[x].levelNR*40;

        GsSortFastSprite(tile,ot,0);
        drawBLOCK(ot,x);
    }
}

void drawBLOCK(GsOT *ot,int ind)
{
    int x,y;

    for(y=0;y<2;y++)
        for(x=0;x<32;x++){
            if((level[ind].status[y][x]<10) && (level[ind].status[y][x])){
                if(level[ind].art[y][x]==6)
                {
                    if(level[ind].levelNR != level[ind+1].levelNR) block2_sp.u = 8*(level[ind].levelNR + 3);
                    else block2_sp.u = 8*(level[ind].levelNR);

                    block2_sp.x = GLOBAL_x + level[ind].foffs_x + (8*x);
                    block2_sp.y = GLOBAL_y + level[ind].foffs_y - 40;
                    GsSortFastSprite(&block2_sp,ot,1);

                } else
                {
                    block_sp.u = 8*(level[ind].art[y][x]);
                    block_sp.v = 8*(level[ind].levelNR);
                    block_sp.x = GLOBAL_x + level[ind].foffs_x + (8*x);
                    block_sp.y = GLOBAL_y + level[ind].foffs_y + (8*y);
                    GsSortFastSprite(&block_sp,ot,1);
                }
            }
    }
}

//********************************************************** Draw NMEs

void drawPINGU(GsOT *ot)
{
    int x;

    for(x=0;x<numPINGU;x++)
    {
        nme.x = GLOBAL_x + pin[x].x;
        nme.y = GLOBAL_y + pin[x].y - jump_h[pin[x].jumpind];

        nme.u = pin[x].dir*16;
        nme.v = pin[x].frame*16 + pin[x].naz*32;
        
        GsSortFastSprite(&nme,ot,0);

        if(pin[x].ice){
            ice.x = GLOBAL_x + pin[x].x - 7 + (1-pin[x].dir) * 24;
            ice.y = GLOBAL_y + pin[x].y + 6;
            GsSortFastSprite(&ice,ot,0);
        }
    }
}

void drawBIRD(GsOT *ot)
{
    int x;

    for(x=0;x<numBIRD;x++)
    {
        bird_pic.x = GLOBAL_x + bird[x].x;
        bird_pic.y = GLOBAL_y + bird[x].y;

        bird_pic.u = bird[x].dir*16;

        if(bird[x].state) bird_pic.v = 2*16;
        else bird_pic.v = bird[x].frame*16;
        
        GsSortFastSprite(&bird_pic,ot,0);
    }
}

void colorPIC(int d)
{
    harry_sp.r=d;
    harry_sp.g=d;
    harry_sp.b=d;

    block2_sp.r=d;
    block2_sp.g=d;
    block2_sp.b=d;

    block_sp.r=d;
    block_sp.g=d;
    block_sp.b=d;

    tile->r=d;
    tile->g=d;
    tile->b=d;

    bird_pic.r = d;
    bird_pic.g = d;
    bird_pic.b = d;

    star_pic.r = d;
    star_pic.g = d;
    star_pic.b = d;

    nme.r = d;
    nme.g = d;
    nme.b = d;

    wolke.r = d;
    wolke.g = d;
    wolke.b = d;

    ice.r = d;
    ice.g = d;
    ice.b = d;

    lives.r = d;
    lives.g = d;
    lives.b = d;
}

//*******************************************************MAINrENDERfUNCTION!

void renderWORLD(GsOT *ot)
{
    signed long x;

    x = (-1 * harry[0].y) + 100;

    if(x<-296) GLOBAL_y = -296;
    else{
        if(GLOBAL_y < x) GLOBAL_y+=2;
        if(GLOBAL_y > x) GLOBAL_y-=2;
    }

    if(pause) pauseANI(ot);

    drawSTAR(ot);
    drawLIVES(ot,0);
    drawLevels(ot);
    drawPINGU(ot);
    drawBIRD(ot);
    drawHARRY(0,ot,0,1);
    drawWOLKE(ot);
}

void renderWORLD2(GsOT *ot)
{
    signed long x1,x2;

    x1 = (-1 * harry[0].y) + 100;
    x2 = (-1 * harry[1].y) + 100;

    if(x1>x2){
        if(x1<-296) GLOBAL_y = -296;
        else{
            if(GLOBAL_y < x1) GLOBAL_y+=2;
            if(GLOBAL_y > x1) GLOBAL_y-=2;
            if(GLOBAL_y == x1)
            if((harry[0].actLEVEL - harry[1].actLEVEL) > 2) {
                harry[1].numLIVES--;
                harry[1].delay = 50;
                harry[1].knok = 1;
                initHARRY2(1,harry[0].x,harry[0].actLEVEL);
            };

        }
    } else {
        if(x2<-296) GLOBAL_y = -296;
        else{
            if(GLOBAL_y < x2) GLOBAL_y+=2;
            if(GLOBAL_y > x2) GLOBAL_y-=2;
            if(GLOBAL_y == x2)
            if((harry[1].actLEVEL - harry[0].actLEVEL) > 2) {
                harry[0].numLIVES--;
                harry[0].delay = 50;
                harry[0].knok = 1;
                initHARRY2(0,harry[1].x,harry[1].actLEVEL);
            };

        }
    }

    if(pause) pauseANI(ot);

    drawSTAR(ot);
    drawLIVES(ot,0);
    drawLIVES(ot,1);
    drawLevels(ot);
    drawPINGU(ot);
    drawBIRD(ot);

    if(harry[0].numLIVES > 0) drawHARRY(0,ot,0,0);
    if(harry[1].numLIVES > 0) drawHARRY(1,ot,0,0);

    drawWOLKE(ot);
}


