

static void init_sound()
{
	/* VAB opening and transmission to sound buffer */
	vab = SsVabTransfer( (u_char*)VH_ADDR, (u_char*)VB_ADDR, -1, 1 );
	if (vab < 0) {
		printf("SsVabTransfer failed (%d)\n", vab);
		return;
	}

	/* SEQ opening */
	seq = SsSeqOpen((u_long *)SEQ_ADDR, vab);
	if (seq < 0)
		printf("SsSeqOpen failed (%d)\n", seq);
}

/* Sound playback start */
static void play_sound()
{
	SsSetMVol(MVOL, MVOL);			/* Main volume setting*/
	SsSeqSetVol(seq, SVOL, SVOL);		/* Volume setting for each SEQ */
	SsSeqPlay(seq, SSPLAY_PLAY, SSPLAY_INFINITY);/* Playback switch ON */
}

/* Sound playback termination */
static void stop_sound()
{
	SsSeqStop(seq);			/* Playback switch OFF */
	VSync(0);
	VSync(0);
	SsSeqClose(seq);			/* SEQ close */
	SsVabClose(vab);			/* VAB close */
}

