/*
 Ŀ
  FILE        : main.c                   VERSION : 1.2     DATE : 26/06/1998 
  DESCRIPTION : IceClimber MainFunction                                      
                                                                             
 Ĵ
  Copyright (C) 1998 by Yannick Suter aka AsC/Nowadays                       
 
*/

#include "libs/header.h"

#define numSTAR 100
#define tiefe 8
#define len 25

#define SCREEN_WIDTH 320
#define SCREEN_HEIGHT 240

void part1(){
    int sx,x;

    for(sx = 1024;sx > 250; sx-=3){
        actBUF = GsGetActiveBuff();
        GsSetWorkBase((PACKET *)GpuPacketArea[actBUF]);

        GsClearOt(0,0,&worldOT[actBUF]);

        x = 4096*(sx/256.0);
        nds.scalex = x;

        GsSortSprite(&nds,&worldOT[actBUF],0);

        DrawSync(0);
        VSync(0);

        GsSwapDispBuff();
        GsSortClear(0,0,0,&worldOT[actBUF]);
        GsDrawOt(&worldOT[actBUF]);
    }
}

void part2(){
    int sx,x;

    int g_ind=0,tind = -5,max = 16;

    while(max != 0)
    {
        actBUF = GsGetActiveBuff();
        GsSetWorkBase((PACKET *)GpuPacketArea[actBUF]);

        GsClearOt(0,0,&worldOT[actBUF]);

        nds.y += tind;

        tind++;
        if(tind == max) { max--; tind = -(max-1);}
        if(tind == 0) g_ind++;
        if(g_ind == 3) max = 0;

        GsSortSprite(&nds,&worldOT[actBUF],0);

        DrawSync(0);
        VSync(0);
        VSync(0);

        GsSwapDispBuff();
        GsSortClear(0,0,0,&worldOT[actBUF]);
        GsDrawOt(&worldOT[actBUF]);
    }

    for(g_ind = 0;g_ind<40;g_ind++)
    {
        actBUF = GsGetActiveBuff();
        GsSetWorkBase((PACKET *)GpuPacketArea[actBUF]);

        GsClearOt(0,0,&worldOT[actBUF]);

        nds.y += tind;
        tind++;

        GsSortSprite(&nds,&worldOT[actBUF],0);

        DrawSync(0);
        VSync(0);
        VSync(0);

        GsSwapDispBuff();
        GsSortClear(0,0,0,&worldOT[actBUF]);
        GsDrawOt(&worldOT[actBUF]);
    }
}

void part3(long rx){
    int sx,x;

    for(sx = 0;sx < rx; sx++){
        actBUF = GsGetActiveBuff();
        GsSetWorkBase((PACKET *)GpuPacketArea[actBUF]);

        GsClearOt(0,0,&worldOT[actBUF]);

        x = 128-((rand()%30)-15);
        nds.r = x; nds.g = x; nds.b = x;

        GsSortSprite(&nds,&worldOT[actBUF],0);

        DrawSync(0);
        VSync(0);

        GsSwapDispBuff();
        GsSortClear(0,0,0,&worldOT[actBUF]);
        GsDrawOt(&worldOT[actBUF]);
    }
}

void part4(int fxx)
{

    int x,temp;

    do{
        actBUF = GsGetActiveBuff();
        GsSetWorkBase((PACKET *)GpuPacketArea[actBUF]);

        GsClearOt(0,0,&worldOT[actBUF]);

        for(x=0;x<numSTAR;x++){

            GsSortGLine(&star[x],&worldOT[actBUF],1);

            star[x].x0 -= vec[x];
            star[x].x1 -= vec[x];

            if(star[x].x1<0){
                vec[x] = (rand()%tiefe)+1;
                star[x].x0 = 320+rand()%320; star[x].x1 = star[x].x0 + len;
                star[x].y0 = rand()%240; star[x].y1 = star[x].y0;
                temp = 255 - ((tiefe-vec[x])*(220/tiefe));
                star[x].r0 = temp; star[x].g0 = temp; star[x].b0 = temp;
                star[x].r1 = 0; star[x].g1 = 0; star[x].b1 = 0;
            }
        }

        DrawSync(0);
        VSync(0);

        GsSwapDispBuff();
        GsSortClear(0,0,0,&worldOT[actBUF]);
        GsDrawOt(&worldOT[actBUF]);

        fxx--;
    }while(fxx!=0);
}

void part5()
{
    int ffx = 600;
    int x,temp;

    do{
        actBUF = GsGetActiveBuff();
        GsSetWorkBase((PACKET *)GpuPacketArea[actBUF]);

        GsClearOt(0,0,&worldOT[actBUF]);

        for(x=0;x<numSTAR;x++){

            GsSortGLine(&star[x],&worldOT[actBUF],1);

            star[x].x0 -= vec[x];
            star[x].x1 -= vec[x];

            if(star[x].x1<0){
                vec[x] = (rand()%tiefe)+1;
                star[x].x0 = 320+rand()%320; star[x].x1 = star[x].x0 + len;
                star[x].y0 = rand()%240; star[x].y1 = star[x].y0;
                temp = 255 - ((tiefe-vec[x])*(220/tiefe));
                star[x].r0 = temp; star[x].g0 = temp; star[x].b0 = temp;
                star[x].r1 = 0; star[x].g1 = 0; star[x].b1 = 0;
            }
        }

        if(ffx>200) printFONT("SINGLE GAME",&worldOT[actBUF],128,128,128,ffx,138);
        else printFONT("SINGLE GAME",&worldOT[actBUF],128,128,128,200,138);

        if(ffx>200) printFONT("LEVEL #",&worldOT[actBUF],128,128,128,ffx,150);
        else printFONT("LEVEL #",&worldOT[actBUF],128,128,128,200,150);

        if(ffx>200) printFONT("START GAME!",&worldOT[actBUF],128,128,128,ffx,162);
        else printFONT("START GAME!",&worldOT[actBUF],128,128,128,200,162);

        if(ffx>200) printFONT("QUIT",&worldOT[actBUF],128,128,128,ffx,174);
        else printFONT("QUIT",&worldOT[actBUF],128,128,128,200,174);

        if(ffx>130) printFONT("SELECT SINGLE OR DEATHMATCH",&worldOT[actBUF],128,128,128,ffx,200);
        else printFONT("SELECT SINGLE OR DEATHMATCH",&worldOT[actBUF],128,128,128,130,200);

        if(ffx>80) printFONT("PROGRAMMED BY ASC-NOWADAYS (C) 1998 FOR THE",&worldOT[actBUF],128,128,220,ffx,235);
        else printFONT("PROGRAMMED BY ASC-NOWADAYS (C) 1998 FOR THE",&worldOT[actBUF],128,128,220,80,235);

        if(ffx>200) printFONT("BUENZLI 7",&worldOT[actBUF],200,40,220,ffx,245);
        else printFONT("BUENZLI 7",&worldOT[actBUF],200,40,220,200,245);

        DrawSync(0);
        VSync(0);

        GsSwapDispBuff();
        GsSortClear(0,0,0,&worldOT[actBUF]);
        GsDrawOt(&worldOT[actBUF]);

        ffx-=4;
    }while(ffx>0);
}

void intro(){
    int x;
    int temp;

    for(x=0;x<numSTAR;x++){
        vec[x] = (rand()%tiefe)+1;
        star[x].x0 = 320+rand()%320; star[x].x1 = star[x].x0 + len;
        star[x].y0 = rand()%240; star[x].y1 = star[x].y0;
        temp = 255 - ((tiefe-vec[x])*(220/tiefe));
        star[x].r0 = temp; star[x].g0 = temp; star[x].b0 = temp;
        star[x].r1 = 0; star[x].g1 = 0; star[x].b1 = 0;
    }

    part1();
    part3(80);
    part2();
    part4(50);
    part5();
}
