/* Prints out file(s) with a delay of seconds and milliseconds between each 
   buffer output. The milliseconds will be rounded down to the nearest 
   supported by the architecture (dependent on CLK_TCK). The amount of 
   characters (size of buffer) to display between the delay (if one is set) 
   can also be defined with an option. 
   If no file arguments are passed, stdin will be read. 
   If the delay option is set, the buffering for standard out will be set
   off.

   This was developed mainly to watch Lance's ASCII animation from the 
   Alternative Party on a UNIX text console or terminal window (without a 
   terminal with slow baudrate). I couldn't resist adding some other 
   functionality to it..

   Author: Kristoffer "Setok" Lawson
   Fishpool Creations Oy Ltd 1998

   Date: 18.04.1998 */


#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/times.h>


/* Arguments: [-d seconds milliseconds] [-c chars] [file1 file2 ...].
 By default there is no delay between printing characters and the amount
 of characters displayed between each display (if delay is on) is 20. */

int main(int argc, char *argv[]) {

  struct timespec waittime;
  int wait, c, n, camount, i;
  FILE *fp;
  char *prognm=argv[0], b[1024];
  clock_t strtime, endtime, tickwait, difftick;
  struct tms blah;

  if(argc>3 && !strcmp(argv[1], "-d")) {
    wait=1;
    /*    waittime.tv_sec=atoi(argv[2]);
    waittime.tv_nsec=atoi(argv[3])*1000000; */
    setbuf(stdout, NULL);
    tickwait=atoi(argv[2])*sysconf(_SC_CLK_TCK);   
    tickwait+=atoi(argv[3])/(1000/sysconf(_SC_CLK_TCK));
    argv+=3;
    argc-=3;    
  }
  else
    wait=0;

  if(argc>2 && !strcmp(argv[1], "-c")) {
    camount=atoi(argv[2]);
    if(camount>1024) {
      fprintf(stderr, "%s: -c option only supports up to 1024 chars\n", 
	      prognm);
      exit(-1);
    }
    argv+=2;
    argc-=2;
  }
  else
    camount=20;

  if(argc==1) {  /* No file arguments, read from standard in */
    c=getchar();
    if(wait) {  /* Delay option on */
      while(c != EOF) {
	i=0;
	/* Print out several characters at a time */
	for(n=0;n<camount && c!=EOF;n++, i++) {  
	    b[i]=c;
	    c=getchar();
	}
	strtime=times(&blah);	
	write(STDOUT_FILENO, b, i);
	endtime=times(&blah);
	if(tickwait > endtime-strtime) {
	  difftick=tickwait - (endtime-strtime);
	  waittime.tv_sec = difftick/sysconf(_SC_CLK_TCK);
	  waittime.tv_nsec = difftick%sysconf(_SC_CLK_TCK);
	    nanosleep(&waittime, NULL);
	}
      }
    }
    else { 
      while( c != EOF) {
	putchar(c);
	c=getc(fp);
      }
    }
  }
  else {  /* File argument(s) given */
    argv++;  /* Jump to first file */
    while(argc>1) {  /* Read files in one at a time */
      if((fp=fopen(*argv, "r")) == NULL) {  /* Error occured when opening */
	fprintf(stderr, "%s: %s: %s\n", prognm, *argv, strerror(errno));
	exit(-1);
      }
      c=getc(fp);
      if(wait) {  /* Delay option on */
	strtime=times(&blah);
	while(c != EOF) {
	  i=0;
	  /* Print out several characters at a time */
	  for(n=0;n<camount && c!=EOF;n++, i++) {  
	    b[i]=c;
	    c=getc(fp);
	  }
	  write(STDOUT_FILENO, b, i);
	  endtime=times(&blah);
	  if(tickwait > endtime-strtime) {
	    difftick=tickwait - (endtime-strtime);
	    waittime.tv_sec = difftick/sysconf(_SC_CLK_TCK);
	    waittime.tv_nsec = difftick%sysconf(_SC_CLK_TCK);
	    nanosleep(&waittime, NULL);
	  }
	  strtime=times(&blah);
	}
      }
      else {  /* Delay option not on */
	while( c != EOF) {
	  putchar(c);
	  c=getc(fp);
	}
      }
      fclose(fp);
      argv++;
      argc--;
    }
  }

  return 0;
}
