

gfx = 1




.386                                    ;pmode/w
.model flat,prolog
.stack 1000h

public _getmem

locals

include int.inc
extrn logoflag:dword
extrn greets:near

public _getmemc

public tune
public initengine, startengine

NULL = 0

;----vesa
include vesa.inc
extrn setpal:near

extrn keypressed:near

;include ..\h\debug.inc

;----font
public f_text2
public f_header
public font

;-----

;procedure overwiew:

;readchar proc near
;_getmem proc near
;_getmemc proc near
;vgasetpal proc near
;savemempos proc near
;freemem proc near
;initmem proc near

;readworld proc near
;readobjects proc near
;m_loaddata proc near
;c_loaddata proc near
;l_loaddata proc near
;t_loaddata proc near
;b_loaddata proc near
;readcubes proc pascal

;dotracks proc near
;m_dotracks proc near
;c_dotracks proc near
;l_dotracks proc near
;t_dotracks proc near
;dotrack proc pascal
;slerp proc near
;dorottrack proc pascal
;dohidetrack proc pascal

;doviewer proc near
;traceobjects proc pascal
;cubetree proc pascal

;texturedraw proc pascal
;drawcube proc pascal
;xformincube proc pascal
;meshxform proc pascal
;makefaces proc pascal
;drawfaces proc pascal

;projektion proc pascal
;xclip proc pascal
;polygon proc pascal
;subxclip proc pascal
;subpolygon proc pascal

;testdir proc pascal
;dolights proc pascal
;ldraw proc pascal
;lconvert proc near ;projiziert die licht-koordinaten
;lpolygon proc pascal ;licht-polygon
;lighttransx proc near
;lighttransy proc near
;lighttransz proc near
;lightclip proc pascal
;sublpolygon proc pascal ;licht-polygon
;sprojektion proc pascal
;spolygon proc pascal

;
;struc
;

;vector
tvec struc
 x1             dd ?
 x2             dd ?
 x3             dd ?
ends

;matrix
tmatrix struc
 A_1n label dword
 A_m1 label dword
 A_11           dd ?
 A_m2 label dword
 A_12           dd ?
 A_m3 label dword
 A_13           dd ?
 A_2n label dword
 A_21           dd ?
 A_22           dd ?
 A_23           dd ?
 A_3n label dword
 A_31           dd ?
 A_32           dd ?
 A_33           dd ?
ends

;quaternion
tquaternion struc  ;fixed size of 16 byte
 q_w            dd ?
 q_x            dd ?
 q_y            dd ?
 q_z            dd ?
ends


;virtual method table for OOP-emulation (each type has one vmt)
tobjvmt struc
 o_size         dd ?                    ;size of object
 o_firstobj     dd ?                    ;points to memory pool of the type
 o_nextobj      dd ?                    ;for memory allocation from the pool
 o_loaddata     dd ?                    ;virtual procedure to load data
 o_dotracks     dd ?                    ;virtual procedure to calculate the tracks
ends

;object:
;-------
tobject struc
 o_vmt          dd ?

 ;hierarchy-system: (pointer)
 o_owner        dd ?
 o_next         dd ?
 o_child        dd ?

 ;linear chain: (pointer)
 o_chain        dd ?                    ;links all objects globally

 ;descent-like cube system: (pointer)
 o_nextincube   dd ?                    ;link to next object in cube
 o_cube         dd ?                    ;link to cube

 ;state: (vektor/matrix)
 o_p            dd 3 dup(?)             ;actual position (position and matrix have fixed order in memory)
 o_A            dd 9 dup(?)             ;actual rotation and scale
 o_hidden       dd ?

 o_stamp        dd ?                    ;stamp to mark object as "used"
ends


;mesh:
;-----
mfMapping = 1                           ;mesh has texture mapping
mfUnitenext = 2                         ;mesh does not cast shadows to the next mesh
mfNorotate = 4                          ;mesh does not have a rotation track

tmesh struc
 m_object       tobject ?

 m_flags        dd ?

 m_nexttemp     dd ?                    ;mesh-temp-list
 m_tlistpos     dd ?                    ;-> list of transformed vertices
 m_vtlistpos    dd ?
 m_z            dd ?                    ;z-distance to viewer
 m_zval         dd ?                    ;8-bit z-buffer value

 m_vertices     dd ?                    ;int
 m_vertexlist   dd ?                    ;pointer to vertex list
 m_mappinglist  dd ?
 ;m_normalslist  dd ?
 m_faces        dd ?                    ;int
 m_facelist     dd ?                    ;pointer

 m_mapptr       dd ?                    ;pointer
 m_mapand       dd ?                    ;int

 ;postrack (3):
 m_postrack     dd ?                    ;pointer
 m_poskey       dd ?                    ;int

 ;rotationtrack (4):
 m_rottrack     dd ?                    ;pointer
 m_rotkey       dd ?                    ;int

 ;scaletrack (3):
 m_scaletrack   dd ?                    ;pointer
 m_scalekey     dd ?                    ;int

 ;hidetrack
 m_hidetrack    dd ?
 m_hidekey      dd ?
 m_hidden       dd ?
ends


;camera:
;-------
tcamera struc
 c_object       tobject ?
 c_target       dd ?                    ;pointer

 ;postrack (3):
 c_postrack     dd ?                    ;pointer
 c_poskey       dd ?                    ;int

 ;FOVtrack (1):
 c_FOVtrack     dd ?                    ;pointer
 c_FOVkey       dd ?                    ;int
 c_FOV          dd ?                    ;float

 ;rolltrack (1):
 c_rolltrack    dd ?                    ;pointer
 c_rollkey      dd ?                    ;int
 c_roll         dd ?                    ;float

ends

tlight struc
 l_camera       tcamera ?

 ;hidetrack
 l_hidetrack    dd ?                    ;pointer
 l_hidekey      dd ?                    ;int
 l_hidden       dd ?                    ;boolean

 l_lmap         dd ?                    ;-> spotlight intensity map
ends


;target:
;-------
ttarget struc
 t_object       tobject ?

 ;postrack (3):
 t_postrack     dd ?                    ;pointer
 t_poskey       dd ?                    ;int
ends


;bound
;-----
tbound struc
  b_object      tobject ?
  b_pos         dd ?                    ;pointer
ends


;track:
;------
ttrackh struc
 th_size        dd ?                    ;size of track
 th_mode        dd ?                    ;1: loop-track
 th_keys        dd ?                    ;number of gaps to interpolate (keys-1)
 th_sframe      dd ?                    ;start-frame
ends

ttrack struc
 t_sframe       dd ?                    ;start-frame of gap
 ;t_easefrom     dd ?
 ;t_easeto       dd ?
 t_eframe       dd ?                    ;end-frame of gap
ends


;material:
;---------
tmaterial struc
 mat_pos        dd ?                    ;position in bitmap-data
 mat_and        dd ?                    ;resolution (and-value for inner-loop)
ends




;cubes
;-----
tmapping struc
 m_u            dd ?
 m_v            dd ?
ends

tdreieck struc
 d_o            dd ?                    ;pointer to supporting vector
 d_n            tvec ?                  ;normal vector of plane
ends

;side-flags
sfTile     = 1                          ;tile direction to get two triangles
sf4point   = 4                          ;all 4 points lie in one plane
sfBitmap   = 8                          ;side has a bitmap
sfNextcube = 16                         ;side is linked to another cube
;sfDrawed   = 256                        ;side has been drawed

tside struc
 s_flags        dd ?                    ;int (side-flags)
 s_mapptr       dd ?                    ;pointer to bitmap data
 s_mapand       dd ?                    ;int
 s_mapping      dd ?                    ;pointer to tmapping (4x)
 s_nextcube     dd ?                    ;pointer to side-cube
 s_dreieck      tdreieck 2 dup(?)
ends

tcube struc
 c_side         tside 6 dup(?)
 c_vertex       dd 8 dup(?)             ;8 pointer to tvec
 c_objlist      dd ?                    ;pointer to tobject
 c_stamp        dd ?                    ;for cube-tree
 c_vstamp       dd ?                    ;for do-lights
 c_vtc          dd ?                    ;for do-lights
ends


ttempcube struc
 tc_vertex      tvec 8 dup(?)           ;transformed vertices
 tc_cubeptr     dd ?                    ;pointer to tcube
 tc_rekursion   dd ?                    ;recursion level
tc_num dd ?
 tc_meshlist    dd ?                    ;mesh-temp-list (pointer to tmesh)
ends


camcubes = 30;32
lightcubes = 20;24

;viewer
;------
tviewer struc
 v_l            dd 3 dup(?)             ;local coordinate system
 v_l1           dd 3 dup(?)
 v_l2           dd 3 dup(?)
 v_l3           dd 3 dup(?)
 v_cube         dd ?                    ;pointer to cube where viewer is in

 v_light        dd ?                    ;= 0 for camera, = 1 for light
 v_cubelist     dd ?                    ;pointer to temp cube list
 v_cubelistmax  dd ?                    ;pointer to absolute list end
 v_cubelistend  dd ?                    ;pointer to actual list end
 v_tlist        dd ?                    ;list of transformed vertices
 v_tlistpos     dd ?                    ;pointer to actual list end
ends


;polygon point
tscreenpoint struc
 sp_sx          dd ?
 sp_sy          dd ?
 sp_z           dd ?
 sp_u           dd ?
 sp_v           dd ?
ends

;polygon point for scanline subdivision
tscan struc ;fixed size
 s_p            dd ?
 s_z            dd ?
 s_u            dd ?
 s_v            dd ?
ends

;light polygon point
tlightpoint struc ;fixed order of elements (see lightclip)
 lp_x           dd ?
 lp_y           dd ?
 lp_z           dd ?
 lp_lx          dd ?
 lp_ly          dd ?
 lp_lz          dd ?
 lp_tz          dd ?                    ;transformed z
ends

;light polygon point for scanline subdivision
tlscan struc ;fixed size
 ls_p            dd ?
 ls_z            dd ?
 ls_lx           dd ?
 ls_ly           dd ?
 ls_lz           dd ?
ends

;shadow polygon point
tshadowpoint struc
 hp_x            dd ?
 hp_y            dd ?
ends


;font writer
;-----------
cSpace    = 250;
cNextline = 251;
c2nd      = 252;
cNextpage = 253;
cEnd      = 255;

tfonth struc
 f_pos           dd ?
 f_x             db ?
 f_y             db ?
ends


;
.data
;

;command line
;__psp dw ?

mem_err db 13,10,'Not enough memory$'
;low_err db 13,10,'Not enough low mem$'
;vesa_err db 13,10,'Vesa mode not supported$'

;pflag db 0 + use8bit

;rxm_mem dd ?
;drv_mem dd ?
tune label byte
include intro1.dat

;soundtype dd ?
;dmabuf dd ?

;mem

handle_si dw ?          ;pmode/w
handle_di dw ?

membase dd ?
memtop  dd ?

oldmembase dd ?




palette    dd ?         ;-> palette
bitmapdata dd ?         ;-> bitmap-data
materials  dd ?

;coltab
lvalues          = 64
ld_lvalues       = 6
xtralvalues      = lvalues*2
coltab     dd ?         ;-> table to generate 32 intensity levels for each color

objtree    dd ?         ;-> object tree
chain      dd NULL      ;-> object chain
cubes      dd ?         ;-> first cube

l_sub = 5               ;cube-recursion level where to switch off light-subdivision
t_sub = 7               ;cube-recursion level where to switch off texture-subdivision

classes = 5             ;number of classes
m_vmt tobjvmt <size tmesh  , NULL, NULL, m_loaddata, m_dotracks>
c_vmt tobjvmt <size tcamera, NULL, NULL, c_loaddata, c_dotracks>
l_vmt tobjvmt <size tlight , NULL, NULL, l_loaddata, l_dotracks>
t_vmt tobjvmt <size ttarget, NULL, NULL, t_loaddata, t_dotracks>
b_vmt tobjvmt <size tbound , NULL, NULL, b_loaddata, b_dotracks>

extrn world:byte
;incdata label byte
;include level.dat
extrn spotl:byte


frame dd 0              ;global frame counter

;dotracks
c_3 dd 3.0
c_sinmin dd 1E-6
framemul = 140

;ambient light track
illum dd ?
am_key      dd 0                        ;actual key
am_keydata  dd    0*framemul,  0*2
            dd  125*framemul, 11*2
            dd  180*framemul,  8*2
            dd  695*framemul,  0*2
            dd 9999*framemul

;fxtrack
fx_key      dd 0                        ;actual key
fx_keydata  dd    0*framemul, nofx
            dd  647*framemul, logo
            dd  800*framemul, nofx
            dd  860*framemul, fontwriter
            dd  960*framemul, nofx
            dd 9999*framemul

;screen variables
xbytes   dd ?
xres     dd ?
yres     dd ?
pbytes   dd ?
linbuf   dd ?
vesaptr  dd ?
;vmemsize dd ?
;pixelnum dd ?
buffer   dd ?
;align 4
;colmask dd 3 dup(?)
c_xmid   dd ? ;float
c_ymid   dd ? ;float

;viewer
viewer tviewer <?>      ;camera
light tviewer <?>       ;global variable for dolights
c_pi_2 dd 1.570796
c_1_33 dd 1.333333

;cube-tree
stamp        dd 0

s = size tvec
s2p_t label byte        ;side -> points
db 2*s, 3*s, 7*s, 6*s
db 0*s, 4*s, 7*s, 3*s
db 0*s, 1*s, 5*s, 4*s
db 1*s, 2*s, 6*s, 5*s
db 4*s, 5*s, 6*s, 7*s
db 0*s, 3*s, 2*s, 1*s

s2p label byte          ;side -> points
db 2, 3, 7, 6
db 0, 4, 7, 3
db 0, 1, 5, 4
db 1, 2, 6, 5
db 4, 5, 6, 7
db 0, 3, 2, 1

;screen- and lightpoints list
splist dd ?

;sprojektion (shadow polygon projection)
c_128 dd 128.0

;lmap
c_32768 dd 32740.0 ;128.0 * 256 (8 bit fraction)

lmap1 dd ?              ;-> 256x256 round spotlight intensity map
lmap2 dd ?              ;-> 256x256 spotlight intensity map with logo
lmap  dd ?              ;-> temporary spotlight map for shadows

c_lmap dd 0.012         ;0.0122718463 = pi/256
;c_lmap1 dd 30.0         ;max. intensity of round spotlight

divtab label dword      ;16/x, x = 1 to 23
        dd 0
c_16    dd 16.000000
        dd 8.000000
        dd 5.333333
        dd 4.000000
        dd 3.200000
        dd 2.666667
        dd 2.285714
c_2     dd 2.000000
        dd 1.777778
        dd 1.600000
        dd 1.454545
        dd 1.333333
        dd 1.230769
        dd 1.142857
        dd 1.066667
        dd 1.000000
        dd 0.941176
        dd 0.888889
        dd 0.842105
        dd 0.800000
        dd 0.761905
        dd 0.727273
        dd 0.695652

divtab32 label dword
dd 0
c_32 dd 32.000000
dd 16.000000
dd 10.666667
dd 8.000000
dd 6.400000
dd 5.333333
dd 4.571429
dd 4.000000
dd 3.555556
dd 3.200000
dd 2.909091
dd 2.666667
dd 2.461538
dd 2.285714
dd 2.133333
dd 2.000000
dd 1.882353
dd 1.777778
dd 1.684211
dd 1.600000
dd 1.523810
dd 1.454545
dd 1.391304
dd 1.333333
dd 1.280000
dd 1.230769
dd 1.185185
dd 1.142857
dd 1.103448
dd 1.066667
dd 1.032258
dd 1.000000
dd 0.969697
dd 0.941176
dd 0.914286
dd 0.888889
dd 0.864865
dd 0.842105
dd 0.820513
dd 0.800000
dd 0.780488
dd 0.761905
dd 0.744186
dd 0.727273
dd 0.711111
dd 0.695652
dd 0.680851


divtab2 dd ?            ;1/x, x = 1 to xres



;font
include font.dat

font dd ?


;
.code
;

comment #
readchar proc near
        ;<- eax = char

        xor     eax,eax
        int     16h
        or      al,al
        jnz     @@0
        sub     al,ah
        or      eax,not 0FFh
        jmp     @@weg
@@0:    and     eax,0FFh

@@weg:
        ret
endp
#

_getmem proc near                       ;get memory from global pool
        ;-> eax = size
        ;<- eax -> mem
        ;CF = 0: successful

        add     eax,3
        and     eax,not 3
        jz      @@weg
        add     eax,membase
        cmp     eax,memtop
        ja      @@0

        xchg    eax,membase
        clc
        jmp     @@weg
@@0:
        mov     ax,4c00h
        int     21h
;        xor     eax,eax
;        stc
@@weg:  ret
endp


_getmemc proc near                      ;get memory and clear it
        ;-> eax = size
        ;<- eax -> mem
        ;CF = 0: successful

        push    ecx
        mov     ecx,eax
        call    _getmem
;        jc      @@0
@@l:
        dec     ecx
        js      @@0
        mov     byte ptr [eax+ecx],0
        jmp     @@l

@@0:    pop     ecx
        ret
endp

vgasetpal proc near                        ;set vga palette
        ;-> esi -> palette

        xor     eax,eax
        mov     dx,3c8h
        out     dx,al
        inc     dx

        mov     ecx,768
@@0:
        mov     al,[esi]
        shr     al,2
@@1:
        out     dx,al
        mov     eax,100
@@w:    dec     eax
        jnz     @@w

        inc     esi
        dec     ecx
        jnz     @@0

        ret
vgasetpal endp


savemempos proc near                    ;all following allocations can be freed
        mov     eax,membase
        mov     oldmembase,eax
        ret
savemempos endp

freemem proc near                       ;free mem since last "savemempos"
        mov     eax,oldmembase
        mov     membase,eax
        ret
freemem endp

initmem proc near                       ;alloc mem for global variables

        ;cube-list (camera)
        mov     eax,(size ttempcube)*camcubes
        mov     viewer.v_cubelistmax,eax
        call    _getmem
;        jc      @@weg
        mov     viewer.v_cubelist,eax
        add     viewer.v_cubelistmax,eax
        mov     viewer.v_light,0
        ;cube-list (light)
        mov     eax,(size ttempcube)*lightcubes
        mov     light.v_cubelistmax,eax
        call    _getmem
;        jc      @@weg
        mov     light.v_cubelist,eax
        add     light.v_cubelistmax,eax
        mov     light.v_light,1

        ;transform-list
        mov     eax,(size tvec)*600
        call    _getmem
;        jc      @@weg
        mov     viewer.v_tlist,eax

        ;buffer
        mov     eax,xres
        imul    eax,yres
        shl     eax,2
        call    _getmem
;        jc      @@weg
        mov     buffer,eax

        ;screenpoints-list
        mov     eax,(size tlightpoint)*600
        call    _getmem
;        jc      @@weg
        mov     splist,eax
        ;coltab
        mov     eax,(lvalues+xtralvalues)*256 *4
        call    _getmemc
;        jc      @@weg
        mov     coltab,eax

        ;lmap
        mov     eax,256*256
        call    _getmem
;        jc      @@weg
        mov     lmap,eax
        ;lmap1
        mov     eax,256*256
        call    _getmem
;        jc      @@weg
        mov     lmap1,eax
        ;lmap2
        mov     eax,256*256
        call    _getmemc
;        jc      @@weg
        mov     lmap2,eax
        ;divtab2
        mov     eax,xres
        add     eax,5
        shl     eax,2
        call    _getmem
;        jc      @@weg
        mov     divtab2,eax

@@weg:  ret
initmem endp

;------ main procedure to read data (label "world" in data segment)
readworld proc near

        lea     esi,world               ;esi -> world data
        mov     ecx,classes             ;ecx = number of different object types
        lea     ebx,m_vmt               ;ebx -> virtual method tables

@@l:            ;allocate mem
        lodsd                           ;eax = number of objects of the same type
        imul    o_size[ebx]
        call    _getmemc                ;allocate mem these objects
;        jc      @@err
        mov     o_firstobj[ebx],eax
        mov     o_nextobj[ebx],eax
        add     ebx,size tobjvmt        ;go to next type
        dec     ecx
        jnz     @@l

        lodsd                           ;eax = number of cubes
        imul    eax,size tcube
        call    _getmemc
;        jc      @@err
        mov     cubes,eax

        mov     palette,esi             ;palette        (768 chars)
        add     esi,768
        lodsd                           ;bitmapdatalen  (int)
        mov     bitmapdata,esi
        add     esi,eax

        lodsd                           ;materials      (int)
        mov     materials,esi
        imul    eax,size tmaterial
        add     esi,eax

        lodsd                           ;number of objects in highest hierarchy
        mov     ecx,eax
        xor     edx,edx                 ;owner = NULL
        call    readobjects
        mov     objtree,edi

        call    readcubes               ;dungeon must be present


@@weg:  ;clc
@@err:  ret
readworld endp


;------ recursive procedure to build up the object tree
readobjects proc near
        ;-> esi -> world data
        ;-> ecx =  number of objects in this hierarchy level
        ;-> edx =  *owner (stays unchanged)
        ;<- edi =  first object of sub-tree

        xor     edi,edi
        or      ecx,ecx
        jz      @@weg

@@next:
        lodsd                           ;id             (int)

        imul    ebx,eax,size tobjvmt
        lea     ebx,m_vmt[ebx]          ;ebx -> vmt of actual object
        mov     eax,o_size[ebx]         ;determine memory requirement
        xchg    o_nextobj[ebx],eax
        add     o_nextobj[ebx],eax

        xchg    edi,eax                 ;edi = *this
        mov     o_next[edi],eax         ;link previous object to actual object

        mov     o_vmt[edi],ebx          ;link vmt to actual object
        mov     o_owner[edi],edx        ;link owner to actual object

        mov     eax,chain               ;link actual object to global chain
        mov     chain,edi
        mov     o_chain[edi],eax

        push    ecx
        push    edx

        lodsd                           ;cubenum        (int)
        or      eax,eax
        js      @@nocube
        imul    eax,size tcube
        add     eax,cubes               ;eax -> cube, which contains actual object
        mov     o_cube[edi],eax         ;link cube to actual object
        mov     edx,c_objlist[eax]      ;link actual object to cube
        mov     o_nextincube[edi],edx
        mov     c_objlist[eax],edi
@@nocube:

                ;read data
        lodsd                           ;childs         (int)
        push    eax

        call    o_loaddata[ebx]         ;read data of actual object (virtual method)
        pop     ecx                     ;ecx = number of childs

                ;go down in hierarchy
        mov     edx,edi                 ;hand over *this as *owner
        call    readobjects             ;recursive call
        mov     eax,edi                 ;eax = *child (sub-tree)
        mov     edi,edx
        mov     o_child[edi],eax        ;link sub-tree to actual object


        pop     edx
        pop     ecx
        dec     ecx
        jnz     @@next

@@weg:  ret
readobjects endp

;load mesh data
m_loaddata proc near
        ;-> edi = *this

        lodsd                           ;flags          (int)
     mov m_flags[edi],eax
        mov     edx,eax                 ;edx = flags
        lodsd                           ;material       (int)
        imul    ebx,eax,size tmaterial
        add     ebx,materials
        mov     eax,mat_pos[ebx]
        add     eax,bitmapdata
        mov     m_mapptr[edi],eax
        mov     eax,mat_and[ebx]
        mov     m_mapand[edi],eax


        lodsd                           ;vertices       (int)
        mov     m_vertices[edi],eax
        mov     m_vertexlist[edi],esi   ;vertex         (n vektors)
        lea     esi,[esi+eax*8]
        lea     esi,[esi+eax*4]         ;esi += n*12

        test    edx,mfMapping
        jz      @@0
        mov     m_mappinglist[edi],esi
        lea     esi,[esi+eax*8]         ;esi += n*8
@@0:
        lodsd                           ;faces          (int)
        mov     m_faces[edi],eax
        mov     m_facelist[edi],esi     ;face           (n faces)

        imul    eax,3*4
        add     esi,eax

                ;tracks
        mov     m_postrack[edi],esi     ;position track (3)
        add     esi,th_size[esi]
    test edx,mfNorotate
    jnz @@noR
        mov     m_rottrack[edi],esi     ;rotation track (4)
        add     esi,th_size[esi]
@@noR:
        mov     m_scaletrack[edi],esi   ;scale track (3)
        add     esi,th_size[esi]

        mov     m_hidetrack[edi],esi    ;hide track
        mov     eax,[esi]
        lea     esi,[esi+eax*4+4]

        ret
m_loaddata endp

;load camera data
c_loaddata proc near
        ;-> edi = *this

        lodsd                           ;targetnum      (int)
        lea     ebx,t_vmt
        imul    o_size[ebx]
        add     eax,o_firstobj[ebx]
        mov     c_target[edi],eax

                ;tracks
        mov     c_postrack[edi],esi     ;position track (3)
        add     esi,th_size[esi]

        mov     c_FOVtrack[edi],esi     ;FOV track (1)
        add     esi,th_size[esi]

        mov     c_rolltrack[edi],esi    ;roll track (1)
        add     esi,th_size[esi]

        ret
c_loaddata endp

;load light data
l_loaddata proc near
        ;-> edi = *this

        call    c_loaddata

        mov     l_hidetrack[edi],esi    ;hide track
        mov     eax,[esi]
        lea     esi,[esi+eax*4+4]

        lodsd                           ;map-boolean
        dec     eax
        mov     eax,lmap1
        js      @@0
        mov     eax,lmap2
@@0:    mov     l_lmap[edi],eax

@@weg:  ret
l_loaddata endp

;load target data
t_loaddata proc near
        ;-> edi = *this

                ;tracks
        mov     t_postrack[edi],esi     ;position track (3)
        add     esi,th_size[esi]

        ret
t_loaddata endp

;load bound data
b_loaddata proc near
        ;-> edi = *this

                ;pos
        mov     b_pos[edi],esi
        add     esi,size tvec

        ret
b_loaddata endp

;load cubes
readcubes proc pascal
local   z:dword, vertices:dword
local   side:dword, skip:dword, e:dword:3 ;3 pointers to tvec
        ;-> esi -> world data

        lodsd                           ;number of vertices *3*4
        mov     vertices,esi

        add     esi,eax
        lodsd                           ;number of cubes
        mov     z,eax
        mov     edi,cubes               ;edi -> cube-memory
@@z_l:          ;cube loop

        mov     ecx,6
        lea     ebx,c_side[edi]
@@s_l:          ;side loop
        lodsd                           ;flags
        mov     s_flags[ebx],eax
        mov     edx,eax

        test    edx,sfBitmap            ;bitmap and mapping present?
        jz      @@0
        lodsd                           ;mappos (position in bitmap-data)
        add     eax,bitmapdata
        mov     s_mapptr[ebx],eax       ;bitmap-pointer
        lodsd
        mov     s_mapand[ebx],eax       ;bitmap-and-mask
        mov     s_mapping[ebx],esi      ;pointer to mapping coordinates
        add     esi,(size tmapping)*4
@@0:
        test    edx,sfNextcube          ;nextcube present?
        jz      @@1
        lodsd                           ;nextcube
        imul    eax,size tcube
        add     eax,cubes
        mov     s_nextcube[ebx],eax
@@1:
        add     ebx,size tside
        dec     ecx
        jnz     @@s_l                   ;next side

@@v_l:          ;vertex loop (ecx = 0)
        lodsd                           ;vertex-number *3*4
        add     eax,vertices
        mov     c_vertex[edi+ecx*4],eax
        inc     ecx
        cmp     ecx,8
        jb      @@v_l                   ;next vertex

                ;calculate side normals
     push esi


        mov     side,5
@@s:
        imul    esi,side,size tside
        lea     esi,c_side[edi+esi]

        mov     eax,s_flags[esi]
        test    eax,sfNextcube
        jz      @@sw                    ;side not connected

        and     eax,sfTile
        mov     skip,eax                ;skip one point to get a triangle

        mov     ebx,size tdreieck
@@d:
        xor     ecx,ecx
        xor     edx,edx
@@p:
        cmp     ecx,skip
        je      @@a                     ;skip point?

        mov     eax,side
        movzx   eax,s2p[eax*4+ecx]
        mov     eax,c_vertex[edi+eax*4]
        mov     e[edx*4],eax            ;store pointer to tvec
        inc     edx
@@a:
        inc     ecx
        cmp     ecx,4
        jb      @@p

                ;n = (a            ) x (b            )
                ;n = (*e[0] - *e[1]) x (*e[2] - *e[1]) to calculate
        mov     eax,e[4]
                                        ;store pointer to supporting vector  (;pointer auf sttzvektor speichern)
        mov     s_dreieck[esi].d_o[ebx],eax
        fld     [eax].x1
        fld     [eax].x2
        fld     [eax].x3

        mov     eax,e[0]
        mov     ecx,e[8]
                ;1. component
        fld     [eax].x2
        fsub    st,st(2)                ;a2
        fld     [ecx].x3
        fsub    st,st(2)                ;b3
        fmulp   st(1),st

        fld     [eax].x3
        fsub    st,st(2)                ;a3
        fld     [ecx].x2
        fsub    st,st(4)                ;b2
        fmulp   st(1),st
        fsubp   st(1),st
                                        ;store x1 of normal vector
        fstp    s_dreieck[esi].d_n[ebx].x1

                ;2. komponente
        fld     [eax].x3
        fsub    st,st(1)                ;a3
        fld     [ecx].x1
        fsub    st,st(4)                ;b1
        fmulp   st(1),st

        fld     [eax].x1
        fsub    st,st(4)                ;a1
        fld     [ecx].x3
        fsub    st,st(3)                ;b3
        fmulp   st(1),st
        fsubp   st(1),st

        fstp    s_dreieck[esi].d_n[ebx].x2

                ;3. komponente
        fld     [eax].x1
        fsub    st,st(3)                ;a1
        fld     [ecx].x2
        fsub    st,st(3)                ;b2
        fmulp   st(1),st

        fld     [eax].x2
        fsub    st,st(3)                ;a2
        fld     [ecx].x1
        fsub    st,st(5)                ;b1
        fmulp   st(1),st
        fsubp   st(1),st

        fstp    s_dreieck[esi].d_n[ebx].x3

        fstp    st
        fstp    st
        fstp    st

        add     skip,2                  ;repeat for second triangle
        sub     ebx,size tdreieck
        jns     @@d
@@sw:
        dec     side
        jns     @@s

     pop esi


        add     edi,size tcube
        dec     z
        jnz     @@z_l                   ;next cube

@@weg:  ret
readcubes endp


;------ recursive procedure to calculate the tracks
dotracks proc near
        ;-> esi = *this
        ;<- esi = NULL
@@next:
        or      esi,esi
        jz      @@weg

        mov     ebx,o_vmt[esi]          ;ebx -> vmt
        call    o_dotracks[ebx]         ;virtual method to calculate the tracks

                                        ;A = matrix, p = position
                                        ;o = owner

                                        ;A = Ao*A (matrix multiplication)
        mov     edi,o_owner[esi]
        or      edi,edi
        jz      @@n                     ;no owner

        xor     ebx,ebx                 ;ebx = n
@@l2:
        fld     o_A[esi + ebx]          ;n-th column of A
        fld     o_A[esi + ebx+3*4]
        fld     o_A[esi + ebx+6*4]

        xor     edx,edx                 ;edx = m
@@l1:
        fld     o_A[edi + edx]          ;* m-th row of Ao
        fmul    st,st(3)
        fld     o_A[edi + edx+1*4]
        fmul    st,st(3)
        fld     o_A[edi + edx+2*4]
        fmul    st,st(3)
        faddp   st(1)
        faddp   st(1)
        lea     eax,[ebx+edx]
        fstp    o_A[esi + eax]          ;= new element (m,n) of A

        add     edx,3*4
        cmp     edx,3*3*4
        jb      @@l1

        fstp    st
        fstp    st
        fstp    st

        add     ebx,4
        cmp     ebx,3*4
        jb      @@l2
                                        ;p = Ao*p + po

        fld     o_p[esi].x1             ;column vektor p
        fld     o_p[esi].x2
        fld     o_p[esi].x3

        xor     edx,edx                 ;edx = m for A
        xor     ebx,ebx                 ;ebx = m for p
@@l3:
        fld     o_A[edi + edx]          ;* m-th row of Ao
        fmul    st,st(3)
        fld     o_A[edi + edx+1*4]
        fmul    st,st(3)
        fld     o_A[edi + edx+2*4]
        fmul    st,st(3)
        faddp   st(1)
        faddp   st(1)
        fadd    o_p[edi + ebx*4]
        fstp    o_p[esi + ebx*4]        ;= new element (m,1) of p

        add     edx,3*4
        inc     ebx
        cmp     ebx,3
        jb      @@l3

        fstp    st
        fstp    st
        fstp    st

        mov     eax,o_hidden[edi]       ;"inherit" hidden-flag
        or      o_hidden[esi],eax
@@n:
        push    esi                     ;next hierarchy level
        mov     esi,o_child[esi]
        call    dotracks
        pop     esi

        mov     esi,o_next[esi]         ;next object
        jmp     @@next

@@weg:  ret
dotracks endp


m_dotracks proc near
        ;-> esi = *this

                ;rotation track (4)
    test m_flags[esi],mfNorotate
    jnz @@noR
        lea     eax,m_rottrack[esi]
        lea     edi,o_A[esi]
        call    dorottrack pascal, eax
    jmp @@R
@@noR:                                  ;no rotation track
    mov     edi,o_owner[esi]            ;copy matrix of owner
    mov     ecx,8
@@Rl:
    mov     eax,o_A[edi+ecx*4]
    mov     o_A[esi+ecx*4],eax
    dec     ecx
    jns     @@Rl
@@R:
                ;scale track (3)
        lea     eax,m_scaletrack[esi]
        lea     edi,o_p[esi]
        call    dotrack pascal, eax, 3

        mov     ecx,2                   ;scale-value into rotation matrix
@@l:
        fld     o_p[esi+ecx*4]
        fld     o_A[esi+ecx*4]
        fmul    st,st(1)
        fstp    o_A[esi+ecx*4]
        fld     o_A[esi+ecx*4+3*4]
        fmul    st,st(1)
        fstp    o_A[esi+ecx*4+3*4]
        fld     o_A[esi+ecx*4+6*4]
        fmulp   st(1)
        fstp    o_A[esi+ecx*4+6*4]
        dec     ecx
        jns     @@l

                ;position track (3)
        lea     eax,m_postrack[esi]
        lea     edi,o_p[esi]
        call    dotrack pascal, eax, 3

                ;hidetrack
        lea     eax,m_hidetrack[esi]
        call    dohidetrack pascal, eax ;modifies m_hidden[esi]
        mov     eax,m_hidden[esi]       ;copy flag
        mov     o_hidden[esi],eax

        ret
m_dotracks endp

c_dotracks proc near
        ;-> esi = *this

                ;position track (3)
        lea     eax,c_postrack[esi]
        lea     edi,o_p[esi]
        call    dotrack pascal, eax, 3

                ;FOV track (1)
        lea     eax,c_FOVtrack[esi]
        lea     edi,c_FOV[esi]
        call    dotrack pascal, eax, 1

                ;roll track (1)
        lea     eax,c_rolltrack[esi]
        lea     edi,c_roll[esi]
        call    dotrack pascal, eax, 1

                ;unit matrix
        lea     edi,o_A[esi]
        xor     eax,eax
        mov     ecx,9
        rep     stosd

        fld1
        fst     o_A[esi].A_11
        fst     o_A[esi].A_22
        fstp    o_A[esi].A_33

@@weg:  ret
c_dotracks endp

l_dotracks proc near
        ;-> esi = *this

        call    c_dotracks

                ;hidetrack
        lea     eax,l_hidetrack[esi]
        call    dohidetrack pascal, eax ;modifies l_hidden[esi]
        mov     eax,l_hidden[esi]       ;copy flag
        mov     o_hidden[esi],eax

@@weg:  ret
l_dotracks endp

t_dotracks proc near
        ;-> esi = *this

                ;position track (3)
        lea     eax,t_postrack[esi]
        lea     edi,o_p[esi]
        call    dotrack pascal, eax, 3

                ;matrix stays empty
@@weg:  ret
endp

b_dotracks proc near
        ;-> esi = *this

        mov     ebx,b_pos[esi]
        mov     eax,[ebx].x1
        mov     o_p[esi].x1,eax
        mov     eax,[ebx].x2
        mov     o_p[esi].x2,eax
        mov     eax,[ebx].x3
        mov     o_p[esi].x3,eax

@@weg:  ret
b_dotracks endp

dotrack proc pascal
arg   _track:dword, typesize:dword
        ;edi -> result
local key:dword
        push    esi

        mov     ebx,_track              ;ebx -> *track, key
        mov     eax,[ebx+4]
        mov     key,eax
        mov     esi,[ebx]               ;esi -> track


        mov     ecx,th_keys[esi]
        imul    ecx,size ttrack - 4
        add     ecx,size ttrackh        ;ecx + esi -> control points

        mov     eax,th_sframe[esi]      ;eax = startframe
        cmp     th_mode[esi],0
        jne     @@loop

                ;single
        mov     edx,frame               ;edx = frame
        cmp     edx,eax
        jbe     @@c                     ;before track-start
        mov     eax,[esi+ecx-4]         ;eax = endframe
        cmp     edx,eax
        jb      @@key
                                        ;behind track-end
        mov     ecx,typesize
        shl     ecx,2
        neg     ecx
        add     ecx,th_size[esi]

@@c:    add     esi,ecx                 ;copy first or last control point
        mov     ecx,typesize
        rep     movsd
        jmp     @@weg

@@loop:
                ;loop & repeat
        mov     ebx,[esi+ecx-4]
        sub     ebx,eax                 ;ebx = endframe - startframe

        neg     eax
        add     eax,frame               ;eax = frame - startframe
        cdq
        idiv    ebx
        or      edx,edx
        jns     @@0
        add     edx,ebx
@@0:    add     edx,th_sframe[esi]

@@key:                                  ;edx = frame

                ;keypos = (site ttrackh) - 4 + key*(size ttrack - 4)
        mov     ebx,size ttrack - 4
        imul    ebx,key
        add     ebx,size ttrackh - 4
        add     ebx,esi

        cmp     edx,t_sframe[ebx]       ;search actual key
        jae     @@1
        mov     key,0
        lea     ebx,[esi + size ttrackh - 4]
@@1:
        cmp     edx,t_eframe[ebx]
        jbe     @@2
        add     ebx,size ttrack - 4
        inc     key
        jmp     @@1
@@2:


@@spline:
                ;t
        mov     eax,t_sframe[ebx]
        sub     edx,eax                 ;edx = (frame - sframe)
        mov     dword ptr [edi],edx     ;temp
        fild    dword ptr [edi]
        neg     eax
        add     eax,t_eframe[ebx]       ;eax = (eframe - sframe)
        mov     dword ptr [edi],eax     ;temp
        fild    dword ptr [edi]
        fdivp   st(1),st                ;t = (frame - sframe) / (eframe - sframe);

                ;P1 * ((( 2*t)-3)*t*t +1)
                ;P4 * (((-2*t)+3)*t*t)
        fld     st(0)
        fadd    st,st(0)                ;2*t
        fsub    c_3                     ;-3
        fmul    st,st(1)                ;*t
        fmul    st,st(1)                ;*t
        fld     st
        fchs
        fld1
        fadd    st(2),st                ;+1
                ;st = 1.0; st(1) = R1, st(2) = R4, st(3) = t

                ;R1 * (t-2)*t*t+t
                ;R4 * (t-1)*t*t
        fadd    st,st(0)
        fsubr   st,st(3)                ;t-2
        fmul    st,st(3)                ;*t
        fmul    st,st(3)                ;*t
        fadd    st,st(3)                ;+t

        fld1
        fsubr   st,st(4)                ;t-1
        fmul    st,st(4)                ;*t
        fmul    st,st(4)                ;*t
                ;st = R4, st(1) = R1, st(2) = P4, st(3) = P1


        add     esi,ecx                 ;esi -> control points

        mov     ebx,typesize
        mov     ecx,ebx                 ;ecx = typesize
        shl     ebx,2
        mov     edx,ebx                 ;edx = typesize*4
        sub     ebx,ecx
        shl     ebx,2
        mov     eax,ebx                 ;eax = typesize*12
        imul    ebx,key
        add     esi,ebx                 ;esi -> P1, R1, R4, P4

        sub     eax,4                   ;eax = "reset-value" for esi
@@l:
        fld     dword ptr [esi]
        fmul    st,st(4)                ;P1
        add     esi,edx

        fld     dword ptr [esi]
        fmul    st,st(3)                ;R1
        faddp   st(1),st
        add     esi,edx

        fld     dword ptr [esi]
        fmul    st,st(2)                ;R4
        faddp   st(1),st
        add     esi,edx

        fld     dword ptr [esi]
        fmul    st,st(4)                ;P4
        faddp   st(1),st

        fstp    dword ptr [edi]

        sub     esi,eax                 ;reset control point pointer
        add     edi,4                   ;next target component

        dec     ecx
        jnz     @@l

        mov     ecx,5
@@clear:
        fstp    st
        dec     ecx
        jnz     @@clear

@@weg:
        mov     ebx,_track              ;ebx -> *track, key
        mov     eax,key
        mov     [ebx+4],eax             ;write key back

        pop     esi
        ret

dotrack endp


slerp proc near ;pascal
        ;esi -> input quaternions (lie one after another)
        ;edi -> resulting quaternions
        ;st = t
        ;edx = repetitions, for 3 it does this (qi:in, qr:result):
              ;qr0 = slerp(qi0,qi1,t)
              ;qr1 = slerp(qi1,qi2,t)
              ;qr2 = slerp(qi2,qi3,t)

@@next:
                ;calculate q1 * q2 = cos(th)
        mov     ecx,3
        fldz
@@skalar:
        fld     dword ptr [esi+ecx*4]
        fmul    dword ptr [esi+ecx*4+4*4]
        faddp   st(1),st
        dec     ecx
        jns     @@skalar
                ;st = cos(th), st(1) = r


                ;calculate sin(th) = sqrt(1-cos(th)^2)
        fld     st(0)
        fmul    st,st(0)
        fld1
        fsubrp  st(1),st                ;st(0) = sin(th)^2 = 1-cos(th)^2
        fcom    c_sinmin

        fstsw   ax
        sahf
        jb      @@linear

        fsqrt                           ;st(0) = sin(th), st(1) = cos(th)

        fst     st(3)
        fxch    st(1)
        fpatan  ;st(0) = th, st(1) = r, st(2) = sin(th)



                ;calculate i1 = sin((1-r)*th)/sinth
        fld1
        fsub    st,st(2)                ;st = 1-r
        fmul    st,st(1)                ;*th
        fsin
        fdiv    st,st(3)                ;/sinth

                ;calculate i2 = sin(r*th)/sinth
        fld     st(2)                   ;st = r
        fmul    st,st(2)                ;*th
        fsin
        fdiv    st,st(4)                ;/sinth

        ffree   st(4)
        jmp     @@i

@@linear:       ;st(2) = r
        fstp    st
                ;i1 = 1-r
        fld1
        fsub    st,st(2)
                ;i2 = r
        fld     st(2)

@@i:
        ;q = q1*i1 + q2*i2
        mov     ecx,4
@@l:
        fld     dword ptr [esi]
        fmul    st,st(2)
        fld     dword ptr [esi+4*4]
        fmul    st,st(2)
        add     esi,4
        faddp   st(1),st
        fstp    dword ptr [edi]
        add     edi,4
        dec     ecx
        jnz     @@l

        mov     ecx,3
@@clear:
        fstp    st
        dec     ecx
        jnz     @@clear


        dec     edx
        jnz     @@next

@@weg:  ret

slerp endp


dorottrack proc pascal
arg     _track:dword
        ;edi -> result
local   key:dword, q0:dword:4, q1:dword:4, q2:dword:4
        push    esi

        mov     ebx,_track              ;ebx -> *track, key
        mov     eax,[ebx+4]
        mov     key,eax
        mov     esi,[ebx]               ;esi -> track


        mov     ecx,th_keys[esi]
        imul    ecx,size ttrack - 4
        add     ecx,size ttrackh        ;ecx + esi -> control points

        mov     eax,th_sframe[esi]      ;eax = startframe
        cmp     th_mode[esi],0
        jne     @@loop

                ;single
        mov     edx,frame               ;edx = frame
        cmp     edx,eax
        jbe     @@c                     ;before track-start
        mov     eax,[esi+ecx-4]         ;eax = endframe
        cmp     edx,eax
        jb      @@key
                                        ;behind track-end
        mov     ecx,th_size[esi]
        sub     ecx,4*4                 ;4*typesize

@@c:    add     esi,ecx                 ;ersten oder letzen kontrollpunkt
        jmp     @@notrack

@@loop:
                ;loop & repeat
        mov     ebx,[esi+ecx-4]
        sub     ebx,eax                 ;ebx = endframe - startframe

        neg     eax
        add     eax,frame               ;eax = frame - startframe
        cdq
        idiv    ebx
        or      edx,edx
        jns     @@0
        add     edx,ebx
@@0:    add     edx,th_sframe[esi]

@@key:                                  ;edx = frame

                ;keypos = (site ttrackh) - 4 + key*(size ttrack - 4)
        mov     ebx,size ttrack - 4
        imul    ebx,key
        add     ebx,size ttrackh - 4
        add     ebx,esi

        cmp     edx,t_sframe[ebx]       ;search actual key
        jae     @@1
        mov     key,0
        lea     ebx,[esi + size ttrackh - 4]
@@1:
        cmp     edx,t_eframe[ebx]
        jbe     @@2
        add     ebx,size ttrack - 4
        inc     key
        jmp     @@1
@@2:


@@spline:
                ;t
        mov     eax,t_sframe[ebx]
        sub     edx,eax                 ;edx = (frame - sframe)
        mov     dword ptr [edi],edx     ;temp
        fild    dword ptr [edi]
        neg     eax
        add     eax,t_eframe[ebx]       ;eax = (eframe - sframe)
        mov     dword ptr [edi],eax     ;temp
        fild    dword ptr [edi]
        fdivp   st(1),st                ;t = (frame - sframe) / (eframe - sframe);


        add     esi,ecx                 ;esi -> control points
        mov     ebx,key
        shl     ebx,2
        sub     ebx,key                 ;ebx = key*4
        shl     ebx,4                   ;*16 (sizeof(quaternion) = 16)
        add     esi,ebx                 ;esi -> qn, an, bn, qn1


        push    edi

        lea     edi,q0
        mov     edx,3                   ;3 repititions
        call    slerp                   ;q0 = slerp(qn,an,t);
                                        ;q1 = slerp(an,bn1,t);
                                        ;q2 = slerp(bn1,qn1,t);
        lea     esi,q0
        mov     edi,esi
        mov     edx,2                   ;2 repititions
        call    slerp                   ;q0 = slerp(q0,q1,t);
                                        ;q1 = slerp(q1,q2,t);
        lea     esi,q0
        mov     edi,esi
        mov     edx,1                   ;1 repitition
        call    slerp                   ;q0 = slerp(q0,q1,t);

        fstp    st ;r

        pop     edi

        lea     esi,q0
@@notrack:                              ;frame out of track range
        fld     q_x[esi]
        fadd    st,st(0)
        fld     q_y[esi]
        fadd    st,st(0)
        fld     q_z[esi]
        fadd    st,st(0)
                ;st(2) = 2x, st(1) = 2y, st = 2z

                ;A11, A22, A33
        fld     q_x[esi]
        fmul    st,st(3)
        fld     q_y[esi]
        fmul    st,st(3)
        fld     q_z[esi]
        fmul    st,st(3)
                ;st(2) = 2xx, st(1) = 2yy, st = 2zz

        fld1                            ;1
        fsub    st,st(2)                ;-2yy
        fsub    st,st(1)                ;-2zz
        fstp    A_11[edi]

        fld1                            ;1
        fsub    st,st(3)                ;-2xx
        fsubrp  st(1)                   ;-2zz
        fstp    A_22[edi]

        fld1                            ;1
        fsubrp  st(1)                   ;-2yy
        fsubrp  st(1)                   ;-2xx
        fstp    A_33[edi]

                ;A21, A12
        fld     q_x[esi]
        fmul    st,st(2)
        fld     q_w[esi]
        fmul    st,st(2)
                ;st(1) = 2yx, st = 2zw

        fld     st(1)                   ;2xy
        fsub    st,st(1)                ;-2wz
        fstp    A_21[edi]
        faddp   st(1)                   ;2xy+2wx
        fstp    A_12[edi]

                ;A13, A31
        fld     q_z[esi]
        fmul    st,st(3)
        fld     q_w[esi]
        fmul    st,st(3)
                ;st(1) = 2xz, st = 2yw

        fld     st(1)                   ;2xz
        fsub    st,st(1)                ;-2yw
        fstp    A_13[edi]
        faddp   st(1)                   ;2xz+2yw
        fstp    A_31[edi]

                ;A32, A23
        fld     q_w[esi]
        fmul    st,st(3)
        fld     q_z[esi]
        fmul    st,st(3)
                ;st(1) = 2xw, st = 2yz

        fld     st(1)                   ;2xw
        fsubr   st,st(1)                ;2yz-
        fstp    A_32[edi]
        faddp   st(1)                   ;2yz+2xw
        fstp    A_23[edi]

        fstp    st
        fstp    st
        fstp    st

@@weg:
        mov     ebx,_track              ;ebx -> *track, key
        mov     eax,key
        mov     [ebx+4],eax             ;write key back

        pop     esi
        ret

dorottrack endp

dohidetrack proc pascal
arg   _track:dword

        push    esi

        mov     ebx,_track              ;ebx -> *track, key
        mov     esi,[ebx]               ;esi -> track

        mov     ecx,[esi]               ;ecx = number of keys
        mov     edx,[ebx+4]             ;edx = key

@@l:    cmp     ecx,edx                 ;end of track?
        jbe     @@w

        mov     eax,[esi+4+edx*4]       ;check switch-frame
        cmp     eax,frame
        ja      @@w                     ;not yet reached
        xor     dword ptr [ebx+8],1     ;switch hidden-flag
        inc     edx                     ;next key
        jmp     @@l

@@w:
        mov     [ebx+4],edx             ;write key back
        pop     esi
        ret
dohidetrack endp

doviewer proc near
        ;-> esi -> tcamera
        ;-> edi -> tviewer
        ;st(0) = x:y ratio (4:3 for camera, 1:1 for light)
        ;<- esi -> tcamera
        mov     eax,o_cube[esi]
        mov     v_cube[edi],eax

        mov     ebx,c_target[esi]

                ;direction vector u to target
        fld     o_p.x1[esi]
        fst     v_l.x1[edi]
        fsubr   o_p.x1[ebx]
        fld     o_p.x2[esi]
        fst     v_l.x2[edi]
        fsubr   o_p.x2[ebx]
        fld     o_p.x3[esi]
        fst     v_l.x3[edi]
        fsubr   o_p.x3[ebx]

                ;calculate local coordinate system l1, l2, l3 (l3 = view axis)
                                        ;l3 = u/|u|
                                        ;l1 = ((u) x (0,0,1))/|(u) x (0,0,1)|
                                        ;   = (u2,-u1,0)/sqrt(u1^2 + u2^2)
                                        ;l2 = l1 x l3  = | a2*b3        |
                                        ; (for l1 = a)   |-a1*b3        |
                                        ; (and l2 = b)   | a1*b2 - a2*b1|

        fld     st(2)                   ;make unit length
        fmul    st,st(0)                ;u1*u1
        fld     st(2)
        fmul    st,st(0)                ;u2*u2
        faddp   st(1),st
        fld     st(1)                   ;st(1) = (u1^2 + u2^2)
        fmul    st,st(0)                ;u3*u3
        fadd    st,st(1)
        fsqrt                           ;sqrt(u1^2 + u2^2 + u3^2) (length of u)

                ;l3                     ;l3 = u/|u|
        fld     st(4)
        fdiv    st,st(1)
        fstp    v_l3.x1[edi]
        fld     st(3)
        fdiv    st,st(1)
        fstp    v_l3.x2[edi]
        fdivr   st,st(2)
        fstp    v_l3.x3[edi]

                ;l1                     ;l1 = (u2,-u1,0)/sqrt(u1^2 + u2^2)
        fsqrt                           ;sqrt(u1^2 + u2^2)

        fld     st(2)                   ;u2/sqrt(u1^2 + u2^2)
        fdiv    st,st(1)
        fstp    v_l1.x1[edi]

        fdivp   st(3),st                ;-u1/sqrt(u1^2 + u2^2)
        fstp    st                      ;remove u3
        fstp    st                      ;remove u2
        fchs
        fstp    v_l1.x2[edi]

        fldz                            ;0
        fstp    v_l1.x3[edi]

                ;l2                     ;l2 = l1 x l3
        fld     v_l3.x1[edi]            ;b1
        fld     v_l1.x2[edi]            ;a2
        fld     v_l3.x2[edi]            ;b2
        fld     v_l1.x1[edi]            ;a1
        fld     v_l3.x3[edi]            ;b3

        fld     st(3)
        fmul    st,st(1)
        fstp    v_l2.x1[edi]            ;a2*b3

        fmul    st,st(1)
        fchs
        fstp    v_l2.x2[edi]            ;-a1*b3

        fmulp   st(1),st
        fxch    st(1)
        fmulp   st(2),st
        fsubrp  st(1),st
        fstp    v_l2.x3[edi]            ;a1*b2-a2*b1

                ;calc l1 and l2 scale factors for camera opening angle
        fld     c_pi_2                  ;1/tan(FOV) = tan(pi/2 - FOV)
        fsub    c_FOV[esi]              ;FOV = halve camera view angle
        fptan
        fstp    st
        fld     st
        fmulp   st(2),st                ;st(2) = (x:y-ratio) * 1/tan(FOV)

                ;calc l1 and l2 scale factors for rotation about the view axis
        fld     c_roll[esi]
        fsincos

                ;rotate & scale l1 and l2
        mov     ecx,2
@@l:            ;l1' = (l1*cos(roll) + l2*sin(roll))/tan(FOV)
        fld     v_l1[edi+ecx*4]
        fmul    st,st(1)                ;cos
        fld     v_l2[edi+ecx*4]
        fmul    st,st(3)                ;sin
        faddp   st(1),st
        fmul    st,st(3)                ;1/tan(FOV)
                ;l2' = (l2*cos(roll) + l1*sin(roll))*(x:y ratio)/tan(FOV)
        fld     v_l2[edi+ecx*4]
        fmul    st,st(2)                ;cos
        fld     v_l1[edi+ecx*4]
        fmul    st,st(4)                ;sin
        fsubp   st(1),st
        fmul    st,st(5)                ;(x:y ratio)/tan(FOV)

        fstp    v_l2[edi+ecx*4]
        fstp    v_l1[edi+ecx*4]
        dec     ecx
        jns     @@l

        fstp    st
        fstp    st
        fstp    st
        fstp    st
        ret
doviewer endp

traceobjects proc pascal ;trace objects in cubes
        ;-> esi = chain (*tobject, chained with o_chain)
local   side:dword

@@l:            ;object loop
        or      esi,esi                 ;esi -> tobject
        jz      @@weg

        mov     edi,o_cube[esi]
        or      edi,edi
        jz      @@next

        lea     edx,c_side[edi + 5*(size tside)]
        mov     side,5
@@s:
        mov     eax,s_flags[edx]
        test    eax,sfNextcube
        jz      @@sw                    ;side connected to another cube (side-cube)

        mov     ebx,size tdreieck

@@d:
        mov     eax,s_dreieck[edx].d_o[ebx]

        fld     o_p[esi].x1
        fsub    [eax].x1
        fmul    s_dreieck[edx].d_n[ebx].x1

        fld     o_p[esi].x2
        fsub    [eax].x2
        fmul    s_dreieck[edx].d_n[ebx].x2
        faddp   st(1),st

        fld     o_p[esi].x3
        fsub    [eax].x3
        fmul    s_dreieck[edx].d_n[ebx].x3
        faddp   st(1),st

        ftst                            ;st < 0: entered side-cube
        fstsw   ax
        fstp    st
        sahf
        ja      @@dw
                ;entered side-cube: modify links
        mov     ecx,c_objlist[edi]
        cmp     esi,ecx                 ;object at 1st position in list
        jne     @@l0
        mov     eax,o_nextincube[esi]   ;remove from list
        mov     c_objlist[edi],eax
        jmp     @@ein

@@l0:                                   ;objekt at 2nd to last position
        or      ecx,ecx
        jz      @@next
        cmp     esi,o_nextincube[ecx]   ;search entry
        je      @@l1
        mov     ecx,o_nextincube[ecx]
        jmp     @@l0
@@l1:
        mov     eax,o_nextincube[esi]   ;remove from list
        mov     o_nextincube[ecx],eax

@@ein:                                  ;insert in list of side-cube
        mov     edi,s_nextcube[edx]     ;edi -> side-cube
        mov     o_cube[esi],edi
        mov     eax,c_objlist[edi]
        mov     o_nextincube[esi],eax
        mov     c_objlist[edi],esi
        jmp     @@next
@@dw:
        sub     ebx,size tdreieck
        jns     @@d

@@sw:
        sub     edx,size tside
        dec     side
        jns     @@s

@@next: mov     esi,o_chain[esi]
        jmp     @@l

@@weg:  ret
traceobjects endp



cubetree proc pascal
        ;-> esi -> tviewer (camera/light)
local   side:dword, listend:dword, readptr:dword ;writeptr : edi
local   c1:byte, c2:byte, c3:byte, c4:byte
local counter:dword

        inc     stamp

        mov     side,0
        mov     c1,50                   ;c1 = 50 to indicate first pass

        mov     edi,v_cubelist[esi]     ;edi -> destination in tempcube list
        mov     readptr,edi             ;read position in tempcube list
        mov     listend,edi             ;end of actual recursion level in list

        mov     ebx,v_cube[esi]         ;ebx -> source-cube
        xor     eax,eax                 ;eax = recursion level
  mov counter,eax
@@l:            ;cube loop
        mov     tc_rekursion[edi],eax   ;write recursion level
   mov eax,counter
   inc counter
   mov tc_num[edi],eax
        mov     tc_cubeptr[edi],ebx     ;connect cube to temp-cube

        mov     eax,stamp               ;mark cube as "used"
        mov     c_stamp[ebx],eax
                                        ;8 vertices to transform
        xor     ecx,ecx                 ;vertex-count (0 to 7)
        xor     eax,eax                 ;vertex-offset (0 to 7*(size tvec))
        mov     tc_meshlist[edi],eax    ;clear mesh-temp-list
@@v_l:          ;vertex transform loop
                                        ;v : vertex to transform
                                        ;l : position of viewer
                                        ;l1: right hand vector of viewer
                                        ;l2: up vector of viewer
                                        ;l3: viewing direction
                                        ;x : transformed vector

        mov     edx,c_vertex[ebx+ecx*4] ;edx -> v

        fld     x1[edx]                 ;v-l (relative position to viewer)
        fsub    v_l.x1[esi]
        fld     x2[edx]
        fsub    v_l.x2[esi]
        fld     x3[edx]
        fsub    v_l.x3[esi]

        fld     v_l1.x1[esi]            ;(v-l)*l1 = x1
        fmul    st,st(3)
        fld     v_l1.x2[esi]
        fmul    st,st(3)
        fld     v_l1.x3[esi]
        fmul    st,st(3)
        faddp   st(1),st
        faddp   st(1),st
        fstp    tc_vertex.x1[edi+eax]

        fld     v_l2.x1[esi]            ;(v-l)*l2 = x2
        fmul    st,st(3)
        fld     v_l2.x2[esi]
        fmul    st,st(3)
        fld     v_l2.x3[esi]
        fmul    st,st(3)
        faddp   st(1),st
        faddp   st(1),st
        fstp    tc_vertex.x2[edi+eax]

        fld     v_l3.x1[esi]            ;(v-l)*l3 = x3
        fmulp   st(3),st
        fld     v_l3.x2[esi]
        fmulp   st(2),st
        fld     v_l3.x3[esi]
        fmulp   st(1),st
        faddp   st(1),st
        faddp   st(1),st
        fstp    tc_vertex.x3[edi+eax]

        add     eax,size tvec
        inc     ecx
        cmp     ecx,8
        jb      @@v_l
                                        ;test if the cube is visible
                ;ecx = 8
        cmp     c1,50                   ;is this the first pass (c1 == 50)?
        mov     c1,cl                   ;c1 = 8 (right border counter)
        je      @@1st                   ;jump to first pass label
        mov     c2,cl                   ;c2 = 8 (left border counter)
        mov     c3,cl                   ;c3 = 8 (upper border counter)
        mov     c4,cl                   ;c4 = 8 (lower border counter)

        xor     edx,edx
@@t_l:          ;vertex test loop
        or      ecx,ecx                 ;cube not visible if counter empty
        jz      @@n_in

        fld     tc_vertex.x1[edi+edx]   ;test right border
        fld     tc_vertex.x3[edi+edx]   ;x1 > x3 ?
        fcom    st(1)
        fstsw   ax
        and     ah,1                    ;if vertex can not be seen
        sub     c1,ah                   ; decremet right border counter

        fchs                            ;test left border
        fcomp   st(1)                   ;-x1 > x3 ?
        fstsw   ax
        and     ah,1
        dec     ah                      ;if vertex can not be seen
        add     c2,ah                   ; decremet left border counter

        fstp    st

        fld     tc_vertex.x2[edi+edx]   ;test upper border
        fld     tc_vertex.x3[edi+edx]   ;x2 > x3 ?
        fcom    st(1)
        fstsw   ax
        and     ah,1
        sub     c3,ah

        fchs                            ;test lower border
        fcomp   st(1)                   ;-x2 > x3 ?
        fstsw   ax
        and     ah,1
        dec     ah
        add     c4,ah

        fstp    st

        add     edx,size tvec
        dec     ecx

        cmp     cl,c1                   ;continue only if all vertices lie
        je      @@t_l                   ; out of one border so far
        cmp     cl,c2
        je      @@t_l
        cmp     cl,c3
        je      @@t_l
        cmp     cl,c4
        je      @@t_l
                ;cube visible if it came so far
@@1st:
        cmp     v_light[esi],0          ;camera or light?
        jne     @@m
        mov     eax,stamp               ;camera :
        mov     c_vstamp[ebx],eax       ; extra mark for light procedures
        mov     c_vtc[ebx],edi          ; extra link to temp-cube
@@m:
        add     edi,size ttempcube      ;new tempcube
        cmp     edi,v_cubelistmax[esi]  ;reached end of tempcube-list?
        jae     @@w                     ;yes -> exit loop
@@n_in:         ;label for cube not visible

        mov     edx,readptr             ;read pointer in tempcube list
        mov     eax,side                ;side actually processed (offset)
@@s:
        cmp     eax,6*(size tside)
        jb      @@2
@@0:    add     edx,size ttempcube      ;go to next cube in tempcube list
        cmp     edx,listend             ;recursion level done?
        jb      @@1
        cmp     edi,edx                 ;were cubes added to list?
        jbe     @@w                     ;no -> exit loop

                                        ;next recursion level
        mov     listend,edi             ;set end of recursion level (edi = writeptr)
@@1:
        xor     eax,eax                 ;set side offset to 0
@@2:
        mov     ebx,tc_cubeptr[edx]     ;ebx -> cube
        mov     ebx,s_nextcube[ebx+eax] ;ebx -> side-cube
        add     eax,size tside
        or      ebx,ebx                 ;side connected?
        jz      @@s                     ;next side (not connected)
        mov     ecx,stamp
        cmp     c_stamp[ebx],ecx        ;side-cube already used?
        je      @@s                     ;next side (already used)

        mov     side,eax
        mov     readptr,edx
                                        ;ebx -> source-cube
        mov     eax,tc_rekursion[edx]   ;eax = recursion level
        inc     eax
        jmp     @@l                     ;repeat loop


@@w:            ;end of loop
        mov     v_cubelistend[esi],edi  ;edi -> cubelistend


;-----
                                        ;generate the tempcube temp-meshlist
        mov     listend,edi
        mov     edi,v_cubelist[esi]

@@c_l:          ;temp cube loop
        cmp     edi,listend
        jae     @@weg

        mov     ebx,tc_cubeptr[edi]
        mov     esi,c_objlist[ebx]      ;esi -> tobject
@@m_l:          ;mesh loop
        or      esi,esi
        jz      @@mw
        push    esi

        xor     edx,edx                 ;edx = 0
@@owner:cmp     o_owner[esi],edx        ;go to top hierarchy level,
        je      @@top                   ; whole hierarchy trees are
        mov     esi,o_owner[esi]        ; inserted into the temp-meshlist
        jmp     @@owner
@@top:
        mov     eax,stamp               ;is object already used?
        cmp     o_stamp[esi],eax
        je      @@hw
        mov     o_stamp[esi],eax        ;mark it as used

@@h0:
        cmp     o_child[esi],edx
        je      @@h1
        mov     esi,o_child[esi]
        jmp     @@h0
@@h1:

        cmp     o_vmt[esi],offset m_vmt ;only meshes
        jne     @@nomesh
        cmp     o_hidden[esi],edx       ;edx = 0
        jne     @@nomesh
        mov     eax,tc_meshlist[edi]    ;insert in temp-list
        mov     tc_meshlist[edi],esi
        mov     m_nexttemp[esi],eax
@@nomesh:

@@h2:   cmp     o_owner[esi],edx
        je      @@hw
        cmp     o_next[esi],edx
        je      @@h3
        mov     esi,o_next[esi]
        jmp     @@h0
@@h3:
        mov     esi,o_owner[esi]
        jmp     @@h1

@@hw:   pop     esi
        mov     esi,o_nextincube[esi]
        jmp     @@m_l
@@mw:

        add     edi,size ttempcube
        jmp     @@c_l
@@weg:  ret
cubetree endp



texturedraw proc pascal
local   zval:dword

        mov     eax,viewer.v_tlist      ;clear transformed vertices list
        mov     viewer.v_tlistpos,eax
        mov     zval,255
        mov     esi,viewer.v_cubelistend
@@c_l:          ;cube loop
        sub     esi,size ttempcube
        cmp     esi,viewer.v_cubelist
        jb      @@weg                   ;no more cubes

        push    esi
        call    drawcube

        mov     esi,[esp]               ;esi -> ttempcube
        mov     esi,tc_meshlist[esi]    ;esi -> mesh

        lea     edi,viewer
        call    xformincube             ;transform all meshes
                                        ;esi -> mesh

@@m_l:          ;mesh loop
        or      esi,esi
        jz      @@1                     ;next cube
        cmp     m_mappinglist[esi],0    ;only meshes with mapping
        je      @@mw

        mov     edi,splist              ;edi -> tscreenpoint - list
        call    makefaces               ;enter faces into splist
        mov     eax,m_mapptr[esi]
        mov     edx,m_mapand[esi]
        mov     ebx,zval
        mov     m_zval[esi],ebx         ;8-bit-z-buffer value for mesh

        shl     ebx,24
        or      ebx,illum               ;brightness

        push esi
        ;mov     ecx,edi                 ;
        ;mov     esi,splist
        ;sub     ecx,esi

        call    drawfaces pascal, eax, edx, ebx
        dec     zval
        pop esi
@@mw:
        mov     esi,m_nexttemp[esi]     ;next object in cube
        jmp     @@m_l

@@1:
        pop     esi
        jmp     @@c_l                   ;next cube

@@weg:  ret
texturedraw endp


drawcube proc pascal
        ;-> esi -> ttempcube
local   tc:dword, side:dword, side_s2p:dword, skip:dword
local   zval:dword,   rekursion:dword

        mov     tc,esi

        mov     eax,tc_rekursion[esi]
  mov rekursion,eax
  mov eax,tc_num[esi]
        shl     eax,24
        or      eax,illum               ;brightness
        mov     zval,eax

        mov     ebx,tc_cubeptr[esi]
        lea     ebx,c_side[ebx + 5*(size tside)]
        mov     side,ebx
        mov     side_s2p,5
@@s:
        mov     ebx,side

        mov     eax,s_flags[ebx]
        test    eax,sfBitmap
        jz      @@nomap
        ;and     s_flags[ebx],not sfDrawed
        and     eax,sfTile + sf4point
        mov     skip,eax

        mov     ebx,s_mapping[ebx]
@@d:
        mov     esi,tc
        mov     edi,splist              ;edi -> screenpoints list
        xor     ecx,ecx
@@p:
        cmp     ecx,skip
        je      @@a                     ;skip point

        mov     edx,side_s2p
        movzx   edx,s2p_t[edx*4+ecx]

        mov     eax,tc_vertex[esi+edx].x1
        mov     sp_sx[edi],eax
        mov     eax,tc_vertex[esi+edx].x2
        mov     sp_sy[edi],eax
        mov     eax,tc_vertex[esi+edx].x3
        mov     sp_z[edi],eax

        mov     eax,m_u[ebx+ecx*8]
        mov     sp_u[edi],eax
        mov     eax,m_v[ebx+ecx*8]
        mov     sp_v[edi],eax

        add     edi,size tscreenpoint
@@a:
        inc     ecx
        cmp     ecx,4
        jb      @@p

        push    ebx                     ;save: ebx -> mapping-koordinaten

        mov     ebx,splist              ;ebx -> screenpoints list
        call    projektion pascal, size tscreenpoint, 1
        jbe     @@0                     ;less than 3 points

;        cmp     zval,t_sub*1000000h
  cmp rekursion,t_sub
        ja      @@ohne
                ;with scanline subdivision
        call    subxclip pascal, size tscreenpoint, 1
        jbe     @@0
        sub     edi,ebx
        mov     esi,side
        ;or      s_flags[esi],sfDrawed
        call    subpolygon pascal, ebx, edi, s_mapptr[esi], s_mapand[esi], zval
        jmp     @@0

@@ohne:         ;without scanline subdivision
        call    xclip
        jbe     @@0
        sub     edi,ebx
        mov     esi,side
        ;or      s_flags[esi],sfDrawed
        call    polygon pascal, ebx, edi, s_mapptr[esi], s_mapand[esi], zval
@@0:
        pop     ebx

        add     skip,2                  ;next triangle if tiled
        cmp     skip,4
        jb      @@d
@@nomap:
        sub     side,size tside
        dec     side_s2p
        jns     @@s

@@weg:  ret
drawcube endp

xformincube proc pascal ;for camera or light
        ;-> esi -> mesh (1st in unsorted chain)
        ;-> edi -> viewer
        ;<- esi -> mesh (1st in sorted chain)
        ;<- edi -> viewer
local   meshptr:dword

        mov     meshptr,NULL

@@l:    or      esi,esi
        jz      @@w
        ;esi -> mesh
        ;edi -> viewer
        call    meshxform
        ;eax -> z-distance

        mov     ebx,meshptr
        or      ebx,ebx
        jz      @@1st
        cmp     eax,m_z[ebx]
        jge     @@1st

@@search:
        mov     edx,ebx
        mov     ebx,m_nexttemp[ebx]
        or      ebx,ebx
        jz      @@ins
        cmp     eax,m_z[ebx]
        jl      @@search
@@ins:
        mov     m_nexttemp[edx],esi
@@0:
   ;-
       cmp v_light[edi],0
       je @@2
 @@1:  test m_flags[esi],mfUnitenext
       jz @@2
       cmp m_nexttemp[esi],0
       je @@2
       mov esi,m_nexttemp[esi]
       push ebx
       push eax
       call meshxform
       pop eax
       pop ebx
       mov m_z[esi],eax
       jmp @@1
 @@2:
   ;-
        xchg    m_nexttemp[esi],ebx

        mov     esi,ebx                 ;get next in temp list
        jmp     @@l

@@1st: ;als ersten einfgen
        mov     meshptr,esi
        jmp     @@0

@@w:    mov     esi,meshptr
@@weg:  ret
xformincube endp


meshxform proc pascal ;for camera or light
        ;-> esi -> mesh
        ;-> edi -> viewer
        ;<- esi -> mesh
        ;<- edi -> viewer
        ;<- eax = z-distance
local   p:dword:3, A:dword:9
                                        ;A = matrix, p = position
                                        ;l = local coordinate system (viewer)

                                        ;A = Al*A (matrix multiplication)

        xor     ebx,ebx                 ;ebx = n
@@l2:
        fld     o_A[esi + ebx*4].A_1n   ;n-th column of A
        fld     o_A[esi + ebx*4].A_2n
        fld     o_A[esi + ebx*4].A_3n

        xor     edx,edx                 ;edx = m
@@l1:
        fld     v_l1[edi + edx].A_m1    ;* m-th row of Al
        fmul    st,st(3)
        fld     v_l1[edi + edx].A_m2
        fmul    st,st(3)
        fld     v_l1[edi + edx].A_m3
        fmul    st,st(3)
        faddp   st(1)
        faddp   st(1)
        lea     eax,[ebx*4+edx]
        fstp    A[eax]                  ;= new element (m,n) of A

        add     edx,3*4
        cmp     edx,3*3*4
        jb      @@l1

        fstp    st
        fstp    st
        fstp    st

        inc     ebx
        cmp     ebx,3
        jb      @@l2
                                        ;p = Al*(p-l)

        fld     o_p[esi].x1             ;(p-l)
        fsub    v_l[edi].x1
        fld     o_p[esi].x2
        fsub    v_l[edi].x2
        fld     o_p[esi].x3
        fsub    v_l[edi].x3

        xor     ebx,ebx                 ;ebx = m
@@l3:
        lea     edx,[ebx+ebx*2]
        fld     v_l1[edi + edx*4].A_m1  ;* m-th row of Ao
        fmul    st,st(3)
        fld     v_l1[edi + edx*4].A_m2
        fmul    st,st(3)
        fld     v_l1[edi + edx*4].A_m3
        fmul    st,st(3)
        faddp   st(1)
        faddp   st(1)
        fstp    p[ebx*4]                ;= new element (m,1) of p

        inc     ebx
        cmp     ebx,3
        jb      @@l3

        fstp    st
        fstp    st
        fstp    st

;----
        push    edi                     ;store: edi -> viewer

                ;transform all vertices
        cmp     v_light[edi],0
        mov     edi,v_tlistpos[edi]     ;edi -> list of transformed vertices
        mov     m_tlistpos[esi],edi     ;save list start for this mesh
        jne     @@light
        mov     m_vtlistpos[esi],edi    ;if camera: reference for light procs
@@light:

        mov     ecx,m_vertices[esi]
        mov     eax,m_vertexlist[esi]

@@t_l:  fld     [eax].x1                ;vertex v (calc A*v + p)
        fld     [eax].x2
        fld     [eax].x3

        xor     ebx,ebx                 ;ebx = m
@@l4:
        lea     edx,[ebx+ebx*2]
        fld     A[edx*4].A_m1           ;* m-th row of A
        fmul    st,st(3)
        fld     A[edx*4].A_m2
        fmul    st,st(3)
        fld     A[edx*4].A_m3
        fmul    st,st(3)
        faddp   st(1)
        faddp   st(1)
        fadd    p[ebx*4]
        fstp    dword ptr [edi + ebx*4] ;= element (m,1) of the vertex

        inc     ebx
        cmp     ebx,3
        jb      @@l4

        fstp    st
        fstp    st
        fstp    st

        add     eax,size tvec
        add     edi,size tvec

        dec     ecx
        jnz     @@t_l

   mov eax,edi
   pop edi
   mov v_tlistpos[edi],eax

   fld p.x3                  ;z-distance of mesh from viewer
   fmul c_128
   fistp p
   mov eax,p
   cmp v_light[edi],0
   je @@0
   neg eax
@@0:
   mov m_z[esi],eax
@@weg:  ret
meshxform endp

makefaces proc pascal
        ;-> esi -> mesh
        ;-> edi -> screenpoints-list
        ;<- esi -> mesh
local   z:dword
                ;make triangles
        mov     ecx,m_faces[esi]
        lea     ecx,[ecx+ecx*2]
        mov     z,ecx
        mov     ebx,m_facelist[esi]
        mov     ecx,m_mappinglist[esi]
        push    esi
        mov     esi,m_tlistpos[esi]     ;esi -> list of transformed vertices

@@d_l:  mov     edx,[ebx]               ;point-number

        mov     eax,m_u[ecx+edx*8]      ;mapping
        mov     sp_u[edi],eax
        mov     eax,m_v[ecx+edx*8]
        mov     sp_v[edi],eax

        lea     edx,[edx+edx*2]         ;edx*3
        mov     eax,[esi+edx*4].x1      ;vertex
        mov     sp_sx[edi],eax
        mov     eax,[esi+edx*4].x2
        mov     sp_sy[edi],eax
        mov     eax,[esi+edx*4].x3
        mov     sp_z[edi],eax

        add     ebx,4
        add     edi,size tscreenpoint
        dec     z
        jnz     @@d_l

        pop     esi

@@weg:  ret
makefaces endp

drawfaces proc pascal
arg     mapptr:dword, mapand:dword, zval:dword
        ;-> edi -> screenpoints-list-end

        mov     ebx,edi

@@l:            ;face-loop
        cmp     ebx,splist              ;end of list?
        jbe     @@weg
        mov     edi,ebx                 ;edi -> end of triangle
        sub     ebx,(size tscreenpoint)*3
        push    ebx                     ;ebx -> start of triangle

        call    projektion pascal, size tscreenpoint, 1
        jbe     @@0                     ;less than tree points

        call    xclip
        jbe     @@0
        sub     edi,ebx                 ;edi = (number of points)*(size tscreenpoint)
        call    polygon pascal, ebx, edi, mapptr, mapand, zval
@@0:
        pop     ebx
        jmp     @@l

@@weg:  ret
drawfaces endp

projektion proc pascal
arg     spsize:dword, vars_1:dword
        ;-> ebx = *sp
        ;-> edi = *sp_end
        ;<- ebx = *sp
        ;<- edi = *sp_end
        ;<- flags: if less than 3 points, jump with jbe
local   _sp:dword, _sp_end:dword ;both are pointers

                                        ;x, y, z: components of source point
                                        ;d : prefix for destination points
                                        ;n : prefix for next sorce point

        mov     _sp,ebx                 ;ebx -> source points
        mov     _sp_end,edi             ;edi -> destination points

        fld1
@@z_l:
                                        ;inn = true : point in front of plane
        fld     sp_z[ebx]               ;inn = (z >= 1)
        fcomp   st(1)

        fstsw   ax
        mov     dh,ah                   ;dh = inn
                ;if (inn)
        sahf
        jb      @@0
                ;point in front of projection plane (visible)
        fld     sp_z[ebx]
        fst     sp_z[edi]

        fld     sp_sx[ebx]              ;dx = xres/2 *(1 + x/z)
        fdiv    st,st(1)
        fadd    st,st(2)
        fmul    c_xmid
        fstp    sp_sx[edi]

        fld     sp_sy[ebx]              ;dy = yres/2 *(1 - y/z)
        fdivrp  st(1),st
        fsubr   st,st(1)
        fmul    c_ymid
        fstp    sp_sy[edi]

        mov     ecx,vars_1              ;mapping
@@l1:   mov     eax,sp_u[ebx+ecx*4]
        mov     sp_u[edi+ecx*4],eax
        dec     ecx
        jns     @@l1

        add     edi,spsize              ;one destination point added
                ;end of if statement
@@0:
        mov     esi,ebx                 ;ebx -> actual source point
        add     esi,spsize              ;esi -> next source point
        cmp     esi,_sp_end             ;wrap if at last point
        jb      @@wrap
        mov     esi,_sp
@@wrap:
                ;if (inn ^ (nz >= 1))
        fld     sp_z[esi]
        fcomp   st(1)
        fstsw   ax
        xor     ah,dh                   ;dh = inn
        sahf
        jnc     @@1
                ;this or next point behind projection plane
                ;r = (1.0-z)/(nz-z)
        fld1
        fst     sp_z[edi]               ;dz = 1.0
        fsub    sp_z[ebx]
        fld     sp_z[esi]
        fsub    sp_z[ebx]
        fdivp   st(1),st                ;st = r

        fld     sp_sx[ebx]              ;x' = x + r*(nx-x)
        fld     sp_sx[esi]
        fsub    st,st(1)
        fmul    st,st(2)
        faddp   st(1),st
        fadd    st,st(2)                ;dx = xres/2 *(1 + x')
        fmul    c_xmid
        fstp    sp_sx[edi]

        fld     sp_sy[ebx]              ;y' = y + r*(ny-y)
        fld     sp_sy[esi]
        fsub    st,st(1)
        fmul    st,st(2)
        faddp   st(1),st
        fsubr   st,st(2)                ;dy = yres/2 *(1 - y')
        fmul    c_ymid
        fstp    sp_sy[edi]

        mov     ecx,vars_1
@@l2:   fld     sp_u[ebx+ecx*4]
        fld     sp_u[esi+ecx*4]
        fsub    st,st(1)
        fmul    st,st(2)
        faddp   st(1),st
        fstp    sp_u[edi+ecx*4]
        dec     ecx
        jns     @@l2
        fstp    st                      ;remove r

        add     edi,spsize              ;one destination point added
                ;end of if statement
@@1:
        cmp     esi,ebx                 ;ns > s?
        mov     ebx,esi                 ;is same as ebx += size tscreenpoint
        ja      @@z_l                   ;repeat loop

                                        ;ebx -> start of s-points
        mov     esi,_sp_end             ;esi -> start of d-points

        mov     ecx,edi
        sub     ecx,esi                 ;ecx = length of all d-points
        shr     ecx,2                   ;ecx = number of dwords to copy

        mov     edi,ebx                 ;edi -> start of s-points
        rep     movsd                   ;copy d-points to start of array

        fstp    st                      ;remove 1.0

        mov     eax,edi
        sub     eax,ebx
        shr     eax,1
        cmp     eax,spsize
      ;----
      jbe @@weg
                                        ;lie points clock-wise?
        mov     edx,spsize
        fld     sp_sx[ebx+edx*2]
        fsub    sp_sx[ebx]
        fld     sp_sy[ebx+edx]
        fsub    sp_sy[ebx]
        fmulp   st(1),st
        fld     sp_sy[ebx+edx*2]
        fsub    sp_sy[ebx]
        fld     sp_sx[ebx+edx]
        fsub    sp_sx[ebx]
        fmulp   st(1),st
        fcomp
        fstsw   ax
        fstp    st
        sahf

      ;---
@@weg:  ret
projektion endp


xclip proc pascal ;x-clipping
        ;-> ebx = *sp
        ;-> edi = *sp_end
        ;<- ebx = *sp
        ;<- edi = *sp_end
        ;<- wenn weniger als 3 punkte, mit jbe wegspringen
local   _sp:dword, _sp_end:dword ;beides pointer
local   i:byte

        fldz                            ;st = x
        mov     i,1
@@i_l:
        mov     _sp,ebx                 ;ebx -> sp[z] (quellpunkte) (z = 0)
        mov     _sp_end,edi             ;edi -> sp[d] (zielpunkte)  (d = m)

        xor     dl,dl                   ;dl = flag
@@z_l:

        fld     sp_sx[ebx]              ;inn = (sp[z].sx >= x);
        fcomp   st(1)
        fstsw   ax
        mov     dh,ah                   ;dh = inn
        xor     ah,i
        sahf
        jnc     @@0
                ;punkt innerhalb
        mov     esi,ebx
        mov     ecx,size tscreenpoint/4
        rep     movsd                   ;sp[d] = sp[z] und d++
@@0:
        mov     esi,ebx
        add     esi,size tscreenpoint   ;nz = z+1
        cmp     esi,_sp_end             ;if (nz >= m) nz = 0;
        jb      @@wrap
        mov     esi,_sp
@@wrap:

        fld     sp_sx[esi]              ;if (inn ^ (sp[nz].sx >= x))
        fcomp   st(1)
        fstsw   ax
        xor     ah,dh                   ;dh = inn
        sahf
        jnc     @@1
                ;dieser oder nchster punkt auerhalb
        inc     dl                      ;flag = 1

        fst     sp_sx[edi]              ;sp[d].sx speichern

                ;r berechnen
        fld     st;x                    ;(x - sp[z].sx)
        fsub    sp_sx[ebx]
        fld     sp_sx[esi]              ;/(sp[nz].sx - sp[z].sx)
        fsub    sp_sx[ebx]
        fdivp   st(1),st                ;st = r


        fld     sp_sy[ebx]              ;sp[d].sy berechnen
        fld     sp_sy[esi]              ; sp[z].sy + r*(sp[nz].sy - sp[z].sy)
        fsub    st,st(1)
        fmul    st,st(2)
        faddp   st(1),st
        fstp    sp_sy[edi]

        fld     sp_u[esi]               ;sp[d].u
        fsub    sp_u[ebx]
        fmul    st,st(1)
        fadd    sp_u[ebx]
        fstp    sp_u[edi]

        fld     sp_v[esi]               ;sp[d].v
        fsub    sp_v[ebx]
        fmulp   st(1),st                ;r entfernen
        fadd    sp_v[ebx]
        fstp    sp_v[edi]

        add     edi,size tscreenpoint   ;d++
@@1:
        cmp     esi,ebx                 ;wz > z?
        mov     ebx,esi                 ;entspricht ebx += size tscreenpoint
        ja      @@z_l                   ;z-schleife

                                        ;ebx -> anfang der z-punkte (sp)
        mov     esi,_sp_end             ;esi -> anfang der d-punkte (sp_end)
                                        ;edi -> ende der d-punkte
        mov     ecx,edi
        sub     ecx,esi                 ;ecx = anzahl zu kopierender byte
        jz      @@w                     ; kein punkt brig (ZF = 1)

        mov     edi,esi                 ;wenn flag = 0: nicht kopieren,
        or      dl,dl                   ; edi = _lp_end zurckgeben
        jz      @@2

        mov     edi,ebx                 ;edi -> anfang der z-punkte
        shr     ecx,2                   ;ecx = anzahl zu kopierender dwords
        rep     movsd
@@2:

        fiadd   xres                    ;x += xres
        dec     i                       ;i-schleife
        jns     @@i_l

        mov     eax,edi
        sub     eax,ebx
        cmp     eax,(size tscreenpoint)*2
@@w:    fstp    st                      ;x entfernen
@@weg:  ret
xclip endp

polygon proc pascal
arg     _sp, sp_end, mapptr, mapand, zval
        ;_sp = *sp, zeiger auf screenpoints

local   pend, y, x_y, lb, lc, rb, rc ;int
local   lx, ldx, lu, ldu, lv, ldv
local   rx, rdx, ru, rdu, rv, rdv
local   xa, xe, txt_x, txt_y ;int


        xor     eax,eax                 ;start- und endpunkt bestimmen
        mov     lb,eax
        mov     rb,eax
        mov     pend,eax

        mov     esi,_sp                 ;esi -> screenpoints
        fld     sp_sy[esi]               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        mov      ecx,sp_end
        sub      ecx,size tscreenpoint  ;esi+ecx -> sp[sp_end-1]
@@max_l:

        fld     sp_sy[esi+ecx]
        fcom    st(1);ymax              ;grten y-wert finden (endpunkt)
        fstsw   ax
        sahf
        jb      @@max
        mov     pend,ecx
        fst     st(1);ymax
        jmp     @@min
@@max:
        fcom    st(2);ymin              ;kleinsten y-wert finden (startpunkt)
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,ecx
        mov     rb,ecx
        fst     st(2);ymin
@@min:  fstp    st

        sub     ecx,size tscreenpoint
        jnz     @@max_l
        fstp    st                      ;ymax entfernen

        fistp   y                       ;y = ceil(ymin)

        mov     eax,y

        cmp     eax,yres                ;y-clipping
        jge     @@weg

        or      eax,eax
        jg      @@y0
        mov     y,0
        xor     eax,eax
@@y0:
        imul    eax,xres
        mov     edx,buffer
        shr     edx,2
        add     eax,edx
        mov     x_y,eax

        mov     lc,1
        mov     rc,1

        ;fld     c_64                    ;st(0) = 64

@@y_l:  ;y-schleife

                ;links
        dec     lc
        jnz     @@l_nz
        mov     edi,_sp
        mov     esi,lb
@@lc:
        cmp     esi,pend
        je      @@fertig                ;lb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = lb
        sub     esi,size tscreenpoint   ;lb--
        jnc     @@l0                    ;wrap
        add     esi,sp_end
@@l0:
        fld     sp_sy[esi+edi]           ;lc = ceil(sp[lb].sy) - y
        fistp   lc
        mov     eax,y
        sub     lc,eax
        jle     @@lc                    ;while lc <= 0
        mov     lb,esi


        fild    y
        fsub    sp_sy[ebx+edi]           ;(y  - sp[ia].y)

        fld     sp_sy[edi+esi]           ;(sp[lb].y - sp[ia].y)
        fsub    sp_sy[edi+ebx]

                ;ldu = (sp[lb].u - sp[ia].u)/(sp[lb].y - sp[ia].y);
        fld     sp_u[edi+esi]
        fsub    sp_u[edi+ebx]
        fdiv    st,st(1)
        fst     ldu

                ;lu = ldu  *(y  - sp[ia].y) + sp[ia].u;
        fmul    st,st(2)
        fadd    sp_u[edi+ebx]
      ;fist txt_x
        fstp    lu

                ;ldv = (sp[lb].v - sp[ia].v)/(sp[lb].y - sp[ia].y);
        fld     sp_v[edi+esi]
        fsub    sp_v[edi+ebx]
        fdiv    st,st(1)
        fst     ldv

                ;lv = ldv  *(y  - sp[ia].y) + sp[ia].v;
        fmul    st,st(2)
        fadd    sp_v[edi+ebx]
      ;fist txt_y
        fstp    lv

                ;ldx = (sp[lb].x - sp[ia].x)/(sp[lb].y - sp[ia].y);
        fld     sp_sx[edi+esi]
        fsub    sp_sx[edi+ebx]
        fdivrp  st(1),st
        fst     ldx

                ;lx = ldx  *(y  - sp[ia].y) + sp[ia].x;
        fmulp   st(1),st
        fadd    sp_sx[edi+ebx]
        fst     lx

        jmp     @@l_z
@@l_nz:
        fld     lu
        fadd    ldu
      ;fist txt_x
        fstp    lu

        fld     lv
        fadd    ldv
      ;fist txt_y
        fstp    lv

        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_z:
                ;rechts
        dec     rc
        jnz     @@r_nz
        mov     edi,_sp
        mov     esi,rb
@@rc:
        cmp     esi,pend
        je      @@fertig                ;rb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = rb
        add     esi,size tscreenpoint   ;rb++
        cmp     esi,sp_end
        jb      @@r0                    ;wrap
        xor     esi,esi
@@r0:
        fld     sp_sy[esi+edi]           ;rc = ceil(sp[rb].sy) - y
        fistp   rc
        mov     eax,y
        sub     rc,eax
        jle     @@rc                    ;while lc <= 0
        mov     rb,esi


        fild    y
        fsub    sp_sy[ebx+edi]           ;(y  - sp[ia].y)

        fld     sp_sy[edi+esi]           ;(sp[rb].y - sp[ia].y)
        fsub    sp_sy[edi+ebx]

                ;rdu = (sp[rb].u - sp[ia].u)/(sp[rb].y - sp[ia].y);
        fld     sp_u[edi+esi]
        fsub    sp_u[edi+ebx]
        fdiv    st,st(1)
        fst     rdu

                ;ru = rdu  *(y  - sp[ia].y) + sp[ia].u;
        fmul    st,st(2)
        fadd    sp_u[edi+ebx]
      fist txt_x
        fstp    ru

                ;rdv = (sp[rb].v - sp[ia].v)/(sp[rb].y - sp[ia].y);
        fld     sp_v[edi+esi]
        fsub    sp_v[edi+ebx]
        fdiv    st,st(1)
        fst     rdv

                ;rv = rdv  *(y  - sp[ia].y) + sp[ia].v;
        fmul    st,st(2)
        fadd    sp_v[edi+ebx]
      fist txt_y
        fstp    rv

                ;rdx = (sp[rb].x - sp[ia].x)/(sp[rb].y - sp[ia].y);
        fld     sp_sx[edi+esi]
        fsub    sp_sx[edi+ebx]
        fdivrp  st(1),st
        fst     rdx

                ;rx = rdx  *(y  - sp[ia].y) + sp[ia].x;
        fmulp   st(1),st
        fadd    sp_sx[edi+ebx]
        fst     rx

        jmp     @@r_z
@@r_nz:
        fld     ru
        fadd    rdu
      fist txt_x
        fstp    ru

        fld     rv
        fadd    rdv
      fist txt_y
        fstp    rv

        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_z:

        fistp   xe                      ;xe = ceil(rx) (rx entfernen)
        fistp   xa                      ;xa = ceil(lx) (lx entfernen)

        mov     edi,xa
        mov     ecx,xe
        sub     ecx,edi                 ;ecx = CCCC
        jle     @@w
        add     edi,x_y                 ;edi -> pixel
    shl edi,2

        movzx   edx,word ptr txt_x      ;edx = 00Xx
        movzx   ebx,word ptr txt_y      ;ebx = 00Yy

        mov     eax,divtab2
        fld     ru
        fsubr   lu
        fmul    dword ptr[eax+ecx*4]
        fistp   txt_x
        fld     rv
        fsubr   lv
        fmul    dword ptr[eax+ecx*4]
        fistp   txt_y


        push    ebp                     ;ebp : lokale variablen
        push    mapand

        mov     eax,txt_x               ;eax = ??Uu
        movzx   esi,ah
        or      esi,zval                ;esi = zlpU
        push    esi

        mov     esi,mapptr              ;esi = TTTT
        movzx   ebp,word ptr txt_y      ;ebp = 00Vv

        shl     ebx,8
        shl     ebp,8
        shrd    ebx,edx,8               ;ebx = x0Yy
        shrd    ebp,eax,8               ;ebp = u0Vv
        shr     edx,8                   ;edx = 000X

        pop     eax                     ;eax = zlpU

        mov     dh,bh
@@inner:
        and     edx,[esp]
        add     ebx,ebp
        mov     ah,[esi+edx]
        ;inc     edi
        adc     dl,al
        dec     ecx
        mov     dh,bh
        mov     [edi+ecx*4],eax;edi*4
        jnz     @@inner

        pop     eax                     ;mapand entfernen
        pop     ebp

@@w:

        mov     eax,xres
        add     x_y,eax
        inc     y
        mov     eax,yres
        cmp     eax,y                   ;while (y < yres)
        jg      @@y_l

@@fertig:
        ;fstp    st                      ;16.0 entfernen

@@weg:  ret
polygon endp

subxclip proc pascal ;x-clipping fr scanline subdiv.
arg     spsize:dword, vars_1:dword
        ;-> ebx = *sp
        ;-> edi = *sp_end
        ;<- ebx = *sp
        ;<- edi = *sp_end
        ;<- wenn weniger als 3 punkte, mit jbe wegspringen
local   _sp:dword, _sp_end:dword ;beides pointer
local   i:byte

        fldz                            ;st = x
        ;fld c_100
        mov     i,1
@@i_l:
        mov     _sp,ebx                 ;ebx -> sp[z] (quellpunkte) (z = 0)
        mov     _sp_end,edi             ;edi -> sp[d] (zielpunkte)  (d = m)

        xor     dl,dl                   ;dl = flag
@@z_l:

        fld     sp_sx[ebx]              ;inn = (sp[z].sx >= x);
        fcomp   st(1)
        fstsw   ax
        mov     dh,ah                   ;dh = inn
        xor     ah,i
        sahf
        jnc     @@0
                ;punkt innerhalb
        mov     esi,ebx
        mov     ecx,spsize;size tscreenpoint/4
        shr     ecx,2
        rep     movsd                   ;sp[d] = sp[z] und d++
@@0:
        mov     esi,ebx
        add     esi,spsize              ;nz = z+1
        cmp     esi,_sp_end             ;if (nz >= m) nz = 0;
        jb      @@wrap
        mov     esi,_sp
@@wrap:

        fld     sp_sx[esi]              ;if (inn ^ (sp[nz].sx >= x))
        fcomp   st(1)
        fstsw   ax
        xor     ah,dh                   ;dh = inn
        sahf
        jnc     @@1
                ;dieser oder nchster punkt auerhalb
        inc     dl                      ;flag = 1
        fst     sp_sx[edi]
                                        ;sp[d].sy berechnen
        fld     sp_sy[esi]              ;(sp[nz].sy - sp[z].sy)
        fsub    sp_sy[ebx]
        fld     sp_sx[esi]              ;/(sp[nz].sx - sp[z].sx)
        fsub    sp_sx[ebx]
        fdivp   st(1),st
        fld     st(1);x
        fsub    sp_sx[ebx]              ;*(x - sp[z].sx)
        fmulp   st(1),st
        fadd    sp_sy[ebx]              ;+sp[z].sy
        fstp    sp_sy[edi]

        fld     sp_sx[ebx]              ;ax = sp[z].sx *sp[z].z;
        fmul    sp_z[ebx]

        fld     sp_sx[esi]              ;ux = sp[nz].sx*sp[nz].z - ax;
        fmul    sp_z[esi]
        fsub    st,st(1)

                ;r = (x * sp[z].z - ax) / (ux - (sp[nz].z - sp[z].z) * x);
        fld     sp_z[esi]               ;ux - (sp[nz].z - sp[z].z) * x
        fsub    sp_z[ebx]
        fmul    st,st(3);x
        fsubp   st(1),st
        fld     sp_z[ebx]               ;(x * sp[z].z - ax)
        fmul    st,st(3);x
        fsubrp  st(2),st
        fdivp   st(1),st                ;st = r

        fld     sp_z[esi]               ;sp[d].z
        fsub    sp_z[ebx]
        fmul    st,st(1)
        fadd    sp_z[ebx]
        fstp    sp_z[edi]

        mov     ecx,vars_1
@@l:    fld     sp_u[esi+ecx*4]               ;sp[d].u
        fsub    sp_u[ebx+ecx*4]
        fmul    st,st(1)
        fadd    sp_u[ebx+ecx*4]
        fstp    sp_u[edi+ecx*4]
        dec     ecx
        jns     @@l
        fstp    st                      ;r entfernen

        add     edi,spsize              ;d++
@@1:
        cmp     esi,ebx                 ;wz > z?
        mov     ebx,esi                 ;entspricht ebx += size tscreenpoint
        ja      @@z_l                   ;z-schleife

                                        ;ebx -> anfang der z-punkte (sp)
        mov     esi,_sp_end             ;esi -> anfang der d-punkte (sp_end)
                                        ;edi -> ende der d-punkte
        mov     ecx,edi
        sub     ecx,esi                 ;ecx = anzahl zu kopierender byte
        jz      @@w                     ; kein punkt brig (ZF = 1)

        mov     edi,esi                 ;wenn flag = 0: nicht kopieren,
        or      dl,dl                   ; edi = _lp_end zurckgeben
        jz      @@2

        mov     edi,ebx                 ;edi -> anfang der z-punkte
        shr     ecx,2                   ;ecx = anzahl zu kopierender dwords
        rep     movsd
@@2:

        fiadd   xres                    ;x += xres
        ;fadd c_100
        dec     i                       ;i-schleife
        jns     @@i_l

        mov     eax,edi
        sub     eax,ebx
        shr     eax,1
        cmp     eax,spsize
@@w:    fstp    st                      ;x entfernen
@@weg:  ret
subxclip endp

subpolygon proc pascal ;texture mapping mit scanline subdivision
arg     _sp, sp_end, mapptr, mapand, zval : dword
        ;_sp = *sp, zeiger auf screenpoints

local   pend, y, x_y, lb, lc, rb, rc : dword ;int
local   lx, ldx, rx, rdx : dword ;float
local   xa, xe, txt_x, txt_y : dword ;int
local   la:dword:4, lu:dword:4, ra:dword:4, ru:dword:4, a:dword:4, u:dword:4


        xor     eax,eax                 ;start- und endpunkt bestimmen
        mov     lb,eax
        mov     rb,eax
        mov     pend,eax

        mov     esi,_sp                 ;esi -> screenpoints
        fld     sp_sy[esi]              ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        mov      ecx,sp_end
        sub      ecx,size tscreenpoint  ;esi+ecx -> sp[sp_end-1]
@@max_l:

        fld     sp_sy[esi+ecx]
        fcom    st(1);ymax              ;grten y-wert finden (endpunkt)
        fstsw   ax
        sahf
        jb      @@max
        mov     pend,ecx
        fst     st(1);ymax
        jmp     @@min
@@max:
        fcom    st(2);ymin              ;kleinsten y-wert finden (startpunkt)
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,ecx
        mov     rb,ecx
        fst     st(2);ymin
@@min:  fstp    st

        sub     ecx,size tscreenpoint
        jnz     @@max_l
        fstp    st                      ;ymax entfernen

        fistp   y                       ;y = ceil(ymin)

        mov     eax,y

        cmp     eax,yres                ;y-clipping
        jge     @@weg

        or      eax,eax
        jg      @@y0
        mov     y,0
        xor     eax,eax
@@y0:
        imul    eax,xres
        dec     eax
        mov     edx,buffer
        shr     edx,2
        add     eax,edx
        mov     x_y,eax

        mov     lc,1
        mov     rc,1

        fld     c_16                    ;st(0) = 16

@@y_l:  ;y-schleife

                ;links
        dec     lc
        jnz     @@l_nz
        mov     edi,_sp
        mov     esi,lb
@@lc:
        cmp     esi,pend
        je      @@fertig                ;lb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = lb
        sub     esi,size tscreenpoint   ;lb--
        jnc     @@l0                    ;wrap
        add     esi,sp_end
@@l0:
        fld     sp_sy[esi+edi]          ;lc = ceil(sp[lb].sy) - y
        fistp   lc
        mov     eax,y
        sub     lc,eax
        jle     @@lc                    ;while lc <= 0
        mov     lb,esi

        fld     sp_z[esi+edi]           ;sp[lb].z einlagern

        ;la
        fld     sp_z[ebx+edi]           ;la.z = sp[ia].z;
        fst     la.s_z

        fld     sp_sy[ebx+edi]          ;la.y = sp[ia].sy*sp[ia].z;
        fmul    st,st(1)
        fst     la.s_p;la.y

        fld     sp_u[ebx+edi]           ;la.u = sp[ia].u;
        fst     la.s_u

        fld     sp_v[ebx+edi]           ;la.v = sp[ia].v;
        fst     la.s_v

        ;lu
        fsubr   sp_v[esi+edi]           ;lu.v = sp[lb].v - sp[ia].v;
        fstp    lu.s_v

        fsubr   sp_u[esi+edi]           ;lu.u = sp[lb].u - sp[ia].u;
        fstp    lu.s_u

        fld     sp_sy[esi+edi]          ;lu.y = sp[lb].sy*sp[lb].z - la.y;
        fmul    st,st(3);sp[lb].z
        fsubrp  st(1),st
        fstp    lu.s_p;lu.y
        fsubp   st(1),st                ;lu.z = sp[lb].z - sp[ia].z;
        fstp    lu.s_z


                ;ldx = (sp[lb].sx - sp[ia].sx)/(sp[lb].sy - sp[ia].sy);
        fld     sp_sx[esi+edi]
        fsub    sp_sx[ebx+edi]
        fld     sp_sy[esi+edi]
        fsub    sp_sy[ebx+edi]
        fdivp   st(1),st
        fst     ldx

                ;lx = ldx   *(y  - sp[ia].sy) + sp[ia].sx;
        fild    y
        fsub    sp_sy[ebx+edi]
        fmulp   st(1),st
        fadd    sp_sx[ebx+edi]
        fst     lx
        jmp     @@l_z
@@l_nz:
        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_z:
                ;rechts
        dec     rc
        jnz     @@r_nz
        mov     edi,_sp
        mov     esi,rb
@@rc:

        cmp     esi,pend
        je      @@fertig                ;rb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = rb
        add     esi,size tscreenpoint   ;rb++
        cmp     esi,sp_end
        jb      @@r0                    ;wrap
        xor     esi,esi
@@r0:
        fld     sp_sy[esi+edi]          ;rc = ceil(sp[rb].sy) - y
        fistp   rc
        mov     eax,y
        sub     rc,eax
        jle     @@rc                    ;while rc <= 0
        mov     rb,esi

        fld     sp_z[esi+edi]           ;sp[lb].z einlagern

        ;ra
        fld     sp_z[ebx+edi]           ;ra.z = sp[ia].z;
        fst     ra.s_z

        fld     sp_sy[ebx+edi]          ;ra.y = sp[ia].sy*sp[ia].z;
        fmul    st,st(1)
        fst     ra.s_p;ra.y

        fld     sp_u[ebx+edi]           ;ra.u = sp[ia].u;
        fst     ra.s_u

        fld     sp_v[ebx+edi]           ;ra.v = sp[ia].v;
        fst     ra.s_v

        ;ru
        fsubr   sp_v[esi+edi]           ;ru.v = sp[rb].v - sp[ia].v;
        fstp    ru.s_v

        fsubr   sp_u[esi+edi]           ;ru.u = sp[rb].u - sp[ia].u;
        fstp    ru.s_u

        fld     sp_sy[esi+edi]          ;ru.y = sp[rb].sy*sp[rb].z - ra.y;
        fmul    st,st(3);sp[lb].z
        fsubrp  st(1),st
        fstp    ru.s_p;ru.y

        fsubp   st(1),st                ;ru.z = sp[rb].z - sp[ia].z;
        fstp    ru.s_z


                ;rdx = (sp[rb].sx - sp[ia].sx)/(sp[rb].sy - sp[ia].sy);
        fld     sp_sx[esi+edi]
        fsub    sp_sx[ebx+edi]
        fld     sp_sy[esi+edi]
        fsub    sp_sy[ebx+edi]
        fdivp   st(1),st
        fst     rdx

                ;rx = rdx   *(y  - sp[ia].sy) + sp[ia].sx;
        fild    y
        fsub    sp_sy[ebx+edi]
        fmulp   st(1),st
        fadd    sp_sx[ebx+edi]
        fst     rx
        jmp     @@r_z
@@r_nz:
        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_z:

                                        ;st(0) = rx,  st(1) = lx
                                        ;st(2) = 0.5, st(3) = 16

                ;links: r = (y *la.z - la.y) / (lu.y - lu.z*y );
        fild    y
        fmul    la.s_z
        fsub    la.s_p;-la.y
        fild    y
        fmul    lu.s_z
        fsubr   lu.s_p;lu.y-
        fdivp   st(1),st                ;st = r

        fld     lu.s_z                  ;a.z = la.z + r*lu.z;
        fmul    st,st(1);*r
        fadd    la.s_z
        fst     a.s_z
        fmul    st,st(3);*lx            ;a.x = a.z*lx;
        fstp    a.s_p;a.x

        fld     lu.s_u                  ;a.u = la.u + r*lu.u;
        fmul    st,st(1);*r
        fadd    la.s_u
        fst     a.s_u
        fistp   txt_x                   ;textur-startkoordinate

        fmul    lu.s_v;*r               ;a.v = la.v + r*lu.v;
        fadd    la.s_v
        fst     a.s_v
        fistp   txt_y                   ;textur-startkoordinate

                ;rechts: r = (y *ra.z - ra.y) / (ru.y - ru.z*y );
        fild    y
        fmul    ra.s_z
        fsub    ra.s_p;ra.y
        fild    y
        fmul    ru.s_z
        fsubr   ru.s_p;ru.y-
        fdivp   st(1),st                ;st = r

        fld     ru.s_z                  ;u.z = ra.z + r*ru.z;
        fmul    st,st(1)
        fadd    ra.s_z

        fld     st                      ;u.x = u.z*rx - a.x;
        fmul    st,st(3);*rx
        fsub    a.s_p;-a.x
        fstp    u.s_p;u.x

        fsub    a.s_z                   ;u.z -= a.z;
        fstp    u.s_z

        fld     ru.s_u                  ;u.u = ra.u + r*ru.u - a.u;
        fmul    st,st(1);*r
        fadd    ra.s_u
        fsub    a.s_u
        fstp    u.s_u

        fmul    ru.s_v;*r               ;u.v = ra.v + r*ru.v - a.v;
        fadd    ra.s_v
        fsub    a.s_v
        fstp    u.s_v

        fistp   xe                      ;xe = ceil(rx) (rx entfernen)
        frndint
        fist    xa                      ;xa = ceil(lx) (lx nicht entfernen)


        mov     edi,xa
        mov     ecx,xe
        sub     ecx,edi                 ;ecx = pixel in einer zeile
        add     edi,x_y                 ;edi -> pixel

@@l:
        mov     edx,txt_x               ;edx = 00Xx
        mov     ebx,txt_y               ;ebx = 00Yy

        cmp     ecx,24
        jge     @@div

                ;weniger als 24 pixel
        or      ecx,ecx
        jle     @@w

        mov     esi,ecx                 ;esi : zu setzende pixel
        xor     ecx,ecx
        push    ecx

        fld     a.s_u
        fadd    u.s_u                   ;a.u + u.u = texutur - endkoordinate
        fisub   txt_x
        fmul    divtab[esi*4]
        fistp   txt_x

        fld     a.s_v
        fadd    u.s_v                   ;a.v + u.v = texutur - endkoordinate
        fisub   txt_y
        fmul    divtab[esi*4]
        fistp   txt_y

        mov     eax,txt_x
        mov     ecx,txt_y

        jmp     @@5
                                        ;st(0) = x
                                        ;st(1) = 16
@@div:          ;scanline subdivision

        fadd    st,st(1);16             ;x um 16 weiter
        fld     st;x                    ;r = (x *a.z - a.x) / (u.x - u.z*x )
        fmul    a.s_z
        fsub    a.s_p;a.x
        fld     st(1);x
        fmul    u.s_z
        fsubr   u.s_p;u.x
        fdivp   st(1),st                ;st = r

        fld     st

        fmul    u.s_u
        fadd    a.s_u                   ;a.u + r*u.u
        fistp   txt_x

        fmul    u.s_v
        fadd    a.s_v                   ;a.v + r*u.v
        fistp   txt_y


        mov     esi,16                  ;esi : zu setzende pixel
        sub     ecx,esi
        push    ecx                     ;ecx : x-zhler

        mov     eax,txt_x
        mov     ecx,txt_y
        sub     eax,edx                 ;eax = 00Uu
        sub     ecx,ebx                 ;ecx = 00Vv

@@5:
        push    ebp                     ;ebp : lokale variablen

        push    mapand

        or      esi,zval
        push    esi
        mov     esi,mapptr              ;esi = TTTT

        shl     ebx,16
        shl     ecx,16 - 4 ;v/16
        shr     eax,4 ;u/16
        shr     ebx,8
        shr     ecx,8
        shrd    ebx,edx,8               ;ebx = x0Yy
        shrd    ecx,eax,8               ;ecx = u0Vv
        movzx   edx,dh                  ;edx = 000X
        movzx   ebp,ah                  ;ebp = 000U
                ;keine lokalen variablen mehr zugnglich
        pop     eax                     ;eax = zlpC

        mov     dh,bh
@@inner:
        and     edx,[esp]
        add     ebx,ecx
        mov     ah,[esi+edx]
        inc     edi
        adc     edx,ebp
        dec     al
        mov     dh,bh
        mov     [edi*4],eax
        jnz     @@inner

        pop     eax                     ;mapand entfernen
        pop     ebp
        pop     ecx
        jmp     @@l
@@w:
        fstp    st                      ;x entfernen

        mov     eax,xres
        add     x_y,eax
        inc     y
        mov     eax,yres
        cmp     eax,y                   ;while (y < yres)
        jg      @@y_l

@@fertig:                               ;16 entfernen
        fstp    st

@@weg:  ret
subpolygon endp

testdir proc pascal
        ;esi -> 3*(tlightpoint) (hintereinander)

                ;(a          ) x (b          ) *  p
                ;(v[0] - v[1]) x (v[2] - v[1]) * (v[1]) berechnen
                                        ;v[1] = p
        fld     lp_lx[esi+(size tlightpoint)]
        fld     lp_ly[esi+(size tlightpoint)]
        fld     lp_lz[esi+(size tlightpoint)]

                ;1. komponente
        fld     [esi].lp_ly
        fsub    st,st(2)                ;a2
        fld     [esi+(size tlightpoint)*2].lp_lz
        fsub    st,st(2)                ;b3
        fmulp   st(1),st

        fld     [esi].lp_lz
        fsub    st,st(2)                ;a3
        fld     [esi+(size tlightpoint)*2].lp_ly
        fsub    st,st(4)                ;b2
        fmulp   st(1),st
        fsubp   st(1),st

        fmul    st,st(3)                ;*p1

                ;2. komponente
        fld     [esi].lp_lz
        fsub    st,st(2)                ;a3
        fld     [esi+(size tlightpoint)*2].lp_lx
        fsub    st,st(5)                ;b1
        fmulp   st(1),st

        fld     [esi].lp_lx
        fsub    st,st(5)                ;a1
        fld     [esi+(size tlightpoint)*2].lp_lz
        fsub    st,st(4)                ;b3
        fmulp   st(1),st
        fsubp   st(1),st

        fmul    st,st(3)
        faddp   st(1),st                ;*p2

                ;3. komponente
        fld     [esi].lp_lx
        fsub    st,st(4)                ;a1
        fld     [esi+(size tlightpoint)*2].lp_ly
        fsub    st,st(4)                ;b2
        fmulp   st(1),st

        fld     [esi].lp_ly
        fsub    st,st(4)                ;a2
        fld     [esi+(size tlightpoint)*2].lp_lx
        fsub    st,st(6)                ;b1
        fmulp   st(1),st
        fsubp   st(1),st

        fmulp   st(2),st
        faddp   st(1),st
        ftst
        fstsw   ax
        fstp    st
        fstp    st
        fstp    st

        sahf
@@weg:  ret
testdir endp


dolights proc pascal
local   vstamp:dword, lightptr:dword;, lcubelistend:dword
local   mapptr:dword, zval:dword ,rekursion:dword
local   tc:dword, vtc:dword, side:dword, side_s2p:dword, auslass:dword
local   z:dword, z2:dword, facelist:dword

;1. schatten der wrfel
;2. licht der flchen eines objekts
;3. schatten der flchen eines objekts
;4. fr alle objekte wiederholen
;5. licht der wrfel

        mov     eax,stamp
        mov     vstamp,eax

                ;light initialisieren

        mov     esi,l_vmt.o_firstobj
        mov     lightptr,esi

@@l_l:  mov     esi,lightptr            ;esi -> tlight
        cmp     esi,l_vmt.o_nextobj
        jae     @@weg
        xor     eax,eax
        cmp     o_hidden[esi],eax
        jne     @@next                  ;versteckt
        cmp     o_cube[esi],eax
        je      @@next                  ;in keinem wrfel


        lea     edi,light    ;licht-objekt in licht-viewer verwandeln
        fld1
        call    doviewer

        mov     eax,l_lmap[esi]         ;licht-map
        mov     mapptr,eax

        lea     esi,light               ;cubetree bzgl. licht
        call    cubetree

        mov     esi,light.v_cubelist    ;esi -> licht-tempcube
        mov     tc,esi

@@c_l:          ;wrfel durchgehen (vorne nach hinten)
        mov     esi,tc
        cmp     esi,light.v_cubelistend
        jae     @@next                  ;nchstes licht

        ;cmp     tc_visible[esi],0
        ;je      @@nc                    ;wrfel nicht im licht-einflu
        mov     ebx,tc_cubeptr[esi]
        mov     eax,vstamp
        cmp     eax,c_vstamp[ebx]
        jne     @@nc                    ;wrfel nicht sichtbar
        mov     edi,c_vtc[ebx]
        mov     vtc,edi                 ;vtc : viewer-tempcube

        mov     eax,viewer.v_tlistpos   ;liste der transformierten vertices
        mov     light.v_tlist,eax       ; lschen (vor jedem wrfel)
        mov     light.v_tlistpos,eax

   mov edi,splist
        lea     ebx,c_side[ebx+(size tside)*5]
        mov     side,ebx
        mov     side_s2p,5
@@s:
        ;shl     mark,2
        mov     ebx,side
        mov     eax,s_flags[ebx]
        test    eax,sfBitmap
        jz      @@ns                    ;seite ohne bitmap

        and     eax,sfTile + sf4point
        mov     auslass,eax

@@d:                                    ;esi -> licht-tempcube
        mov     esi,tc
        mov     ebx,vtc
        xor     ecx,ecx
        push    edi
@@p:
        cmp     ecx,auslass
        je      @@a                     ;punkt auslassen

        mov     edx,side_s2p
        movzx   edx,s2p_t[edx*4+ecx]
                ;beobachter bezogene koordinaten in lp
        mov     eax,tc_vertex[ebx+edx].x1
        mov     lp_x[edi],eax
        mov     eax,tc_vertex[ebx+edx].x2
        mov     lp_y[edi],eax
        mov     eax,tc_vertex[ebx+edx].x3
        mov     lp_z[edi],eax
                ;licht bezogene koordinaten in lp
        mov     eax,tc_vertex[esi+edx].x1
        mov     lp_lx[edi],eax
        mov     eax,tc_vertex[esi+edx].x2
        mov     lp_ly[edi],eax
        mov     eax,tc_vertex[esi+edx].x3
        mov     lp_lz[edi],eax

        add     edi,size tlightpoint
@@a:
        inc     ecx
        cmp     ecx,4
        jb      @@p
      ;
        pop     esi        ;startadresse mit abspeichern
        mov     [edi],esi
        add     edi,4

        call    testdir    ;esi -> 3* tlightpoint
        ja      @@nd
                ;schatten (polygon vom licht abgewandt)
        sub     edi,4
        push    esi
        call    sprojektion ;esi -> tlightpoint
        jbe     @@sw


        sub     edi,esi
      lea eax,mapptr
        call    spolygon pascal, esi, edi, eax;mapptr
@@sw:   pop     edi

@@nd:           ;nchstes dreieck
        add     auslass,2
        cmp     auslass,4
        jb      @@d
@@ns:           ;nchste seite
        sub     side,size tside
        dec     side_s2p
        jns     @@s


;jmp @@t0
        push    edi ;edi -> splist

        mov     esi,tc
        mov     esi,tc_meshlist[esi]
        lea     edi,light
        call    xformincube

        pop     edi ;edi -> splist
      mov     facelist,edi

@@m_l:  or      esi,esi
        jz      @@mw                    ;keine meshes mehr
@@m_l2:
        mov     eax,m_zval[esi]         ;8-bit-z-buffer wert des mesh
        mov     zval,eax

                ;dreiecke bilden
        mov     ecx,m_faces[esi]
        mov     z,ecx
        mov     ebx,m_facelist[esi]
@@d_l:
        mov     ecx,m_vtlistpos[esi]
        push    esi
        mov     esi,m_tlistpos[esi]     ;esi -> transformier-liste
        push    edi
        mov     z2,3

@@3_l:  mov     edx,[ebx]               ;punkt-nummer
        lea     edx,[edx+edx*2]         ;edx*3

        mov     eax,[ecx+edx*4].x1      ;vertex
        mov     lp_x[edi],eax
        mov     eax,[ecx+edx*4].x2
        mov     lp_y[edi],eax
        mov     eax,[ecx+edx*4].x3
        mov     lp_z[edi],eax

        mov     eax,[esi+edx*4].x1      ;vertex
        mov     lp_lx[edi],eax
        mov     eax,[esi+edx*4].x2
        mov     lp_ly[edi],eax
        mov     eax,[esi+edx*4].x3
        mov     lp_lz[edi],eax

        add     ebx,4
        add     edi,size tlightpoint
        dec     z2
        jnz     @@3_l

        pop     esi
        call    testdir    ;esi -> 3* tlightpoint

        jb      @@nd2
                ;licht (polygon dem licht zugewandt)
        push    ebx
        push    esi
        call    ldraw pascal, mapptr, zval ,255 ;ohne subdivision
        pop     edi
        pop     ebx
@@nd2:
        pop     esi
        dec     z
        jnz     @@d_l
     test    m_flags[esi],mfUnitenext
     jz      @@no_U
     cmp     m_nexttemp[esi],0
     je      @@no_U
     mov     esi,m_nexttemp[esi]     ;nchstes objekt im wrfel
     jmp     @@m_l2
 @@no_U:
        push    esi
                           ;liste der schatten-flchen abbauen
@@d_l2: cmp     edi,facelist
        jbe     @@nm
        lea     esi,[edi-(size tlightpoint)*3]
        push    esi
        call    sprojektion ;esi -> tlightpoint
        jbe     @@nd3
        sub     edi,esi
        lea     eax,mapptr
        call    spolygon pascal, esi, edi, eax;_mapptr
@@nd3:  pop     edi
        jmp     @@d_l2

@@nm:   pop     esi

        mov     esi,m_nexttemp[esi]     ;nchstes objekt im wrfel
        jmp     @@m_l
@@mw:
@@t0:
                  ;liste der wrfel-licht-flchen abbauen
        mov     ebx,vtc
        mov     eax,tc_rekursion[ebx]
 mov rekursion,eax
 mov eax,tc_num[ebx]
        mov     zval,eax
@@s_l2:
        cmp     edi,splist
        jbe     @@nc
        sub     edi,4
        mov     esi,[edi]
        push    esi

        call    ldraw pascal, mapptr, zval, rekursion ;mit subdivision
        pop     edi
        jmp     @@s_l2


@@nc:           ;nchster wrfel
        add     tc,size ttempcube
        jmp     @@c_l

@@next:         ;nchstes licht
      mov eax,l_vmt.o_size
      add lightptr,eax
      jmp  @@l_l
@@weg:  ret
dolights endp

ldraw proc pascal
arg     mapptr:dword, zval:dword, rekursion:dword
        ;-> esi -> lp
        ;-> edi -> lp_end
        mov ebx,esi

        fldz                            ;st = abstand = 0.0
        xor     al,al
        call    lighttransx             ;ebx -> lp, edi -> lp_end
        call    lightclip
        jbe     @@0

        mov     al,1
        call    lighttransx             ;ebx -> lp, edi -> lp_end
        call    lightclip
        jbe     @@0

        xor     al,al
        call    lighttransy             ;ebx -> lp, edi -> lp_end
        call    lightclip
        jbe     @@0

        mov     al,1
        call    lighttransy             ;ebx -> lp, edi -> lp_end
        call    lightclip
        jbe     @@0
        fstp    st                      ;abstand entfernen

        fld1                            ;st = abstand = 1.0
        call    lighttransz             ;ebx -> lp, edi -> lp_end
        call    lightclip               ;falloff als abstand
        jbe     @@0
        fstp    st                      ;abstand entfernen

        call    projektion pascal, size tlightpoint, 2
        jbe     @@weg

                ;mit subdivision
;        cmp     zval,l_sub
  cmp rekursion,l_sub
        ja      @@ohne
        call    subxclip pascal, size tlightpoint, 2
        jbe     @@weg
        sub     edi,ebx
        mov     eax,zval
        shl     eax,8
        call    sublpolygon pascal, ebx, edi, mapptr, eax
        jmp     @@weg

@@ohne:         ;ohne subdivision
        call    lconvert
        call    xclip
        jbe     @@weg
        sub     edi,ebx
        mov     eax,zval
        shl     eax,16
        call    lpolygon pascal, ebx, edi, mapptr, eax
        jmp     @@weg

@@0:    fstp    st
@@weg:  ret
ldraw endp

lconvert proc near ;projiziert die licht-koordinaten
        ;-> ebx = *lp
        ;-> edi = *lp_end

        mov     edx,edi
        mov     edi,ebx   ;tscreenpoint mu krzer sein als tlightpoint
        mov     esi,ebx
@@l:
        mov     eax,lp_x[esi]
        mov     sp_sx[edi],eax
        mov     eax,lp_y[esi]
        mov     sp_sy[edi],eax
        fld     lp_lz[esi]
        fld     lp_lx[esi]
        fdiv    st,st(1)
        fstp    sp_u[edi]
        fdivr   lp_ly[esi]
        fstp    sp_v[edi]
        add     esi,size tlightpoint
        add     edi,size tscreenpoint
        cmp     esi,edx
        jb      @@l


@@weg:  ret
lconvert endp


lpolygon proc pascal ;licht-polygon
arg     _sp, sp_end, mapptr, zval : dword
        ;_sp = *sp, zeiger auf screenpoints

local   pend, y, x_y, lb, lc, rb, rc ;int
local   lx, ldx, lu, ldu, lv, ldv
local   rx, rdx, ru, rdu, rv, rdv
local   xa, xe, txt_x, txt_y ;int


        xor     eax,eax                 ;start- und endpunkt bestimmen
        mov     lb,eax
        mov     rb,eax
        mov     pend,eax

        mov     esi,_sp                 ;esi -> screenpoints
        fld     sp_sy[esi]               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        mov      ecx,sp_end
        sub      ecx,size tscreenpoint  ;esi+ecx -> sp[sp_end-1]
@@max_l:

        fld     sp_sy[esi+ecx]
        fcom    st(1);ymax              ;grten y-wert finden (endpunkt)
        fstsw   ax
        sahf
        jb      @@max
        mov     pend,ecx
        fst     st(1);ymax
        jmp     @@min
@@max:
        fcom    st(2);ymin              ;kleinsten y-wert finden (startpunkt)
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,ecx
        mov     rb,ecx
        fst     st(2);ymin
@@min:  fstp    st

        sub     ecx,size tscreenpoint
        jnz     @@max_l
        fstp    st                      ;ymax entfernen

        fistp   y                       ;y = ceil(ymin)

        mov     eax,y

        cmp     eax,yres                ;y-clipping
        jge     @@weg

        or      eax,eax
        jg      @@y0
        mov     y,0
        xor     eax,eax
@@y0:
        imul    eax,xres
        mov     edx,buffer
        shr     edx,2
        add     eax,edx
        mov     x_y,eax

        mov     lc,1
        mov     rc,1

        ;fld     c_64                    ;st(0) = 64

@@y_l:  ;y-schleife

                ;links
        dec     lc
        jnz     @@l_nz
        mov     edi,_sp
        mov     esi,lb
@@lc:
        cmp     esi,pend
        je      @@fertig                ;lb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = lb
        sub     esi,size tscreenpoint   ;lb--
        jnc     @@l0                    ;wrap
        add     esi,sp_end
@@l0:
        fld     sp_sy[esi+edi]           ;lc = ceil(sp[lb].sy) - y
        fistp   lc
        mov     eax,y
        sub     lc,eax
        jle     @@lc                    ;while lc <= 0
        mov     lb,esi


        fild    y
        fsub    sp_sy[ebx+edi]           ;(y  - sp[ia].y)

        fld     sp_sy[edi+esi]           ;(sp[lb].y - sp[ia].y)
        fsub    sp_sy[edi+ebx]

                ;ldu = (sp[lb].u - sp[ia].u)/(sp[lb].y - sp[ia].y);
        fld     sp_u[edi+esi]
        fsub    sp_u[edi+ebx]
        fdiv    st,st(1)
        fst     ldu

                ;lu = ldu  *(y  - sp[ia].y) + sp[ia].u;
        fmul    st,st(2)
        fadd    sp_u[edi+ebx]
      fist txt_x
        fstp    lu

                ;ldv = (sp[lb].v - sp[ia].v)/(sp[lb].y - sp[ia].y);
        fld     sp_v[edi+esi]
        fsub    sp_v[edi+ebx]
        fdiv    st,st(1)
        fst     ldv

                ;lv = ldv  *(y  - sp[ia].y) + sp[ia].v;
        fmul    st,st(2)
        fadd    sp_v[edi+ebx]
      fist txt_y
        fstp    lv

                ;ldx = (sp[lb].x - sp[ia].x)/(sp[lb].y - sp[ia].y);
        fld     sp_sx[edi+esi]
        fsub    sp_sx[edi+ebx]
        fdivrp  st(1),st
        fst     ldx

                ;lx = ldx  *(y  - sp[ia].y) + sp[ia].x;
        fmulp   st(1),st
        fadd    sp_sx[edi+ebx]
        fst     lx

        jmp     @@l_z
@@l_nz:
        fld     lu
        fadd    ldu
      fist txt_x
        fstp    lu

        fld     lv
        fadd    ldv
      fist txt_y
        fstp    lv

        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_z:
                ;rechts
        dec     rc
        jnz     @@r_nz
        mov     edi,_sp
        mov     esi,rb
@@rc:
        cmp     esi,pend
        je      @@fertig                ;rb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = rb
        add     esi,size tscreenpoint   ;rb++
        cmp     esi,sp_end
        jb      @@r0                    ;wrap
        xor     esi,esi
@@r0:
        fld     sp_sy[esi+edi]           ;rc = ceil(sp[rb].sy) - y
        fistp   rc
        mov     eax,y
        sub     rc,eax
        jle     @@rc                    ;while lc <= 0
        mov     rb,esi


        fild    y
        fsub    sp_sy[ebx+edi]           ;(y  - sp[ia].y)

        fld     sp_sy[edi+esi]           ;(sp[rb].y - sp[ia].y)
        fsub    sp_sy[edi+ebx]

                ;rdu = (sp[rb].u - sp[ia].u)/(sp[rb].y - sp[ia].y);
        fld     sp_u[edi+esi]
        fsub    sp_u[edi+ebx]
        fdiv    st,st(1)
        fst     rdu

                ;ru = rdu  *(y  - sp[ia].y) + sp[ia].u;
        fmul    st,st(2)
        fadd    sp_u[edi+ebx]
        fstp    ru

                ;rdv = (sp[rb].v - sp[ia].v)/(sp[rb].y - sp[ia].y);
        fld     sp_v[edi+esi]
        fsub    sp_v[edi+ebx]
        fdiv    st,st(1)
        fst     rdv

                ;rv = rdv  *(y  - sp[ia].y) + sp[ia].v;
        fmul    st,st(2)
        fadd    sp_v[edi+ebx]
        fstp    rv

                ;rdx = (sp[rb].x - sp[ia].x)/(sp[rb].y - sp[ia].y);
        fld     sp_sx[edi+esi]
        fsub    sp_sx[edi+ebx]
        fdivrp  st(1),st
        fst     rdx

                ;rx = rdx  *(y  - sp[ia].y) + sp[ia].x;
        fmulp   st(1),st
        fadd    sp_sx[edi+ebx]
        fst     rx

        jmp     @@r_z
@@r_nz:
        fld     ru
        fadd    rdu
        fstp    ru

        fld     rv
        fadd    rdv
        fstp    rv

        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_z:

        fistp   xe                      ;xe = ceil(rx) (rx entfernen)
        fistp   xa                      ;xa = ceil(lx) (lx entfernen)

        mov     edi,xa
        mov     ecx,xe
        sub     ecx,edi                 ;ecx = CCCC
        jle     @@w
        add     edi,x_y                 ;edi -> pixel

        movzx   edx,word ptr txt_x      ;edx = 00Xx
        movzx   ebx,word ptr txt_y      ;ebx = 00Yy
        add     dh,80h
        add     bh,80h

        mov     eax,divtab2
        fld     ru
        fsub    lu
        fmul    dword ptr[eax+ecx*4]
        fistp   txt_x
        fld     rv
        fsub    lv
        fmul    dword ptr[eax+ecx*4]
        fistp   txt_y

        mov     esi,mapptr              ;esi = TTTT

        push    ebp                     ;ebp : lokale variablen

        movzx   eax,word ptr txt_x
        or      eax,zval                ;eax = 0zUu
        movzx   ebp,word ptr txt_y      ;ebp = 00Vv

        shl     ebx,8
        shl     ebp,8
        shrd    ebx,edx,8               ;ebx = x0Yy
        shrd    ebp,eax,8               ;ebp = u0Vv
        shr     edx,8                   ;edx = 000X
        shr     eax,8                   ;eax = 00zU
                ;keine lokalen variablen mehr zugnglich

        mov     dh,bh
        jmp     @@inner
@@i0:
        add     ebx,ebp
        adc     dl,al
        inc     edi
        dec     ecx
        mov     dh,bh
        jz      @@iw
@@inner:
        cmp     ah,[edi*4+3]            ;schreiberlaubnis
        jne     @@i0
        mov     dh,[edx+esi]            ;dh = helligkeit
        add     ebx,ebp
        adc     dl,al
        add     [edi*4+2],dh
        inc     edi
        dec     ecx
        mov     dh,bh
        jnz     @@inner
@@iw:

        pop     ebp
@@w:

        mov     eax,xres
        add     x_y,eax
        inc     y
        mov     eax,yres
        cmp     eax,y                   ;while (y < yres)
        jg      @@y_l

@@fertig:
        ;fstp    st                      ;16.0 entfernen

@@weg:  ret
lpolygon endp



lighttransx proc near
        ;-> al = 0: tz = x + z, 1: tz = -x + z
        ;-> ebx = *lp
        ;-> edi = *lp_end
        ;<- ebx = *lp
        ;<- edi = *lp_end
        push    ebx
@@l:
        fld     lp_lz[ebx]
        ;fmul    st,st(2)
        fld     lp_lx[ebx]

        or      al,al
        jz      @@0
        fchs
@@0:    faddp   st(1),st

        fstp    lp_tz[ebx]
        add     ebx,size tlightpoint
        cmp     ebx,edi
        jb      @@l

        pop     ebx
@@weg:  ret
lighttransx endp

lighttransy proc near
        push    ebx
@@l:
        fld     lp_lz[ebx]
        ;fmul    st,st(2)
        fld     lp_ly[ebx]

        or      al,al
        jz      @@0
        fchs
@@0:    faddp   st(1),st

        fstp    lp_tz[ebx]
        add     ebx,size tlightpoint
        cmp     ebx,edi
        jb      @@l

        pop     ebx
@@weg:  ret
lighttransy endp

lighttransz proc near
        push    ebx
        fld     c_32768             ;gleichzeitig x1*128*256 und x2*128*256
@@l:
        mov     eax,lp_lz[ebx]
        mov     lp_tz[ebx],eax
        fld     lp_lx[ebx]
        fmul    st,st(1)
        fstp    lp_lx[ebx]
        fld     lp_ly[ebx]
        fmul    st,st(1)
  ;      fchs
        fstp    lp_ly[ebx]

        add     ebx,size tlightpoint
        cmp     ebx,edi
        jb      @@l

        fstp    st
        pop     ebx
@@weg:  ret
lighttransz endp

lightclip proc pascal
        ;-> st(0) = abstand
        ;-> ebx = *lp
        ;-> edi = *lp_end
        ;<- ebx = *lp
        ;<- edi = *lp_end
        ;<- wenn weniger als 3 punkte, mit jbe wegspringen
local   _lp:dword, _lp_end:dword ;beides pointer

        mov     _lp,ebx                 ;ebx -> lp[z] (quellpunkte) (z = 0)
        mov     _lp_end,edi             ;edi -> lp[d] (zielpunkte)  (d = m)

        xor     dl,dl                   ;dl = flag
@@z_l:

        fld     lp_tz[ebx]              ;inn = (lp[z].tz >= abstand);
        fcomp   st(1)
        fstsw   ax
        mov     dh,ah                   ;dh = inn
        sahf
        jb      @@0
                ;punkt innerhalb
        mov     esi,ebx
        mov     ecx,size tlightpoint/4
        rep     movsd                   ;lp[d] = lp[z] und d++
@@0:
        mov     esi,ebx
        add     esi,size tlightpoint    ;nz = z+1
        cmp     esi,_lp_end             ;if (nz >= m) nz = 0;
        jb      @@wrap
        mov     esi,_lp
@@wrap:

        fld     lp_tz[esi]              ;if (inn ^ (lp[nz].tz >= abstand))
        fcomp   st(1)
        fstsw   ax
        xor     ah,dh                   ;dh = inn
        sahf
        jnc     @@1
                ;dieser oder nchster punkt auerhalb
        inc     dl                      ;flag = 1
                ;r = (abstand - l[z].tz)/(l[nz].tz-l[z].tz);
        fld     st
        fsub    lp_tz[ebx]
        fld     lp_tz[esi]
        fsub    lp_tz[ebx]
        fdivp   st(1),st                ;st = r

        mov     ecx,5
                ;d[dm] = l[z] + r*(l[nz]-l[z]) fr x, y, z, lx, ly, lz
@@l:    fld     lp_x[ebx+ecx*4]
        fld     lp_x[esi+ecx*4]
        fsub    st,st(1)
        fmul    st,st(2)
        faddp   st(1),st
        fstp    lp_x[edi+ecx*4]
        dec     ecx
        jns     @@l
        fstp    st                      ;r entfernen

        add     edi,size tlightpoint    ;d++
@@1:
        cmp     esi,ebx                 ;wz > z?
        mov     ebx,esi                 ;entspricht ebx += size tlightpoint
        ja      @@z_l                   ;z-schleife

                                        ;ebx -> anfang der z-punkte
        mov     esi,_lp_end             ;esi -> anfang der d-punkte
                                        ;edi -> ende der d-punkte
        mov     ecx,edi
        sub     ecx,esi                 ;ecx = anzahl zu kopierender byte
        ;mov     edi,ebx                 ; edi = _lp
        jz      @@weg                   ; kein punkt brig

        mov     edi,esi                 ;wenn flag = 0: nicht kopieren,
        or      dl,dl                   ; edi = _lp_end zurckgeben
        jz      @@w

        mov     edi,ebx                 ;edi -> anfang der z-punkte
        shr     ecx,2                   ;ecx = anzahl zu kopierender dwords
        rep     movsd
@@w:
        mov     eax,edi
        sub     eax,ebx
        shr     eax,1
        cmp     eax,size tlightpoint

@@weg:  ret
lightclip endp

sublpolygon proc pascal ;licht-polygon
arg     _lp, lp_end, mapptr, zval : dword
        ;_sp = *sp, zeiger auf screenpoints

local   pend, y, x_y, lb, lc, rb, rc : dword ;int
local   lx, ldx, rx, rdx : dword ;float
local   xa, xe, txt_x, txt_y : dword ;int
local   la:dword:5, lu:dword:5, ra:dword:5, ru:dword:5, a:dword:5, u:dword:5


        xor     eax,eax                 ;start- und endpunkt bestimmen
        mov     lb,eax
        mov     rb,eax
        mov     pend,eax

        mov     esi,_lp                 ;esi -> screenpoints
        fld     lp_y[esi]               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        mov      ecx,lp_end
        sub      ecx,size tlightpoint  ;esi+ecx -> lp[lp_end-1]
@@max_l:

        fld     lp_y[esi+ecx]
        fcom    st(1);ymax              ;grten y-wert finden (endpunkt)
        fstsw   ax
        sahf
        jb      @@max
        mov     pend,ecx
        fst     st(1);ymax
        jmp     @@min
@@max:
        fcom    st(2);ymin              ;kleinsten y-wert finden (startpunkt)
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,ecx
        mov     rb,ecx
        fst     st(2);ymin
@@min:  fstp    st

        sub     ecx,size tlightpoint
        jnz     @@max_l
        fstp    st                      ;ymax entfernen

        fistp   y                       ;y = ceil(ymin)

        mov     eax,y

        cmp     eax,yres                ;y-clipping
        jge     @@weg

        or      eax,eax
        jg      @@y0
        mov     y,0
        xor     eax,eax
@@y0:
        imul    eax,xres
        mov     edx,buffer
        shr     edx,2
        add     eax,edx
        mov     x_y,eax

        mov     lc,1
        mov     rc,1

        fld     c_32;c_16                    ;st(0) = 16

@@y_l:  ;y-schleife

                ;links
        dec     lc
        jnz     @@l_nz
        mov     edi,_lp
        mov     esi,lb
@@lc:
        cmp     esi,pend
        je      @@fertig                ;lb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = lb
        sub     esi,size tlightpoint    ;lb--
        jnc     @@l0                    ;wrap
        add     esi,lp_end
@@l0:
        fld     lp_y[esi+edi]           ;lc = ceil(lp[lb].sy) - y
        fistp   lc
        mov     eax,y
        sub     lc,eax
        jle     @@lc                    ;while lc <= 0
        mov     lb,esi

        fld     lp_z[esi+edi]           ;lp[lb].z einlagern

        ;la
        fld     lp_z[ebx+edi]           ;la.z = lp[ia].z;
        fst     la.ls_z

        fld     lp_y[ebx+edi]           ;la.y = lp[ia].sy*lp[ia].z;
        fmul    st,st(1)
        fst     la.ls_p;la.y

        fld     lp_lx[ebx+edi]          ;la.lx = lp[ia].lx;
        fst     la.ls_lx

        fld     lp_ly[ebx+edi]          ;la.ly = lp[ia].ly;
        fst     la.ls_ly

        fld     lp_lz[ebx+edi]          ;la.lz = lp[ia].lz;
        fst     la.ls_lz

        ;lu
        fsubr   lp_lz[esi+edi]          ;lu.lz = lp[lb].lz - lp[ia].lz;
        fstp    lu.ls_lz

        fsubr   lp_ly[esi+edi]          ;lu.ly = lp[lb].ly - lp[ia].ly;
        fstp    lu.ls_ly

        fsubr   lp_lx[esi+edi]          ;lu.lx = lp[lb].lx - lp[ia].lx;
        fstp    lu.ls_lx

        fld     lp_y[esi+edi]           ;lu.y = lp[lb].y*lp[lb].z - la.y;
        fmul    st,st(3);lp[lb].z
        fsubrp  st(1),st
        fstp    lu.ls_p;lu.y
        fsubp   st(1),st                ;lu.z = lp[lb].z - lp[ia].z;
        fstp    lu.ls_z


                ;ldx = (lp[lb].x - lp[ia].x)/(lp[lb].y - lp[ia].y);
        fld     lp_x[esi+edi]
        fsub    lp_x[ebx+edi]
        fld     lp_y[esi+edi]
        fsub    lp_y[ebx+edi]
        fdivp   st(1),st
        fst     ldx

                ;lx = ldx   *(y  - lp[ia].y) + lp[ia].x;
        fild    y
        fsub    lp_y[ebx+edi]
        fmulp   st(1),st
        fadd    lp_x[ebx+edi]
        fst     lx
        jmp     @@l_z
@@l_nz:
        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_z:
                ;rechts
        dec     rc
        jnz     @@r_nz
        mov     edi,_lp
        mov     esi,rb
@@rc:

        cmp     esi,pend
        je      @@fertig                ;rb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = rb
        add     esi,size tlightpoint   ;rb++
        cmp     esi,lp_end
        jb      @@r0                    ;wrap
        xor     esi,esi
@@r0:
        fld     lp_y[esi+edi]           ;rc = ceil(lp[rb].sy) - y
        fistp   rc
        mov     eax,y
        sub     rc,eax
        jle     @@rc                    ;while rc <= 0
        mov     rb,esi

        fld     lp_z[esi+edi]           ;lp[lb].z einlagern

        ;ra
        fld     lp_z[ebx+edi]           ;ra.z = lp[ia].z;
        fst     ra.ls_z

        fld     lp_y[ebx+edi]           ;ra.y = lp[ia].sy*lp[ia].z;
        fmul    st,st(1)
        fst     ra.ls_p;ra.y

        fld     lp_lx[ebx+edi]          ;ra.lx = lp[ia].lx;
        fst     ra.ls_lx

        fld     lp_ly[ebx+edi]          ;ra.ly = lp[ia].ly;
        fst     ra.ls_ly

        fld     lp_lz[ebx+edi]          ;ra.lz = lp[ia].lz;
        fst     ra.ls_lz

        ;ru
        fsubr   lp_lz[esi+edi]          ;ru.lz = lp[rb].lz - lp[ia].lz;
        fstp    ru.ls_lz

        fsubr   lp_ly[esi+edi]          ;ru.ly = lp[rb].ly - lp[ia].ly;
        fstp    ru.ls_ly

        fsubr   lp_lx[esi+edi]          ;ru.lx = lp[rb].lx - lp[ia].lx;
        fstp    ru.ls_lx

        fld     lp_y[esi+edi]           ;ru.y = lp[rb].sy*lp[rb].z - ra.y;
        fmul    st,st(3);lp[lb].z
        fsubrp  st(1),st
        fstp    ru.ls_p;ru.y

        fsubp   st(1),st                ;ru.z = lp[rb].z - lp[ia].z;
        fstp    ru.ls_z


                ;rdx = (lp[rb].x - lp[ia].x)/(lp[rb].y - lp[ia].y);
        fld     lp_x[esi+edi]
        fsub    lp_x[ebx+edi]
        fld     lp_y[esi+edi]
        fsub    lp_y[ebx+edi]
        fdivp   st(1),st
        fst     rdx

                ;rx = rdx   *(y  - lp[ia].y) + lp[ia].x;
        fild    y
        fsub    lp_y[ebx+edi]
        fmulp   st(1),st
        fadd    lp_x[ebx+edi]
        fst     rx
        jmp     @@r_z
@@r_nz:
        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_z:

                                        ;st(0) = rx,  st(1) = lx
                                        ;st(2) = 0.5, st(3) = 16

                ;links: r = (y *la.z - la.y) / (lu.y - lu.z*y );
        fild    y                       ;opti
        fmul    la.ls_z
        fsub    la.ls_p;-la.y
        fild    y
        fmul    lu.ls_z
        fsubr   lu.ls_p;lu.y-
        fdivp   st(1),st                ;st = r

        fld     lu.ls_z                 ;a.z = la.z + r*lu.z;
        fmul    st,st(1);*r
        fadd    la.ls_z
        fst     a.ls_z
        fmul    st,st(3);*lx            ;a.x = a.z*lx;
        fstp    a.ls_p;a.x

        fld     lu.ls_lz
        fmul    st,st(1);*r             ;a.lz = la.lz + r*lu.lz;
        fadd    la.ls_lz
        fst     a.ls_lz

        fld     lu.ls_lx                ;a.lx = la.lx + r*lu.lx;
        fmul    st,st(2);*r
        fadd    la.ls_lx
        fst     a.ls_lx

        fld     lu.ls_ly                ;a.ly = la.ly + r*lu.ly;
        fmul    st,st(3);*r
        fadd    la.ls_ly
        fst     a.ls_ly

        fdiv    st,st(2)                   ;a.ly/a.lz
        fistp   txt_y
        fdivrp  st(1),st                   ;a.lx/a.lz
        fistp   txt_x

        fstp    st                         ;r entfernen
                ;rechts: r = (y *ra.z - ra.y) / (ru.y - ru.z*y );
        fild    y                       ;opti
        fmul    ra.ls_z
        fsub    ra.ls_p;ra.y
        fild    y
        fmul    ru.ls_z
        fsubr   ru.ls_p;ru.y-
        fdivp   st(1),st                ;st = r

        fld     ru.ls_z                 ;u.z = ra.z + r*ru.z;
        fmul    st,st(1)
        fadd    ra.ls_z

        fld     st                      ;u.x = u.z*rx - a.x;
        fmul    st,st(3);*rx
        fsub    a.ls_p;-a.x
        fstp    u.ls_p;u.x

        fsub    a.ls_z                  ;u.z -= a.z;
        fstp    u.ls_z

        fld     ru.ls_lx                ;u.lx = ra.lx + r*ru.lx - a.lx;
        fmul    st,st(1);*r
        fadd    ra.ls_lx
        fsub    a.ls_lx
        fstp    u.ls_lx

        fld     ru.ls_ly                ;u.ly = ra.ly + r*ru.ly - a.ly;
        fmul    st,st(1);*r
        fadd    ra.ls_ly
        fsub    a.ls_ly
        fstp    u.ls_ly

        fmul    ru.ls_lz;*r             ;u.lz = ra.lz + r*ru.lz - a.lz;
        fadd    ra.ls_lz
        fsub    a.ls_lz
        fstp    u.ls_lz

        fistp   xe                      ;xe = ceil(rx) (rx entfernen)
        frndint
        fist    xa                      ;xa = ceil(lx) (lx nicht entfernen)


        mov     edi,xa
        mov     ecx,xe
        sub     ecx,edi                 ;ecx = pixel in einer zeile
        add     edi,x_y                 ;edi -> pixel

@@l:
        mov     edx,txt_x               ;edx = 00Xx
        mov     ebx,txt_y               ;ebx = 00Yy

        cmp     ecx,48;24                 ;16
        jge     @@div

                ;weniger als 24 pixel
        or      ecx,ecx
        jle     @@w

        mov     esi,ecx                 ;esi : zu setzende pixel
        xor     ecx,ecx
        push    ecx

        fld     a.ls_lz
        fadd    u.ls_lz

        fld     a.ls_lx                 ;textur - endkoordinate
        fadd    u.ls_lx                 ;(a.lx + 1*u.lx)/(a.lz + 1*u.lz)
        fdiv    st,st(1)
        fisub   txt_x
        fmul    divtab32[esi*4]           ;16
        fistp   txt_x

        fld     a.ls_ly                 ;textur - endkoordinate
        fadd    u.ls_ly                 ;(a.ly + 1*u.ly)/(a.lz + 1*u.lz)
        fdivrp  st(1),st
        fisub   txt_y
        fmul    divtab32[esi*4]
        fistp   txt_y

        mov     eax,txt_x
        mov     ecx,txt_y

        jmp     @@5
                                        ;st(0) = x
                                        ;st(1) = 16
@@div:          ;scanline subdivision

        fadd    st,st(1);16             ;x um 16 weiter
        fld     st;x                    ;r = (x *a.z - a.x) / (u.x - u.z*x )
        fmul    a.s_z
        fsub    a.s_p;a.x
        fld     st(1);x
        fmul    u.s_z
        fsubr   u.s_p;u.x
        fdivp   st(1),st                ;st = r

        fld     u.ls_lz                 ;(a.lz + r*u.lz)
        fmul    st,st(1)
        fadd    a.ls_lz

        fld     u.ls_lx                 ;x = (a.ly + r*u.ly)/(a.lz + r*u.lz)
        fmul    st,st(2)
        fadd    a.ls_lx
        fdiv    st,st(1)
        fistp   txt_x

        fld     u.ls_ly                 ;y = (a.ly + r*u.ly)/(a.lz + r*u.lz)
        fmul    st,st(2)
        fadd    a.ls_ly
        fdivrp  st(1),st
        fistp   txt_y

        fstp    st                      ;r entfernen

        mov     esi,32;16                  ;esi : zu setzende pixel
        sub     ecx,esi
        push    ecx                     ;ecx : x-zhler

        mov     eax,txt_x
        mov     ecx,txt_y
        sub     eax,edx                 ;eax = 00Uu
        sub     ecx,ebx                 ;ecx = 00Vv

@@5:
        push    ebp                     ;ebp : lokale variablen

        add     dh,80h
        add     bh,80h

        or      esi,zval
        push    esi
        mov     esi,mapptr              ;esi = TTTT

        shl     ebx,16
        shl     ecx,16 - 5 ;v/16
        shr     eax,5 ;u/16
        shr     ebx,8
        shr     ecx,8
        shrd    ebx,edx,8               ;ebx = x0Yy
        shrd    ecx,eax,8               ;ecx = u0Vv
        movzx   edx,dh                  ;edx = 000X
        movzx   ebp,ah                  ;ebp = 000U
                ;keine lokalen variablen mehr zugnglich
        pop     eax                     ;eax = 00zC

        mov     dh,bh
     xchg ebp,ecx
        jmp     @@inner
@@i0:
        add     ebx,ebp;ecx
        adc     dl,cl;adc     edx,ebp
        inc     edi
        dec     al
        mov     dh,bh
        jz      @@iw
@@inner:
        cmp     ah,[edi*4+3]
        jne     @@i0
        mov     dh,[edx+esi];15
        add     ebx,ebp;ecx
        adc     dl,cl;adc     edx,ebp
        add     [edi*4+2],dh
        inc     edi
        dec     al
        mov     dh,bh
        jnz     @@inner
@@iw:

        pop     ebp
        pop     ecx
        jmp     @@l
@@w:
        fstp    st                      ;x entfernen

        mov     eax,xres
        add     x_y,eax
        inc     y
        mov     eax,yres
        cmp     eax,y                   ;while (y < yres)
        jg      @@y_l

@@fertig:
        fstp    st                      ;16.0 entfernen

@@weg:  ret
sublpolygon endp


sprojektion proc pascal
        ;-> esi = *sp
        ;-> edi = *sp_end
        ;<- esi = *sp
        ;<- edi = *sp_end
        ;<- wenn weniger als 3 punkte, mit jbe wegspringen
local   _sp:dword, _sp_end:dword ;beides pointer

        mov     _sp,esi                 ;esi -> sp[z] (quellpunkte)
        mov     _sp_end,edi             ;edi -> sp[d] (zielpunkte)

        fld1
@@z_l:

        fld     [esi].lp_lz                ;inn = (t[z].z >= 1);
        fcomp   st(1)

        fstsw   ax
        mov     dh,ah                   ;dh = inn
        sahf
        jb      @@0
                ;punkt vor projektionsebene (sichtbar)
        fld     [esi].lp_lz

        fld     [esi].lp_lx                ;sx = xres/2 *(1 + t[z].x/t[z].z);
        fdiv    st,st(1)
        fadd    st,st(2)
        fmul    c_128
        fstp    hp_x[edi]

        fld     [esi].lp_ly                ;sy = yres/2 *(1 - t[z].y/t[z].z);
        fdivrp  st(1),st
        fadd    st,st(1)
        fmul    c_128
        fstp    hp_y[edi]

        add     edi,size tshadowpoint   ;m++
@@0:
        mov     ebx,esi
        add     ebx,size tlightpoint    ;nz = z+1
        cmp     ebx,_sp_end             ;if (nz >= m) nz = 0;
        jb      @@wrap
        mov     ebx,_sp
@@wrap:
        fld     [ebx].lp_lz                ;if (inn ^ (t[wz].z >= 1))
        fcomp   st(1)
        fstsw   ax
        xor     ah,dh                   ;dh = inn
        sahf
        jnc     @@1
                ;dieser oder letzter punkt hinter projektionsebene
                ;r = (1.0-t[z].z)/(t[wz].z-t[z].z);
        fld1
        fsub    [esi].lp_lz
        fld     [ebx].lp_lz
        fsub    [esi].lp_lz
        fdivp   st(1),st                ;st = r

        fld     [esi].lp_lx                ;x = t[z].x + r*(t[wz].x-t[z].x);
        fld     [ebx].lp_lx
        fsub    st,st(1)
        fmul    st,st(2)
        faddp   st(1),st
        fadd    st,st(2)                ;sx = xres/2 *(1 + x);
        fmul    c_128
        fstp    hp_x[edi]

        fld     [esi].lp_ly                ;y = t[z].y + r*(t[wz].y-t[z].y);
        fld     [ebx].lp_ly
        fsub    st,st(1)
        fmul    st,st(2)
        faddp   st(1),st
        fadd    st,st(2)                ;sy = yres/2 *(1 - y);
        fmul    c_128
        fstp    hp_y[edi]

        fstp    st                      ;r entfernen

        add     edi,size tshadowpoint   ;m++
@@1:
        cmp     ebx,esi                 ;wz > z?
        mov     esi,ebx                 ;entspricht esi += size tscreenpoint
        ja      @@z_l                   ;z-schleife
        fstp    st                      ;1.0 entfernen

        mov     esi,_sp_end             ;esi -> anfang der schatten-punkte
                                        ;edi -> ende der schatten-punkte

        mov     eax,edi
        sub     eax,esi
        shr     eax,1
        cmp     eax,size tshadowpoint
@@weg:  ret

sprojektion endp

spolygon proc pascal
arg     _sp:dword, sp_end:dword, _mapptr:dword
        ;_sp = *sp, zeiger auf screenpoints

local   pend, y, ymax, x_y, lb, lc, rb, rc : dword ;int
local   lx, ldx, rx, rdx : dword ;float
local   xa, xe: dword ;int


        xor     eax,eax                 ;start- und endpunkt bestimmen
        mov     lb,eax
        mov     rb,eax
        mov     pend,eax

        mov     esi,_sp                 ;esi -> screenpoints
        fld     hp_y[esi]               ;st(0) = ymax
        fld     st                      ;st(1) = ymin

        mov     ecx,sp_end
        sub     ecx,size tshadowpoint   ;esi+ecx -> sp[sp_end-1]
@@max_l:

        fld     hp_y[esi+ecx]
        fcom    st(1);ymax              ;grten y-wert finden (endpunkt)
        fstsw   ax
        sahf
        jb      @@max
        mov     pend,ecx
        fst     st(1);ymax
        jmp     @@min
@@max:
        fcom    st(2);ymin              ;kleinsten y-wert finden (startpunkt)
        fstsw   ax
        sahf
        ja      @@min
        mov     lb,ecx
        mov     rb,ecx
        fst     st(2);ymin
@@min:  fstp    st

        sub     ecx,size tshadowpoint
        jnz     @@max_l
        fistp   ymax                    ;ymax entfernen

        fistp   y                       ;y = ceil(ymin)

        mov     eax,y

        cmp     eax,256                 ;y-clipping
        jge     @@weg

        or      eax,eax
        jg      @@y0
        mov     y,0
        xor     eax,eax
@@y0:
        cmp     eax,ymax
        jge     @@weg

      mov     ebx,_mapptr  ;lmap kopieren
      mov     esi,[ebx]
      cmp     esi,lmap
      je      @@lmap
      mov     edi,lmap
      mov     [ebx],edi
      mov     ecx,65536/4
      rep     movsd
      mov     esi,[ebx];lmap
@@lmap:


        shl     eax,8
        add     eax,esi;mapptr
        mov     x_y,eax

        mov     lc,1
        mov     rc,1

@@y_l:  ;y-schleife

                ;links
        dec     lc
        jnz     @@l_nz
        mov     edi,_sp
        mov     esi,lb
@@lc:
        cmp     esi,pend
        je      @@fertig                ;lb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = lb
        sub     esi,size tshadowpoint   ;lb--
        jnc     @@l0                    ;wrap
        add     esi,sp_end
@@l0:
        fld     hp_y[esi+edi]           ;lc = ceil(sp[lb].sy) - y
        fistp   lc
        mov     eax,y
        sub     lc,eax
        jle     @@lc                    ;while lc <= 0
        mov     lb,esi


                ;ldx = (sp[lb].sx - sp[ia].sx)/(sp[lb].sy - sp[ia].sy);
        fld     hp_x[esi+edi]
        fsub    hp_x[ebx+edi]
        fld     hp_y[esi+edi]
        fsub    hp_y[ebx+edi]
        fdivp   st(1),st
        fst     ldx

                ;lx = ldx   *(y  - sp[ia].sy) + sp[ia].sx;
        fild    y
        fsub    hp_y[ebx+edi]
        fmulp   st(1),st
        fadd    hp_x[ebx+edi]
        fst     lx
        jmp     @@l_z
@@l_nz:
        fld     lx
        fadd    ldx                     ;lx bleibt im copro
        fst     lx
@@l_z:

        fistp   xa                      ;xa = ceil(lx) (lx entfernen)

                ;rechts
        dec     rc
        jnz     @@r_nz
        mov     edi,_sp
        mov     esi,rb
@@rc:

        cmp     esi,pend
        je      @@fertig                ;rb == pend -> unten angekommen
        mov     ebx,esi                 ;ia = rb
        add     esi,size tshadowpoint   ;rb++
        cmp     esi,sp_end
        jb      @@r0                    ;wrap
        xor     esi,esi
@@r0:
        fld     hp_y[esi+edi]           ;rc = ceil(sp[rb].sy) - y
        fistp   rc
        mov     eax,y
        sub     rc,eax
        jle     @@rc                    ;while rc <= 0
        mov     rb,esi


                ;rdx = (sp[rb].sx - sp[ia].sx)/(sp[rb].sy - sp[ia].sy);
        fld     hp_x[esi+edi]
        fsub    hp_x[ebx+edi]
        fld     hp_y[esi+edi]
        fsub    hp_y[ebx+edi]
        fdivp   st(1),st
        fst     rdx

                ;rx = rdx   *(y  - sp[ia].sy) + sp[ia].sx;
        fild    y
        fsub    hp_y[ebx+edi]
        fmulp   st(1),st
        fadd    hp_x[ebx+edi]
        fst     rx
        jmp     @@r_z
@@r_nz:
        fld     rx
        fadd    rdx                     ;rx bleibt im copro
        fst     rx
@@r_z:
                                        ;st(0) = rx,  st(1) = lx
        fistp   xe                      ;xe = ceil(rx) (rx entfernen)

        mov     edi,xa
      dec edi
;
        or      edi,edi
        jns     @@c0
        xor     edi,edi
@@c0:
        mov     ecx,xe ;<
      inc ecx
        cmp     ecx,256
        jl      @@c1
        mov     ecx,256
@@c1:
;
        sub     ecx,edi                 ;ecx = pixel in einer zeile
        jle     @@w
        add     edi,x_y                 ;edi -> pixel

        xor     eax,eax
;     cmp ecx,10
;     jb  @@o5
;     mov edx,ecx
;     mov ecx,edi
;     neg ecx
;     and ecx,3
;     sub edx,ecx
;     rep stosb

;     mov ecx,edx
;     shr ecx,2
;     rep stosd
;     mov ecx,edx
;     and ecx,3

;@@o5:
        rep     stosb

@@w:
        mov     eax,256
        add     x_y,eax
        inc     y
        cmp     eax,y                   ;while (y < yres)
        jg      @@y_l

@@fertig:

@@weg:  ret
spolygon endp

comment ^
clearbuffer proc near
        mov     edi,buffer
        mov     ecx,64000
        xor     eax,eax
        rep     stosd

@@weg:  ret
clearbuffer endp
^


comment ^
copybuffer proc near
        mov     esi,buffer
        inc     esi
       ; inc     esi
        mov     edi,0A0000h
        mov     ecx,64000-4
@@l:
        mov     al,[esi+ecx*4+8]

        mov     ah,[esi+ecx*4+12]
        shl     eax,16
        mov     al,[esi+ecx*4]
        mov     ah,[esi+ecx*4+4]

        mov     [edi+ecx],eax

        sub     ecx,4
        jns     @@l

@@weg:  ret
copybuffer endp
^

copybuffer8 proc near

        mov     ebx,coltab
        mov     esi,buffer
        inc     esi
        mov     edi,linbuf
        mov     ebp,yres
@@y_l:
        mov     ecx,xres
        sub     ecx,4
@@x_l:
        movzx   eax,word ptr [esi+ecx*4+12] ;al : textur, ah : helligkeit
        movzx   edx,word ptr [esi+ecx*4+8]
        mov     ah,[ebx+eax]
        mov     al,[ebx+edx]
        shl     eax,16
        movzx   edx,word ptr [esi+ecx*4+4]
        mov     ah,[ebx+edx]
        movzx   edx,word ptr [esi+ecx*4]
        mov     al,[ebx+edx]

        mov     [edi+ecx],eax
        sub     ecx,4
        jns     @@x_l

        mov     eax,xres
        shl     eax,2
        add     esi,eax
        add     edi,xbytes
        dec     ebp
        jnz     @@y_l

        ret
copybuffer8 endp



copybuffer16 proc near

        mov     ebx,coltab
        mov     esi,buffer
        inc     esi
        mov     edi,linbuf
        mov     ebp,yres
@@y_l:
        mov     ecx,xres
        shr     ecx,1
        dec     ecx
@@x_l:
        movzx   edx,word ptr [esi+ecx*8+4]
        movzx   eax,word ptr [esi+ecx*8]

        mov     dx,[ebx+edx*2]
        shl     edx,16
        mov     dx,[ebx+eax*2]

        mov     [edi+ecx*4],edx

        dec     ecx
        jns     @@x_l

        mov     eax,xres
        shl     eax,2
        add     esi,eax
        add     edi,xbytes
        dec     ebp
        jnz     @@y_l

        ret
copybuffer16 endp

copybuffer24 proc near

        mov     ebx,coltab
        mov     esi,buffer
        inc     esi
        mov     edi,linbuf
        mov     ebp,yres
@@y_l:
        push    edi ebp

        mov     ecx,xres
        shr     ecx,2
@@x_l:
                ;1.
        movzx   eax,word ptr [esi]
        add     esi,4
        mov     ebp,[ebx+eax*4];030201h;

                ;2.
        movzx   eax,word ptr [esi]
      shl     ebp,8
        add     esi,4
        mov     edx,[ebx+eax*4];060504h;

                ;3.
        movzx   eax,word ptr [esi]
      shrd    ebp,edx,8
        add     esi,4
      mov     [edi],ebp
      add     edi,4
        mov     ebp,[ebx+eax*4];090807h;
      shl     edx,8

                ;4.
        movzx   eax,word ptr [esi]
      shrd    edx,ebp,16
        add     esi,4
      mov     [edi],edx
      add     edi,4
      shl     ebp,8
        mov     edx,[ebx+eax*4];0c0b0ah;

      shld    edx,ebp,8
      mov     [edi],edx
      add     edi,4

        dec     ecx
        jnz     @@x_l

        pop     ebp edi
        add     edi,xbytes

        dec     ebp
        jnz     @@y_l

        ret
copybuffer24 endp

copybuffer32 proc near

        mov     ebx,coltab
        mov     esi,buffer
        inc     esi
        mov     edi,linbuf
        mov     ebp,yres
@@y_l:
        mov     ecx,xres
        shr     ecx,1
        dec     ecx
@@x_l:
        movzx   eax,word ptr [esi+ecx*8]
        movzx   edx,word ptr [esi+ecx*8+4]

        mov     eax,[ebx+eax*4]
        mov     edx,[ebx+edx*4]

        mov     [edi+ecx*8],eax
        mov     [edi+ecx*8+4],edx

        dec     ecx
        jns     @@x_l

        mov     eax,xres
        shl     eax,2
        add     esi,eax
        add     edi,xbytes
        dec     ebp
        jnz     @@y_l

        ret
copybuffer32 endp


;init-prozeduren
initpaltab proc pascal
        ;-> esi -> tvesa
        local   z, palcnt

                ;calc palette in all light values
        mov     z,lvalues+xtralvalues-1
@@l0:
        mov     ebx,palette
        mov     palcnt,0
@@l1:
        mov     edi,2
@@l2:
        movzx   edx,byte ptr[ebx+edi]   ;g,b,r
        imul    edx,z
        shr     edx,ld_lvalues
        cmp     edx,255
        jb      @@clip
        mov     dl,255
@@clip:

        shl     eax,8
        mov     al,dl

        dec     edi
        jns     @@l2
                                        ;eax = ?gbr

        movzx   edx,al                  ;r
        mov     cl,[esi].vesa_redbits
        shl     edx,cl
        shr     edx,8
        mov     cl,[esi].vesa_redpos
        shl     edx,cl
        mov     edi,edx

        movzx   edx,ah                  ;g
        mov     cl,[esi].vesa_greenbits
        shl     edx,cl
        shr     edx,8
        mov     cl,[esi].vesa_greenpos
        shl     edx,cl
        or      edi,edx

        shr     eax,8                   ;b
        movzx   edx,ah
        mov     cl,[esi].vesa_bluebits
        shl     edx,cl
        shr     edx,8
        mov     cl,[esi].vesa_bluepos
        shl     edx,cl
        or      edx,edi

        mov     ecx,palcnt
        mov     ch,byte ptr z


        mov     edi,coltab              ;edi -> tpaltab
        cmp     pbytes,2
        ja      @@32
        mov     [edi+ecx*2],dx
        jmp     @@16
@@32:   mov     [edi+ecx*4],edx
@@16:

        add     ebx,3
        inc     palcnt
        cmp     palcnt,256
        jb      @@l1

        dec     z
        jns     @@l0

        ret
initpaltab endp

comment #
maketruecoltab proc near

        cmp     bpp,24
        jae     @@truecol

        xor     eax,eax                 ;15/16 bit
        mov     ebx,2
@@col_l:
        mov     cl,8
        mov     al,colsize[ebx]
        add     colpos[ebx],al
        sub     cl,al
        mov     al,0FFh
        shl     al,cl
        mov     colmask[ebx*4],eax

        dec     ebx
        jns     @@col_l
        jmp     @@tab
@@truecol:
        ja      @@32bit
                                        ;24 bit
        mov     dl,16
        mov     ebx,2
;        xor     ebx,ebx
@@l0:
        mov     ecx,2
@@l1:
        cmp     dl,colpos[ecx]
        je      @@240
        dec     ecx
        jnz     @@l1
@@240:
        mov     colmask[ebx*4],ecx
        dec     ebx;inc     ebx
        sub     dl,8
        jns     @@l0

        mov     eax,colmask[0]
        add     palette,eax
        sub     colmask[4],eax
        add     eax,colmask[4]
        sub     colmask[8],eax

@@32bit:

@@tab:
        mov     edi,coltab
        xor     ebx,ebx
@@l2:
        xor     ecx,ecx
@@l:
        mov     eax,ebx
        imul    ecx
        shr     eax,ld_lvalues;5           ;identitt bei helligkeit 32
        or      ah,ah
        jz      @@0
        mov     al,255
@@0:
        mov     [edi],al
        inc     edi

        inc     ecx
        cmp     ecx,256
        jb      @@l

        inc     ebx
        cmp     ebx,lvalues+xtralvalues
        jb      @@l2

@@weg:  ret
maketruecoltab endp
#

palconv proc pascal
maxdiff = 2500;512*4

local   z:dword, p:dword, l1:dword:3, s:dword

        mov     edi,palette

        mov     z,1
@@z_l:
        mov     p,0
@@p_l:
        mov     esi,p
        lea     esi,[esi+esi*2]         ;esi*3
        add     esi,edi
        mov     ecx,2
@@0:    movzx   eax,byte ptr [esi+ecx]
        imul    z                       ;l1 = z*pal[p,c]
        mov     l1[ecx*4],eax           ;l1: sollfarbe
        dec     ecx
        jns     @@0


        xor     esi,esi
        mov     s,esi
        mov     edx,0FFFFFFFFh          ;edx = mina
@@s_l:
                ;rot
        movzx   eax,byte ptr[esi+edi]
        shl     eax,ld_lvalues;5                   ;eax = 32*pal[s,0]
        sub     eax,l1[0]
        cmp     eax,maxdiff
        jb      @@w1
        cmp     eax,-maxdiff
        jb      @@s
@@w1:                                   ;eax = l1-l2
                ;grn
        movzx   ebx,byte ptr [esi+edi+1]
        shl     ebx,ld_lvalues;5                   ;ebx = 32*pal[s,1]
        sub     ebx,l1[4]
        cmp     ebx,maxdiff
        jb      @@w2
        cmp     ebx,-maxdiff
        jb      @@s
@@w2:
                ;blau
        movzx   ecx,byte ptr [esi+edi+2]
        shl     ecx,ld_lvalues;5                   ;ebp = 32*pal[s,2]
        sub     ecx,l1[8]
        cmp     ecx,maxdiff
        jb      @@w3
        cmp     ecx,-maxdiff
        jb      @@s
@@w3:


        imul    eax,eax                 ;sqr(l1-l2) fr alle 3 farben
        imul    ebx,ebx
        imul    ecx,ecx
        add     ebx,eax                 ;a += sqr(l1-l2))
        add     ebx,ecx

        cmp     ebx,edx
        jae     @@s                     ;if a < mina

@@mina:         ;passendere farbe gefunden
        mov     edx,ebx
        mov     ebx,z                   ;z ist 1-basiert
        dec     ebx
        shl     ebx,8
        add     ebx,p
        add     ebx,coltab
        mov     eax,s
        mov     [ebx],al
        or      edx,edx
        jz      @@p

@@s:
        add     esi,3
        inc     s
        cmp     esi,256*3
        jb      @@s_l

@@p:
        inc     p
        cmp     p,256
        jb      @@p_l

        inc     z
        cmp     z,lvalues
        jbe     @@z_l



        mov     edi,z
        dec     edi
        shl     edi,8
        add     edi,coltab
        mov     ecx,256*xtralvalues -1
@@free:
        mov     [edi+ecx],cl
        dec     ecx
        jns     @@free

        ret
palconv endp



makelmap1 proc proc pascal
local   x:dword, y:dword, b:dword, c_lmap1:dword

      mov eax,lvalues*9/10
      mov c_lmap1,eax

        mov     edi,lmap1

        mov     y,-128
@@y_l:
        mov     x,-128
@@x_l:
        fild    x
        fmul    st,st(0)
        fild    y
        fmul    st,st(0)
        faddp   st(1),st
        fsqrt
        fmul    c_lmap
        fcos
        fimul    c_lmap1
        fistp   b

        movzx   ebx,byte ptr x
        mov     bh,byte ptr y
        xor     ebx,8080h

        mov     eax,b
        or      eax,eax
        jns     @@0
        xor     eax,eax
@@0:
;        cmp     eax,31
;        jb      @@1
;        mov     eax,31
;@@1:
        mov     [edi+ebx],al

        inc     x
        cmp     x,128
        jl      @@x_l

        inc     y
        cmp     y,128
        jl      @@y_l

@@weg:  ret
makelmap1 endp

makelmap2 proc near

        mov     edi,lmap                ;logo entpacken
        lea     esi,spotl

        mov     eax,lvalues*9 /10
        xor     edx,edx
@@l:
        movzx   ecx,byte ptr[esi]
        inc     esi
        add     edx,ecx
        rep     stosb
        xchg    ah,al
        cmp     edx,65536
        jb      @@l


        mov     esi,lmap                ;logo filtern
        mov     edi,lmap2

        xor     ebx,ebx
@@y_l:
        inc     bh
        xor     bl,bl
@@x_l:
        inc     bl

        mov     al,[esi+ebx+1]
        add     al,[esi+ebx-1]
        add     al,[esi+ebx+256]
        add     al,[esi+ebx-256]
        shr     al,2
        mov     [edi+ebx],al


        cmp     bl,254
        jb      @@x_l

        cmp     bh,254
        jb      @@y_l

@@weg:  ret
makelmap2 endp

makedivtab2 proc near

        mov     edi,divtab2
        mov     ecx,1
        fldz
@@l:
        fld1
        faddp   st(1),st
        fld1
        fdiv    st,st(1)
        fstp    dword ptr[edi+ecx*4]
        inc     ecx
        cmp     ecx,xres
        jbe     @@l
        fstp    st

@@weg:  ret
makedivtab2 endp

makefont proc near


                ;daten
        lea     esi,f_data
        lodsd
        mov     edx,eax
   ; mov ebx,ecx
        add     eax,3
        and     eax,not 3
        call    _getmem
;        jc      @@weg

        mov     font,eax
        mov     edi,eax

        mov     eax,30
@@l:
        movzx   ecx,byte ptr[esi]
        inc     esi
        xchg    ah,al
        sub     edx,ecx
        rep     stosb
        or      edx,edx
        jnz     @@l

     ;ebx

        clc
@@weg:  ret
makefont endp


;ambient track
doambienttrack proc near

        mov     edx,frame
@@0:
        mov     ebx,am_key
        cmp     edx,am_keydata[ebx*8+8] ;start-frame des nchsten keys
        jl      @@1
        inc     am_key
        jmp     @@0
@@1:
        mov     eax,am_keydata[ebx*8+4] ;key-wert

        sub     edx,am_keydata[ebx*8]   ;aktiv-frames
        cmp     edx,framemul*6
        jge     @@2

        sub     eax,am_keydata[ebx*8-4]
        imul    edx
        mov     ecx,framemul*6
        idiv    ecx
        add     eax,am_keydata[ebx*8-4]
@@2:
        shl     eax,16
        mov     illum,eax

@@weg:  ret
doambienttrack endp

;extra-fx

dofxtrack proc near ;mu mind. 1 key haben

        mov     eax,frame
@@0:
        mov     ebx,fx_key
        cmp     eax,fx_keydata[ebx*8+8] ;start-frame des nchsten keys
        jl      @@1
        inc     fx_key
        jmp     @@0
@@1:
        sub     eax,fx_keydata[ebx*8]   ;aktiv-frames
        call    fx_keydata[ebx*8+4]    ;key-prozedur

        ret
dofxtrack endp

nofx proc near
        ret
nofx endp

logo proc pascal
local   yadd, x_y

    mov eax,logoflag
    add eax,100
    cmp eax,maincount
    jl @@2
    ;cmp logoflag,0
    ;je @@2
                ;y
        mov     eax,yres
        mov     ebx,eax
        shr     eax,4

        mov     edi,eax   ;y-start
        mov     edx,frame
        shr     edx,4
        and     edx,63
        mov     dl,byte ptr divtab[edx+4]
        shr     edx,5
        add     edi,edx
        imul    edi,xres

        sub     ebx,eax   ;ebx = y-end
        sub     ebx,eax   ;ebx = y-pixel
        mov     eax,65536
        xor     edx,edx
        div     ebx
        mov     yadd,eax

                ;x
        mov     eax,xres
        mov     ebx,eax
        shr     eax,3

        add     edi,eax   ;x-start
        mov     edx,frame
        shr     edx,5
        and     edx,63
        mov     dl,byte ptr divtab[edx+15]
        shr     edx,5
        add     edi,edx

        sub     ebx,eax   ;ebx = x-end
        sub     ebx,eax   ;ebx = x-pixel
        mov     eax,65536
        xor     edx,edx
        div     ebx
        mov     ebx,eax                 ;ebx = 00Uu

        shl     edi,2
        add     edi,buffer
        add     edi,2
        mov     x_y,edi

        mov     esi,lmap2               ;esi = TTTT

        xor     edx,edx                 ;edx = 00YX
        dec     dh
        xor     ecx,ecx                 ;ecx = 00yx

        mov     eax,yadd                ;eax = 00Vl
@@y_l:
        xor     dl,dl
        xor     cl,cl
        mov     edi,x_y
@@x_l:
        mov     al,[esi+edx]
        add     [edi],al
        add     edi,4
        add     cl,bl
        adc     dl,bh
        jnc     @@x_l

        mov     edi,xres
        shl     edi,2
        add     x_y,edi

        sub     ch,byte ptr yadd
        sbb     dh,ah

        jnc     @@y_l

@@2:
comment ^
     jmp @@weg
                ;y
        mov     eax,yres
        mov     ebx,eax
        shr     eax,4

        mov     edi,eax   ;y-start
        mov     edx,maincount
        shr     edx,4
        and     edx,63
        mov     dl,byte ptr divtab[edx+23]
        shr     edx,5
        add     edi,edx
        imul    edi,xres

        sub     ebx,eax   ;ebx = y-end
        sub     ebx,eax   ;ebx = y-pixel
        mov     eax,65536
        xor     edx,edx
        div     ebx
        mov     yadd,eax

                ;x
        mov     eax,xres
        mov     ebx,eax
        shr     eax,3

        add     edi,eax   ;x-start
        mov     edx,maincount
        shr     edx,5
        and     edx,63
        mov     dl,byte ptr divtab[edx+11]
        shr     edx,5
        add     edi,edx

        sub     ebx,eax   ;ebx = x-end
        sub     ebx,eax   ;ebx = x-pixel
        mov     eax,65536
        xor     edx,edx
        div     ebx
        mov     ebx,eax                 ;ebx = 00Uu

        mov     eax,buffer
        shr     eax,2
        add     edi,eax
        mov     x_y,edi

        mov     esi,lmap2               ;esi = TTTT

        xor     edx,edx                 ;edx = 00YX
        dec     dh
        xor     ecx,ecx                 ;ecx = 00yx

        mov     eax,weiss               ;eax = 0lpl

@@y_l2:
        xor     dl,dl
        xor     cl,cl
        mov     edi,x_y
@@x_l2:
        mov     al,[esi+edx]
      cmp al,0
      jne @@ex
@@weiter:
        inc     edi
        add     cl,bl
        adc     dl,bh
        jnc     @@x_l2

        mov     edi,xres
        add     x_y,edi

        sub     ch,byte ptr yadd
        sbb     dh,byte ptr yadd +1

        jnc     @@y_l2
        jmp     @@weg
@@ex:
        mov     [edi*4],eax
        jmp     @@weiter
^
@@weg:  ret
logo endp



fontwriter proc pascal
        ;-> eax = frames
local   phase:dword, y:dword

    cmp     linbuf,0A0000h;test    pflag,useVesa
    jne     @@weg;jnz     @@weg

        shr     eax,7;8
        mov     edx,eax
        and     eax,15
        cmp     eax,2                   ;1.phase
        jbe     @@weg
        mov     phase,eax    ;0-2 : aus, 3-5 : 1. zeile, 6-15 : 2. zeile

        shr     edx,4

        lea     edi,f_text
@@l:
        cmp     byte ptr[edi],cEnd
        je      @@weg
        or      edx,edx
        jz      @@0
        mov     ecx,30
        mov     al,cNextpage
        repne   scasb
        dec     edx
        jmp     @@l
@@0:
        mov     esi,edi
        mov     edi,10*320+20
        mov     y,edi
@@l2:
        lodsb
        cmp     al,cSpace
        jne     @@1
        add     edi,12
        jmp     @@l2
@@1:
        cmp     al,cNextline
        jne     @@2
        add     y,24*320
        mov     edi,y
        jmp     @@l2
@@2:
        cmp     al,c2nd
        jne     @@3
        cmp     phase,5                 ;2.phase
        jbe     @@weg
        add     y,90*320
        mov     edi,y
        jmp     @@l2
@@3:
        cmp     al,cNextpage
        je      @@weg

        push    esi

                                        ;writechar
        movzx   ebx,al
        imul    ebx,6
        mov     esi,f_header[ebx].f_pos
        add     esi,font

        push    edi
        shl     edi,2
        add     edi,buffer
        add     edi,2

        movzx   edx,f_header[ebx].f_x
        mov     ch,f_header[ebx].f_y
@@y_l:
        mov     cl,dl
@@x_l:
        lodsb
        add     [edi],al
        add     edi,4

        dec     cl
        jnz     @@x_l

        mov     eax,xres
        sub     eax,edx ;f_x
        shl     eax,2
        add     edi,eax

        dec     ch
        jnz     @@y_l

        pop     edi
        ;inc     edx
        add     edi,edx ;f_x



        pop     esi
        jmp     @@l2

@@weg:  ret
fontwriter endp

;-------start-------------------

initengine proc near
        ;-> eax -> membase
        ;-> edx -> memtop
        ;-> esi -> tvesa
        push    ebp

        mov     membase,eax
        mov     memtop,edx

        mov     eax,[esi].vesa_xbytes
        mov     xbytes,eax
        mov     eax,[esi].vesa_xres
        mov     xres,eax
        mov     eax,[esi].vesa_yres
        mov     yres,eax
        mov     eax,[esi].vesa_pbytes
        mov     pbytes,eax              ;2: 16 bit, 3: 24 bit, 4: 32 bit
        mov     eax,[esi].vesa_linbuf
        mov     linbuf,eax
        mov     vesaptr,esi
;copro
        finit
        push    0001100001111111b ;1b7Fh
        ;          IR P I
        fldcw   word ptr [esp]
        pop     eax

;grafik
        fild    xres
        fdiv    c_2
        fstp    c_xmid
        fild    yres
        fdiv    c_2
        fstp    c_ymid
;font
        call    makefont
;        jc      @@weg
;savemempos
        call    savemempos
;initmem
        call    initmem
;        jc      @@weg
;readworld
        call    readworld
;        jc      @@weg

;
        cmp     pbytes,1
        ja      @@true
                ;8 bit
        call    palconv

if gfx gt 0
        mov     esi,palette
        cmp     linbuf,0A8000h
        jb      @@vga
        call    setpal
        jmp     @@vga0
@@vga:  call    vgasetpal
@@vga0:
endif
        jmp     @@8
@@true:
                ;hi/true color
        mov     esi,vesaptr
        call    initpaltab              ;esi -> tvesa
@@8:

        call    makelmap1
        call    makelmap2
        call    makedivtab2

@@weg:  pop     ebp
        ret
initengine endp

startengine proc near

        push    ebp
;part1
;        mov     maincount,530*framemul
                                        ;--------------- S
@@f:
        mov     eax,maincount
        mov     edx,eax
        sub     edx,frame

        cmp     edx,256
        jle     @@f1

        add     frame,256

        mov     esi,objtree             ;tracks neu berechnen
        call    dotracks

        mov     esi,chain
        call    traceobjects

        jmp      @@f
@@f1:
        mov     frame,eax
        ;call    clearbuffer

        mov     esi,objtree             ;tracks neu berechnen
        call    dotracks

        mov     esi,chain
        call    traceobjects

        call    doambienttrack

        mov     esi,c_vmt.o_firstobj    ;eine kamera als beobachter verwenden
        lea     edi,viewer
        fld     c_1_33
        call    doviewer

        lea     esi,viewer              ;cubetree bzgl. beobachter
        call    cubetree

        call    texturedraw

        call    dolights

        call    dofxtrack   ;vor copybuffer

;if gfx gt 0
        cmp     pbytes,3
        ja      @@32
        je      @@24
        cmp     pbytes,2
        je      @@16
        call    copybuffer8
        jmp     @@1
@@16:   call    copybuffer16
        jmp     @@1
@@24:   call    copybuffer24
        jmp     @@1
@@32:   call    copybuffer32
@@1:
;endif

        call    keypressed
        or      eax,eax
;        mov     ah,1
;        int     16h
        jnz     @@weg


        ;add     frame,20
        cmp     frame,1100*framemul      ;------------- E
        jle     @@f

;part2
@@p2:
        cmp     linbuf,0A0000h;test    pflag,useVesa
        jne     @@weg;jnz     @@weg
        call    freemem
        call    greets


@@weg:  pop     ebp
        ret
startengine endp



end

