Program tulip3D;

Uses CRT,GFXMCGAf,GFX32,CRYS32U,gfxmcga;

Const Num_V=(63+1);
      Num_P=(54+1);


Type
  Vertex = Record x, y, z : Longint; End;
  Poly = Record v1,v2,v3,v4,c : Byte; end;

Var
  Time : Longint ABSOLUTE $0:$046c;
  STime, ETime, Frame : Longint;
  Sint, Cost{, ZFluxt }: Array[0..1023] of Longint;

  OCds : Array[0..Num_V-1] of Vertex; {object coords}
  OPol : Array[0..Num_P-1] of Poly;
  WCds : Array[0..Num_V-1] of Vertex; {world/screen coords}
  PIND : array[0..Num_P] of integer;
  PZ : array[0..Num_P] of longint;

  xx,yy,zz, xc,yc, rx,ry,rz,wx,wy,wz,Loop,zflux:Integer;
                  {y}    {x}
  ftable : array [0..59,0..59] of byte; {fire}
  ftp : pointer;
  movem:integer;

{$L tulidata.obj}
PROCEDURE TuliData; external;

{}
Procedure MakeTables;
Begin
 For Loop := 0 to 1023 do Begin
  Sint[Loop]:=Round(Sin(Loop*(2*Pi)/512)*32768);
  Cost[Loop]:=Round(Cos(Loop*(2*Pi)/512)*32768);

{  ZFluxt[loop]:=round(Sin(Loop*2*(Pi)/512)*1024);}
 End;
End;

{}
PROCEDURE Init;
var t:text;f:file;rr:real;tmp:char;
    LW:integer;
begin

  for LW:=0 to Num_V-2 do with OCds[LW] do
  begin
   x:=mem[seg(@tulidata^):ofs(@tulidata^)+LW*3]-100;
   y:=mem[seg(@tulidata^):ofs(@tulidata^)+LW*3+1]-100;
   z:=mem[seg(@tulidata^):ofs(@tulidata^)+LW*3+2]-100;
   x:=x*24;
   y:=y*24;
   z:=(z-30)*19;
  end;
  for LW:=0 to Num_P-2 do with OPol[LW] do
  begin
   v1:=mem[seg(@tulidata^):ofs(@tulidata^)+(Num_V-1)*3+LW*4];
   v2:=mem[seg(@tulidata^):ofs(@tulidata^)+(Num_V-1)*3+LW*4+1];
   v3:=mem[seg(@tulidata^):ofs(@tulidata^)+(Num_V-1)*3+LW*4+2];
   v4:=mem[seg(@tulidata^):ofs(@tulidata^)+(Num_V-1)*3+LW*4+3];
  end;

  {FIRE COORDS}
  with OCds[63] do begin x:=0;y:=19;z:=23*19;end;
  With OPol[54] do begin v1:=63; v2:=63; v3:=63; v4:=63;end;

  For Loop:=0 to 21 do OPol[Loop].c:=63+63;
  For Loop:=22 to 31 do OPol[Loop].c:=50+63;
  For Loop:= 32 to 37 do OPol[Loop].c:=120+63;
  For Loop:= 38 to Num_P-1 do OPol[Loop].c:=128+63;


  for Loop:= 1 to 63 do
  begin
   Pal(Loop,Loop,Loop div 3+ Loop div 3,0); {fire}
   Pal(Loop+63,63-loop,42-(loop div 3+Loop div 3),10+loop div 4); {fire}

   Pal(Loop+128,Loop,Loop,Loop);
   Pal(Loop+192,Loop div 2,Loop div 2,Loop div 2);
  end;
  {fire}
  Fillchar(ftable,360,0);
  ftp:=addr(ftable);
  movem:=0;

end;

{}
PROCEDURE quicksort(lo,hi:integer);

procedure sort(l,r:integer);
var i,j,x,y:integer;
begin
  i:=l; j:=r; x:=PZ[(l+r) div 2];
  repeat
    while PZ[i]<x do inc(i);
    while x<PZ[j] do dec(j);
    if i<=j then begin
      y:=PZ[i]; PZ[i]:=PZ[j]; PZ[j]:=y;
      y:=pind[i]; pind[i]:=pind[j]; pind[j]:=y;
      inc(i); dec(j);
    end;
  until i>j;
  if l<j then sort(l,j);
  if i<r then sort(i,r);
end;

begin
  sort(lo,hi);
end;

{}
Function SHRI(I,B : Longint) : Longint;
Begin If I<0 Then SHRI:=-((-I) Shr B) Else SHRI:=(I Shr B); End;

{}
Procedure Rotate3D;
var  x,y,z,xn,yn,zn:Longint;
     rxnew,rynew,rznew : WORD;
Begin
 For Loop := 0 to Num_V -1 do
 Begin
   x:=OCds[Loop].x; y:=OCds[Loop].y; z :=OCds[Loop].z;
   RXnew:=RX;
   RYnew:=RY;
   RZnew:=RZ;
{Y}
  Xn:=shri(X*Cost[RYnew]-Z*Sint[RYnew],15);
  Zn:=shri(X*Sint[RYnew]+Z*Cost[RYnew],15);
  X:=Xn; Z:=Zn;
{Z}
  Xn:=shri(X*Cost[RZnew]-Y*Sint[RZnew],7);
  Yn:=shri(X*Sint[RZnew]+Y*Cost[RZnew],7);
  X:=Xn; Y:=Yn;

  WCds[Loop].x := X Div (5000-Z) + xc;
  WCds[Loop].y := Y Div (5500-Z) + yc;
  WCds[Loop].z:=8000+Z;
 End;
End;

{}
PROCEDURE PutFire(fx,fy,VirSeg:word);
var aa,xx,yy,fxx,tmp,varn:integer;
    flx,fly,ftpseg : word;
begin

 for flx:=xc-fx+26 to xc-fx+34 do ftable[44,flx]:=127;
varn:=1;
varn:=varn+movem;

Asm
{LA MEDIA ENTRE CADA PUNTO Y TRES DE LOS Q LE RODEAN}
   les   di,[ftp]
   push  di
   add   di,240
   mov   cx, 1440
 @LP1:
   add   di, 2
   mov   ax, word ptr es:[di+59]
   mov   bx,ax
   mov   ax, word ptr es:[di+61]
   add   bx,ax
   shr   bl,2
   shr   bh,2
   add   di,varn
   mov   ax, word ptr es:[di-1]
   sub   di,varn
   mov   dx,ax
   add   di,varn
   mov   ax, word ptr es:[di+59]
   sub   di,varn
   add   dx,ax
   shr   dl,2
   shr   dh,2
   add   bx,dx
   sub   bl,1
   jns   @nz3
   mov   bl,0
  @nz3:
   sub   bh,1
   jns   @nz4
   mov   bh,0
  @nz4:
   mov   es:[di], bx

   dec   cx
   jnz   @LP1
end;
{VOLCAR BUFFER A PANTALLA VIRTUAL}
asm
  push ds
  lds si,ftp
  mov es,virseg
  mov ax,fy
  sub ax,55
  shl ax,6
  mov di,ax
  shl ax,2
  add di,ax
  add di,fx
  sub di,89
  mov bh,60
  mov cx,320
  sub cl,bh
 @l:
  mov bl,30
  add di,120
 @l2:
  lodsw
  or ah,ah
  jz @s1
  mov [es:di],ah
 @s1:
  or al,al
  jz @s2
  mov [es:di+1],al
 @s2:
  sub di,2
  dec bl
  jnz @l2
  add di,cx
  dec bh
  jnz @l
  pop ds
end;
end;

{}
{}

Begin
 Asm Mov ax,13h;int 10h;end;

 SetUpVirtual;
 For Loop:=0 to 255 do Pal(Loop,0,0,0);
 Init;
 MakeTables;
 xc:=159; yc:=99;
 rx:=116; ry:=0; rz:=0;
 wx:=0; wy:=7; wz:=0;
 Frame:=0;STime:=Time;

{X}
 For Loop := 0 to Num_V -1 do with OCds[Loop] do
 begin
  YY:=shri((Y*Cost[rx])-(Z*Sint[rx]),15);
  ZZ:=shri((Y*Sint[rx])+(Z*Cost[rx]),15);
  Y:=YY; Z:=ZZ;
 end;

 Repeat
  Rotate3D;
  ry:=(ry+wy); if ry> 511 then ry:=ry-511;
  inc(wx,5); if wx> 511 then wx:=0;

  for Loop:=0 to Num_P-1 do with OPol[Loop] do begin
   PZ[Loop]:=(WCds[v1].z+WCds[v2].z+WCds[v3].z+WCds[v4].z) shr 1;
   Pind[Loop]:=Loop;
  end;
  QuickSort(0,Num_P);

  for Loop:=0 to Num_P-1 do begin
   PZ[Loop]:=(PZ[Loop] div 118-110)*2;
   if PZ[LOOP]<0 then PZ[Loop]:=0;
   if PZ[LOOP]>63 then PZ[Loop]:=63;
  end;

  CLS32(VirSeg,0);

  For Loop := 0 to Num_P-1 do with OPol[Pind[Loop]] do
  begin
   if Pind[Loop]=54 then
   begin
    PutFire(WCds[63].x,WCds[63].y,VirSeg);
   end else
   begin
    DrawPolyf(WCds[v1].x,WCds[v1].y,
             WCds[v2].x,WCds[v2].y,
             WCds[v3].x,WCds[v3].y,
             WCds[v4].x,WCds[v4].y,PZ[Loop]+c,VirSeg);
   end;
  end;

  Frame:=Frame+1;
  Flip32(VirSeg,VidSeg);
  Until keypressed;
 ETime := Time;

 Asm Mov ax,03h;int 10h;end;
 ShutDown;
 Write('3D TULIPALO feat. ASM-FLAME .. 031196 by EleriuM CorE     at ');
 Writeln((Frame*18.2)/(ETime-STime):5:2, ' fps');
 WriteLn;
 WriteLn(' Code........Real Ice & Enco');
 WriteLn(' Object......Obscure');
 WriteLn;
 WriteLn('last mod. 261196');
end.
