// EFFECTS.CC

#include "demo.h"



// load bitmaps and such to preprocess effects
// call this after all effects have been defined

void pre_process_effects(All_Effects_Struc *all)
{
int i, f;
Effect_Struc *effect;

   for(i=0; i < all->num_effects; i++) {
      effect = all->effects[i];
	  	f = effect->function;

		switch(f) {

			case 0 :	image_routine(effect);
						break;

         case 1 : effect->dst = World_Image_Buf;		// recursive
              		break;

         case 2 : break;
       }
   }
}




void process_effects(All_Effects_Struc *all)
{
int i, f;
Effect_Struc *effect;

   for(i=0; i < all->num_effects; i++) {
      effect = all->effects[i];
	  	f = effect->function;

		switch(f) {

//			case 0 :	image_routine(effect);
//						break;

//         case 1 : 		// recursive
              		break;
      }
   }
}




All_Effects_Struc * init_all_effects(void)
{
All_Effects_Struc *all;

	all = (All_Effects_Struc *) malloc(sizeof(All_Effects_Struc));
   all->num_effects = 0;
   return(all);
}


void free_all_effects(All_Effects_Struc *all)
{
Effect_Struc *effect;
int i;
	for(i=0; i < all->num_effects; i++) {
      free_effect(all->effects[i]);
   }
	free(all);

}

void free_effect(Effect_Struc *effect)
{
	free(effect->dst);
   free(effect);
}


void sucks(char *str)
{
int i;
uchar ch;

	i=0;
	while (i<30) {
		ch = (uchar) getkey();
      if((ch==13)||(ch==10)) break;
      if(ch==(uchar)K_BackSpace) { if (i>0) { i--; str[i]=0; } }
      else {
	      str[i] = ch;
   	   str[i+1] = 0;
   		i++;
      }
  		font_top(str);
  }
}

int suckd(void)
{
int i;
uchar ch;
char str[80];

	i=0;
	while (i<30) {
		ch = (uchar) getkey();
      if((ch==13)||(ch==10)) break;
		if(ch==(uchar)K_BackSpace) { if (i>0) { i--; str[i]=0; } }
      else {
	      str[i] = ch;
   	   str[i+1] = 0;
   		i++;
      }
      font_top(str);
   }
   return(atoi(str));
}



// allocates dst
// size = width and height of result bitmap

Effect_Struc * add_effect(void)
{
char str[120];
int temp,size;
Effect_Struc *effect;

	effect= (Effect_Struc *) malloc(sizeof(Effect_Struc));

//	font_bot("Size of bitmap [64-256]: ");
//   size = suckd();
  	size = 200;
//   sprintf(str,"%d",size);
//	font_top(str);

   //font_bot(str);
   effect->dst = (int *) malloc(sizeof(int) * (HEIGHT*WIDTH));
   effect->src = effect->dst;
   effect->width = WIDTH;
   effect->height = HEIGHT;
   effect->size = size;
   effect->function = 0;

   sprintf(str, "Function number [0-%d]: ", NUM_FUNCTIONS-1);
   font_bot(str);
   effect->function = suckd();
	sprintf(str,"%d",effect->function);
   font_top(str);

   font_bot("Texture file: ");
   sucks(str);
   sprintf(effect->filename,"PICS\\%s",str);
	font_top(effect->filename);
   return(effect);
}

// allocates buffer, reads in file.raw and file.pal, converts to 32 bit
// and return ptr to buffer

int * RAW8to32(char *filename)
{
char str[80];
FILE *fp;
uchar *pic;
uchar *pal;
int *vid;

	vid = (int *) malloc(SCREEN32_SIZE);
   pic = (uchar *) malloc(64000);
   pal = (uchar *) malloc(768);

	sprintf(str,"%s.RAW",filename);
	fp = fopen(str,"rb");
   fread(pic, sizeof(char), 64000, fp);		// read pic
   fclose(fp);

	sprintf(str,"%s.PAL",filename);
	fp = fopen(str,"rb");
   fread(pal, sizeof(char), 768, fp);		// read pal
   fclose(fp);

   convert8to32(vid, pic, pal, 64000);

   free(pal);
   free(pic);

	return(vid);
}


// open file, load bitmap of (size*size) ints into effect buffer
// effect->dst = effect->src = image

void image_routine(Effect_Struc *effect)
{
FILE *fp;
int *buf;
char str[120];

  	effect->dst = RAW8to32(effect->filename);
   effect->src = effect->dst;
}

