// ---------------------------- VSSPLINE.H -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Types and functions for spline interpolation.

#ifndef _VSSPLINE_H_
#define _VSSPLINE_H_

#include "vsalgeb.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    VSALG_TCoord time;
    VSALG_T3DPoint v;
    VSALG_TCoord bias, tension, cont, easefrom, easeto;

        // Dynamic fields used during spline construction.
} VSSPL_TKey, *VSSPL_PKey;

typedef struct {
    int         nkeys;
    VSSPL_PKey  keys;       // Must be ordered increasingly by time.

        // Dynamic fields
    VSALG_TCoord mint, maxt;

    int lastkey;            // Cache enhances sequential key access.
} VSSPL_TSpline, *VSSPL_PSpline;


    // Initialize spline parameters.
extern bool VSSPL_Init(VSSPL_PSpline sp);



#ifdef __cplusplus
}
#endif

#endif

// ---------------------------- VSSPLINE.H -----------------------
