// ------------------------------ VSNAMEL.H --------------------
// Bye Jare of Iguana (Javier Arvalo Baeza) in 1995.
// Copyright (C) 1994-1995 by the author.

// Nifty binary tree to store something and access it by name. Store the
// data you want to be named in the "data" pointer field of the TName.

#ifndef _VSNAMEL_H_
#define _VSNAMEL_H_

#ifndef _VSBASE_H_
#include "vsbase.h"
#endif

enum {
    VSNL_NAMELEN = 20,
};

    // Node in the names binary tree.
typedef struct sNLName {
    char            name[VSNL_NAMELEN];
    void           *data;
    struct sNLName *left,
                   *right;
} VSNL_TName, *VSNL_PName;

typedef VSNL_PName  VSNL_TNameTree;
typedef VSNL_PName *VSNL_PNameTree;

// -----------------------------------

extern  bool     VSNL_Init(VSNL_PNameTree t);

extern  void     VSNL_End(VSNL_PNameTree t);

extern  VSNL_PName VSNL_AddName(VSNL_PNameTree t, const char *name);

extern  VSNL_PName VSNL_FindName(VSNL_PNameTree t, const char *name);

extern  void     VSNL_AddTree(VSNL_PNameTree t, VSNL_TNameTree src);

extern  void     VSNL_DelName(VSNL_PNameTree t, const char *name);

typedef bool (*VSNL_PWalkFunction)(VSNL_PName *n, void *data);

    // In-deep walk through the tree. Visit a node after its children.
extern  bool VSNL_WalkTree(VSNL_PNameTree t, VSNL_PWalkFunction func, void *data);

//extern  void VSNL_DumpTree(VSNL_PNameTree t);

#endif

// ------------------------------ VSNAMEL.H --------------------

