// ---------------------------- VSLIGHT.H -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Light types and handling.

#ifndef _VSLIGHT_H_
#define _VSLIGHT_H_

#include "vsalgeb.h"

#ifdef __cplusplus
extern "C" {
#endif


enum {
        // Light types.
    VSLT_AMBIENT,
    VSLT_FOG,
    VSLT_DIRECTIONAL,
    VSLT_OMNI,
};

typedef struct {
    float r, g, b;
    float intens;
} VSL_TLightRGB, *VSL_PLightRGB;

typedef struct {
    dword type;
    VSL_TLightRGB rgb;
    union {
//        struct {
//        } amb;
        struct {
            VSALG_TCoord dmin, dmax;
        } fog;
        struct {
            VSALG_T3DPoint dir;
            VSALG_TCoord falloff;
                // Dynamic fields:
            VSALG_T3DPoint rd;
        } dir;
        struct {
            VSALG_T3DPoint v;
            VSALG_TCoord falloff;       // 1000 seems nice.
                // Dynamic fields:
            VSALG_T3DPoint rv;
        } omni;
    };
} VSL_TLight, *VSL_PLight;

#define VSL_SetRGB(l, _r, _g, _b) ((l)->r = (_r),(l)->g = (_g),(l)->b = (_b))

#define VSL_SetAmbient(l, _r, _g, _b) \
    ((l)->type = VSLT_AMBIENT, VSL_SetRGB((l),_r,_g,_b))

#define VSL_SetDirectional(l, _r, _g, _b, _x, _y, _z)   \
    ((l)->type = VSLT_DIRECTIONAL,                      \
     VSL_SetRGB((l),_r,_g,_b),                          \
     VSALG_Set3D(&(l)->dir.dir, _x,_y,_z))

#define VSL_SetOmni(l, _r, _g, _b, _a, _x, _y, _z, _f) \
    ((l)->type = VSLT_OMNI,                        \
     VSL_SetRGB(&(l)->rgb,_r,_g,_b),               \
     ((l)->rgb.intens = (_a)),                     \
     ((l)->omni.falloff = (_f)),                   \
     VSALG_Set3D(&(l)->omni.v, _x,_y,_z))

#define VSL_SetFog(l, _r, _g, _b, _min, _max) \
    ((l)->type = VSLT_FOG,                    \
     VSL_SetRGB((l),_r,_g,_b),                \
     (l)->fog.dmin = _min,                    \
     (l)->fog.dmax = _max)


    // Calc intensity value given r, g, b.
extern void VSL_SetRGBIntens(VSL_PLightRGB rgb);


#ifdef __cplusplus
}
#endif

#endif

// ---------------------------- VSLIGHT.H -----------------------
