// ---------------------------- VSDUMPSC.H -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Functions to dump a 32-bit buffer to a given screen format.
// Format of 32-bit pixel is: 2.8.2.8.2.8.2 in RGB.

#ifndef _VSDUMPSC_H_
#define _VSDUMPSC_H_

#ifndef _VSBASE_H_
#include "vsbase.h"
#endif

#include "vsclrt32.h"

#ifdef __cplusplus
extern "C" {
#endif

enum {
        // Dump modes
    VSDSCT_8BIT,                // 8-bit faked hicolor mode.
    VSDSCT_RGB565,              // 16-bit R-G-B
    VSDSCT_RGB555,              // 15-bit R-G-B
    VSDSCT_BGR565,              // 16-bit inverted, B-G-R
    VSDSCT_BGR555,              // 15-bit inverted, B-G-R
    VSDSCT_RGB888,              // 24-bit R-G-B
    VSDSCT_RGB0888,             // 32-bit R-G-B
    VSDSCT_BGR888,              // 24-bit inverted, B-G-R
    VSDSCT_BGR0888,             // 32-bit inverted, B-G-R
    VSDSCT_GENERIC16,           // Generic 16-bit format
    VSDSCT_GENERIC24,           // Generic 24-bit format
    VSDSCT_GENERIC32,           // Generic 32-bit format

    VSDSCT_MAX,

        // Constants
    VSDSF_RPOS   = 22,
    VSDSF_RWIDTH = 8,
    VSDSF_RMASK  = ((1 << VSDSF_RWIDTH)-1) << VSDSF_RPOS,
    VSDSF_GPOS   = 12,
    VSDSF_GWIDTH = 8,
    VSDSF_GMASK  = ((1 << VSDSF_GWIDTH)-1) << VSDSF_GPOS,
    VSDSF_BPOS   = 2,
    VSDSF_BWIDTH = 8,
    VSDSF_BMASK  = ((1 << VSDSF_BWIDTH)-1) << VSDSF_BPOS,
};

typedef void (*VSDS_PDumpFunc)(void *dest,
                               int n,
                               const VSCLR_TPixel *src);

extern VSDS_PDumpFunc VSDS_Functions[VSDSCT_MAX];

    // Selected function at initialization.
extern VSDS_PDumpFunc VSDS_Function;

    // Init.
extern bool VSDS_Init(int rpos, int rwidth,
                      int gpos, int gwidth,
                      int bpos, int bwidth,
                      int bpp);

extern void VSDS_End(void);

#ifdef __cplusplus
}
#endif

#endif

// ---------------------------- VSDUMPSC.H -----------------------
