// ---------------------------- VSDUMPSC.C -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Functions to dump a 32-bit buffer to a given screen format.
// Format of 32-bit pixel is: 2.8.2.8.2.8.2 in RGB.
#if 0

#include "vsdumpsc.h"

static struct {
    int rpos, rwidth;
    int gpos, gwidth;
    int bpos, bwidth;
    int bpp;
} BitInfo;


    // Do-nothing
static void GenericNull(void *dest,
                        int n,
                        const VSCLR_TPixel *src) {
}


static void Generic8bit(void *dest,
                        int n,
                        const VSCLR_TPixel *src) {
    byte *p = (byte*)dest;

    while (n-- > 0) {
        dword s;
        byte b;

        s = *src++;
        b = (((s & VSDSF_RMASK) >> (VSDSF_RPOS + VSDSF_RWIDTH - 3 - 5)) & 0xE0)
          | (((s & VSDSF_GMASK) >> (VSDSF_GPOS + VSDSF_GWIDTH - 3 - 2)) & 0x1C)
          | (((s & VSDSF_BMASK) >> (VSDSF_BPOS + VSDSF_BWIDTH - 2 - 0)) & 0x03);
        *p++ = b;
    }
}

extern void DoRGB565(void *dest, int n, const VSCLR_TPixel *src);
#pragma aux DoRGB565 parm [EDI] [ECX] [ESI] modify [EBX EAX EDX] = \
"  @@l:                         "  \
"    MOV     EAX,[ESI]          "  \
"    MOV     EBX,EAX            "  \
"    MOV     EDX,EAX            "  \
"    AND     EAX,0x3E000000     "  \
"    AND     EBX,0x000FC000     "  \
"    AND     EDX,0x000003E0     "  \
"    SHR     EAX,25-11          "  \
"    SHR     EBX,14-5           "  \
"    SHR     EDX,5              "  \
"    OR      EAX,EBX            "  \
"    OR      EAX,EDX            "  \
"    MOV     [EDI],AX           "  \
"    ADD     EDI,2              "  \
"    ADD     ESI,4              "  \
"    DEC     ECX                "  \
"    JNZ     @@l                "


static void RGB565(void *dest,
                   int n,
                   const VSCLR_TPixel *src) {
    DoRGB565(dest, n, src);
}

extern void DoRGB555(void *dest, int n, const VSCLR_TPixel *src);
#pragma aux DoRGB555 parm [EDI] [ECX] [ESI] modify [EBX EAX EDX] = \
"  @@l:                         "  \
"    MOV     EAX,[ESI]          "  \
"    MOV     EBX,EAX            "  \
"    MOV     EDX,EAX            "  \
"    AND     EAX,0x3E000000     "  \
"    AND     EBX,0x000F8000     "  \
"    AND     EDX,0x000003E0     "  \
"    SHR     EAX,25-10          "  \
"    SHR     EBX,15-5           "  \
"    SHR     EDX,5              "  \
"    OR      EAX,EBX            "  \
"    OR      EAX,EDX            "  \
"    MOV     [EDI],AX           "  \
"    ADD     EDI,2              "  \
"    ADD     ESI,4              "  \
"    DEC     ECX                "  \
"    JNZ     @@l                "

static void RGB555(void *dest,
                   int n,
                   const VSCLR_TPixel *src) {
    DoRGB555(dest, n, src);
}

static void Generic16bit(void *dest,
                        int n,
                        const VSCLR_TPixel *src) {
    word *p = (word *)dest;

    while (n-- > 0) {
        dword s;
        word b;

        s = *src++;
        b = (((s & VSDSF_RMASK) >> (VSDSF_RPOS + VSDSF_RWIDTH - BitInfo.rwidth)) << BitInfo.rpos)
          | (((s & VSDSF_GMASK) >> (VSDSF_GPOS + VSDSF_GWIDTH - BitInfo.gwidth)) << BitInfo.gpos)
          | (((s & VSDSF_BMASK) >> (VSDSF_BPOS + VSDSF_BWIDTH - BitInfo.bwidth)) << BitInfo.bpos);
        *p++ = b;
    }
}

extern void DoRGB0888(void *dest, int n, const VSCLR_TPixel *src);
#pragma aux DoRGB0888 parm [EDI] [ECX] [ESI] modify [EBX EAX EDX] = \
"  @@l:                         "  \
"    MOV     EAX,[ESI]          "  \
"    MOV     EBX,EAX            "  \
"    MOV     EDX,EAX            "  \
"    AND     EAX,0x3FC00000     "  \
"    AND     EBX,0x000FF000     "  \
"    AND     EDX,0x000003FC     "  \
"    SHR     EAX,22-16          "  \
"    SHR     EBX,12-8           "  \
"    SHR     EDX,2              "  \
"    OR      EAX,EBX            "  \
"    OR      EAX,EDX            "  \
"    MOV     [EDI],EAX          "  \
"    ADD     EDI,4              "  \
"    ADD     ESI,4              "  \
"    DEC     ECX                "  \
"    JNZ     @@l                "

static void RGB0888(void *dest,
                    int n,
                    const VSCLR_TPixel *src) {
    DoRGB0888(dest, n, src);
}


static void Generic32bit(void *dest,
                         int n,
                         const VSCLR_TPixel *src) {
    dword *p = (dword *)dest;

    while (n-- > 0) {
        dword s;
        dword b;

        s = *src++;
        b = (((s & VSDSF_RMASK) >> (VSDSF_RPOS + VSDSF_RWIDTH - BitInfo.rwidth)) << BitInfo.rpos)
          | (((s & VSDSF_GMASK) >> (VSDSF_GPOS + VSDSF_GWIDTH - BitInfo.gwidth)) << BitInfo.gpos)
          | (((s & VSDSF_BMASK) >> (VSDSF_BPOS + VSDSF_BWIDTH - BitInfo.bwidth)) << BitInfo.bpos);
        *p++ = b;
    }
}

    // Init.
extern bool VSDS_Init(int rpos, int rwidth,
                      int gpos, int gwidth,
                      int bpos, int bwidth,
                      int bpp) {
    BitInfo.rpos = rpos;
    BitInfo.gpos = gpos;
    BitInfo.bpos = bpos;
    BitInfo.rwidth = rwidth;
    BitInfo.gwidth = gwidth;
    BitInfo.bwidth = bwidth;
    BitInfo.bpp = bpp;

    switch (bpp) {
        case 8:
            VSDS_Function = Generic8bit;
            break;
        case 15:
        case 16:
            if (rpos == 11 && gpos == 5 && bpos == 0)
                VSDS_Function = RGB565;
            else if (rpos == 10 && gpos == 5 && bpos == 0)
                VSDS_Function = RGB555;
            else
                VSDS_Function = Generic16bit;
            break;
        case 24:
            VSDS_Function = GenericNull;
            break;
        case 32:
            if (rpos == 16 && gpos == 8 && bpos == 0)
                VSDS_Function = RGB0888;
            else
                VSDS_Function = Generic32bit;
            break;
        default:
            VSDS_Function = GenericNull;
    }
    return (VSDS_Function != GenericNull);
}

extern void VSDS_End(void) {
    VSDS_Function = GenericNull;
}

VSDS_PDumpFunc VSDS_Function = GenericNull;

VSDS_PDumpFunc VSDS_Functions[VSDSCT_MAX] = {
/*    VSDSCT_8BIT,       */     Generic8bit,
/*    VSDSCT_RGB565,     */     Generic16bit,
/*    VSDSCT_RGB555,     */     Generic16bit,
/*    VSDSCT_BGR565,     */     Generic16bit,
/*    VSDSCT_BGR555,     */     Generic16bit,
/*    VSDSCT_RGB888,     */     NULL,
/*    VSDSCT_RGB0888,    */     Generic32bit,
/*    VSDSCT_BGR888,     */     NULL,
/*    VSDSCT_BGR0888,    */     Generic32bit,
/*    VSDSCT_GENERIC16,  */     Generic16bit,
/*    VSDSCT_GENERIC24,  */     NULL,
/*    VSDSCT_GENERIC32,  */     Generic32bit,
};


// ---------------------------- VSDUMPSC.H -----------------------
#endif