#if 0
// ---------------------------- VSDEPTHL.H -----------------------
// VSpace library
// Written by Javier Arvalo Baeza.
// Defines a list of elements ready for ordering, drawing, etc.

#ifndef _VSDEPTHL_H_
#define _VSDEPTHL_H_

#include "vspoly.h"
#include "vsalgeb.h"

typedef struct VSB_SBitmap *VSB_PBitmap;

#ifdef __cplusplus
extern "C" {
#endif


    // Scene elements.
typedef struct {
    dword           depth;      // Always first field.
    dword           type;       // Always second field.
} VSDL_TElement, *VSDL_PElement;

    // Scene
typedef struct {
    long           maxmem, memused;
    void          *mem;
    dword          mindepth, maxdepth;
    int            maxel, nel;
    VSDL_PElement *s1, *s2;
} VSDL_TScene, *VSDL_PScene;

    // ----------------------------------

    // Specify how much memory and how many elements to handle at one time.
extern bool VSDL_Init(VSDL_PScene s, long maxmem, int maxel);

    // Free mem, etc.
extern void VSDL_End(VSDL_PScene s);

    // Reset current counters: empty the scene.
extern void VSDL_Reset(VSDL_PScene s);

    // Allocate new element from the scene array.
extern VSDL_PElement VSDL_Add(VSDL_PScene s, dword depth, int type, int size);

    // Order pointers to elements into the s1 array.
extern void VSDL_Order(VSDL_PScene s);

// ---------------------
// Sample structures.

typedef struct {
    VSDL_TElement    el;
    int              nv;
    VSPLY_PMaterial  mat;
    dword            flags;
    VSPLY_TPolyPoint p[];
} VSDL_TPolygon, *VSDL_PPolygon;

    // Use this in Add(), as the 'size' parameter.
#define VSDL_SIZEPOLY(n) (sizeof(VSDL_TPolygon) + (n)*sizeof(VSPLY_TPolyPoint))

    // ----

typedef struct {
    VSDL_TElement    el;
    dword            c;
    VSALG_T2DPoint   p;
} VSDL_TDot, *VSDL_PDot;

#define VSDL_SIZEDOT(n) (sizeof(VSDL_TDot))

    // ----

typedef struct {
    VSDL_TElement    el;
    VSB_PBitmap      pb;
    sint32           x, y, w, h;
    int              nsat, n;
    int              r, g, b;
} VSDL_TLight, *VSDL_PLight;

#define VSDL_SIZELIGHT(n) (sizeof(VSDL_TLight))

    // ----

    // Values for the 'type' field in Add().
enum {
    VSDLET_NONE,
    VSDLET_POLY,
    VSDLET_DOT,
    VSDLET_LIGHT,

    VSDLET_USER,
};

#ifdef __cplusplus
}
#endif

#endif

// ---------------------------- VSDEPTHL.H -----------------------
#endif