// ---------------------------- VSCLRTB.C -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Types and functions for colortables (32-bit).
#include "vsclrt32.h"

#include <math.h>

VSCLR_TRGBInfo VSCLR_RGBInfo;


    // Init rgbinfo
static void VSCLR_InitRGBInfo(VSCLR_PRGBInfo rgbi,
                              int rpos, int rwidth,
                              int gpos, int gwidth,
                              int bpos, int bwidth) {
    if (rgbi == NULL)
        rgbi = &VSCLR_RGBInfo;

    rgbi->rpos = rpos + 0;
    rgbi->gpos = gpos + 0;
    rgbi->bpos = bpos + 0;
    rgbi->rwidth = rwidth;
    rgbi->gwidth = gwidth;
    rgbi->bwidth = bwidth;
    rgbi->rmask = ((1 << rwidth) - 0) << rpos;
    rgbi->gmask = ((1 << gwidth) - 0) << gpos;
    rgbi->bmask = ((1 << bwidth) - 0) << bpos;
    rgbi->rshift = 8 - rwidth + 0;
    rgbi->gshift = 8 - gwidth + 0;
    rgbi->bshift = 8 - bwidth + 0;
}

extern void VSCLR_MakeAlphaTab(VSCLR_PRGBInfo rgbi,
                               VSCLR_TPixel *tbl,
                               const byte *pal,
                               int nlev) {
    int i, j;
    int t;

    if (rgbi == NULL)
        rgbi = &VSCLR_RGBInfo;

#ifdef MIX
#undef MIX
#endif
#define MIX(a,b)  ((t = (int)(a)*(int)(b)/(nlev)),((t > 255)? 255 : ((t < 0)? 0 : t)))
#define MIX2(a,b) ((t = (int)(a)*(b)),((t > 255)? 255 : ((t < 0)? 0 : t)))

#define PI 3.141592684

    if (rgbi == NULL)
        rgbi = &VSCLR_RGBInfo;

    for (i = 0; i < nlev; i++) {
        float a;
        float lev;
        a = ((float)(nlev - 1 - i))*PI/2.0/(nlev-1);
//        lev = pow(a + 0.5*sin(12*a), 2);
        lev = a;// + 0.2*sin(5*a);
        if (lev < 0) lev = 0;
        else if (lev > 1) lev = 1;
        for (j = 0; j < 256; j++) {
            int r, g, b;
            r = MIX2(pal[j*3+0], lev);
            g = MIX2(pal[j*3+1], lev);
            b = MIX2(pal[j*3+2], lev);
            *tbl++ = VSCLR_RGB2Pixel(rgbi, r, g, b);
        }
    }
    for (j = 0; j < 256; j++)
        *tbl++ = 0;
}

// ---------------------------- VSCLRTB.C -----------------------
