#if 0
// ---------------------------- VSCAMERA.C -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// 3D Camera handling

#include "vscamera.h"


extern void VSC_SetCamera(VSC_PCamera cam,
                          VSALG_P3DPoint c,
                          VSALG_P3DMatrix m,
                          VSALG_TCoord focus) {
    VSALG_Copy3DVector(&cam->c, c);
    VSALG_Copy3DMatrix(&cam->m, m);
    cam->focus = focus;
}


extern void VSC_SetCameraParms(VSC_PCamera cam, VSV_PViewport v) {
        // Set direction vector.
    cam->dir.x = cam->m.v[0].z;
    cam->dir.y = cam->m.v[1].z;
    cam->dir.z = cam->m.v[2].z;

    VSALG_Transpose(&cam->im, &cam->m);
        // Viewport info.
    cam->cx = v->w/2;
    cam->cy = v->h/2;
    cam->fx = v->rx*cam->focus;
    cam->fy = v->ry*cam->focus;
    cam->xz[0] = cam->fy/( v->h/2);
    cam->xz[1] = cam->fy/(-v->h/2-1);
    cam->xz[2] = cam->fx/( v->w/2);
    cam->xz[3] = cam->fx/(-v->w/2-1);
}

// ---------------------------- VSCAMERA.C -----------------------
#endif