#if 0
// ---------------------------- VSBITMAP.C -----------------------
// VSpace 3d library.
// Designed and written by Javier Arvalo Baeza.
// Types and functions for bitmap & sprite handling.

#include "vsbitmap.h"

static sint32 TempIncESI, TempIncEBP;
static VSV_TPixel *EndEDI;

extern void DrawScanAdd(VSV_TPixel *dest, const byte *src,
                        const VSV_TPixel *tbl,
                        sint32 pos);
#pragma aux DrawScanAdd parm [EDI] [ESI] [EDX] [EAX] modify [EBX ECX] = \
"   PUSH    EBP             " \
"   MOV     EBP,EAX         " \
"   SAR     EAX,16          " \
"   SHL     EBP,16          " \
"   ADD     ESI,EAX         " \
"@@l:                       " \
"   XOR     ECX,ECX         " \
"   MOV     EAX,[TempIncEBP]" \
"   MOV     CL,[ESI]        " \
"   ADD     EBP,EAX         " \
"   MOV     EAX,[ECX*4+EDX] " \
"   MOV     ECX,[TempIncESI]" \
"   ADC     ESI,ECX         " \
"   MOV     EBX,[EDI]       " \
"   AND     EBX,0x3FCFF3FC " \
"   ADD     EDI,4          " \
"   ADD     EAX,EBX        " \
"   TEST    EAX,0xC0300C00 " \
"   JZ      @@c3           " \
"   TEST    EAX,0xC0000000 " \
"   JZ      @@c1           " \
"    OR     EAX,0x3FC00000 " \
"@@c1:                     " \
"   TEST    EAX,0x00300000 " \
"   JZ      @@c2           " \
"    OR     EAX,0x000FF000 " \
"@@c2:                     " \
"   TEST    EAX,0x00000C00 " \
"   JZ      @@c3           " \
"    OR     EAX,0x000003FC " \
"@@c3:                     " \
"   MOV     ECX,[EndEDI]   " \
"   MOV     [EDI-4],EAX    " \
"   CMP     EDI,ECX        " \
"   JB      @@l            " \
"   POP     EBP            "


    // 16.16 coordinates.
extern bool VSB_DrawBitmap(VSV_PViewport v, VSB_PBitmap b,
                           VSV_TPixel *map,
                           sint32 x, sint32 y,
                           sint32 w, sint32 h) {
    sint32 dx, dy, px, py, x0, x1, y0, y1;
    int nx, ny, skipx, skipy;
    VSV_TPixel *dest;
    byte *src;

    if (w <= 4 || h <= 4)
        return FALSE;

    skipx = -x;
    if (skipx < 0)
        skipx = 0;
    x0 = x + skipx;
    x1 = x + w;
    if (x1 > (v->w << 16))
        x1 = (v->w << 16);
    nx = (x1 >> 16) - (x0 >> 16);
    if (nx <= 0)
        return FALSE;
    skipy = -y;
    if (skipy < 0)
        skipy = 0;
    y0 = y + skipy;
    y1 = y + h;
    if (y1 > (v->h << 16))
        y1 = (v->h << 16);
    ny = (y1 >> 16) - (y0 >> 16);
    if (ny <= 0)
        return FALSE;
    dx = FP32Div(b->w, w);
    dy = FP32Div(b->h, h);
    px = FP16Mult(dx, skipx + (~x0 & 0xFFFF));
    py = FP16Mult(dy, skipy + (~y0 & 0xFFFF));
    dest = v->pix + (x0 >> 16) + v->offs*(y0 >> 16);

    TempIncESI = (dx >> 16);
    TempIncEBP = (dx << 16);

    while (ny > 0) {
        src = b->pix + b->w*(py >> 16);
        EndEDI = dest + nx;
        DrawScanAdd(dest, src, map, px);
        dest += v->offs;
        py   += dy;
        ny--;
    }
    return TRUE;
}

extern void VSB_MakeMap(VSV_TPixel *map, int nsat, int n,
                        int r, int g, int b) {
    int i;
    float dr, dg, db;
    float pr, pg, pb;
    float dn;

    if (nsat > n)
        nsat = n;
    dn = 1.0/(float)nsat;
    dr = dn*(float)r;
    dg = dn*(float)g;
    db = dn*(float)b;

    pr = pg = pb = 0;
    for (i = 0; i < nsat; i++) {
        map[i] = VSV_MakePixel((int)pr, (int)pg, (int)pb);
        pr += dr;
        pg += dg;
        pb += db;
    }
    if (i < n) {
        dn = 1.0/(float)(n - i);
        dr = dn*(float)(255 - pr);
        dg = dn*(float)(255 - pg);
        db = dn*(float)(255 - pb);
        for (; i < n; i++) {
            map[i] = VSV_MakePixel((int)pr, (int)pg, (int)pb);
            pr += dr;
            pg += dg;
            pb += db;
        }
    }
}

extern void VSB_MakeDrawBitmap(VSV_PViewport v, VSB_PBitmap pb,
                              sint32 x, sint32 y,
                              sint32 w, sint32 h,
                              int nsat, int n,
                              int r, int g, int b) {
    VSV_TPixel map[256];

    VSB_MakeMap(map, nsat, n, r, g, b);
    VSB_DrawBitmap(v, pb, map, x, y, w, h);
}

// ---------------------------- VSBITMAP.C -----------------------
#endif