
#include "despair.h"
#include "stext.h"
#include "writer.h"

#include "pix.h"
#include "tcscr.h"
#include "llkey.h"
#include "llscreen.h"
#include "text.h"

#define _VSBASE_H_

#include "vspace.h"

#include <stdio.h>

// -------------------------
//TextureMacro MACRO name, b1, b2, dotex, dorgb
//VSTM_DumpScan2100_, B1_2100, B2_2100, 1, 1

#define NLEVBITS  5
#define NLEV (1 << NLEVBITS)

#define  DESTSIZE  4
#define  REPTBITS 4
#define  NREPT   (1 << REPTBITS)


dword IncA   ; 
dword IncA2  ; 
dword IncUV  ; 
dword IncUV2 ; 
dword IncRGB ; 
dword IncRGB2; 
dword counter;
dword VSTM_Dither;
dword VSTM_APos; 
dword VSTM_AInc; 
dword VSTM_RPos; 
dword VSTM_RInc; 
dword VSTM_GPos; 
dword VSTM_GInc; 
dword VSTM_BPos; 
dword VSTM_BInc; 
dword VSTM_UPos; 
dword VSTM_UInc; 
dword VSTM_VPos; 
dword VSTM_VInc; 
dword VSTM_TextureMask;
byte* VSTM_TexturePtr;

void VSTM_DumpScan2000(dest, n)
{
#ifdef USE_ASM
__asm
{
  //TextureMacro MACRO name, b1, b2, dotex, dorgb
  //TextureMacro VSTM_DumpScan2100_, B1_2100, B2_2100, 1, 1

          MOV   EAX, dest
        MOV   EDX, n

  TEST	EDX,EDX
	JLE	LABELret
	PUSHAD
	MOV	EDI,EAX
        DEC     EDX
	MOV	[counter],EDX

        MOV     EDX,[EDI]               ; Cache prefill

 	 ; Prepare increment variables IncA, IncRGB and IncUV

        MOV     ECX,[VSTM_Dither]
        SHL     ECX,15
        ADD     [VSTM_APos],ECX
        SHR     ECX,7
        SUB     ECX,0C0h                ; dither? 0x40 : -3*0x40

	MOV	EDX,[VSTM_AInc]
        SHR     EDX,8
        MOV     EAX,EDX
        SUB     EDX,ECX
        ADD     EAX,ECX
        AND     EDX,0FFFFh
        AND     EAX,0FFFFh
	MOV	[IncA],EDX
	MOV	[IncA2],EAX

	MOV	EAX,[VSTM_VInc]
	MOV	AX,WORD PTR [VSTM_UInc+2]
	MOV	[IncUV],EAX
	MOV	[IncUV2],EAX

        MOV     EAX,[VSTM_RInc]
        MOV     EBX,[VSTM_GInc]
        MOV     ECX,[VSTM_BInc]
        AND     EAX,00FFC000h
        AND     EBX,00FFC000h
        AND     ECX,00FFC000h
        SHL     EAX,20-14
        SHR     EBX,14-10
        SHR     ECX,14-0

        OR      EAX,EBX
        MOV     EBX,[VSTM_GInc]
        OR      EAX,ECX                 ; Unadjusted RGB delta.
        AND     EBX,80000000h
        MOV     ECX,[VSTM_BInc]
        SHR     EBX,32-20
        AND     ECX,80000000h
        SUB     EAX,EBX
        SHR     ECX,32-10
        SUB     EAX,EBX
        MOV     [IncRGB],EAX
        MOV     [IncRGB2],EAX

	 ; Prepare pointers
        MOV     ESI,[VSTM_TexturePtr]

 	 ; Prepare position variables PosA, PosRGB and PosUV
         ; EBX : V.v.U.u             8.8.8.8
         ; ECX : n.0.(1-A).(1.a)     8.8.8.8
         ; ESI : puntero a la textura.
         ; EDI : Destino, como siempre.
         ; EBP : RA.ra.GA.ga.BA.ba   2.5.5.5.5.5.5
         ; EDX esta libre para usarlo como temporal para los deltas.
	MOV	ECX,[VSTM_APos]
        SHR     ECX,8

	MOV	EBX,[VSTM_VPos]
	MOV	BX,WORD PTR [VSTM_UPos+2]

        MOV     EAX,[VSTM_RPos]
        MOV     EDX,[VSTM_GPos]
        MOV     EBP,[VSTM_BPos]
        AND     EAX,00FFC000h
        AND     EDX,00FFC000h
        AND     EBP,00FFC000h
        SHL     EAX,20-14
        SHR     EDX,14-10
        SHR     EBP,14-0
        OR      EAX,EDX
        OR      EBP,EAX

        MOV     EAX,[counter]
        TEST    EAX,EAX
        JZ      LABELquitlp
LABELloop:
        CMP     EAX,NREPT-1
        JL      LABELc1
         MOV    EAX,NREPT-1
    LABELc1:
        INC     EAX
        SHR     EAX,1
        JZ	LABELquitlp
        DEC	EAX
	AND	ECX,0FFFFh
        SHL	EAX,24
        OR	ECX,EAX
  LABELlp:
        MOV     EAX,EBX                         ; 1
        MOV     EDX,[EDI+8]
        SHR     EAX,16                          ; 1
        MOV     EDX,[IncUV]
        MOV     AL,BH                           ; 1
        ADD     EBX,EDX
        MOV     AL,[ESI+EAX]                    ; 1+AGI
        MOV     EDX,[IncA]
        MOV     AH,CH                           ; 1
        ADD     ECX,EDX
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]      ; 1
        MOV     EDX,[IncRGB]
        ADD     EAX,EBP                         ; 1
        ADD     EBP,EDX				; +1?
        MOV     [EDI],EAX                       ; 1
        MOV     EAX,EBX
        SHR     EAX,16                          ; 1
        MOV     EDX,[IncUV2]
        MOV     AL,BH                           ; 1
        ADD     EBX,EDX
        MOV     AL,[ESI+EAX]                    ; 1+AGI
        MOV     EDX,[IncA2]
        MOV     AH,CH                           ; 1
        ADD     ECX,EDX
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]      ; 1
        MOV     EDX,[IncRGB2]
        ADD     EAX,EBP                         ; 1
        ADD     EBP,EDX				; +1?
        MOV     [EDI+4],EAX			; 1
        ADD     EDI,8
        SUB     ECX,(1 SHL 24)			; 1
        JGE     LABELlp
	 ; Total is 20 cycles per pixel.

         ; Make outer loop quit as early as possible.
        MOV     EAX,[counter]
        SUB     EAX,NREPT
        JLE     LABELquitlp
        MOV     [counter],EAX

         ; Readjust position values.
        MOV     EAX,[VSTM_AInc]
        MOV     ECX,[VSTM_RInc]
        SHL     EAX,REPTBITS
        SHL     ECX,REPTBITS
        ADD     [VSTM_APos],EAX
        MOV     EAX,[VSTM_GInc]
        ADD     [VSTM_RPos],ECX
        SHL     EAX,REPTBITS
        MOV     ECX,[VSTM_BInc]
        ADD     [VSTM_GPos],EAX
        SHL     ECX,REPTBITS
        MOV     EAX,[VSTM_UInc]
        ADD     [VSTM_BPos],ECX
        SHL     EAX,REPTBITS
        MOV     ECX,[VSTM_VInc]
        ADD     [VSTM_UPos],EAX
        SHL     ECX,REPTBITS
        ADD     [VSTM_VPos],ECX

	MOV	ECX,[VSTM_APos]
        SHR     ECX,8

 	MOV	EBX,[VSTM_VPos]
	MOV	BX,WORD PTR [VSTM_UPos+2]

        MOV     EAX,[VSTM_RPos]
        MOV     EDX,[VSTM_GPos]
        MOV     EBP,[VSTM_BPos]
        AND     EAX,00FFC000h
        AND     EDX,00FFC000h
        AND     EBP,00FFC000h
        SHL     EAX,20-14
        SHR     EDX,14-10
        SHR     EBP,14-0
        OR      EAX,EDX
        OR      EBP,EAX

        MOV     EAX,[counter]
        JMP     LABELloop
  LABELquitlp:
         ; Usual odd pixel
	TEST	EAX,1
	JNZ	LABELnoodd

        MOV     EAX,EBX
        SHR     EAX,16
        MOV     AL,BH
        MOV     AL,[ESI+EAX]
        MOV     AH,CH
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]
        ADD     EAX,EBP
        MOV     [EDI],EAX
    LABELnoodd:

   LABELbye:
LABELret:
   	POPAD
 }

  /*
  __asm
        {
        MOV   EAX, dest
        MOV   EDX, n
        TEST	EDX,EDX
	      JLE	LABELret
	      PUSHAD
	      MOV	EDI,EAX
              DEC     EDX
              MOV     EAX,[EDI]       ; Cache prefill
	      MOV	[counter],EDX
              JZ      LABELjust1         ; 1-pixel span, don't bother with deltas.

 	 ; Prepare increment variables IncA, IncRGB and IncUV

        //IF dotex
                 ; Calc Alpha increments
                MOV     ECX,[VSTM_Dither]
                SHL     ECX,15
                ADD     [VSTM_APos],ECX
                SHR     ECX,7
                SUB     ECX,0C0h                ; dither? 0x40 : -3*0x40

        	MOV	EDX,[VSTM_AInc]
                SHR     EDX,8
                MOV     EAX,EDX
                SUB     EDX,ECX
                ADD     EAX,ECX
                AND     EDX,0FFFFh
                AND     EAX,0FFFFh
        	MOV	[IncA],EDX
        	MOV	[IncA2],EAX

                 ; Calc texture increments
        	MOV	EAX,[VSTM_VInc]
        	MOV	AX,WORD PTR [VSTM_UInc+2]
        	MOV	[IncUV],EAX
        	MOV	[IncUV2],EAX
        //ENDIF

        //IF dorgb
                MOV     EAX,[VSTM_RInc]
                MOV     EBX,[VSTM_GInc]
                MOV     ECX,[VSTM_BInc]
                AND     EAX,00FFC000h
                AND     EBX,00FFC000h
                AND     ECX,00FFC000h
                SHL     EAX,20-14
                SHR     EBX,14-10
                SHR     ECX,14-0

                 ; Adjust delta
                OR      EAX,EBX
                MOV     EBX,[VSTM_BInc]
                OR      EAX,ECX                 ; Unadjusted RGB delta.
                MOV     ECX,[VSTM_GInc]
                AND     EBX,80000000h
                AND     ECX,80000000h
                SHR     EBX,31-10
                SHR     ECX,31-20
//       SUB     EAX,EBX
//               SUB     EAX,ECX
                MOV     [IncRGB],EAX
                MOV     [IncRGB2],EAX
        //ENDIF

   LABELjust1:

 	 ; Prepare position variables PosA, PosRGB and PosUV
         ; EBX : V.v.U.u             8.8.8.8
         ; ECX : n.0.(1-A).(1.a)     8.8.8.8
         ; ESI : puntero a la textura.
         ; EDI : Destino, como siempre.
         ; EBP : RA.ra.GA.ga.BA.ba   2.5.5.5.5.5.5
         ; EDX esta libre para usarlo como temporal para los deltas.

        //IF dotex
        	 ; Prepare pointers
                MOV     ESI,[VSTM_TexturePtr]

        	MOV	ECX,[VSTM_APos]
                SHR     ECX,8

        	MOV	EBX,[VSTM_VPos]
        	MOV	BX,WORD PTR [VSTM_UPos+2]
        //ENDIF

        //IF dorgb
                MOV     EAX,[VSTM_RPos]
                MOV     EDX,[VSTM_GPos]
                MOV     EBP,[VSTM_BPos]
                AND     EAX,00FFC000h
                AND     EDX,00FFC000h
                AND     EBP,00FFC000h
                SHL     EAX,20-14
                SHR     EDX,14-10
                SHR     EBP,14-0
                OR      EAX,EDX
                OR      EBP,EAX
        //ENDIF

        MOV     EAX,[counter]
        TEST    EAX,EAX
        JZ      LABELquitlp
LABELloop:
        CMP     EAX,NREPT-1
        JL      LABELc1
         MOV    EAX,NREPT-1
    LABELc1:
        INC     EAX
        SHR     EAX,1
        JZ	LABELquitlp
        DEC	EAX
	AND	ECX,0FFFFh
        SHL	EAX,24
        OR	ECX,EAX

        //IF dotex
        //ELSE
        //        MOV     EDX,[IncRGB]
        //        MOV	ESI,[IncRGB2]
        //ENDIF

  LABELlp:
        MOV     EAX,EBX                         ; 1
        MOV     EDX,[EDI+8]
        SHR     EAX,16                          ; 1
        MOV     EDX,[IncUV]
        MOV     AL,BH                           ; 1
        ADD     EBX,EDX
        AND     EAX,[VSTM_TextureMask]
        MOV     AL,[ESI+EAX]                    ; 1+AGI
        MOV     EDX,[IncA]
        MOV     AH,CH                           ; 1
        ADD     ECX,EDX
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]      ; 1
        MOV     EDX,[IncRGB]
        ADD     EAX,EBP                         ; 1
        ADD     EBP,EDX				; +1?
        MOV     [EDI],EAX                       ; 1
        MOV     EAX,EBX
        SHR     EAX,16                          ; 1
        MOV     EDX,[IncUV2]
        MOV     AL,BH                           ; 1
        ADD     EBX,EDX
        AND     EAX,[VSTM_TextureMask]
        MOV     AL,[ESI+EAX]                    ; 1+AGI
        MOV     EDX,[IncA2]
        MOV     AH,CH                           ; 1
        ADD     ECX,EDX
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]      ; 1
        MOV     EDX,[IncRGB2]
        ADD     EAX,EBP                         ; 1
        ADD     EBP,EDX				; +1?
        MOV     [EDI+4],EAX			; 1

        ADD     EDI,8
        SUB     ECX,(1 SHL 24)			; 1
        JGE     LABELlp

         ; Make outer loop quit as early as possible.
        MOV     EAX,[counter]
        SUB     EAX,NREPT
        JLE     LABELquitlp
        MOV     [counter],EAX

         ; Readjust position values.
        //IF dotex
                //IF dorgb
                        MOV     EAX,[VSTM_AInc]
                        MOV     ECX,[VSTM_RInc]
                        SHL     EAX,REPTBITS
                        SHL     ECX,REPTBITS
                        ADD     [VSTM_APos],EAX
                        MOV     EAX,[VSTM_GInc]
                        ADD     [VSTM_RPos],ECX
                        SHL     EAX,REPTBITS
                        MOV     ECX,[VSTM_BInc]
                        ADD     [VSTM_GPos],EAX
                        SHL     ECX,REPTBITS
                        MOV     EAX,[VSTM_UInc]
                        ADD     [VSTM_BPos],ECX
                        SHL     EAX,REPTBITS
                        MOV     ECX,[VSTM_VInc]
                        ADD     [VSTM_UPos],EAX
                        SHL     ECX,REPTBITS
                        ADD     [VSTM_VPos],ECX
                //ELSE
                //        MOV     EAX,[VSTM_AInc]
                //        MOV     ECX,[VSTM_UInc]
                //        SHL     EAX,REPTBITS
                //        SHL     ECX,REPTBITS
                //        ADD     [VSTM_APos],EAX
                //        MOV     EAX,[VSTM_VInc]
                //        ADD     [VSTM_UPos],ECX
                 //       SHL     EAX,REPTBITS
                //        ADD     [VSTM_VPos],EAX
                //ENDIF
        //ELSE
        //        MOV     ECX,[VSTM_RInc]
        //        SHL     ECX,REPTBITS
        //        MOV     EAX,[VSTM_GInc]
        //        ADD     [VSTM_RPos],ECX
        //        SHL     EAX,REPTBITS
        //        MOV     ECX,[VSTM_BInc]
        //        ADD     [VSTM_GPos],EAX
        //        SHL     ECX,REPTBITS
        //        ADD     [VSTM_BPos],ECX
        //ENDIF

        //IF dotex
        	MOV	ECX,[VSTM_APos]
                SHR     ECX,8

         	MOV	EBX,[VSTM_VPos]
        	MOV	BX,WORD PTR [VSTM_UPos+2]
        //ENDIF

        //IF dorgb
                MOV     EAX,[VSTM_RPos]
                MOV     EDX,[VSTM_GPos]
                MOV     EBP,[VSTM_BPos]
                AND     EAX,00FFC000h
                AND     EDX,00FFC000h
                AND     EBP,00FFC000h
                SHL     EAX,20-14
                SHR     EDX,14-10
                SHR     EBP,14-0
                OR      EAX,EDX
                OR      EBP,EAX
        //ENDIF

        MOV     EAX,[counter]
        JMP     LABELloop
  LABELquitlp:
         ; Usual odd pixel
	TEST	EAX,1
	JNZ	LABELnoodd
         MOV     EAX,EBX
        SHR     EAX,16
        MOV     AL,BH
        AND     EAX,[VSTM_TextureMask]
        MOV     AL,[ESI+EAX]
        MOV     AH,CH
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]
        ADD     EAX,EBP
        MOV     [EDI],EAX

    LABELnoodd:

   LABELbye:
   	POPAD
   LABELret:
   	}
*/



/*
  __asm
  {
        MOV   eax, dest
        MOV   edx, n

        TEST	EDX,EDX
	      JLE	LABELret
	      PUSHAD
	      MOV	EDI,EAX
        DEC     EDX
        MOV     EAX,[EDI]       ; Cache prefill
	      MOV	[counter],EDX
        JZ      LABELjust1         ; 1-pixel span, don't bother with deltas.

 	 ; Prepare increment variables IncA, IncRGB and IncUV

//        IF dotex
                 ; Calc Alpha increments
                MOV     ECX,[VSTM_Dither]
                SHL     ECX,15
                ADD     [VSTM_APos],ECX
                SHR     ECX,7
                SUB     ECX,0C0h                ; dither? 0x40 : -3*0x40

        	MOV	EDX,[VSTM_AInc]
                SHR     EDX,8
                MOV     EAX,EDX
                SUB     EDX,ECX
                ADD     EAX,ECX
                AND     EDX,0FFFFh
                AND     EAX,0FFFFh
        	MOV	[IncA],EDX
        	MOV	[IncA2],EAX

                 ; Calc texture increments
        	MOV	EAX,[VSTM_VInc]
        	MOV	AX,WORD PTR [VSTM_UInc+2]
        	MOV	[IncUV],EAX
        	MOV	[IncUV2],EAX
//        ENDIF

        //IF dorgb
                MOV     EAX,[VSTM_RInc]
                MOV     EBX,[VSTM_GInc]
                MOV     ECX,[VSTM_BInc]
                AND     EAX,00FFC000h
                AND     EBX,00FFC000h
                AND     ECX,00FFC000h
                SHL     EAX,20-14
                SHR     EBX,14-10
                SHR     ECX,14-0

                 ; Adjust delta
                OR      EAX,EBX
                MOV     EBX,[VSTM_BInc]
                OR      EAX,ECX                 ; Unadjusted RGB delta.
                MOV     ECX,[VSTM_GInc]
                AND     EBX,80000000h
                AND     ECX,80000000h
                SHR     EBX,31-10
                SHR     ECX,31-20
;                SUB     EAX,EBX
;                SUB     EAX,ECX
                MOV     [IncRGB],EAX
                MOV     [IncRGB2],EAX
        //ENDIF

   LABELjust1:

 	 ; Prepare position variables PosA, PosRGB and PosUV
         ; EBX : V.v.U.u             8.8.8.8
         ; ECX : n.0.(1-A).(1.a)     8.8.8.8
         ; ESI : puntero a la textura.
         ; EDI : Destino, como siempre.
         ; EBP : RA.ra.GA.ga.BA.ba   2.5.5.5.5.5.5
         ; EDX esta libre para usarlo como temporal para los deltas.

        //IF dotex
        	 ; Prepare pointers
                MOV     ESI,[VSTM_TexturePtr]

        	MOV	ECX,[VSTM_APos]
                SHR     ECX,8

        	MOV	EBX,[VSTM_VPos]
        	MOV	BX,WORD PTR [VSTM_UPos+2]
        //ENDIF

        //IF dorgb
                MOV     EAX,[VSTM_RPos]
                MOV     EDX,[VSTM_GPos]
                MOV     EBP,[VSTM_BPos]
                AND     EAX,00FFC000h
                AND     EDX,00FFC000h
                AND     EBP,00FFC000h
                SHL     EAX,20-14
                SHR     EDX,14-10
                SHR     EBP,14-0
                OR      EAX,EDX
                OR      EBP,EAX
        //ENDIF

        MOV     EAX,[counter]
        TEST    EAX,EAX
        JZ      LABELquitlp
LABELloop:
        CMP     EAX,NREPT-1
        JL      LABELc1
         MOV    EAX,NREPT-1
    LABELc1:
        INC     EAX
        SHR     EAX,1
        JZ	LABELquitlp
        DEC	EAX
	      AND	ECX,0FFFFh
        SHL	EAX,24
        OR	ECX,EAX

        //IF dotex
    
  LABELlp:
        //&b1
        //beginm
        MOV     EAX,EBX                         ; 1
        MOV     EDX,[EDI+8]
        SHR     EAX,16                          ; 1
        MOV     EDX,[IncUV]
        MOV     AL,BH                           ; 1
        ADD     EBX,EDX
        AND     EAX,[VSTM_TextureMask]
        MOV     AL,[ESI+EAX]                    ; 1+AGI
        MOV     EDX,[IncA]
        MOV     AH,CH                           ; 1
        ADD     ECX,EDX
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]      ; 1
        MOV     EDX,[IncRGB]
        ADD     EAX,EBP                         ; 1
        ADD     EBP,EDX				; +1?
        MOV     [EDI],EAX                       ; 1
        MOV     EAX,EBX
        SHR     EAX,16                          ; 1
        MOV     EDX,[IncUV2]
        MOV     AL,BH                           ; 1
        ADD     EBX,EDX
        AND     EAX,[VSTM_TextureMask]
        MOV     AL,[ESI+EAX]                    ; 1+AGI
        MOV     EDX,[IncA2]
        MOV     AH,CH                           ; 1
        ADD     ECX,EDX
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]      ; 1
        MOV     EDX,[IncRGB2]
        ADD     EAX,EBP                         ; 1
        ADD     EBP,EDX				; +1?
        MOV     [EDI+4],EAX			; 1

        // endm

        ADD     EDI,8
        SUB     ECX,(1 SHL 24)			; 1
        JGE     LABELlp

         ; Make outer loop quit as early as possible.
        MOV     EAX,[counter]
        SUB     EAX,NREPT
        JLE     LABELquitlp
        MOV     [counter],EAX

         ; Readjust position values.
        //IF dotex
                //IF dorgb
                        MOV     EAX,[VSTM_AInc]
                        MOV     ECX,[VSTM_RInc]
                        SHL     EAX,REPTBITS
                        SHL     ECX,REPTBITS
                        ADD     [VSTM_APos],EAX
                        MOV     EAX,[VSTM_GInc]
                        ADD     [VSTM_RPos],ECX
                        SHL     EAX,REPTBITS
                        MOV     ECX,[VSTM_BInc]
                        ADD     [VSTM_GPos],EAX
                        SHL     ECX,REPTBITS
                        MOV     EAX,[VSTM_UInc]
                        ADD     [VSTM_BPos],ECX
                        SHL     EAX,REPTBITS
                        MOV     ECX,[VSTM_VInc]
                        ADD     [VSTM_UPos],EAX
                        SHL     ECX,REPTBITS
                        ADD     [VSTM_VPos],ECX
    
        //IF dotex
        	MOV	ECX,[VSTM_APos]
                SHR     ECX,8

         	MOV	EBX,[VSTM_VPos]
        	MOV	BX,WORD PTR [VSTM_UPos+2]
        //ENDIF

        //IF dorgb
                MOV     EAX,[VSTM_RPos]
                MOV     EDX,[VSTM_GPos]
                MOV     EBP,[VSTM_BPos]
                AND     EAX,00FFC000h
                AND     EDX,00FFC000h
                AND     EBP,00FFC000h
                SHL     EAX,20-14
                SHR     EDX,14-10
                SHR     EBP,14-0
                OR      EAX,EDX
                OR      EBP,EAX
        //ENDIF

        MOV     EAX,[counter]
        JMP     LABELloop
  LABELquitlp:
         ; Usual odd pixel
	TEST	EAX,1
	JNZ	LABELnoodd
         //&b2
         //B2_2100 MACRO
        MOV     EAX,EBX
        SHR     EAX,16
        MOV     AL,BH
        AND     EAX,[VSTM_TextureMask]
        MOV     AL,[ESI+EAX]
        MOV     AH,CH
        MOV     EAX,[VSTM_AlphaTbl+4*EAX]
        ADD     EAX,EBP
        MOV     [EDI],EAX
        //ENDM


    LABELnoodd:

   	POPAD
   LABELret:
}
*/
#endif
}

typedef dword TPixel;
static int BPP = 32;

#define pal ScrapPal
static byte (*pix)[256];

#define NTAB (VSTM_ANLEV)

#define desttab (VSTM_AlphaTbl[0])

static dword BeginTime;

#define NGREETS 20

static byte *GreetTex[NGREETS];
static dword GreetPal[NGREETS][256];
static int   GreetW[NGREETS];
static int   GreetH[NGREETS];
static int   NumGreet = 0;
static int   GreetScan = -240;

void DrawGrScan(TPixel *dest, int n, byte *tex, int x)
{
	/*int i;
	for (i=0;i<n;i++) {
		dest[i+x]=tex[i];
	}*/
	#ifdef USE_ASM
//#pragma aux DrawGrScan parm [EDI] [ECX] [ESI] [EBX] modify [EAX EDX] = 
__asm
{
              mov     edi, dest
              mov     ecx, n
              mov     esi, tex
              mov     ebx, x

              MOV     EAX,[NumGreet]     
              SHL     EAX,10             
              MOV     EDX,OFFSET GreetPal
              ADD     EDX,EAX            
              LEA     EDI,[EDI+EBX*4]    
  LABELlp:        XOR    EAX,EAX            
               MOV    EBX,[EDI]          
               MOV    AL,[ESI]           
               AND    EBX,0x3FCFF3FC     
               ADD    EDI,4              
               INC    ESI                
               MOV    EAX,[EDX+EAX*4]    
               AND    EAX,0x3FCFF3FC     
               ADD    EAX,EBX            
               TEST   EAX,0xC0300C00     
               JZ     LABELc3               
               TEST   EAX,0xC0000000     
               JZ     LABELc1               
                OR    EAX,0x3FC00000     
            LABELc1:                        
               TEST   EAX,0x00300000     
               JZ     LABELc2               
                OR    EAX,0x000FF000     
            LABELc2:                        
               TEST   EAX,0x00000C00     
               JZ     LABELc3               
                OR    EAX,0x000003FC     
            LABELc3:                        
               DEC    ECX                
               MOV    [EDI-4],EAX        
               JNZ    LABELlp               
}
#endif
}

/*
{
    int i;

    for (i = 0; i < n; i++, x++)
        dest[x] = TCS_AddPixel(dest[x], GreetPal[NumGreet][tex[i]]);
}
*/

static void DrawGreet(int x, int y, byte *tex, int w, int h)
{
    int i;

    for (i = 0; i < h; i++, y++)
        if (y >= 0 && y < TCS_Height)
            DrawGrScan(&TCS_Screen[320*y], w, tex + w*i, x);
}


static void DrawScan(TPixel *dest, int n, byte *tex, TPixel *tab,
              sint32 u, sint32 u2, sint32 v, sint32 v2,
              sint32 a, sint32 a2, sint32 r, sint32 r2,
              sint32 g, sint32 g2, sint32 b, sint32 b2,
              bool dith) {
    sint32 ir, ig, ib, ia, iu, iv;

    r = FP8Mult(r, a);
    g = FP8Mult(g, a);
    b = FP8Mult(b, a);

    r2 = FP8Mult(r2, a2);
    g2 = FP8Mult(g2, a2);
    b2 = FP8Mult(b2, a2);

    a *= NTAB;
    a2 *= NTAB;

    ir = ((r2-r)/n);
    ig = ((g2-g)/n);
    ib = ((b2-b)/n);
    iv = ((v2-v)/n);
    iu = ((u2-u)/n);
    ia = ((a2-a)/n);

    VSTM_APos = a << 0;
    VSTM_RPos = r << 0;
    VSTM_GPos = g << 0;
    VSTM_BPos = b << 0;
    VSTM_UPos = u << 8;
    VSTM_VPos = v << 8;

    VSTM_AInc = ia << 0;
    VSTM_RInc = ir << 0;
    VSTM_GInc = ig << 0;
    VSTM_BInc = ib << 0;
    VSTM_UInc = iu << 8;
    VSTM_VInc = iv << 8;

    VSTM_Dither = dith;
    VSTM_TexturePtr = tex;
    VSTM_TextureMask = 0xFFFF;

    VSTM_DumpScan2000(dest, n);
}

static bool DoTmap32(dword time) {
    TPixel *p, *q;
    int i;
    float angle = (float) ((time-BeginTime)/2.0);
    float  r0 = (float) ((cos(0.012*angle+0.2)/2.4)+0.5),
           r1 = (float) ((cos(0.025*angle+1.7)/2.4)+0.5),
           r2 = (float) ((cos(0.010*angle+3.2)/2.4)+0.5),
           r3 = (float) ((cos(0.031*angle+0.9)/2.4)+0.5),
           g0 = (float) ((cos(0.013*angle+2.2)/2.4)+0.5),
           g1 = (float) ((cos(0.020*angle+9.0)/2.4)+0.5),
           g2 = (float) ((cos(0.014*angle+1.1)/2.4)+0.5),
           g3 = (float) ((cos(0.011*angle+3.3)/2.4)+0.5),
           b0 = (float) ((cos(0.018*angle+0.0)/2.4)+0.5),
           b1 = (float) ((cos(0.042*angle+2.2)/2.4)+0.5),
           b2 = (float) ((cos(0.009*angle+5.2)/2.4)+0.5),
           b3 = (float) ((cos(0.016*angle+1.0)/2.4)+0.5),
           a0 = (float) ((cos(0.032*angle+3.1)/2.4)+0.5),
           a1 = (float) ((cos(0.002*angle+0.3)/2.4)+0.5),
           a2 = (float) ((cos(0.022*angle+2.0)/2.4)+0.5),
           a3 = (float) ((cos(0.013*angle+0.2)/2.4)+0.5);

    sint32 u, v, du, dv;

    q = TCS_Screen;

    du = (long) ( (0.9*cos(0.005*angle)+1)*cos((2*sin(0.0033*angle)+0.005*angle))*65536/2 * 2);
    dv = (long) (((0.9*cos(0.005*angle)+1)*sin((2*cos(0.0033*angle)+0.005*angle))*65536/2 * 2) * (6.0 / 5));

    u = (long) ( 32768+4*256*8192*cos(0.0057*angle));
    v = (long) ((32768+4*256*8192*sin(0.004 *angle)) * (6.0 / 5));

#define TCS_SizeX TCS_Width
#define TCS_SizeY TCS_Height

    u += -TCS_SizeX*du + TCS_SizeY*dv;
    v += -TCS_SizeX*dv - TCS_SizeY*du;

    for (i = 0; i < TCS_SizeY; i+=1, q += TCS_SizeX) {
            // Initial/final values for a, r, g, b.
        float ri, gi, bi, ai, rf, gf, bf, af;
        ai = a0 + (a3 - a0)*i/TCS_SizeY;
        ri = r0 + (r3 - r0)*i/TCS_SizeY;
        gi = g0 + (g3 - g0)*i/TCS_SizeY;
        bi = b0 + (b3 - b0)*i/TCS_SizeY;
        af = a1 + (a2 - a1)*i/TCS_SizeY;
        rf = r1 + (r2 - r1)*i/TCS_SizeY;
        gf = g1 + (g2 - g1)*i/TCS_SizeY;
        bf = b1 + (b2 - b1)*i/TCS_SizeY;

        p = q;

        DrawScan(p, TCS_SizeX, pix, desttab,
                 u, u+TCS_SizeX/1*du,
                 v, v+TCS_SizeX/1*dv,
                 ai*65536, af*65536, ri*65536, rf*65536,
                 gi*65536, gf*65536, bi*65536, bf*65536,
                 (i>>0)&1);
        u -= dv;
        v += du;
    }

    {
        int gr;

        GreetScan = (time-BeginTime)/4 - 270;

#define GRHEIGHT 35
        gr = GreetScan / GRHEIGHT;
        gr--;
        for (; gr < NGREETS; gr++)
        {
            if (gr >= 0 && gr < NGREETS)
            {
                NumGreet = gr;
                if (gr & 1)
                {
                    DrawGreet((310 - GreetW[gr]), gr * GRHEIGHT - GreetScan, GreetTex[gr], GreetW[gr], GreetH[gr]);
                }
                else
                {
                    DrawGreet(10, 160 + GreetScan - gr * GRHEIGHT, GreetTex[gr], GreetW[gr], GreetH[gr]);
                }
            }
            if (gr * GRHEIGHT - GreetScan > 200)
                break;
        }
        GreetScan++;
    }

        // Antialias
    if (TCS_Bpp > 16) {
        for (i = (TCS_SizeY-1)*TCS_SizeX
          , p = TCS_Screen
          , q = TCS_Screen + TCS_SizeX;
         i > 0;
         i--, p++, q++)
        *p = (
              (*p & 0x3FCFF3FC) + (p[1] & 0x3FCFF3FC)
             +(*q & 0x3FCFF3FC) + (q[1] & 0x3FCFF3FC)
             ) >> 2;
        for (i = TCS_SizeY-1, p = TCS_Screen; i >= 0; i--) {
            *p = 0;
            p += TCS_SizeX;
        }
    }

//    DoText(time - BeginTime);
    DoWriter(time - BeginTime);

    TCS_Dump(TCS_Screen, 0, TCS_Height);

    return TRUE;
}

extern bool LoadTmap32(dword time) {
    int i, j;
    static byte gpal[NGREETS][768];

    //LLS_Init(LLSM_DIRECT, LLS_VMode);   // Free the mem.

    REQUIRE( (pix = NEW(256*256)) != NULL);
    PIX_Load("GFX\\feedback.gif", pix, pal, NULL, NULL, FALSE);

    for (i = 0; i < NGREETS; i++)
        REQUIRE( (GreetTex[i] = NEW(256*64)) != NULL);

    PIX_Load("GFX\\GREET\\gre.gif", GreetTex[ 0], gpal[ 0], &GreetW[ 0], &GreetH[ 0], TRUE);
    PIX_Load("GFX\\GREET\\ami.gif", GreetTex[ 1], gpal[ 1], &GreetW[ 1], &GreetH[ 1], TRUE);
    PIX_Load("GFX\\GREET\\cap.gif", GreetTex[ 2], gpal[ 2], &GreetW[ 2], &GreetH[ 2], TRUE);
    PIX_Load("GFX\\GREET\\cen.gif", GreetTex[ 3], gpal[ 3], &GreetW[ 3], &GreetH[ 3], TRUE);
    PIX_Load("GFX\\GREET\\clo.gif", GreetTex[ 4], gpal[ 4], &GreetW[ 4], &GreetH[ 4], TRUE);
    PIX_Load("GFX\\GREET\\fue.gif", GreetTex[ 5], gpal[ 5], &GreetW[ 5], &GreetH[ 5], TRUE);
    PIX_Load("GFX\\GREET\\gob.gif", GreetTex[ 6], gpal[ 6], &GreetW[ 6], &GreetH[ 6], TRUE);
    PIX_Load("GFX\\GREET\\hex.gif", GreetTex[ 7], gpal[ 7], &GreetW[ 7], &GreetH[ 7], TRUE);
    PIX_Load("GFX\\GREET\\isp.gif", GreetTex[ 8], gpal[ 8], &GreetW[ 8], &GreetH[ 8], TRUE);
    PIX_Load("GFX\\GREET\\mir.gif", GreetTex[ 9], gpal[ 9], &GreetW[ 9], &GreetH[ 9], TRUE);
    PIX_Load("GFX\\GREET\\mis.gif", GreetTex[10], gpal[10], &GreetW[10], &GreetH[10], TRUE);
    PIX_Load("GFX\\GREET\\mov.gif", GreetTex[11], gpal[11], &GreetW[11], &GreetH[11], TRUE);
    PIX_Load("GFX\\GREET\\nov.gif", GreetTex[12], gpal[12], &GreetW[12], &GreetH[12], TRUE);
    PIX_Load("GFX\\GREET\\sci.gif", GreetTex[13], gpal[13], &GreetW[13], &GreetH[13], TRUE);
    PIX_Load("GFX\\GREET\\spl.gif", GreetTex[14], gpal[14], &GreetW[14], &GreetH[14], TRUE);
    PIX_Load("GFX\\GREET\\the.gif", GreetTex[15], gpal[15], &GreetW[15], &GreetH[15], TRUE);
    PIX_Load("GFX\\GREET\\tlo.gif", GreetTex[16], gpal[16], &GreetW[16], &GreetH[16], TRUE);
    PIX_Load("GFX\\GREET\\vpt.gif", GreetTex[17], gpal[17], &GreetW[17], &GreetH[17], TRUE);
    PIX_Load("GFX\\GREET\\wah.gif", GreetTex[18], gpal[18], &GreetW[18], &GreetH[18], TRUE);
    PIX_Load("GFX\\GREET\\zor.gif", GreetTex[19], gpal[19], &GreetW[19], &GreetH[19], TRUE);

    for (j = 0; j < NGREETS; j++)
        for (i = 0; i < 256; i++) {
            GreetPal[j][i] = ((int)gpal[j][i*3] << 22) + ((int)gpal[j][i*3+1] << 12) + ((int)gpal[j][i*3+2] << 2);
        }
    VSCLR_InitRGBInfo(NULL,
                VSDSF_RPOS+2, VSDSF_RWIDTH-2,
                VSDSF_GPOS+2, VSDSF_GWIDTH-2,
                VSDSF_BPOS+2, VSDSF_BWIDTH-2);
    VSCLR_MakeAlphaTab(&VSCLR_RGBInfo, VSTM_AlphaTbl[0], pal,  NTAB);

    InitWriter("ENDTEXT.TXT");
    InitInks();

    return TRUE;
}

extern bool InitTmap32(dword time) {
    int i, j;

    BeginTime = time;

    if ( (i = BASE_CheckArg("bpp")) > 0)
        BPP = atoi(ArgV[i]);

    if (
        !TCS_Init(320, 200, 32)
     /*&& !TCS_Init(320, 200, 32)
     && !TCS_Init(320, 200, 16)
     && !TCS_Init(320, 200, 15)
     && !TCS_Init(320, 200, 8))*/ ){
        BASE_Abort("You suck.\n");
    }

    CurFunction = DoTmap32;

    return TRUE;
}

extern bool EndTmap32(dword time) {
    TCS_End(-1);
    DISPOSE(pix);

    EndWriter();

    CurFunction = NULL;
    return TRUE;
}
