
#ifndef _TCSCR_H_
#define _TCSCR_H_

#include "base.h"

#ifdef __cplusplus
extern "C" {
#endif

enum {
    TCSCRRGB,
    TCSCRBGR,
};

typedef dword TCS_TPixel, *TCS_PPixel;

#define TCS_MAKEPIX(r,g,b) ((((byte)(r)) << 22) | (((byte)(g)) << 12) | (((byte)(b)) << 2))

extern int TCS_Bpp;
extern int TCS_ColorMode;

extern TCS_TPixel *TCS_Screen;
extern int       TCS_Width;
extern int       TCS_Height;
extern int       TCS_Size;

extern bool TCS_Init(int w, int h, int bpp);

extern void TCS_End(int mode);

extern void TCS_Dump(const TCS_TPixel *org, int miny, int maxy);

extern int TCS_SetPage(int page);

    // Handy functions.

    // Two versions: the first is faster if the input values can't be
    // ensured to be in the range, and most of the times there's no
    // overflow. The "safe" one performs two ANDs that might not be
    // necessary, but doesn't have to make extra corrections when
    // saturating.

static dword TCS_AddPixel(dword scr, dword add_)
{
  //assert(!"TEST");
  int ireturn;
  __asm
  {
       MOV     EAX, scr
       MOV     EBX, add_
       AND     EAX,0x3FCFF3FC
       AND     EBX,0x3FCFF3FC 
       ADD     EAX,EBX        
       TEST    EAX,0xC0300C00
       JZ      c3
       TEST    EAX,0xC0000000 
       JZ      c1           
        OR     EAX,0x3FC00000 
      c1:                     
       TEST    EAX,0x00300000 
       JZ      c2           
        OR     EAX,0x000FF000 
     c2:                     
       TEST    EAX,0x00000C00 
       JZ      c3           
        OR     EAX,0x000003FC 
     c3:                    
       mov     ireturn, eax
  }

  return ireturn;
}
/*#pragma aux  TCS_AddPixel parm [EAX] [EBX] modify nomemory value [EAX] = \
"   AND     EAX,0x3FCFF3FC " \
"   AND     EBX,0x3FCFF3FC " \
"   ADD     EAX,EBX        " \
"   TEST    EAX,0xC0300C00 " \
"   JZ      @@c3           " \
"   TEST    EAX,0xC0000000 " \
"   JZ      @@c1           " \
"    OR     EAX,0x3FC00000 " \
"@@c1:                     " \
"   TEST    EAX,0x00300000 " \
"   JZ      @@c2           " \
"    OR     EAX,0x000FF000 " \
"@@c2:                     " \
"   TEST    EAX,0x00000C00 " \
"   JZ      @@c3           " \
"    OR     EAX,0x000003FC " \
"@@c3:                     "
*/

/*
extern dword TCS_SubPixel(dword scr, dword add);
#pragma aux  TCS_SubPixel parm [EAX] [EBX] modify nomemory value [EAX] = \
"   AND     EAX,0x3FCFF3FC " \
"   AND     EBX,0x3FCFF3FC " \
"   ADD     EAX,EBX        " \
"   TEST    EAX,0xC0300C00 " \
"   JZ      @@c3           " \
"   TEST    EAX,0xC0000000 " \
"   JZ      @@c1           " \
"    OR     EAX,0x3FC00000 " \
"@@c1:                     " \
"   TEST    EAX,0x00300000 " \
"   JZ      @@c2           " \
"    OR     EAX,0x000FF000 " \
"@@c2:                     " \
"   TEST    EAX,0x00000C00 " \
"   JZ      @@c3           " \
"    OR     EAX,0x000003FC " \
"@@c3:                     "
*/


#ifdef __cplusplus
}
#endif



#endif

