#if 0
#include "despair.h"

#include "llscreen.h"
#include "llkey.h"
#include "pix.h"

#include <math.h>
#include <stdio.h>

#define PI 3.14159264f

typedef struct {
    byte angle;
    byte rad;
} TAngTab;

typedef struct {
    dword disp;
} TRadTab;

#define MAXDISP (128)

#define TEXW 256


static void BuildTables(TAngTab *tb, TRadTab *rd) {
    int i, j;
    float rad, ang;
    float maxrad = 0;

    for (i = -100; i < 100; i++) {
        for (j = -128; j < 128; j++) {
            rad = (float)sqrt(i*i+j*j);
            ang = 3.0f*PI/2-(float) atan2((i+0*(float) cos(j*PI/140))*PI/100, (j+0*(float)sin(i*PI/100))*PI/100);
            tb->angle = (unsigned char) (ang*128/PI);// + 192*(cos((rad)*PI/80));
            tb->rad   = (unsigned char) (rad+0*(1+cos((i+j)*PI/100)));
/*
            rad = sqrt(i*i+j*j);
            ang = 3.0*PI/2-atan2((i+40*cos(j*PI/140))*PI/100, (j+70*sin(i*PI/100))*PI/100);
            tb->angle = ang*128/PI;// + 192*(cos((rad)*PI/80));
            tb->rad   = (rad+20*(1+cos((i+j)*PI/100)));
*/

//            tb->angle = (i+100);
//            tb->rad   = (j+128);
            if (maxrad < rad)
                maxrad = rad;
            tb++;
        }
    }

    for (j = -MAXDISP/2+1; j <= MAXDISP/2; j++) {
        for (i = 0; i < 256; i++) {
            rd->disp = TEXW*(int)(j*cos(i*PI/128)) + (int)(j*sin(i*PI/128));
            rd++;
        }
    }
}

static void DrawRipple(byte *dest, const byte *tex, TAngTab *angtb, TRadTab *radtb, byte *radd, byte *gadd) {
    int i, j, k;

    k = 0;
    for (i = 0; i < 200; i++) {
        for (j = 0; j < 256; j++) {
            byte c;

            c = tex[(k + radtb[(((byte)(angtb->angle+64)) + 256*gadd[angtb->rad])].disp + radtb[(angtb->angle + 256*radd[angtb->rad])].disp) & 65535];
//            c = tex[(k + radtb[(angtb->angle + 256*radd[angtb->rad])].disp) & 65535];
            *dest = c;
            dest++;
            angtb++;
            k++;
        }
        dest += 320-256;
    }
}

static byte *tex;
static TAngTab *angtb;
static TRadTab *radtb;
static byte radd[256];
static byte gadd[256];
int    basetime = 0;


static bool DoRipple(dword time) {
    int i;
    float maxr, maxg;

    time -= basetime;

    maxr = (MAXDISP/2-0.5f)*(1-(float) cos((float)(time)*PI/874.0f))/2;
    maxg = (MAXDISP/2-0.5f)*(1-(float) cos((float)(time)*PI/554.0f))/2;

    for (i = 0; i < SIZEARRAY(radd); i++) {
        int r;

        r = (int) (maxr*(1.0f+(float)sin((float)((-(int) time)+i)*PI/64.0f))/2);
//        r = r*(i*i/400.0)/((i*i/400.0)+1);
        r += MAXDISP/2;
        radd[i] = r;
        r = (int) (maxg*((float) sin((float)((-(int) time)+i)*PI/44.0f))/2);
        r += MAXDISP/2;
        gadd[i] = r;
    }
    DrawRipple(LLS_Screen[0] + 32, tex, angtb, radtb, radd, gadd);

    SplitDump();
    //LLS_Update();
    return TRUE;
}

extern bool InitRipple(dword time) {

    angtb = NEW(TEXW*200*sizeof(*angtb));
    REQUIRE(angtb != NULL);
    radtb = NEW(256*MAXDISP*sizeof(*radtb));
    REQUIRE(radtb != NULL);

    BuildTables(angtb, radtb);

    memset(LLS_Screen[0], 0, 320*200);

    tex = NEW(65536);
    REQUIRE(tex != NULL);
    memset(tex, 0, 65536);
    PIX_Load("GFX\\ripp2.gif", tex, DestPal, NULL, NULL, FALSE);
    VGA_DumpPalette(DestPal, 0, 256);
    basetime = time;
    CurFunction = DoRipple;
    return TRUE;
}

extern bool EndRipple(dword time) {
    DISPOSE(tex);
    DISPOSE(radtb);
    DISPOSE(angtb);
    CurFunction = NULL;
    return TRUE;
}
#endif