/*
    PLASMA.CPP.
   C  pcc  襬 VGA p.
   H室 䠩:
                     VGA.DRV - pp VGA p
                     FIRE.COL - p 
   Copyright (C) 1994 by D.J. Wolf/Nimbus Studio Labs, Moscow, Russia.
   All rights reserved.
   tel.(095) 941-5065 (ask Andrew).
*/

#include <mtools.hpp>        // 䠩  襩 ⥪ Multimedia Toolkits v1.0.
#include <graphics.hpp>      //     cc⢥(c 
                             //y c c ;)
#include <mtfile.hpp>
#include <psts4.hpp>

#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/stat.h>
#include <mem.h>
#include <dos.h>
#include <alloc.h>

#include "nsdemo.hpp"

//p p  p⠫.
#define MAX_X_SIZE 320

//p pp c 뢮.
#define MAX_X_DIST 80
#define MAX_Y_DIST 50

// 䠩 p.
#define PLACOL01 "plasma.col"

// 䠩    䥪 N2.
#define PLADAT02 "plasma2.dat"

// 䠩 p   pcc N2
#define PLACOL02 "plasma2.col"

// 䠩    䥪 N3.
#define PLADAT03 "plasma3.dat"

// 䠩 p   pcc N3.
#define PLACOL03 "plasma3.col"

//c쭮 c cy 梥⮢.
#define MAX_COLORS 256

#define F 2.0
#define xadj (width/2)
#define yadj (height/2)
#define round(q) ((long)(q)+0.5)

// cyc  .
char bySinTab1[255],bySinTab2[255];

//Hyp p Multimedia Toolkits v1.0.
//pc p⮢ pc pp  Mono  Color p.
extern unsigned far _wPortCRC;

//p楤yp yc⠭ pcp p.
void SetupVideoModeEx()
  {
   outport(_wPortCRC-0x10,0x1000);    //Cp cpc. (p饭  0x3x4).
   outport(_wPortCRC-0x12,0x23);      //c p⠫쭮 pp⪨ - 14MHz
				      //200 cp  p. (p饭  0x3x2)
   outport(_wPortCRC-0x10,0x3000);    //Cp cpc. (p饭  0x3x4).
  }

//p楤yp p  (䥪 1).
// pyc  ⮬ c  nsfirst.vol.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int Plasma1()
   {
    char byColorMap[768];                 //⥫  py.
    unsigned wColor;                      //ypy騩 梥 窨.
    unsigned wIndex11,wIndex12;           //c  cc bySinTab1  bySinTab2.
    unsigned wIndex21,wIndex22;           //c  cc bySinTab1  bySinTab2.
    unsigned BufferSeg;                   //C py쭮 p.

    //⥭ p.
    MTFile *file=new MTFile(PLACOL01,MT_READ_ONLY);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",PLACOL01);
	delete file;
	return FALSE;
       }

    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)&byColorMap;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=768l;

    if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)768l))
       {
	CloseGraph();
	printf("\nCan't read file 'plasma.col'!");
	delete file;
	return FALSE;
       }
    delete file;

    //뤥塞   py p.
    if (!MakeVirtualScreen(&Scr,320,MAX_Y_DIST*4,MEM_STANDARD))
       {
	CloseGraph();
	printf("\nNot enough memory!");
	return FALSE;
       }

    //c ⠡ cyc.
    for (unsigned i=0;i<255;i++)
      {
       bySinTab1[i]=sin(2*3.1415*i/255)*128+128;
       bySinTab2[i]=cos(2*3.1415*i/255)*128+128;
      }

    //樠 pc p.
    InitGraph("vga.drv",0);
    if (GraphResult()!=GRAPH_NO_ERROR)
       {
	DeleteVirtualScreen(&Scr);
	printf("\nCan't setup video mode or can't find driver 'vga.drv'!");
	return FALSE;
       }

    //頥 py.
    ClearColorMap();

    wIndex11=50;
    wIndex12=90;

    BufferSeg=FP_SEG((char huge*)Scr.RasterData.lpRealAddress);

    //頥 py p.
    SetActiveScreen(VIRTUAL_SCREEN,&Scr);
    ClearScreen();

    unsigned long dwLength;
    int nFade=0;

    dwLength=0l;

    do
      {
       if (nFade<64)
	  {
	   // py.
	   FadeColorMapOnce(byColorMap,ON,0,256);
	   nFade++;
	  }

       if (dwLength>136l*dwP5)
	  {
	   //c py.
	   FadeColorMapOnce(byColorMap,OFF,0,256);
	   nFade++;
	  }

       wIndex11++;
       wIndex12++;

       for(unsigned y=0;y<MAX_Y_DIST;y++)
	 {
	  wIndex21=bySinTab1[(y+wIndex11)%255];
	  wIndex22=bySinTab1[wIndex12%255];
	  _DI=y*320*4+FP_OFF((char huge*)Scr.RasterData.lpRealAddress);
	  asm {
	       push es
	       push di
	       push word ptr BufferSeg
	       pop es                                //es:di - y⥫  .
	       mov cx,MAX_X_DIST                     //cx-pp p  Y/4.
	      };
	  Label1:
	       //c 梥 c.
	       _AX=(bySinTab1[(_CX+wIndex21)%255]+bySinTab2[(y+wIndex22)%255])%255;
	  asm {
	       mov ah,al
	       stosw                          //cy 4 窨 
	       stosw                          //梥  .
	       loop Label1                    //   c cp.
	       pop si
	      };
	  //py y祭y cpy  3 p.
	  asm {
	       push ds
	       push es
	       pop ds                         //ds=es=c .
	       mov dx,3                       //c py cp.
	      };
	  Label2:
	  asm {
	       push si
	       mov cx,MAX_X_SIZE
	       repnz movsb                    //py cpy.
	       pop si
	       dec dx
	       jnz Label2:
	       pop ds
	       pop es
	      };
	 }

       //뢮 p  p.
       SetActiveScreen(DISPLAY);
       ScreenToDisplay(&Scr,0,0,320,200,0,0,COPY_PUT);

       dwLength++;
      }
    while(!kbhit() && dwLength<200l*dwP5);          //   py y.

    FadeColorMap(byColorMap,OFF,0,256,3);

    DeleteVirtualScreen(&Scr);
    return TRUE;
   }


//p楤yp p樨 室    䥪 N2.
// c뢠c  䠩 c  PLADAT02.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int GenPlasma2Data()
   {
    //C 䠩..
    MTFile *file=new MTFile(PLADAT02);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't create file %s !",PLADAT02);
	delete file;
	return FALSE;
       }

    randomize();

    //뤥塞    .
    char huge *data;
    if ((data=(char*)farmalloc(70000l))==NULL)
	{
	 CloseGraph();
	 printf("Not enough free memory.\n\n");
	 delete file;
	 return FALSE;
	}

    //c塞 室 .
    for (float x=0; x<256; x++)
    for (float y=0; y<256; y++)
     {
      data[x+256*y]=83*(3+(cos(0.09*sqrt((x-128)*(x-128)+(y-128)*(y-128))))+
		    cos(x/21.0)+cos(y/26.0))+1;

//      if (data[x+256*y]==0) data[x+256*y]=1;
     }

    //c뢠 䠩.
    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)data;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=70000l;

    if (!file->Write(&TmpBlk,(unsigned long)0l,(unsigned long)35000l))
       {
	CloseGraph();
	printf("\nCan't write file %s !",PLADAT02);
	delete file;
	farfree(data);
	return FALSE;
       }

    if (!file->Write(&TmpBlk,(unsigned long)35000l,(unsigned long)35000l))
       {
	CloseGraph();
	printf("\nCan't write file %s !",PLADAT02);
	delete file;
	farfree(data);
	return FALSE;
       }
    delete file;
    farfree(data);

    //C py.
    file=new MTFile(PLACOL02);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't create file %s !",PLACOL02);
	delete file;
	return FALSE;
       }

    char byColorMap[768];

    byColorMap[0]=byColorMap[1]=byColorMap[2]=0;

    for (int i=0; i<256; i++)
	{
	 byColorMap[i*3]=(char)(sin(i*M_PI*2/64)*31.0+31);
	 byColorMap[i*3+1]=(char)(sin(i*M_PI*2/128)*31.0+31);
	 byColorMap[i*3+2]=(char)(sin(i*M_PI*2/256)*31.0+31);
	}

/*    byColorMap[0]-=20;
    byColorMap[1]-=10;
    byColorMap[2]-=5;*/

    //c뢠 䠩.
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)&byColorMap;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=768l;

    if (!file->Write(&TmpBlk,(unsigned long)0l,(unsigned long)768l))
       {
	CloseGraph();
	printf("\nCan't write file %s !",PLACOL02);
	delete file;
	farfree(data);
	return FALSE;
       }
    delete file;

    return TRUE;
   }

//p楤yp p  (䥪 2).
//Special thanks to Thomas Hagen.
// pyc  ⮬ c  nsfirst.vol.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int Plasma2()
   {
    char byColorMap[768];

    //p뢠 䠩 .
    MTFile *file=new MTFile(PLADAT02,MT_READ_ONLY);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",PLADAT02);
	delete file;
	return FALSE;
       }


    //뤥塞    .
    char huge *data;
    if ((data=(char*)farmalloc(70000l))==NULL)
	{
	 CloseGraph();
	 printf("Not enough free memory.\n\n");
	 delete file;
	 return FALSE;
	}

    //⠥ 䠩.
    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)data;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=70000l;

    if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)70000l))
       {
	CloseGraph();
	printf("\nCan't read file %s !",PLADAT02);
	delete file;
	farfree(data);
	return FALSE;
       }

    delete file;

    //⥭ p.
    file=new MTFile(PLACOL02,MT_READ_ONLY);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",PLACOL02);
	delete file;
	return FALSE;
       }

    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)&byColorMap;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=768l;

    if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)768l))
       {
	CloseGraph();
	printf("\nCan't read file %s !",PLACOL02);
	delete file;
	return FALSE;
       }
    delete file;

    //樠 pc p.
    InitGraph("vga.drv",0);
    if (GraphResult()!=GRAPH_NO_ERROR)
       {
	farfree(data);
	printf("\nCan't setup video mode or can't find driver 'vga.drv'!");
	return FALSE;
       }

    int nFade=0;

    //頥 py.
//    ClearColorMap();
    SetColorMap(byColorMap);

    for (float teller=0;teller<400*dwP5; teller++)
      {
/*       if (nFade<64)
	  {
	   // py.
	   FadeColorMapOnce(byColorMap,ON,0,256);
	   nFade++;
	  }*/

       if (teller>(400-64)*dwP5)
	  {
	   //c py.
	   FadeColorMapOnce(byColorMap,OFF,0,256);
	   nFade++;
	  }

       //c c  cc Data.
       int pl1=48+cos(teller/37)*47.0+256*(int)(48+47*(sin(teller/31)));
       int pl2=48+sin(teller/24)*47.0+256*(int)(48+47*(cos(teller/19)))-pl1;

       //p p.
       asm {
	    mov ax,0a000h
	    mov es,ax
	    xor di,di                    //es:di - y⥫  .

	    push ds
	    lds si,data                  //ds:si - y⥫  .
	    add si,pl1                   //p塞 1- c.
	    mov bx,pl2                   //bx=2- c.
	    pusha
	    mov cl,100                   //c cp  p/2
	   };

       Plasma2L1:
       asm mov dx,160                 //c c  cp/2.
				      //.. ( c y稢c  2).
       Plasma2L2:
       asm {
	    lodsb
	    add al,[si+bx]            //ah,al-2 yc⠭ c
	    mov ah,al
	    mov es:[di+320],ax        //뢮 2 c  ⥪y饩 cp+1
	    stosw                     //뢮 2 c  ⥪y饩 cp.
	    dec dx
	    jnz Plasma2L2             //  c c  cp.

	    add si,256-160

	    add di,320                //뢠  cyy cpy .
	    dec cl
	    jnz Plasma2L1             //  c cp( 2 cp   p室).
	    popa
	    pop ds
	   }
	if (kbhit()) teller=20000;
	}

    FadeColorMap(byColorMap,OFF,0,256,3);

    farfree(data);
    return TRUE;
   }

unsigned PlasmaRandom(int x1,int y1,int x2,int y2)
   {
    return ((((float)random(32000))/32000.0)-0.5)*F*sqrt(pow(x2-x1,2)+pow(y2-y1,2));
   }

//p楤yp
//pp:
//          x1 -
//          y1 -
//          x2 -
//          y2 -
//          xm -
//          ym -
unsigned Adjust(int x1,int y1,
	    int x2,int y2,
	    int xm,int ym)
  {
   unsigned wColor;            // 窨.
   unsigned wResColor;         //ypy騩 梥 窨.

   //y砥 梥 窨  (x1,y1).
   wColor=GetPixel(x1,y1);
   wResColor=wColor;

   //y砥 梥 窨  (x2,y2).
   wColor=GetPixel(x2,y2);
   wResColor+=wColor;

   //y祬 ycp 梥.
   wResColor>>=1;

   //塞 cy砩 䠪p.
   wResColor+=PlasmaRandom(x1,y1,x2,y2);

   //pp塞  p 祭.
   if (wResColor>256) wResColor=225;
   if (wResColor<1) wResColor=1;

   //c⠭ y  (xm,ym).
   PutPixel(xm,ym,wResColor);

   return wResColor;
  }

//p楤yp  cp (x1,y1)-(x2,y2)  4 cp.
//c :
//  롨pc 窠  cp cp (x1,y1)-(x2,y2).  窠 
//  cp  4 cp. c⠭c 梥 ⮩ 窨  cy 4-
//  p 梥⮢ 祪, .. (color(x1,y1)+color(x2,y1)+color(x2,y2)+color(x1,y2))/4.
//   pypc 뢠c   p楤yp    cp.
//pp:
//          x1 - p X  p孥 y cp,
//          y1 - p Y  p孥 y cp,
//          x2 - p X p  y cp,
//          y2 - p Y p  y cp.
void SubDivide(int x1,int y1,int x2,int y2)
   {
    int xC,yC;                 //p X,Y 業p cp.
    xC=(x1+x2)/2;
    yC=(y1+y2)/2;

    //Hy  쭥襥  cp?
    if (xC<=x1)
      if (yC<=y1) return;

    unsigned wResColor;        //ypy騩 梥 窨.
    unsigned wColor;           // 窨.

    wResColor=0;

    //y砥 梥 窨  (xC,y1).
    wColor=GetPixel(xC,y1);
    if (wColor==0)
       {
	//pyc yc⠭ ⥫쭮 窨.
	wColor=Adjust(x1,y1,x2,y1,xC,y1);
       }
    wResColor+=wColor;

    //y砥 梥 窨  (x2,yC).
    wColor=GetPixel(x2,yC);
    if (wColor==0)
       {
	//pyc yc⠭ ⥫쭮 窨.
	wColor=Adjust(x2,y1,x2,y2,x2,yC);
       }
    wResColor+=wColor;

    //y砥 梥 窨  (xC,y2).
    wColor=GetPixel(xC,y2);
    if (wColor==0)
       {
	//pyc yc⠭ ⥫쭮 窨.
	wColor=Adjust(x1,y2,x2,y2,xC,y2);
       }
    wResColor+=wColor;

    //y砥 梥 窨  (x1,yC).
    wColor=GetPixel(x1,yC);
    if (wColor==0)
       {
	//pyc yc⠭ ⥫쭮 窨.
	wColor=Adjust(x1,y1,x1,y2,x1,yC);
       }
    wResColor+=wColor;

    // pypy騩 梥  4.
    wResColor>>=2;

    //c⠭ y.
    PutPixel(xC,yC,wResColor);

    //ypc 뢠 p楤ypy   cp.

    //  p孥 cp.
    SubDivide(x1,y1,xC,yC);

    // p p孥 cp.
    SubDivide(xC,y1,x2,yC);

    // p  cp.
    SubDivide(xC,yC,x2,y2);

    //   cp.
    SubDivide(x1,yC,xC,y2);
   }

//p楤yp p樨 室    䥪 N3.
// c뢠c  䠩 c  PLADAT03.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int GenPlasma3Data()
   {
    //C 䠩..
    MTFile *file=new MTFile(PLADAT03);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't create file %s !",PLADAT02);
	delete file;
	return FALSE;
       }

   //뤥塞   py p.
   if (!MakeVirtualScreen(&Scr,320,200,MEM_STANDARD))
       {
	CloseGraph();
	printf("\nNot enough memory!");
	delete file;
	return FALSE;
       }

    //C p.
    SetActiveScreen(VIRTUAL_SCREEN,&Scr);

    ClearScreen();

    randomize();

    PutPixel(0,0,random(MAX_COLORS));
    PutPixel(319,199,random(MAX_COLORS));
    PutPixel(0,199,random(MAX_COLORS));
    PutPixel(319,0,random(MAX_COLORS));

    SubDivide(0,0,319,199);

    //c뢠 䠩.
    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)Scr.RasterData.lpRealAddress;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=64000l;

    if (!file->Write(&TmpBlk,(unsigned long)0l,(unsigned long)32000l))
       {
	CloseGraph();
	printf("\nCan't write file %s !",PLADAT03);
	delete file;
	DeleteVirtualScreen(&Scr);
	return FALSE;
       }

    if (!file->Write(&TmpBlk,(unsigned long)32000l,(unsigned long)32000l))
       {
	CloseGraph();
	printf("\nCan't write file %s !",PLADAT03);
	delete file;
	DeleteVirtualScreen(&Scr);
	return FALSE;
       }
    delete file;
    DeleteVirtualScreen(&Scr);

    //C py.
    file=new MTFile(PLACOL03);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't create file %s !",PLACOL03);
	delete file;
	return FALSE;
       }

    char byColorMap[768];

    byColorMap[0]=byColorMap[1]=byColorMap[2]=0;

    for (int i=1; i<256; i++)
	{
	 byColorMap[i*3]=(char)(sin(i*M_PI*2/64)*31.0+31);
	 byColorMap[i*3+1]=(char)(sin(i*M_PI*2/128)*31.0+31);
	 byColorMap[i*3+2]=(char)(sin(i*M_PI*2/256)*31.0+31);
	}

    //c뢠 䠩.
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)&byColorMap;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=768l;

    if (!file->Write(&TmpBlk,(unsigned long)0l,(unsigned long)768l))
       {
	CloseGraph();
	printf("\nCan't write file %s !",PLACOL03);
	delete file;
	return FALSE;
       }
    delete file;

    return TRUE;
   }

//p楤yp p  (䥪 3).
// pyc  ⮬ c  nsfirst.vol.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int Plasma3()
   {
    char byColorMap[768];

    //p뢠 䠩 .
    MTFile *file=new MTFile(PLADAT03,MT_READ_ONLY);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",PLADAT03);
	delete file;
	return FALSE;
       }

   //뤥塞   py p.
   if (!MakeVirtualScreen(&Scr,320,200,MEM_STANDARD))
       {
	CloseGraph();
	printf("\nNot enough memory!");
	delete file;
	return FALSE;
       }

    //⠥ 䠩.
    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)Scr.RasterData.lpRealAddress;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=64000l;

    if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)64000l))
       {
	CloseGraph();
	printf("\nCan't read file %s !",PLADAT03);
	delete file;
	DeleteVirtualScreen(&Scr);
	return FALSE;
       }

    delete file;

    //⥭ p.
    file=new MTFile(PLACOL03,MT_READ_ONLY);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",PLACOL02);
	delete file;
	DeleteVirtualScreen(&Scr);
	return FALSE;
       }

    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)&byColorMap;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=768l;

    if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)768l))
       {
	CloseGraph();
	printf("\nCan't read file %s !",PLACOL03);
	delete file;
	DeleteVirtualScreen(&Scr);
	return FALSE;
       }
    delete file;

    //樠 pc p.
    InitGraph("vga.drv",0);
    if (GraphResult()!=GRAPH_NO_ERROR)
       {
	DeleteVirtualScreen(&Scr);
	printf("\nCan't setup video mode or can't find driver 'vga.drv'!");
	return FALSE;
       }

    //c⠭ py.
//    SetColorMap(byColorMap);

    //頥 py.
    ClearColorMap();

    ScreenToDisplay(&Scr,0,0,320,200,0,0,COPY_PUT);

    unsigned wColRotate;
    unsigned long dwLength;
    int nFade=0;

    wColRotate=0;
    dwLength=0l;

    do
      {
       if (nFade<64 && wColRotate==20)
	  {
	   // py.
	   FadeColorMapOnce(byColorMap,ON,0,256);
	   nFade++;
	  }

       if (dwLength>(35000l-64l)*dwP5)
	  {
	   //c py.
	   FadeColorMapOnce(byColorMap,OFF,0,256);
	   nFade++;
	  }


       if (wColRotate==20)
	 {
	  if (nFade>63) CycleColor(1,255,LEFT);

	  wColRotate=0;
	 }
       else wColRotate++;

       dwLength++;
      }
    while(!kbhit() && dwLength<35000l*dwP5);             //   py y.

    FadeColorMap(byColorMap,OFF,0,256,3);

    DeleteVirtualScreen(&Scr);
    return TRUE;
   }
