@ECHO OFF
REM **************************************************************************
REM Batchfile for starting the SUPERUNKNOWN demo.
REM **************************************************************************
REM sound  : The UltraMID TSR which have to be loaded first needs about 40K
REM          to operate. This batch-file tries to install UltraMID in high-
REM          RAM to get as much free conventional memory as possible. If
REM          you dont have the LH program then you have to free as much of
REM          conventional memory as possible and remove the LH before
REM          "ultramid -nsunknown.ini". After UltraMID has installed itself
REM          you need about 616K of additional memory to run.
REM **************************************************************************
REM nosound: You need about 616K of free conventional memory to run.
REM **************************************************************************

ECHO.
ECHO INITIALISING THE SUPERUNKNOWN DEMO...
ECHO.


REM Initialises UltraMID, which tries to find the GUS.
REM Remove the LH if you don't have this prog.
LH ULTRAMID -Q -NSUNKNOWN.201

IF ERRORLEVEL = 1 GOTO NOGUS

REM A GUS-card was found and UltraMID was successfully installed.
SUNKNOWN -GUS %1 %2

REM Frees the UltraMID from memory.
ULTRAMID -F -Q

GOTO DONE


REM No GUS found.
:NOGUS
ECHO.
ECHO The Gravis Ultrasound initialisation failed for your system.
ECHO This may be due to the lack of a GUS-card on your system.
ECHO If not - please check your soundcard settings.
ECHO.
ECHO Hit [Return] to continue without sound, or [Ctrl]+[C] to abort.
PAUSE

REM Starts the demo with no sound.
SUNKNOWN %1 %2

:DONE
