/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import codeanticode.glgraphics.GLModel;
import codeanticode.glgraphics.GLModelEffectParameter;
import codeanticode.glgraphics.GLModelEffectVertexAttrib;
import codeanticode.glgraphics.GLSLShader;
import codeanticode.glgraphics.GLState;
import codeanticode.glgraphics.GLTexture;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.media.opengl.GL;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.opengl.PGraphicsOpenGL;
import processing.xml.XMLElement;

public class GLModelEffect
implements PConstants {
    protected PApplet parent;
    protected String description;
    protected GL gl;
    protected PGraphicsOpenGL pgl;
    protected GLState glstate;
    protected GLSLShader shader;
    protected String vertexFN;
    protected String geometryFN;
    protected String fragmentFN;
    protected String inGeoPrim;
    protected String outGeoPrim;
    protected int maxNumOutVert;
    protected int numTextures;
    protected HashMap<String, Integer> texHashMap;
    protected int[] texUnitUniform;
    protected String[] texNameArray;
    protected int numParams;
    protected HashMap<String, GLModelEffectParameter> paramsHashMap;
    protected GLModelEffectParameter[] paramsArray;
    protected int numVertAttribs;
    protected HashMap<String, GLModelEffectVertexAttrib> vertAttribHashMap;
    protected GLModelEffectVertexAttrib[] vertAttribArray;

    public GLModelEffect() {
        this.parent = null;
    }

    public GLModelEffect(PApplet pApplet, String string) {
        this.parent = pApplet;
        this.initEffect(string);
    }

    public GLModelEffect(PApplet pApplet, URL uRL) {
        this.parent = pApplet;
        this.initEffect(uRL);
    }

    public void delete() {
        this.shader.delete();
    }

    public String getDescription() {
        return this.description;
    }

    public void apply(GLModel gLModel) {
        gLModel.render(this);
    }

    public void apply(GLModel[] gLModelArray) {
        for (int i = 0; i < gLModelArray.length; ++i) {
            gLModelArray[i].render(this);
        }
    }

    public void start() {
        this.shader.start();
        for (int i = 0; i < this.numParams; ++i) {
            this.paramsArray[i].copyToShader();
        }
    }

    public void stop() {
        this.shader.stop();
    }

    public void setTextures(GLTexture[] gLTextureArray) {
        for (int i = 0; i < gLTextureArray.length; ++i) {
            if (-1 >= this.texUnitUniform[i]) continue;
            String string = gLTextureArray[i].getName();
            if (!string.equals("") && this.texHashMap.containsKey(string)) {
                Integer n = this.texHashMap.get(string);
                this.gl.glUniform1iARB(this.texUnitUniform[i], n.intValue());
                continue;
            }
            this.gl.glUniform1iARB(this.texUnitUniform[i], i);
        }
    }

    public void setVertexAttribs(int[] nArray, String[] stringArray, int[] nArray2) {
        for (int i = 0; i < this.numVertAttribs; ++i) {
            String string = stringArray[i];
            this.gl.glBindBufferARB(34962, nArray[i]);
            if (!string.equals("") && this.vertAttribHashMap.containsKey(string)) {
                GLModelEffectVertexAttrib gLModelEffectVertexAttrib = this.vertAttribHashMap.get(string);
                gLModelEffectVertexAttrib.setAttribArrayPointer(nArray2[i], false, 0);
                continue;
            }
            this.vertAttribArray[i].setAttribArrayPointer(nArray2[i], false, 0);
        }
    }

    public void enableVertexAttribs() {
        for (int i = 0; i < this.numVertAttribs; ++i) {
            this.vertAttribArray[i].enableVertexAttribArray();
        }
    }

    public void disableVertexAttribs() {
        for (int i = 0; i < this.numVertAttribs; ++i) {
            this.vertAttribArray[i].disableVertexAttribArray();
        }
    }

    public void setParameterValue(String string, int n) {
        if (this.paramsHashMap.containsKey(string)) {
            GLModelEffectParameter gLModelEffectParameter = this.paramsHashMap.get(string);
            gLModelEffectParameter.setValue(n);
        }
    }

    public void setParameterValue(String string, float f) {
        if (this.paramsHashMap.containsKey(string)) {
            GLModelEffectParameter gLModelEffectParameter = this.paramsHashMap.get(string);
            gLModelEffectParameter.setValue(f);
        }
    }

    public void setParameterValue(String string, float[] fArray) {
        if (this.paramsHashMap.containsKey(string)) {
            GLModelEffectParameter gLModelEffectParameter = this.paramsHashMap.get(string);
            gLModelEffectParameter.setValue(fArray);
        }
    }

    public void setParameterValue(String string, int n, float f) {
        if (this.paramsHashMap.containsKey(string)) {
            GLModelEffectParameter gLModelEffectParameter = this.paramsHashMap.get(string);
            gLModelEffectParameter.setValue(n, f);
        }
    }

    public void setParameterValue(String string, int n, int n2, float f) {
        if (this.paramsHashMap.containsKey(string)) {
            GLModelEffectParameter gLModelEffectParameter = this.paramsHashMap.get(string);
            gLModelEffectParameter.setValue(n, n2, f);
        }
    }

    public void setParameterValues(float[] ... fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            this.paramsArray[i].setValue(fArray2);
        }
    }

    public int getParameterCount() {
        return this.numParams;
    }

    public int getParameterType(int n) {
        return this.paramsArray[n].getType();
    }

    public String getParameterName(int n) {
        return this.paramsArray[n].getName();
    }

    public String getParameterLabel(int n) {
        return this.paramsArray[n].getLabel();
    }

    public GLModelEffectParameter getParameter(int n) {
        return this.paramsArray[n];
    }

    public void setParameterValue(int n, int n2) {
        this.paramsArray[n].setValue(n2);
    }

    public void setParameterValue(int n, float f) {
        this.paramsArray[n].setValue(f);
    }

    public void setParameterValue(int n, float[] fArray) {
        this.paramsArray[n].setValue(fArray);
    }

    public void setParameterValue(int n, int n2, float f) {
        this.paramsArray[n].setValue(n2, f);
    }

    public void setParameterValue(int n, int n2, int n3, float f) {
        this.paramsArray[n].setValue(n2, n3, f);
    }

    public GLModelEffectParameter getParameter(String string) {
        if (this.paramsHashMap.containsKey(string)) {
            GLModelEffectParameter gLModelEffectParameter = this.paramsHashMap.get(string);
            return gLModelEffectParameter;
        }
        return null;
    }

    protected void initEffect(String string) {
        this.initEffectCommon();
        string = string.replace('\\', '/');
        XMLElement xMLElement = new XMLElement(this.parent, string);
        this.loadXML(xMLElement);
        this.initShader(string, false);
    }

    protected void initEffect(URL uRL) {
        this.initEffectCommon();
        try {
            String string = PApplet.join((String[])PApplet.loadStrings((InputStream)uRL.openStream()), (String)"\n");
            XMLElement xMLElement = new XMLElement(string);
            this.loadXML(xMLElement);
        }
        catch (IOException iOException) {
            System.err.println("Error loading effect: " + iOException.getMessage());
        }
        this.initShader(uRL.toString(), true);
    }

    private void initEffectCommon() {
        this.pgl = (PGraphicsOpenGL)this.parent.g;
        this.gl = this.pgl.gl;
        this.glstate = new GLState(this.gl);
        this.numTextures = 0;
        this.texHashMap = new HashMap();
        this.texUnitUniform = null;
        this.texNameArray = null;
        this.numParams = 0;
        this.paramsHashMap = new HashMap();
        this.paramsArray = null;
        this.numVertAttribs = 0;
        this.vertAttribHashMap = new HashMap();
        this.vertAttribArray = null;
    }

    protected void loadXML(XMLElement xMLElement) {
        int n = xMLElement.getChildCount();
        this.fragmentFN = "";
        this.geometryFN = "";
        this.vertexFN = "";
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (string.equals("description")) {
                this.description = xMLElement2.getContent();
                continue;
            }
            if (string.equals("vertex")) {
                this.vertexFN = xMLElement2.getContent();
                continue;
            }
            if (string.equals("geometry")) {
                this.geometryFN = xMLElement2.getContent();
                this.inGeoPrim = xMLElement2.getString("input");
                this.outGeoPrim = xMLElement2.getString("output");
                this.maxNumOutVert = xMLElement2.getInt("vertcount");
                continue;
            }
            if (string.equals("fragment")) {
                this.fragmentFN = xMLElement2.getContent();
                continue;
            }
            if (string.equals("textures")) {
                this.loadTextures(xMLElement2);
                continue;
            }
            if (string.equals("vertexattribs")) {
                this.loadVertAttribs(xMLElement2);
                continue;
            }
            if (string.equals("parameters")) {
                this.loadParams(xMLElement2);
                continue;
            }
            System.err.println("Unrecognized element in effect config file!");
        }
    }

    protected void loadTextures(XMLElement xMLElement) {
        int n;
        this.numTextures = n = xMLElement.getChildCount();
        this.texNameArray = new String[this.numTextures];
        this.texUnitUniform = new int[this.numTextures];
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("texture")) continue;
            String string2 = xMLElement2.getString("name");
            String string3 = xMLElement2.getContent();
            int n2 = PApplet.parseInt((String[])PApplet.split((String)string3, (char)' '))[0];
            this.texHashMap.put(string2, new Integer(n2));
            this.texNameArray[i] = string2;
        }
    }

    protected void loadVertAttribs(XMLElement xMLElement) {
        int n;
        this.numVertAttribs = n = xMLElement.getChildCount();
        this.vertAttribArray = new GLModelEffectVertexAttrib[this.numVertAttribs];
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("vertexattrib")) continue;
            String string2 = xMLElement2.getString("name");
            String string3 = xMLElement2.getString("type");
            String string4 = xMLElement2.getString("label");
            String string5 = xMLElement2.getContent();
            int n2 = GLModelEffectVertexAttrib.getType(string3);
            float[] fArray = PApplet.parseFloat((String[])PApplet.split((String)string5, (char)' '));
            if (-1 >= n2 || this.paramsHashMap.containsKey(string2)) continue;
            GLModelEffectVertexAttrib gLModelEffectVertexAttrib = new GLModelEffectVertexAttrib(this.parent, string2, string4, n2);
            gLModelEffectVertexAttrib.setValue(fArray);
            this.vertAttribHashMap.put(string2, gLModelEffectVertexAttrib);
            this.vertAttribArray[i] = gLModelEffectVertexAttrib;
        }
    }

    protected void loadParams(XMLElement xMLElement) {
        int n;
        this.numParams = n = xMLElement.getChildCount();
        this.paramsArray = new GLModelEffectParameter[this.numParams];
        for (int i = 0; i < n; ++i) {
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string = xMLElement2.getName();
            if (!string.equals("parameter")) continue;
            String string2 = xMLElement2.getString("name");
            String string3 = xMLElement2.getString("type");
            String string4 = xMLElement2.getString("label");
            String string5 = xMLElement2.getContent();
            int n2 = GLModelEffectParameter.getType(string3);
            float[] fArray = PApplet.parseFloat((String[])PApplet.split((String)string5, (char)' '));
            if (-1 >= n2 || this.paramsHashMap.containsKey(string2)) continue;
            GLModelEffectParameter gLModelEffectParameter = new GLModelEffectParameter(this.parent, string2, string4, n2, fArray.length);
            gLModelEffectParameter.setValue(fArray);
            this.paramsHashMap.put(string2, gLModelEffectParameter);
            this.paramsArray[i] = gLModelEffectParameter;
        }
    }

    String fixShaderFilename(String string, String string2) {
        String string3 = string.replace('\\', '/');
        if (!string2.equals("") && string3.indexOf(string2) != 0) {
            string3 = string2 + string3;
        }
        return string3;
    }

    protected void initShader(String string, boolean bl) {
        int n;
        boolean bl2 = false;
        String string2 = "";
        int n2 = string.lastIndexOf(47);
        if (-1 < n2) {
            string2 = string.substring(0, n2 + 1);
        }
        this.shader = new GLSLShader(this.parent);
        if (!this.vertexFN.equals("")) {
            this.vertexFN = this.fixShaderFilename(this.vertexFN, string2);
            if (bl) {
                try {
                    this.shader.loadVertexShader(new URL(this.vertexFN));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(malformedURLException.getMessage());
                }
            } else {
                this.shader.loadVertexShader(this.vertexFN);
            }
        }
        if (!this.geometryFN.equals("")) {
            this.geometryFN = this.fixShaderFilename(this.geometryFN, string2);
            if (bl) {
                try {
                    this.shader.loadGeometryShader(new URL(this.geometryFN));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(malformedURLException.getMessage());
                }
            } else {
                this.shader.loadGeometryShader(this.geometryFN);
            }
            bl2 = true;
        }
        if (!this.fragmentFN.equals("")) {
            this.fragmentFN = this.fixShaderFilename(this.fragmentFN, string2);
            if (bl) {
                try {
                    this.shader.loadFragmentShader(new URL(this.fragmentFN));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(malformedURLException.getMessage());
                }
            } else {
                this.shader.loadFragmentShader(this.fragmentFN);
            }
        }
        if (bl2) {
            this.shader.setupGeometryShader(this.inGeoPrim, this.outGeoPrim, this.maxNumOutVert);
        } else {
            this.shader.setup();
        }
        for (n = 0; n < this.numTextures; ++n) {
            this.texUnitUniform[n] = this.shader.getUniformLocation(this.texNameArray[n]);
        }
        for (n = 0; n < this.numParams; ++n) {
            this.paramsArray[n].setShader(this.shader);
            this.paramsArray[n].init();
        }
        for (n = 0; n < this.numVertAttribs; ++n) {
            this.vertAttribArray[n].setShader(this.shader);
            this.vertAttribArray[n].init();
        }
    }
}

