void rotation_3d(signed int px, signed int py, signed int pz);





struct polydata {
    long x1,y1,x2,y2,x3,y3,x4,y4;
    long rx1,ry1,rx2,ry2,rx3,ry3,rx4,ry4;
    short col;
    long z1,z2,z3,z4;
    };
struct polydata polys;

#pragma aux polygon_ "_*" parm caller [];

long sintab[360];
long costab[360];
signed long rotfin_x,rotfin_y,rotfin_z,xoffs,yoffs,zoffs,xrot,yrot,zrot;
signed int xdeg,ydeg,zdeg;



void maketabs()
{
long loop;
for (loop=0; loop<360; loop++)
   sintab[loop]=(sin(loop*pi/180))*32768;
for (loop=0; loop<360; loop++)
   costab[loop]=(cos(loop*pi/180))*32768;
}


void draw_poly(char *where)
{
    rotation_3d(polys.x1,polys.y1,polys.z1);
    polys.x1=rotfin_x; polys.y1=rotfin_y; polys.z1=rotfin_z;
    rotation_3d(polys.x2,polys.y2,polys.z2);
    polys.x2=rotfin_x; polys.y2=rotfin_y; polys.z2=rotfin_z;
    rotation_3d(polys.x3,polys.y3,polys.z3);
    polys.x3=rotfin_x; polys.y3=rotfin_y; polys.z3=rotfin_z;
    rotation_3d(polys.x4,polys.y4,polys.z4);
    polys.x4=rotfin_x; polys.y4=rotfin_y; polys.z4=rotfin_z;
    polys.col=1;
    if ((polys.z1>-200) && (polys.z2>-200) && (polys.z3>-200) && (polys.z4>-200)) 
         polygon_((char*)where,&polys);
}




void rotation_3d(signed int px, signed int py, signed int pz)
{

  long xx,yy,zz,xt,yt,zt,x,y,z;
  long xangle,yangle,zangle;
  
  if (xdeg<0) xdeg=xdeg+360;
  if (ydeg<0) ydeg=ydeg+360;
  if (zdeg<0) zdeg=zdeg+360;
  if (xdeg>359) xdeg=xdeg-360;
  if (ydeg>359) ydeg=ydeg-360;
  if (zdeg>359) zdeg=zdeg-360;

  xangle = xdeg;
  yangle = ydeg;
  zangle = zdeg;

long newx,newy,newz,oldx,oldy,oldz;

   oldx=px-xrot;
   oldy=py-yrot;
   oldz=pz-zrot;

      newy=(oldy*(costab[xangle]))-(oldz*(sintab[xangle]));
      newz=(oldz*(costab[xangle]))+(oldy*(sintab[xangle]));
      oldy=newy>>15;
      oldz=newz>>15;

      newx=((oldx*costab[yangle]))-((oldz*sintab[yangle]));
      newz=((oldz*costab[yangle]))+((oldx*sintab[yangle]));
      oldz=newz>>15;
      oldx=newx>>15;

      newx=((oldx*costab[zangle]))-((oldy*sintab[zangle]));
      newy=((oldy*costab[zangle]))+((oldx*sintab[zangle]));
      oldx=newx>>15;
      oldy=newy>>15;
           
  x=oldx+xrot+xoffs;
  y=oldy+yrot+yoffs;
  z=oldz+zrot+zoffs-xrot-yrot+90;
  if (z<0) z=0;
  
  if ((z+256)!=0) xx=(((x-xrot)*256)/(z+256))+xrot;
  if ((z+256)!=0) yy=(((y-yrot)*256)/(z+256))+yrot;

  rotfin_x=xx;
  rotfin_y=yy;
  rotfin_z=z;

}


void poly2d(long x1,long y1,
            long x2,long y2,
            long x3,long y3,
            long x4,long y4,
            long tx1,long ty1,
            long tx2,long ty2,
            long tx3,long ty3,
            long tx4,long ty4,
            char* src,char* dest)
{
signed long mnx,mxx,mny,mxy;
signed long m1,m2,m3,m4,f1,f2,f3,f4,d1,d2,d3,d4;
signed long tmark0x,tmark1x,tmark2x,tmark3x,tstep0x,tstep1x,tstep2x,tstep3x;
signed long tmark0y,tmark1y,tmark2y,tmark3y,tstep0y,tstep1y,tstep2y,tstep3y;
signed long tmxx,tmnx,tmxy,tmny;
signed long xx1,xx2,xx3,xx4,zz1,zz2,zz3;
signed long step0x,step1x,step2x,step0z,step1z,step2z,step3x;
signed long mark0x,mark1x,mark2x,mark0z,mark1z,mark2z,mark3x;
signed long lz,rz;
signed long tdx,tdy,dx1,dy1,y;
long xloop;

                          //Cheks to see if polys Y values are on screen!
   mny=y1; mxy=y1;
   if (y2<mny)  mny=y2;
   if (y2>mxy)  mxy=y2;
   if (y3<mny)  mny=y3;      
   if (y3>mxy)  mxy=y3;
   if (y4<mny)  mny=y4;      
   if (y4>mxy)  mxy=y4;
   if (mxy<0)   return;    //exit();
   if (mny>599) return;  //exit();
                          //Cheks to see if polys X values are on screen!}
   mnx=x1; mxx=x1;
   if (x2<mnx)  mnx=x2;
   if (x2>mxx)  mxx=x2;
   if (x3<mnx)  mnx=x3;
   if (x3>mxx)  mxx=x3;
   if (x4<mnx)  mnx=x4;
   if (x4>mxx)  mxx=x4;
   if (mxx<0)   return;    //exit();
   if (mnx>799) return;  //exit();

   m1=x1-x4; d1=y1-y4;
   m2=x2-x1; d2=y2-y1;
   m3=x3-x2; d3=y3-y2;
   m4=x4-x3; d4=y4-y3;

tx1=tx1 << 16;
ty1=ty1 << 16;
tx2=tx2 << 16;
ty2=ty2 << 16;
tx3=tx3 << 16;
ty3=ty3 << 16;
tx4=tx4 << 16;
ty4=ty4 << 16;

if ((y4-y1)!=0) {
  tstep0y=(ty4-ty1) / (y4-y1);
  tstep0x=(tx4-tx1) / (y4-y1);
  }
if ((y1-y2)!=0) {
  tstep1y=(ty1-ty2) / (y1-y2);
  tstep1x=(tx1-tx2) / (y1-y2);
  }
if ((y2-y3)!=0) {
  tstep2y=(ty2-ty3) / (y2-y3);
  tstep2x=(tx2-tx3) / (y2-y3);
  }
if ((y3-y4)!=0) {
  tstep3y=(ty3-ty4) / (y3-y4);
  tstep3x=(tx3-tx4) / (y3-y4);
  }

if (y1<y4) {
  tmark0y=ty1;
  tmark0x=tx1; 
  } else {
         tmark0y=ty4;
         tmark0x=tx4;
         }
if (y1<y2) {
  tmark1y=ty1;
  tmark1x=tx1;
  } else {
         tmark1y=ty2;
         tmark1x=tx2;
         } 
if (y2<y3) {
  tmark2y=ty2;
  tmark2x=tx2;
  } else {
         tmark2y=ty3;
         tmark2x=tx3;
         } 
if (y3<y4) {
  tmark3y=ty3;
  tmark3x=tx3;
  } else {
         tmark3y=ty4;
         tmark3x=tx4;
         } 

xx1=x1 << 16;
xx2=x2 << 16;
xx3=x3 << 16;
xx4=x4 << 16;

if ((y4-y1)!=0) step0x=(xx4-xx1) / (y4-y1);
if ((y1-y2)!=0) step1x=(xx1-xx2) / (y1-y2);
if ((y2-y3)!=0) step2x=(xx2-xx3) / (y2-y3);
if ((y3-y4)!=0) step3x=(xx3-xx4) / (y3-y4);
if (y1<y4) mark0x=xx1; else mark0x=xx4;
if (y1<y2) mark1x=xx1; else mark1x=xx2;
if (y2<y3) mark2x=xx2; else mark2x=xx3;
if (y3<y4) mark3x=xx3; else mark3x=xx4;


for (y=mny; y<mxy; y++)
{
    mnx=799 << 16;                  //to clip the screen
    mxx=000 << 16;
   tmnx=799 << 16;
   tmxx=000 << 16;
   tmny=599 << 16;
   tmxy=000 << 16;

   if (y1!=y4) {
     if (((y4>=y) && (y1<=y)) || ((y1>=y) && (y4<=y))) {
         if (mark0x>mxx) { mxx=mark0x; tmxx=tmark0x; tmxy=tmark0y; }
         if (mark0x<mnx) { mnx=mark0x; tmnx=tmark0x; tmny=tmark0y; }
         tmark0x=(tmark0x+tstep0x);
         tmark0y=(tmark0y+tstep0y);
         mark0x=(mark0x+step0x);
        }
   }

   if (y1!=y2) {
     if (((y2>=y) && (y1<=y)) || ((y1>=y) && (y2<=y))) {
         if (mark1x>mxx) { mxx=mark1x; tmxy=tmark1y; tmxx=tmark1x; }
         if (mark1x<mnx) { mnx=mark1x; tmny=tmark1y; tmnx=tmark1x; }
         tmark1x=(tmark1x+tstep1x);
         tmark1y=(tmark1y+tstep1y);
         mark1x=(mark1x+step1x);
        }
   }

   if (y2!=y3) {
     if (((y3>=y) && (y2<=y)) || ((y2>=y) && (y3<=y))) {
         if (mark2x>mxx) { mxx=mark2x; tmxx=tmark2x; tmxy=tmark2y; }
         if (mark2x<mnx) { mnx=mark2x; tmnx=tmark2x; tmny=tmark2y; }
         tmark2x=(tmark2x+tstep2x);
         tmark2y=(tmark2y+tstep2y);
         mark2x=(mark2x+step2x);
        }
   }
   
   if (y3!=y4) {
     if (((y4>=y) && (y3<=y)) || ((y3>=y) && (y4<=y))) {
         if (mark3x>mxx) { mxx=mark3x; tmxx=tmark3x; tmxy=tmark3y; }
         if (mark3x<mnx) { mnx=mark3x; tmnx=tmark3x; tmny=tmark3y; }
         tmark3x=(tmark3x+tstep3x);
         tmark3y=(tmark3y+tstep3y);
         mark3x=(mark3x+step3x);
     }
   }
   
   mnx=mnx >> 16;
   mxx=mxx >> 16;
   if ((y>=0) && (y<600)) 
     if (mnx<mxx) {

          if ((mnx-mxx)!=0) tdx=(tmnx-tmxx) / ((mnx-mxx));
          if ((mnx-mxx)!=0) tdy=(tmny-tmxy) / ((mnx-mxx));
       dx1=tmnx;
       dy1=tmny;
          while (mnx<0) 
          {
            dx1=dx1+tdx;
            dy1=dy1+tdy;
            mnx=mnx+1;
          }
       tmnx=dx1;
       tmny=dy1;

       dx1=tmxx;
       dy1=tmxy;
          while (mxx>799) 
          {
            dx1=dx1-tdx;
            dy1=dy1-tdy;      
            mxx=mxx-1;
          }; 
       tmxx=dx1;
       tmxy=dy1;

       if ((mnx-mxx)!=0) tdx=(tmnx-tmxx) / ((mnx-mxx));
       if ((mnx-mxx)!=0) tdy=(tmny-tmxy) / ((mnx-mxx));
       dx1=tmnx;
       dy1=tmny;
   
       hline_tmap1_(mnx,mxx,y,dx1,dy1,tdx,tdy,src,dest);
   }
 }
}