#include <iostream>
using namespace std;

struct Knoten
{
	int Wert;
	Knoten* Links;
	Knoten* Rechts;
};

Knoten* Wurzel;

void Hinzufuegen( Knoten* knoten, int Wert )
{
	if( Wert < knoten->Wert ) // links
	{
		if( knoten->Links == NULL ) // Blatt erreicht
		{
			// neuen Knoten erzeugen
			knoten->Links = new Knoten;

			// Knoten initialisieren
			knoten = knoten->Links;
			knoten->Links = NULL;
			knoten->Rechts = NULL;
			knoten->Wert = Wert;
		}
		else
		{
			// rekursiv das passende Blatt suchen
			Hinzufuegen( knoten->Links, Wert );
		}
	}
	else // rechts
	{
		// analog zu links
	}
}

bool Suchen( Knoten* knoten, int Wert )
{
	if( knoten == NULL )
	{
		// Ende erreicht, ohne den Wert zu finden
		return false;
	}
	else
	{
		if( Wert == knoten->Wert ) // Wert gefunden
		{
			return true;
		}
		else if( Wert < knoten->Wert ) // links suchen
		{
			return Suchen( knoten->Links, Wert );
		}
		else // rechts suchen
		{
			return Suchen( knoten->Rechts, Wert );
		}
	}
}

void main()
{
	Wurzel = new Knoten;
	Wurzel->Links = NULL;
	Wurzel->Rechts = NULL;
	Wurzel->Wert = 10;

	Hinzufuegen( Wurzel, 5 );

	if( Suchen( Wurzel, 5 ) )
		cout << "5 gefunden" << endl;

	if( !Suchen( Wurzel, 7 ) )
		cout << "7 nicht gefunden" << endl;

}