{$A+,B-,D+,E+,F-,G+,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
unit NormGUS;

interface
procedure _gus_player_pause;
procedure _gus_player_continue;
function  _gus_modload(name : string) : boolean;
{
 Ld die in NAME bergebene Datei in den Speicher und das GUS-Ram. Die
 Function liefert den Wert TRUE, wenn die MOD-Datei einwandfrei geladen
 werden konnte, sonst den Wert FALSE.
}

procedure _gus_modstarten;
{
 Startet die Ausgebe eines galadenen MODs ber den Timer-Interrupt
}

procedure _gus_mod_beenden;
{
 Beendet die Ausgabe eines MODs
}

procedure _gus_initialisieren;
{
 Initialisiert die GUS
}

function _gus_init_env : boolean;
{
 Initialisiert die GUS, keine Hardware-Detection sondern Prfen der
 Umgebungs-Variablen ULTRASND
}

procedure _gus_set_chanelpos;
{
 Setzt die Position der einzelnen GUS-Kanle
}

{
 *************************************************************************
 ***               T Y P  -  D e k l a r a t i o n e n                 ***
 *************************************************************************
}
type Song_header = record         { Die Globalen Infos zur MOD-Datei  }
       kennung : string[25];
       SongName : string[30];
       Liedlaenge : byte;
       Arrang : array[0..255] of byte;
       Num_Patts : byte;
       Num_Inst : byte;
     end;

type Modinfo = record
       Stimmen : word;
       Tietel  : string[20];
       Patt_anz : word;
     end;

Type Runinfo = record
        Ausschlag : array[1..8] of byte;
        Zeile,
        Pattnr   : integer;
        Volumes  : array[1..8] of byte;
        speed    : byte;
        bpm      : byte;
     end;

type
 PKanalInfo = ^TKanalInfo;
 TKanalInfo = record
   InstNr     : byte;             { Hardware bezogene Variablen       }
   Mempos     : longint;
   Ende       : longint;
   Loop_Start : longint;
   Loop_Ende  : longint;

   Volume     : integer;          { MOD bezogene Variablen            }
   Frequenz   : word;
   Looping    : byte;
   Ton        : integer;
   Start_Ton  : integer;
   Ziel_Ton   : integer;
   Effekt     : byte;
   Opperand   : byte;

   Effektx,                       { Effekt bezogene Variablen         }
   Effekty      : integer;
   Appegpos     : integer;
   slidespeed   : integer;
   vslide       : integer;
   retrig_count : byte;
   vibpos       : byte;
   vibx         : byte;
   viby         : byte;
 end;

 PInstrumenrInfo = ^TInstrumentInfo;
 TInstrumentInfo = record
   Name       : string[22];
   Mempos     : longint;
   Ende       : longint;
   l_Start    : longint;
   l_ende     : longint;
   Groesse    : word;
   Loop_Start : word;
   Loop_Ende  : word;
   Volume     : word;
   Looping    : byte;
 end;


{
 *************************************************************************
 ***             Gloale Konstanten und Variablen                       ***
 *************************************************************************
}
Const
  Play_Chanel : array[1..14]      { Zum ausmaskieren einzelner Kanle }
    of byte = (1,1,1,1,1,1,1,     { 1 = GUS-Kanal wird gespielt       }
               1,1,1,1,1,1,1);    { 0 = GUS-Kanal wird nicht gespielt }

var Kanaele       : array[0..31] of PKanalInfo;
    Instrumente   : array[0..31] of PInstrumenrInfo;
  MOD_Stimmen     : word;         { Anzahl der Stimmen (4/8)          }
  MOD_Patternsize : word;         { Gre eines MOD-Patterns in Byte  }
  stop_Thevoice   : array[1..8] of boolean;
  GUSMOD :boolean;
  modpl : boolean;
  vh              : Song_Header;  { Globale Song - Definitionen       }
  FadeOut         : integer;
  RF              : boolean;
  Modinfptr       : pointer;
  Modinf          : Modinfo;
  Runinf          : Runinfo;
  SyncMod         : Boolean;
  SyncTrigger     : Boolean;
  chpos           : array[1..8] of integer; { Pos. d. Kanals im Halbkreis}


implementation
uses dos,crt,design,fselect;

const VibratoTable : array[0..63] of integer =(
	0,24,49,74,97,120,141,161,
	180,197,212,224,235,244,250,253,
	255,253,250,244,235,224,212,197,
	180,161,141,120,97,74,49,24,
	0,-24,-49,-74,-97,-120,-141,-161,
	-180,-197,-212,-224,-235,-244,-250,-253,
	-255,-253,-250,-244,-235,-224,-212,-197,
	-180,-161,-141,-120,-97,-74,-49,-24);

const Voice_Divisor : array[14..32] of byte =
       (43,40,37,35,33,31,30,28,27,26,25,24,23,22,21,20,20,19,18);
      Voice_Base : array[14..14] of longint =
       (88195);

const GUS_Environment : boolean = true;
  Modinstanz : byte = 31;         { Anzahl der Instrumente in einer   }
                                  { MOD-Datei (15 oder 31)            }
  ModId : array[1..4] of          { Kennungen fr 4-stimmige MODs     }
        String = ('M.K.','FLT4','4CHN','FOXY');
  Chn6 : string = '6CHN';         { Kennung fr 6-stimmige MODs       }
  chn8 : string = '8CHN';         { Kennung fr 8-stimmige MODs       }
  WOLF : string = 'WOLF';         { Kennung fr 8-stimmige MODs       }
  ModKennungen : string           { Alle MOD-Kennungen zur Detection  }
    = 'FOXYM.K.FLT44CHN6CHN8CHNWOLF';
  Interrupt_speed : word = 50;    { Anzahl Aufrufe Interrupts         }
  Num_Voices = 14;                { Wir benutzen 14 GUS - Kanle ...  }
  U_Ram_Freepos : longint = 2;    { Zur Verwaltung des GUS - RAM      }

  Play_Voice = 0; Stop_Voice = 3; { Konstanten zur Auswahl des Typs   }
  Bit8       = 0; Bit16      = 4; { der zu spielenden Stimme ...      }
  No_Loop    = 0; Mit_Loop   = 8;
  Unidirect  = 0; Bidirect   = 16;
  Go_forw    = 0; Go_Back    = 64;

var GUS_envstr : string;
    GUS_BASE : word;
  oldv : array[0..15] of integer;
  tickcounter,                    { Zur Geschwindigkeits-Steuerung    }
  ticklimit    : word;
  altertimer   : pointer;         { Pointer auf den alten Timer-Int.  }
  i            : Integer ;        { die wohl beliebteste Variable ;)  }
  gusmf        : file;            { Zum Handling der MOD-Datei        }
  Pattern      : array[0..127]    { Pointer auf die Pattern im Ram    }
                 of pointer;


{$L Gusasm}
procedure U_StartVoice(Nr,Modus : byte); external;
{
 Startet den in Nr bergebenen Kanal der Gus im ber Modus eingestellten
 Modus
}

procedure u_Voicefreq(Nr : byte;Freq : word); external;
{
 Setzt die Frequenz Freq fr den in Nr eingestellten Kanal
}

procedure u_VoiceBalance(Nr,balance : byte); external;
{
 Zum Einstellen der Balance des in Nr angegebenen Kanals. Fr balance sind
 Werte von 0 bis 15 erlaubt, wobei 0 fr ganz links, 7 fr mittig und 15
 fr ganz rechts steht
}

procedure u_VoiceVolume(Nr : byte; Vol : word); external;
{
 Hiermit setzen Sie die Lautstrke Vol des in Nr bergebenen Kanals
}

procedure u_delay; external;
{
 Zum Warten beim Zugriff auf selbst-modifizierende Register des GF1,
 zum internen Gebrauch
}

function  detect_gus : word; external;
{
 Zur Erkennung der GUS. Die Funktion liefert eine 0, wenn eine Karte
 gefunden wurde, und eine 1, wenn keine GUS erkannt wurde. Diese Funktion
 stellt gleichzeitig den richtigen Base-Port fr die GUS ein.
}

procedure u_Initialize; external;
{
 Initialisiert die Gravis Ultrasound.
}

procedure Ultra_Mem2Gus(samp : pointer;start : longint;laenge : word); external;
{
 Mit dieser Procedure kopieren Sie ein Sampel aus dem Ram in das RAM der GUS
 Das ber samp adressierte Sampel wird dabei mittels der Poke-Methode ber-
 tragen. In laenge geben Sie die Lnge des zu bertragenden Sampels an.
}

procedure gus_speaker_on; external;
{
 Schaltet den Lautsprecher der GUS ein.
}

procedure u_Voicedata(start,lsta,sende : longint;Nr : word); external;
{
 Stellt sie Paramterer fr einen Kanal ein. Dabei bezeichnet start die
 Anfangsposition der Stimme im GUS-Ram, lsta den Start der Loop und sende
 die End-Position des Kanals. Die Nummer des Kanals whlen Sie ber Nr.
}

function  Ffaktor(t:word) : word; external;
{
 Die Funktion Ffaktor liefert die der Notennummer t entsprechende Frequenz
 fr die GUS aus der Mod-Frequenztabelle
}

function  Notennr(hoehe : word) : byte; external;
{
 Hiermit ermitteln Sie aus dem in hoehe bergebenen Tonhhen-Wert aus der
 MOD-Datei die Nummer der Note.
}

procedure voice_rampin(Stimme:byte;vol : word); external;
{
 Diese Funktion wird benutzt, um das Knacken von Sampels am Anfang zu ver-
 meiden. Die in Stimme ausgewhlte Stimme wird nicht sofort auf die in vol
 bergebene Lautstrke gesetzt, sondern mit der schnellstmglichen GUS-Ramp
 von 0 auf die Lautstrke hochgeslidet.
 Die Procedure ist ein Ersatz fr u_VoiceVolume.
}

procedure voice_slidein(nr,speed : byte;vol : word); external;
{
 Mit dieser Procedure knnen Sie einen Kanal der GUS einfaden. Nr bezeichnet
 die Nummer des zu fadenden Kanals, in vol bergeben Sie die Ziel-Lautstrke.
 Bei der Geschwindigkeit geben die oberen beiden Bits die Ramp-Speed und die
 unteren 6 Bits den Increment-Faktor an. Die schnellste Ramp errechen Sie mit
 einem Wert von 63, die langsamste mit 192.
}

procedure dos_getmem(var zeiger:pointer;menge:word); external;
{
 Diese Procedure ist ein Erstatz fr die Pascal Getmem-Procedure. Sie
 benutzt jedoch den DOS-Speicher und ist somit fr TSRs lebensnotwendig,
 um nicht immer einen konstanten Speicherbereich zu belegen, sondern den
 Speicherbedarf an das jeweilige MOD anpassen zu knnen.
}

procedure dos_freemem(zeiger:pointer); external;
{
 Dos_Freemem ist das Equivalent zur Pascal Freemem Procedure. Eine Gre
 des freizugebenden Speichers ist nicht anzugeben.
}

procedure init_gus_base(base : word); external;
{
 Initialisiert die Gravis Ultrasound mit der in Base bergebenen Adresse.
}


{$L loadin}
procedure loadin; external;    { Ansi - Pic }


procedure init_the_gus(base : word);
begin;
  init_gus_base(base);
end;

procedure u_init;
var li : integer;
begin;
   u_Initialize;                  { Init im Assembler - Teil }
end;

FUNCTION ConvertString(Source : Pointer; Size : BYTE):String;
{
 Zur umwandlung eines ASCIIZ-Strings in einen Pascal-String
}
VAR
   WorkStr : String;
BEGIN
   Move(Source^,WorkStr[1],Size);
   WorkStr[0] := CHR(Size);
   if pos(#0,Workstr) <> 0 then WorkStr[0] := chr(pos(#0,Workstr)-1);
   ConvertString := WorkStr;
END;

procedure Lade_Instrument(Nr : byte);
{
 Ld das Instrument mit der Nummer nr in das GUS-Ram
}
var gr : longint;
    samp : pointer;
begin;
   gr := Instrumente[nr]^.Groesse;
   if gr > 10 then begin;      { Nur laden wenn > 10, sonst eh crap ! }
     dos_getmem(samp,gr);
     Blockread(gusmf,samp^,gr);
     U_Ram_freepos := U_Ram_freepos + (16-(U_Ram_freepos MOD 16));
     Instrumente[nr]^.Mempos := U_Ram_freepos;
     Ultra_Mem2Gus(samp,Instrumente[nr]^.Mempos,gr);
     dos_freemem(samp);           { Stimmen-Variablen initialisieren  }
     Instrumente[nr]^.l_start :=
        Instrumente[nr]^.Mempos + Instrumente[nr]^.Loop_Start;
     if Instrumente[nr]^.Looping = Mit_loop then begin;
       Instrumente[nr]^.ende :=
         Instrumente[nr]^.Mempos + Instrumente[nr]^.Loop_Ende;
     end else begin;
       Instrumente[nr]^.ende := Instrumente[nr]^.Mempos + gr - 25;
     end;
     Inc(U_Ram_Freepos,gr);       { Verwaltungszeiger weiter setzen   }
   end;
end;

procedure Neue_Interrupt_Speed(speed : word);
{
 Stellt die Geschwindigkeit des Interrupts entsprechend den BpM ein.
}
var zaehler : word;
    loz,hiz : byte;
begin;
 interrupt_speed := round(speed / 2.5);
 zaehler := 1193180 DIV interrupt_speed;
 loz := lo(zaehler);
 hiz := hi(zaehler);
 asm
  cli
  mov dx,43h
  mov al,36h
  out dx,al
  mov dx,40h
  mov al,loz
  out dx,al
  mov al,hiz
  out dx,al
  sti
 end;
end;

procedure _gus_set_chanelpos;
{
 Setzt die Position der einzelnen GUS-Kanle
}
begin;
  u_VoiceBalance(1,chpos[1]);
  u_VoiceBalance(2,chpos[2]);
  u_VoiceBalance(3,chpos[3]);
  u_VoiceBalance(4,chpos[4]);
  u_VoiceBalance(5,chpos[5]);
  u_VoiceBalance(6,chpos[6]);
  u_VoiceBalance(7,chpos[7]);
  u_VoiceBalance(8,chpos[8]);
end;

procedure display_loading(s : string);
{
 Zeigt an, wie weit das Laden der Sampel fortgeschritten ist.
}
var li,slen : integer;
var z : integer;
begin;
  for z := 0 to 12 do begin;
{    move(ptr(seg(loadin),ofs(loadin)+z*34*2)^,ptr($B800,z*160+8*160+44)^,34*2);}
  end;
  while pos('\',s) <> 0 do begin;
    delete(s,1,pos('\',s));
  end;
  slen := length(s);
  slen := (15 - slen) div 2;
  for li := 1 to slen do s := ' '+s;
{  gotoxy(33,13);
  write(s);}
end;

function _gus_modload(name : string) : boolean;
{
 Ld die in name bergebene MOD-Datei. Setzt voraus, da die angegebene
 Datei im Pfad existiert und nicht schreibgeschtzt ist.
}
var dummya : array[0..30] of byte;{ Fr die String - Behandlung       }
    daptr : pointer;              { Pointer auf dummya                }
    dumw : word;                  { Dummy-Variablen zum Einlesen      }
    dumb : byte;
    Restlaenge : longint;         { Zum ermitteln der Patternzahl     }
    li : integer;
    Kennung : array[1..4] of char;{ Die Kennung der MOD-Datei         }
    ias : integer;                { Instrumenten-abhngige Startpos.  }
begin;
  U_Ram_freepos := 32;
  for li := 0 to 15 do begin;
    new(Kanaele[li]);
    kanaele[li]^.vibpos := 0;
  end;
  for li := 0 to 31 do begin;
     new(Instrumente[li]);
     Instrumente[li]^.Name := '';
  end;

  runinf.Zeile := 0;
  runinf.Pattnr := -1;
  tickcounter := 0;
  ticklimit := 6;
  runinf.speed := 6;
  runinf.bpm := 125;
  ias := 0;
  daptr := @dummya;

  assign(gusmf,name);             { File ffnen + Lnge initialisieren}
  reset(gusmf,1);

{  save_screen;
  display_loading(name);}

  Restlaenge := filesize(gusmf);
  Restlaenge := Restlaenge  - 1084;

  seek(gusmf,1080);               { Prfen, ob MOD mit 15/31 Stimmen  }
  Blockread(gusmf,Kennung,4);
  if pos(Kennung,Modkennungen) = 0 then begin;
    { 15 Stimmen ? }
    seek(gusmf,600);
    Blockread(gusmf,Kennung,4);
    if pos(Kennung,Modkennungen) = 0 then begin;
      { Keine gltige .MOD-Datei }
      writeln('Keine gltige .MOD - Datei !!!');
      halt(0);
    end else begin;
      Modinstanz := 15;
      ias := -16*30;
    end;
  end;

  if (Kennung = MODId[1]) or      { Stimmenzahl der MOD-Datei ?       }
     (Kennung = MODId[2]) or
     (Kennung = MODId[3]) or
     (Kennung = MODId[4])
  then begin;
    MOD_Stimmen := 4;
    MOD_Patternsize := 4*256;
  end else
    if (Kennung = CHn6) then begin;
      _gus_modload := false;
      exit;
    end else
      if (Kennung = CHn8) or (Kennung = WOLF) then begin;
        MOD_Stimmen := 8;
        MOD_Patternsize := 8*256;
      end;

  seek(gusmf,0);
  Blockread(gusmf,dummya,20);     { Namen der Datei ermitteln         }
  vh.SongName := ConvertString(daptr,20);
  seek(gusmf,950+ias);            { Liedlnge in Pattern              }
  Blockread(gusmf,vh.Liedlaenge,1);
  seek(gusmf,952+ias);            { Arrangement einlesen              }
  Blockread(gusmf,vh.Arrang,128);

  vh.Num_Inst := Modinstanz;      { Instrumente (15/31) einlesen      }
  seek(gusmf,20+ias);

  for li := 1 to 32 do Instrumente[li]^.Name := '';

  for li := 1 to vh.Num_Inst do begin;
    Blockread(gusmf,dummya,22);   { Instrumenten - Name               }
    Instrumente[li]^.Name := ConvertString(daptr,22);

    Blockread(gusmf,dumw,2);      { Lnge des Sampels                 }
    Instrumente[li]^.Groesse := swap(dumw) * 2;

    Blockread(gusmf,dumb,1);      { Lautstrke einlesen               }
    Blockread(gusmf,dumb,1);
    Instrumente[li]^.Volume := dumb;

    Blockread(gusmf,dumw,2);      { Start der Loop einlesen           }
    Instrumente[li]^.Loop_Start := swap(dumw) * 2;
    Blockread(gusmf,dumw,2);

    dumw := swap(dumw) * 2;       { Loopende aus Start+Lnge einlesen }
    Instrumente[li]^.Loop_Ende := Instrumente[li]^.Loop_Start+dumw;

    if (Instrumente[li]^.Loop_Ende -      { Looping im Instrument ?           }
        Instrumente[li]^.Loop_Start) >= 10 then begin;
      Instrumente[li]^.Looping := mit_loop;
    end else begin;
      Instrumente[li]^.Looping := no_loop;
    end;
    Dec(Restlaenge,Instrumente[li]^.Groesse);
  end;

  Vh.Num_Patts := Restlaenge DIV MOD_Patternsize ; { Patternzahl ?    }
  seek(gusmf,1084+ias);

  for li := 1 to Vh.Num_Patts do begin; { Pattern einlesen            }
    dos_getmem(Pattern[li],MOD_Patternsize );
    Blockread(gusmf,Pattern[li]^,MOD_Patternsize );
  end;

  for li := 1 to vh.Num_Inst do begin; { Instrumente einlesen         }
    Lade_Instrument(li);
{    screen[16,23+li].a := 5;}
  end;

  close(gusmf);

  for i := 1 to 31 do begin; { Kanal-Variablen initialisieren         }
    u_VoiceBalance (i,7) ;
    u_VoiceVolume (i,0) ;
    u_VoiceFreq (i,12000);
    U_StartVoice(i,Stop_Voice);
    u_Voicedata(0,0,0,i);
  end;
  runinf.Zeile := 0;                     { Laufzeit - Variablen init. }
  runinf.Pattnr := -1;
  tickcounter := 0;
  ticklimit := 6;
  runinf.speed := 6;
  runinf.bpm := 125;
  if MOD_Stimmen = 4 then begin;  { Kanle im Halbkreis anordnen      }
    chpos[1] := 2;
    chpos[2] := 12;
    chpos[3] := 9;
    chpos[4] := 5;
    _gus_set_chanelpos;;
  end;
  if MOD_Stimmen = 8 then begin;
    chpos[1] := 8;
    chpos[2] := 6;
    chpos[3] := 10;
    chpos[4] := 4;
    chpos[5] := 11;
    chpos[6] := 3;
    chpos[7] := 13;
    chpos[8] := 1;
    _gus_set_chanelpos;;
  end;

  neue_interrupt_Speed(runinf.bpm);
{  restore_screen;}
  Modinf.Stimmen  := MOD_Stimmen;  { Konstante MOD-Infos in Struktur   }
  Modinf.Tietel   := vh.Songname;  { zur bergabe                      }
  Modinf.Patt_anz := Vh.Liedlaenge;
  _gus_modload    := true;
end;


procedure effekt_vibrato(nr : byte);
{
 Aus dem Effekt-Handling ausgelagerte Vibrato-Procedure
}
var vibswap : integer;
begin;
  inc(Kanaele[nr]^.vibpos,Kanaele[nr]^.vibx);
  if Kanaele[nr]^.vibpos > 64 then
    dec(Kanaele[nr]^.vibpos,64);
  vibswap :=
    (VibratoTable[Kanaele[nr]^.vibpos] * Kanaele[nr]^.viby) div 256;
  inc(Kanaele[nr]^.Start_Ton,vibswap);
  if Kanaele[nr]^.Start_Ton < 1 then
    Kanaele[nr]^.Start_Ton := 1;
  Kanaele[nr]^.Frequenz :=
    longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
  u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
end;


procedure E_toneportamento(nr : byte);
{
 Aus dem Effekt-Handling ausgelagerte TonePortamento-Procedure
}
begin;
  if Kanaele[nr]^.slidespeed < 0 then
  begin
    inc(Kanaele[nr]^.Start_Ton,Kanaele[nr]^.slidespeed);
    if Kanaele[nr]^.Start_Ton < Kanaele[nr]^.Ziel_Ton then
      Kanaele[nr]^.Start_Ton := Kanaele[nr]^.Ziel_Ton;
  end else begin
    inc(Kanaele[nr]^.Start_Ton,Kanaele[nr]^.slidespeed);
    if Kanaele[nr]^.Start_Ton > Kanaele[nr]^.Ziel_Ton then
      Kanaele[nr]^.Start_Ton := Kanaele[nr]^.Ziel_Ton;
  end;

  if Kanaele[nr]^.Start_Ton < 1 then
    Kanaele[nr]^.Start_Ton := 1;
  Kanaele[nr]^.Frequenz :=
    longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
  u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
  oldv[nr] := Kanaele[nr]^.Start_Ton;
end;

procedure EI_toneportamento(nr : byte);
{
 Init fr die aus dem Effekt-Handling ausgelagerte Vibrato-Procedure
}
begin;
  { Inc-Faktor bestimmen }
  if Kanaele[nr]^.Opperand <> 0 then
  begin;
    if Kanaele[nr]^.Start_Ton > Kanaele[nr]^.Ziel_Ton then
    begin;
      Kanaele[nr]^.slidespeed := -(Kanaele[nr]^.Opperand);
    end else begin;
      Kanaele[nr]^.slidespeed := (Kanaele[nr]^.Opperand);
    end;
  end;
  if Kanaele[nr]^.Start_Ton < 1 then
    Kanaele[nr]^.Start_Ton := 1;
  Kanaele[nr]^.Frequenz :=
    longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
  u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
  oldv[nr] := Kanaele[nr]^.Start_Ton;
end;

procedure Initialisiere_Effekte(nr : byte);
var swaplong      : longint;
    vibswap       : integer;
begin;
  if Kanaele[nr]^.Effekt = 0 then exit;
  case Kanaele[nr]^.Effekt of
    0 : begin; { Appegio }
          Kanaele[nr]^.Appegpos := 0;
          Kanaele[nr]^.Effektx := Kanaele[nr]^.Opperand shr 4;
          Kanaele[nr]^.Effekty := Kanaele[nr]^.Opperand and $0f;

          inc(Kanaele[nr]^.Appegpos);
          case (Kanaele[nr]^.Appegpos MOD 3) of
            0 : begin; {ap = 3 !}
                  Kanaele[nr]^.Start_Ton :=
                  Kanaele[nr]^.Ton + Kanaele[nr]^.Effekty;
                end;
            1 : begin; {ap = 1 !}
                  Kanaele[nr]^.Start_Ton :=
                  Kanaele[nr]^.Ton;
                end;
            2 : begin; {ap = 2 !}
                  Kanaele[nr]^.Start_Ton :=
                  Kanaele[nr]^.Ton + Kanaele[nr]^.Effektx;
                end;
          end;
          if Kanaele[nr]^.Start_Ton < 1 then
            Kanaele[nr]^.Start_Ton := 1;
          Kanaele[nr]^.Frequenz :=
            longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
          u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
        end;
    1 : begin;  { Portamento up }
          dec(Kanaele[nr]^.Start_Ton,Kanaele[nr]^.Opperand);
          if Kanaele[nr]^.Start_Ton < 1 then
            Kanaele[nr]^.Start_Ton := 1;
          Kanaele[nr]^.Frequenz :=
            longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
          u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
        end;
    2 : begin;  { Portamento down }
          inc(Kanaele[nr]^.Start_Ton,Kanaele[nr]^.Opperand);
          if Kanaele[nr]^.Start_Ton < 1 then
            Kanaele[nr]^.Start_Ton := 1;
          Kanaele[nr]^.Frequenz :=
            longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
          u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
        end;
    3 : begin; { Tone Portamento }
          EI_toneportamento(nr);
        end;
    4 : begin;  { Vibrato  *new* }
          Kanaele[nr]^.vibx := Kanaele[nr]^.Opperand shr 4;
          Kanaele[nr]^.viby := Kanaele[nr]^.Opperand and $0f;
          effekt_vibrato(nr);
        end;
    5 : begin; {NOTE SLIDE + VOLUME SLIDE:   *new* }
          { init }
          if Kanaele[nr]^.Opperand <= $0f then
          begin;
            Kanaele[nr]^.vslide := -(Kanaele[nr]^.Opperand AND $0f);
            Kanaele[nr]^.slidespeed := -(Kanaele[nr]^.Opperand AND $0f);
          end else begin;
            Kanaele[nr]^.vslide := (Kanaele[nr]^.Opperand shr 4);
            Kanaele[nr]^.slidespeed := (Kanaele[nr]^.Opperand shr 4);
          end;
          { volume slide }
          inc(Kanaele[nr]^.volume,Kanaele[nr]^.vslide);
          if Kanaele[nr]^.volume < 0 then Kanaele[nr]^.volume := 0;
          if Kanaele[nr]^.volume > 63 then Kanaele[nr]^.volume := 63;
          if Kanaele[nr]^.volume-FadeOut>0 then u_VoiceVolume(Nr,Kanaele[nr]^.volume-FadeOut);
          { Note slide }
          inc(Kanaele[nr]^.Start_Ton,Kanaele[nr]^.slidespeed);
          if Kanaele[nr]^.Start_Ton < 1 then
            Kanaele[nr]^.Start_Ton := 1;
          Kanaele[nr]^.Frequenz :=
            longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
          u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
        end;
    6 : begin;  { Vibrato & Volume slide  *new* }
          { init }
          Kanaele[nr]^.vibx := Kanaele[nr]^.Opperand shr 4;
          Kanaele[nr]^.viby := Kanaele[nr]^.Opperand and $0f;
          if Kanaele[nr]^.Opperand <= $0f then
          begin;
            Kanaele[nr]^.vslide := -(Kanaele[nr]^.Opperand AND $0f);
          end else begin;
            Kanaele[nr]^.vslide := (Kanaele[nr]^.Opperand shr 4);
          end;
          { volume slide }
          inc(Kanaele[nr]^.volume,Kanaele[nr]^.vslide);
          if Kanaele[nr]^.volume < 0 then Kanaele[nr]^.volume := 0;
          if Kanaele[nr]^.volume > 63 then Kanaele[nr]^.volume := 63;
          if Kanaele[nr]^.volume-FadeOut>0 then u_VoiceVolume(Nr,Kanaele[nr]^.volume-FadeOut);
          { vibrato }
          effekt_vibrato(nr);
        end;
    7 : begin; { tremolo  *new* }
           Kanaele[nr]^.vibx := Kanaele[nr]^.Opperand shr 4;
           Kanaele[nr]^.viby := Kanaele[nr]^.Opperand and $0f;
           inc(Kanaele[nr]^.vibpos,Kanaele[nr]^.vibx);
           if Kanaele[nr]^.vibpos > 64 then
             dec(Kanaele[nr]^.vibpos);
           vibswap :=
             (VibratoTable[Kanaele[nr]^.vibpos] * Kanaele[nr]^.viby) div 256;
           inc(Kanaele[nr]^.Volume,vibswap);
           if Kanaele[nr]^.Volume < 0 then Kanaele[nr]^.Volume := 0;
           if Kanaele[nr]^.Volume > 63 then Kanaele[nr]^.Volume := 63;
           if Kanaele[nr]^.volume-FadeOut>0 then u_VoiceVolume(nr,Kanaele[nr]^.volume-FadeOut);
        end;
    8 : begin; { Synchonisation }
        if  SyncMod then SyncTrigger:=True;
        end;
    9 : begin;  { Sampel - Offset *new* }
          swaplong := longint((Kanaele[nr]^.Opperand+1)) * 256;
          Kanaele[nr]^.Mempos := Kanaele[nr]^.Mempos+swaplong;
          u_Voicedata(Kanaele[nr]^.Mempos,Kanaele[nr]^.Loop_Start,
                    Kanaele[nr]^.Ende,nr);
          U_StartVoice(nr,Play_Voice+Bit8+Kanaele[nr]^.Looping+Unidirect);
        end;
   $a : begin;  { Volume sliding  *new* }
          if Kanaele[nr]^.Opperand <= $0f then
          begin;
            Kanaele[nr]^.vslide := -(Kanaele[nr]^.Opperand AND $0f);
          end else begin;
            Kanaele[nr]^.vslide := (Kanaele[nr]^.Opperand shr 4);
          end;
          inc(Kanaele[nr]^.volume,Kanaele[nr]^.vslide);
          if Kanaele[nr]^.volume < 0 then Kanaele[nr]^.volume := 0;
          if Kanaele[nr]^.volume > 63 then Kanaele[nr]^.volume := 63;
          if Kanaele[nr]^.volume-FadeOut>0 then u_VoiceVolume(Nr,Kanaele[nr]^.volume-FadeOut);
        end;
   $b : begin; { Position Jump *ok* }
          runinf.Zeile := 64;
          runinf.Pattnr := Kanaele[nr]^.Opperand;
        end;
   $c : begin; { Set Note Volume *ok* }
          if Kanaele[nr]^.Opperand > 63 then Kanaele[nr]^.Opperand := 63;
          if Kanaele[nr]^.Opperand < 1 then
          begin
            Kanaele[nr]^.volume := 0;
            u_VoiceVolume(nr,0);
            U_StartVoice(nr,Stop_Voice);
            stop_Thevoice[nr] := true;
          end else begin
            Kanaele[nr]^.volume := Kanaele[nr]^.Opperand;
            if Kanaele[nr]^.volume-FadeOut>0 then u_VoiceVolume(Nr,Kanaele[nr]^.volume-FadeOut);
            Runinf.Volumes[nr] := 63-FadeOut;
          end;
        end;
   $d : begin; { Patterm Break *ok* }
          runinf.Zeile := 64;
        end;
   $e : begin;  { Erweiterter Effekt - Befehl }
          case (Kanaele[nr]^.Opperand shr 4) of
            1 : begin; { Fine slide up }
                  dec(Kanaele[nr]^.Start_Ton,Kanaele[nr]^.Opperand and $0f);
                  if Kanaele[nr]^.Start_Ton < 1 then Kanaele[nr]^.Start_Ton := 1;
                  Kanaele[nr]^.Frequenz :=
                    longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
                  u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
                end;
            2 : begin; { Fine slide down }
                  inc(Kanaele[nr]^.Start_Ton,Kanaele[nr]^.Opperand and $0f);
                  if Kanaele[nr]^.Start_Ton < 1 then Kanaele[nr]^.Start_Ton := 1;
                  Kanaele[nr]^.Frequenz :=
                    longint(Voice_Base[14] div Kanaele[nr]^.Start_Ton);
                  u_VoiceFreq(nr,Kanaele[nr]^.Frequenz);
                end;
            9 : begin; { Retriggering !!! *new* }
                  Kanaele[nr]^.Retrig_count :=
                    Kanaele[nr]^.Opperand and $0f;
                end;
           $a : begin; { fine volume slide up }
                  Kanaele[nr]^.vslide := (Kanaele[nr]^.Opperand AND $0f);
                  inc(Kanaele[nr]^.volume,Kanaele[nr]^.vslide);
                  if Kanaele[nr]^.volume < 0 then Kanaele[nr]^.volume := 0;
                  if Kanaele[nr]^.volume > 63 then Kanaele[nr]^.volume := 63;
                  if Kanaele[nr]^.volume-FadeOut>0 then u_VoiceVolume(Nr,Kanaele[nr]^.volume-FadeOut);
                end;
           $b : begin; { fine volume slide down }
                  Kanaele[nr]^.vslide := (Kanaele[nr]^.Opperand AND $0f);
                  dec(Kanaele[nr]^.volume,Kanaele[nr]^.vslide);
                  if Kanaele[nr]^.volume < 0 then Kanaele[nr]^.volume := 0;
                  if Kanaele[nr]^.volume > 63 then Kanaele[nr]^.volume := 63;
                  if Kanaele[nr]^.volume-FadeOut>0 then u_VoiceVolume(Nr,Kanaele[nr]^.volume-FadeOut);
                end;
           $c : begin;  { Cut Voice *ok* }
                  stop_Thevoice[nr] := true;
                end;
           end;
        end;
   $f : begin; { Set Speed  *ok* }
          if Kanaele[nr]^.Opperand <= $f then begin;
            ticklimit := Kanaele[nr]^.Opperand;
            runinf.speed := ticklimit;
          end else begin;
            runinf.bpm := Kanaele[nr]^.Opperand;
            neue_interrupt_Speed(Kanaele[nr]^.Opperand);
          end;
        end;
  end;
end;

procedure play_pattern_gus;
{
 Diese Procedure wird periodisch aufgerufen. Sie spielt eine Zeile der
 MOD-Datei ab.
}
var li        : integer;
    dumw      : word;
    Die_Zeile : array[1..8,0..3] of Byte;
    Effekt    : byte;
    Ton       : word;
    Inst      : byte;
begin;
{
 **************************************************************************
 ***   Im Mod vorrcken                                                 ***
 **************************************************************************
}
  inc(runinf.Zeile);              { Eine Zeile vorrcken              }
  if runinf.Zeile > 64 then runinf.Zeile := 1;
  if runinf.Zeile = 1 then begin; { Neues Pattern ?                   }
    inc(runinf.Pattnr);
    if runinf.Pattnr > vh.Liedlaenge then runinf.Pattnr := 1;
  end;
                                  { Noten laden                       }
  move(ptr(seg(pattern[vh.Arrang[runinf.Pattnr]+1]^),
       ofs(pattern[vh.Arrang[runinf.Pattnr]+1]^)+
          (runinf.Zeile-1)*4*Mod_Stimmen)^,
       Die_Zeile,4*8);

{
 **************************************************************************
 ***   Die Stimmen abarbeiten                                           ***
 **************************************************************************
}
  for li := 1 to MOD_Stimmen do begin;
    if play_chanel[li] = 1 then begin;
      stop_Thevoice[li] := false;

      Ton  := ((Die_Zeile[li,0] AND $0f) shl 8)+Die_Zeile[li,1];
      Inst := (Die_Zeile[li,0] AND $f0)+((Die_Zeile[li,2] AND $F0) SHR 4);
      Kanaele[li]^.Effekt   := Die_Zeile[li,2] AND $0f;
      Kanaele[li]^.Opperand := Die_Zeile[li,3];

      Kanaele[li]^.Start_Ton := oldv[li];

      if Ton <> 0 then begin;  { Ist ein Ton eingetragen ??? }
        if Kanaele[li]^.Effekt = 3 then begin;
          Kanaele[li]^.Ziel_Ton := Ton;
        end else begin;
          Kanaele[li]^.Ton := Ton;
          Kanaele[li]^.Start_Ton := Ton;
          oldv[li] := Kanaele[li]^.Start_Ton;
        end;
      end;

      If Inst <> 0 then begin; { neues Instrument benutzen ??? }
        Kanaele[li]^.InstNr     := Inst;
        Kanaele[li]^.Mempos     := Instrumente[Kanaele[li]^.InstNr]^.Mempos;
        Kanaele[li]^.Loop_Start := Instrumente[Kanaele[li]^.InstNr]^.l_start;
        Kanaele[li]^.Ende       := Instrumente[Kanaele[li]^.InstNr]^.ende;
        Kanaele[li]^.volume     := Instrumente[Kanaele[li]^.InstNr]^.volume;
        Kanaele[li]^.Looping    := Instrumente[Kanaele[li]^.InstNr]^.Looping;
        u_Voicedata(Kanaele[li]^.Mempos,Kanaele[li]^.Loop_Start,
                    Kanaele[li]^.Ende,li);
      end;
      Kanaele[li]^.Retrig_count := 0;

      Initialisiere_Effekte(li);


      If (Ton <> 0) then begin; { Note angeschlagen }
        Kanaele[li]^.Frequenz := longint(Voice_Base[14] div Kanaele[li]^.Start_Ton);
        u_VoiceFreq(li,Kanaele[li]^.Frequenz); { Frequenz setzen }


        if Kanaele[li]^.Effekt = $c then begin; { Extra, weil sonst zu frh ! }
          if Kanaele[li]^.Opperand > 63 then Kanaele[li]^.Opperand := 63;
          if Kanaele[li]^.Opperand < 1 then
          begin
            Kanaele[li]^.volume := 0;
            u_VoiceVolume(li,0);
            U_StartVoice(li,Stop_Voice);
            stop_Thevoice[li] := true;
          end else begin
            Kanaele[li]^.volume := Kanaele[li]^.Opperand;
            if Kanaele[li]^.volume-FadeOut>0 then u_VoiceVolume(li,Kanaele[li]^.volume-FadeOut);
            Runinf.Volumes[li] := 63-FadeOut;
          end;
        end else begin;
          if Kanaele[li]^.volume > 63 then Kanaele[li]^.volume := 63;
           if Kanaele[li]^.volume-FadeOut>0 then voice_rampin(li,Kanaele[li]^.volume-FadeOut);
           Runinf.Volumes[li] := 63-FadeOut;
        end;

        U_StartVoice(li,Stop_Voice); { Alte Stimme anhalten }

        u_Voicedata(Kanaele[li]^.Mempos,Kanaele[li]^.Loop_Start,
                    Kanaele[li]^.Ende,li);
        if not stop_Thevoice[li] then begin; { Neue Stimme starten }
          U_StartVoice(li,Play_Voice+Bit8+Kanaele[li]^.Looping+Unidirect);
          Runinf.Ausschlag[li] := Kanaele[li]^.volume * 4; { Fr Equalizer }
        end;
      end; { Note angeschlagen }
    end else begin;
      u_VoiceVolume(li,0);
    end;
  if Kanaele[li]^.volume-FadeOut>0 then u_VoiceVolume(li,Kanaele[li]^.volume-FadeOut);
  end; {for}
end;

procedure tick_effects;
var li : integer;
    vibswap : integer;
begin;
  for li := 1 to MOD_Stimmen do begin;
    if runinf.volumes[li] > 0 then
      dec(runinf.volumes[li]);
    case Kanaele[li]^.Effekt of { Laufzeit - Effekte abarbeiten         }
      0 : begin;
            inc(Kanaele[li]^.Appegpos);
            case (Kanaele[li]^.Appegpos MOD 3) of
              0 : begin; {ap = 3 !}
                    Kanaele[li]^.Start_Ton :=
                    Kanaele[li]^.Ton + Kanaele[li]^.Effekty;
                  end;
              1 : begin; {ap = 1 !}
                    Kanaele[li]^.Start_Ton :=
                    Kanaele[li]^.Ton;
                  end;
              2 : begin; {ap = 2 !}
                    Kanaele[li]^.Start_Ton :=
                    Kanaele[li]^.Ton + Kanaele[li]^.Effektx;
                  end;
             end;
          end;
      1 : begin;
          {!"! new }
            Kanaele[li]^.Opperand := Kanaele[li]^.Opperand and $0F;
          {!"! new end }
            dec(Kanaele[li]^.Start_Ton,Kanaele[li]^.Opperand);
            if Kanaele[li]^.Start_Ton < 1 then
              Kanaele[li]^.Start_Ton := 1;
            Kanaele[li]^.Frequenz :=
              longint(Voice_Base[14] div Kanaele[li]^.Start_Ton);
            u_VoiceFreq(li,Kanaele[li]^.Frequenz);
          end;
      2 : begin;
          {!"! new }
            Kanaele[li]^.Opperand := Kanaele[li]^.Opperand and $0F;
          {!"! new end }
            inc(Kanaele[li]^.Start_Ton,Kanaele[li]^.Opperand);
            if Kanaele[li]^.Start_Ton < 1 then
              Kanaele[li]^.Start_Ton := 1;
            Kanaele[li]^.Frequenz :=
              longint(Voice_Base[14] div Kanaele[li]^.Start_Ton);
            u_VoiceFreq(li,Kanaele[li]^.Frequenz);
          end;
      3 : begin; { Tone Portamento }
            E_toneportamento(li);
          end;
      4 : begin;  { vibrato  *new* }
            effekt_vibrato(li);
          end;
     5 : begin;
           { volume slide }
           inc(Kanaele[li]^.volume,Kanaele[li]^.vslide);
           if Kanaele[li]^.volume < 0 then Kanaele[li]^.volume := 0;
           if Kanaele[li]^.volume > 63 then Kanaele[li]^.volume := 63;
           if Kanaele[li]^.volume-FadeOut>0 then u_VoiceVolume(li,Kanaele[li]^.volume-FadeOut);
           { Note slide }
           inc(Kanaele[li]^.Start_Ton,Kanaele[li]^.slidespeed);
            if Kanaele[li]^.Start_Ton < 1 then
              Kanaele[li]^.Start_Ton := 1;
           Kanaele[li]^.Frequenz :=
             longint(Voice_Base[14] div Kanaele[li]^.Start_Ton);
           u_VoiceFreq(li,Kanaele[li]^.Frequenz);
         end;
     6 : begin;
           { volume slide }
           inc(Kanaele[li]^.volume,Kanaele[li]^.vslide);
           if Kanaele[li]^.volume < 0 then Kanaele[li]^.volume := 0;
           if Kanaele[li]^.volume > 63 then Kanaele[li]^.volume := 63;
           if Kanaele[li]^.volume-FadeOut>0 then u_VoiceVolume(li,Kanaele[li]^.volume-FadeOut);
           { vibrato }
           inc(Kanaele[li]^.vibpos,Kanaele[li]^.vibx);
           if Kanaele[li]^.vibpos > 64 then
             dec(Kanaele[li]^.vibpos);
           vibswap :=
             (VibratoTable[Kanaele[li]^.vibpos] * Kanaele[li]^.viby) div 256;
           inc(Kanaele[li]^.Start_Ton,vibswap);
            if Kanaele[li]^.Start_Ton < 1 then
              Kanaele[li]^.Start_Ton := 1;
           Kanaele[li]^.Frequenz :=
             longint(Voice_Base[14] div Kanaele[li]^.Start_Ton);
           u_VoiceFreq(li,Kanaele[li]^.Frequenz);
         end;
     7 : begin; { tremolo  *new* }
            inc(Kanaele[li]^.vibpos,Kanaele[li]^.vibx);
            if Kanaele[li]^.vibpos > 64 then
              dec(Kanaele[li]^.vibpos);
            vibswap :=
              (VibratoTable[Kanaele[li]^.vibpos] * Kanaele[li]^.viby) div 256;
            inc(Kanaele[li]^.Volume,vibswap);
            if Kanaele[li]^.Volume < 0 then Kanaele[li]^.Volume := 0;
            if Kanaele[li]^.Volume > 63 then Kanaele[li]^.Volume := 63;
            if Kanaele[li]^.volume-FadeOut>0 then u_VoiceVolume(li,Kanaele[li]^.volume-FadeOut);
         end;
    8 : begin; { Synchronisation }
            if SyncMod then SyncTrigger:=True;
        end;
    $a : begin; { Volume sliding   **new* }
           inc(Kanaele[li]^.volume,Kanaele[li]^.vslide);
           if Kanaele[li]^.volume < 0 then Kanaele[li]^.volume := 0;
           if Kanaele[li]^.volume > 63 then Kanaele[li]^.volume := 63;
           if Kanaele[li]^.volume-FadeOut>0 then u_VoiceVolume(li,Kanaele[li]^.volume-FadeOut);
         end;
    $e : begin;  { Erweiterter Effekt - Befehl }
          case (Kanaele[li]^.Opperand shr 4) of
              9: begin; { Retriggering !!! }
                   if Kanaele[li]^.Opperand and $0f <> 0 then begin;
                     dec(Kanaele[li]^.Retrig_count);
                     if Kanaele[li]^.Retrig_count = 0 then begin;
                       Kanaele[li]^.Retrig_count := Kanaele[li]^.Opperand and $0f;
                       u_Voicedata(Kanaele[li]^.Mempos,Kanaele[li]^.Loop_Start,
                              Kanaele[li]^.Ende,li);
                       U_StartVoice(li,Play_Voice+Bit8+Kanaele[li]^.Looping+Unidirect);
                     end;
                   end;
                 end;
           end;
        end;
    end;
  end;
end;

{$F+}
procedure mytimer; interrupt;
{
 Mein Timer-Interrupt
}
begin;
  tick_effects;
  inc(tickcounter);
  if tickcounter >= ticklimit then begin;
    Tickcounter := 0;
    Play_Pattern_gus;
  end;
  Port[$20] := $20;
end;

procedure tue_nichts; interrupt;
{
 Dummy-Interrupt. Auf ihn wird geschaltet, wenn die Ausgabe angehalten wird.
}
begin;
  port[$20] := $20;
end;

procedure _gus_modstarten;
{
 Startet die Ausgabe des MOD-Files ber den Timer-Interrupt. Das MOD-File
 mu bereits geladen worden sein !
}
var zaehler : word;
    loz,hiz : byte;
begin;
 zaehler := 1193180 DIV interrupt_speed;
 loz := lo(zaehler);
 hiz := hi(zaehler);
 asm
  cli
  mov dx,43h
  mov al,36h
  out dx,al
  mov dx,40h
  mov al,loz
  out dx,al
  mov al,hiz
  out dx,al
 end;
 getintvec(8,altertimer);
 setintvec(8,@Mytimer);
 asm sti end;
end;


procedure _gus_player_pause;
{
 Hlt die Ausgabe ber den Timer-Interrupt an
}
var li : integer;
begin;
 setintvec(8,@Tue_nichts);
 for li := 0 to 31 do
   u_VoiceVolume (li,0) ;
end;

procedure _gus_player_continue;
{
 Setzt die Ausgabe ber den Timer-Interrupt fort.
}
var li : integer;
begin;
 setintvec(8,@Mytimer);
 for li := 1 to 31 do
   if Kanaele[li]^.volume-FadeOut>0 then Voice_Rampin(li,Kanaele[li]^.volume-FadeOut);
end;

procedure timerint_zurueck;
{
 Resettet den Timer-Interrupt auf seinen ursprnglichen Wert.
}
begin;
 asm
  cli
  mov dx,43h
  mov al,36h
  out dx,al
  xor ax,ax
  mov dx,40h
  out dx,al
  out dx,al
 end;
 setintvec(8,altertimer);
 asm sti end;
end;

procedure dispose_mod;
{
 Entfernt ein geladenens MOD aus dem Hauptspeicher. Die Sampels auf der GUS
 werden NICHT gelscht.
}
begin;
  for i := 0 to 31 do begin;
    U_StartVoice(i,Stop_Voice);
  end;
  for i := 1 to Vh.Num_Patts do begin;
    dos_freemem(Pattern[i]);
  end;
  for i := 0 to 15 do begin;
    dispose(Kanaele[i]);
  end;
  for i := 0 to 31 do begin;
     dispose(Instrumente[i]);
  end;
end;

procedure _gus_mod_beenden;
{
 Beendet die Ausgabe eines MODs
}
begin;
  timerint_zurueck;
  dispose_mod;
end;

procedure _gus_initialisieren;
{
 Initialisiert die GUS
}
begin;
  u_init;
  gus_speaker_on;
end;

procedure get_from_environment;
{
 Ermittelt die Base-Adresse der GUS aus der Environment-Variablen
 ULTRASND
}
var apos,ipos,dpos : integer;
    astr,istr,dstr,gusstr : string;
    code : integer;
begin;
  GUS_envstr := GetEnv('ULTRASND');

 { GUS - Base erkennen }
  gusstr := Copy(GUS_envstr,1,3);
  val(gusstr,GUS_BASE,code);
  if code <> 0 then begin;
    GUS_Environment := false;
  end else
    GUS_Environment := true;
end;

function dec_2_hex(w : word) : word;
{
 Convertiert eine Dezimal-Zahl in eine Hex-Zahl. Wichtig fr Environment-
 Behandlung
}
const exp : array[1..4] of word = (4096,256,16,0);
var c,hs : string;
    v,i,li : integer;
begin;
  str(w,hs);
  while length(hs) < 4 do hs := '0'+hs;
  w := 0;
  for li := 1 to 4 do begin;
    c := hs[li];
    val(c,v,i);
    w := w + v * exp[li];
  end;
  dec_2_hex := w;
end;

procedure write_environment;
{
 Gibt die aus den Environment ermittelte BASE-Adresse der GUS aus
}
begin;
  if GUS_Environment then begin;
{    writeln(' GUS_BASE: ',GUS_BASE);
    writeln(' initializing Gravis Ultrasound Card');}
    gus_base := dec_2_hex(gus_base);
    init_the_gus(Gus_base);
{    delay(777);}
  end else begin;
{    writeln('The environment-variable ULTRASND is not set !');
    delay(777);}
  end;
end;

function _gus_init_env : boolean;
{
 Initialisiert die GUS, keine Hardware-Detection sondern Prfen der
 Umgebungs-Variablen ULTRASND
}
begin;
{  clrscr;}
  get_from_environment;
  write_environment;
  _gus_init_env := gus_environment;
end;

begin;
end.
