Unit NormFont;
Interface
uses Dos, Crt, NormVga;
type
   Zeich = Array[0..79] of TSprite;

const
   chdata1 : array[1..(26*4)] of integer=(
   4,12,13,23,    {a}
   16,12,24,23,   {b}
   28,12,36,23,   {c}
   40,12,48,23,   {d}
   52,12,60,23,   {e}
   64,12,68,23,   {f}
   72,12,80,26,   {g}
   84,12,92,23,   {h}
   94,12,100,23,  {i}
   101,12,106,25, {j}
   110,12,119,23, {k}
   120,12,125,23, {l}
   128,12,141,23, {m}
   144,12,154,23, {n}
   157,12,165,23, {o}
   168,12,177,25, {p}
   180,12,190,25, {q}
   192,12,200,23, {r}
   202,12,211,23, {s}
   212,12,220,23, {t}
   222,12,230,23, {u}
   232,12,241,23, {v}
   243,12,256,23, {w}
   258,12,266,23, {x}
   269,12,277,26, {y}
   281,12,290,23);{z}

   chdata2 : array[1..(26*4)] of integer=(
   2,34,13,45,    {A}
   12,34,22,45,   {B}
   22,34,33,45,   {C}
   33,34,44,45,   {D}
   44,34,54,45,   {E}
   54,34,62,45,   {F}
   63,34,73,45,   {G}
   74,34,83,45,   {H}
   83,34,87,45,   {I}
   85,34,95,45,   {J}
   94,34,103,45,  {K}
   104,34,114,45, {L}
   112,34,122,45, {M}
   123,34,132,45, {N}
   133,34,143,45, {O}
   145,34,154,45, {P}
   155,34,165,45, {Q}
   167,34,178,45, {R}
   178,34,188,45, {S}
   187,34,196,45, {T}
   197,34,207,45, {U}
   206,34,215,45, {V}
   215,34,231,45, {W}
   231,34,240,45, {X}
   240,34,249,45, {Y}
   249,34,259,45);{Z}

   chdata3 : array[1..(27*4)] of integer=(
   6,59,11,70,    {1}
   13,59,23,70,   {2}
   21,59,31,70,   {3}
   29,59,37,70,   {4}
   37,59,46,70,   {5}
   45,59,54,70,   {6}
   54,59,63,70,   {7}
   62,59,70,70,   {8}
   69,59,78,70,   {9}
   78,59,87,70,   {0}
   89,59,95,73,   {;}
   98,59,105,70,  {:}
   103,59,110,73, {,}
   109,59,115,70, {.}
   116,59,124,70, {-}
   126,59,134,70, {(}
   135,59,145,70, {)}
   144,59,152,70, {=}
   157,59,165,70, {+}
   169,59,174,70, {/}
   178,59,195,70, {%}
   195,59,208,70, {&}
   209,59,216,70, {"}
   219,59,227,70, {!}
   228,59,237,70, {?}
   238,59,247,70, {*}
   248,59,260,70);{#}
var
   Zeichen, Zeichen1, Zeichen2 : ^Zeich;
   csr : integer;
   bold : boolean;

type

   TFont = Object
    Constructor Init;
    procedure Print(st : string; x, y : integer; c : integer);
    procedure BoldPrint(st : string; x, y : integer; c : integer);
    procedure TyperPrint(st : string; x, y : integer; c : integer);
    Destructor Done;
  End;


Var
   Font : TFont;

Implementation

Constructor TFont.Init;
var i, cx1, cy1, cx2, cy2 : integer;
begin;
New(Zeichen);
New(Zeichen1);
New(Zeichen2);
Bold:=False;
vga.Init(False);
vga.ClearScreen;
vga.ReadGFX('SDTFNT0.GFX',True);
for i:=0 to 25 do begin;
cx1:=chdata1[(i*4)+1];
cy1:=chdata1[(i*4)+2];
cx2:=chdata1[(i*4)+3];
cy2:=chdata1[(i*4)+4];
Zeichen^[i].Init(cx2-cx1, cy2-cy1);
Zeichen^[i].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 25 do begin;
cx1:=chdata2[(i*4)+1];
cy1:=chdata2[(i*4)+2];
cx2:=chdata2[(i*4)+3];
cy2:=chdata2[(i*4)+4];
Zeichen^[i+26].Init(cx2-cx1, cy2-cy1);
Zeichen^[i+26].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 26 do begin;
cx1:=chdata3[(i*4)+1];
cy1:=chdata3[(i*4)+2];
cx2:=chdata3[(i*4)+3];
cy2:=chdata3[(i*4)+4];
Zeichen^[i+26+27].Init(cx2-cx1, cy2-cy1);
Zeichen^[i+26+27].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 25 do begin;
cx1:=chdata1[(i*4)+1];
cy1:=chdata1[(i*4)+2];
cx2:=chdata1[(i*4)+3];
cy2:=chdata1[(i*4)+4];
Zeichen^[i].Init(cx2-cx1, cy2-cy1);
Zeichen^[i].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 25 do begin;
cx1:=chdata2[(i*4)+1];
cy1:=chdata2[(i*4)+2];
cx2:=chdata2[(i*4)+3];
cy2:=chdata2[(i*4)+4];
Zeichen^[i+26].Init(cx2-cx1, cy2-cy1);
Zeichen^[i+26].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 26 do begin;
cx1:=chdata3[(i*4)+1];
cy1:=chdata3[(i*4)+2];
cx2:=chdata3[(i*4)+3];
cy2:=chdata3[(i*4)+4];
Zeichen^[i+26+27].Init(cx2-cx1, cy2-cy1);
Zeichen^[i+26+27].GrabSpriteFromMemory(cx1, cy1);
end;
vga.ReadGFX('SDTFNT1.GFX',True);
for i:=0 to 25 do begin;
cx1:=chdata1[(i*4)+1];
cy1:=chdata1[(i*4)+2];
cx2:=chdata1[(i*4)+3];
cy2:=chdata1[(i*4)+4];
Zeichen1^[i].Init(cx2-cx1, cy2-cy1);
Zeichen1^[i].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 25 do begin;
cx1:=chdata2[(i*4)+1];
cy1:=chdata2[(i*4)+2];
cx2:=chdata2[(i*4)+3];
cy2:=chdata2[(i*4)+4];
Zeichen1^[i+26].Init(cx2-cx1, cy2-cy1);
Zeichen1^[i+26].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 26 do begin;
cx1:=chdata3[(i*4)+1];
cy1:=chdata3[(i*4)+2];
cx2:=chdata3[(i*4)+3];
cy2:=chdata3[(i*4)+4];
Zeichen1^[i+26+27].Init(cx2-cx1, cy2-cy1);
Zeichen1^[i+26+27].GrabSpriteFromMemory(cx1, cy1);
end;
vga.ReadGFX('SDTFNT2.GFX',True);
for i:=0 to 25 do begin;
cx1:=chdata1[(i*4)+1];
cy1:=chdata1[(i*4)+2];
cx2:=chdata1[(i*4)+3];
cy2:=chdata1[(i*4)+4];
Zeichen2^[i].Init(cx2-cx1, cy2-cy1);
Zeichen2^[i].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 25 do begin;
cx1:=chdata2[(i*4)+1];
cy1:=chdata2[(i*4)+2];
cx2:=chdata2[(i*4)+3];
cy2:=chdata2[(i*4)+4];
Zeichen2^[i+26].Init(cx2-cx1, cy2-cy1);
Zeichen2^[i+26].GrabSpriteFromMemory(cx1, cy1);
end;
for i:=0 to 26 do begin;
cx1:=chdata3[(i*4)+1];
cy1:=chdata3[(i*4)+2];
cx2:=chdata3[(i*4)+3];
cy2:=chdata3[(i*4)+4];
Zeichen2^[i+26+27].Init(cx2-cx1, cy2-cy1);
Zeichen2^[i+26+27].GrabSpriteFromMemory(cx1, cy1);
end;
vga.Done;
end;

procedure TFont.Print(st : string; x, y : integer; c : integer);
var li, i : integer;
    ox : integer;
begin;
  ox:=x;
  for li := 1 to length(st) do begin;
  if Bold then inc(x,1);
  if st[li]='' then begin; c:=0; end;{BLAU}
  if st[li]='' then begin; c:=1; end;{ROT}
  if st[li]='' then begin; c:=2; end;{GELB}
  if st[li]=' ' then begin; x:=x+5; end;
  if Bold then
  begin
  if x>=305 then begin;
  if csr<11 then begin; inc(csr); y:=y+15; x:=ox; end;
  end;
  end
  else
  begin
  if x>=307 then begin;
  if csr<11 then begin; inc(csr); y:=y+15; x:=ox; end;
  end;
  end;
  if (ord(st[li])>=ord('A')) and (ord(st[li])<=ord('Z')) then begin;
  i := Ord(st[li])-65;
  if c=0 then Zeichen^[i+26].ToggleSprite(x,y);
  if c=1 then Zeichen1^[i+26].ToggleSprite(x,y);
  if c=2 then Zeichen2^[i+26].ToggleSprite(x,y);
  x := x + (chdata2[(i*4)+3] - chdata2[(i*4)+1])- 1 ;
  end;
  if (ord(st[li])>=ord('a')) and (ord(st[li])<=ord('z')) then begin;
  i := Ord(st[li])-97;
  if c=0 then Zeichen^[i].ToggleSprite(x,y);
  if c=1 then Zeichen1^[i].ToggleSprite(x,y);
  if c=2 then Zeichen2^[i].ToggleSprite(x,y);
  x := x + (chdata1[(i*4)+3] - chdata1[(i*4)+1])- 1 ;
  end;
  if c=0 then begin;
  if st[li]='1' then begin; i := 1; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])-2; end;
  if st[li]='2' then begin; i := 2; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='3' then begin; i := 3; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='4' then begin; i := 4; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='5' then begin; i := 5; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='6' then begin; i := 6; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='7' then begin; i := 7; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='8' then begin; i := 8; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='9' then begin; i := 9; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='0' then begin; i := 10; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])+1;
   end;
  if st[li]=';' then begin; i := 11; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=':' then begin; i := 12; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=',' then begin; i := 13; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='.' then begin; i := 14; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='-' then begin; i := 15; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='(' then begin; i := 16; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=')' then begin; i := 17; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='=' then begin; i := 18; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='+' then begin; i := 19; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='/' then begin; i := 20; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]) - 8;
  end;
  if st[li]='%' then begin; i := 21; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='&' then begin; i := 22; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 12; end;
  if st[li]='"' then begin; i := 23; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='`' then begin; i := 23; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=chr(39) then begin; i := 23; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]);
  end;
  if st[li]='!' then begin; i := 24; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='?' then begin; i := 25; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='*' then begin; i := 26; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='#' then begin; i := 27; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  end;
  if c=1 then begin;
  if st[li]='1' then begin; i := 1; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])-2;
   end;
  if st[li]='2' then begin; i := 2; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='3' then begin; i := 3; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='4' then begin; i := 4; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='5' then begin; i := 5; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='6' then begin; i := 6; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='7' then begin; i := 7; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='8' then begin; i := 8; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='9' then begin; i := 9; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='0' then begin; i := 10; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])+1;
  end;
  if st[li]=';' then begin; i := 11; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=':' then begin; i := 12; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=',' then begin; i := 13; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='.' then begin; i := 14; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='-' then begin; i := 15; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='(' then begin; i := 16; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=')' then begin; i := 17; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='=' then begin; i := 18; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='+' then begin; i := 19; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='/' then begin; i := 20; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]) - 8;
  end;
  if st[li]='%' then begin; i := 21; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='&' then begin; i := 22; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 12; end;
  if st[li]='"' then begin; i := 23; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='`' then begin; i := 23; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=chr(39) then begin; i := 23; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]);
  end;
  if st[li]='!' then begin; i := 24; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='?' then begin; i := 25; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='*' then begin; i := 26; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='#' then begin; i := 27; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  end;
  if c=2 then begin;
  if st[li]='1' then begin; i := 1; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])-2;
   end;
  if st[li]='2' then begin; i := 2; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='3' then begin; i := 3; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='4' then begin; i := 4; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='5' then begin; i := 5; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='6' then begin; i := 6; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='7' then begin; i := 7; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='8' then begin; i := 8; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='9' then begin; i := 9; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='0' then begin; i := 10; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])+1;
  end;
  if st[li]=';' then begin; i := 11; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=':' then begin; i := 12; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=',' then begin; i := 13; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='.' then begin; i := 14; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='-' then begin; i := 15; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='(' then begin; i := 16; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=')' then begin; i := 17; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='=' then begin; i := 18; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='+' then begin; i := 19; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='/' then begin; i := 20; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]) - 8;
  end;
  if st[li]='%' then begin; i := 21; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='&' then begin; i := 22; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 12; end;
  if st[li]='"' then begin; i := 23; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='`' then begin; i := 23; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=chr(39) then begin; i := 23; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]);
  end;
  if st[li]='!' then begin; i := 24; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='?' then begin; i := 25; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='*' then begin; i := 26; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='#' then begin; i := 27; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  end;
 end;
end;

procedure TFont.TyperPrint(st : string; x, y : integer; c : integer);
var li, i : integer;
    ox : integer;
begin;
  ox:=x;
  for li := 1 to length(st) do begin;
  if Bold then inc(x,1);
  if st[li]='' then begin; c:=0; end;{BLAU}
  if st[li]='' then begin; c:=1; end;{ROT}
  if st[li]='' then begin; c:=2; end;{GELB}
  if st[li]=' ' then begin; x:=x+5; end;
  if Bold then
  begin
  if x>=305 then begin;
  if csr<11 then begin; inc(csr); y:=y+15; x:=ox; end;
  end;
  end
  else
  begin
  if x>=307 then begin;
  if csr<11 then begin; inc(csr); y:=y+15; x:=ox; end;
  end;
  end;
  if (ord(st[li])>=ord('A')) and (ord(st[li])<=ord('Z')) then begin;
  i := Ord(st[li])-65;
  if c=0 then Zeichen^[i+26].ToggleSprite(x,y);
  if c=1 then Zeichen1^[i+26].ToggleSprite(x,y);
  if c=2 then Zeichen2^[i+26].ToggleSprite(x,y);
  x := x + (chdata2[(i*4)+3] - chdata2[(i*4)+1])- 1 ;
  end;
  if (ord(st[li])>=ord('a')) and (ord(st[li])<=ord('z')) then begin;
  i := Ord(st[li])-97;
  if c=0 then Zeichen^[i].ToggleSprite(x,y);
  if c=1 then Zeichen1^[i].ToggleSprite(x,y);
  if c=2 then Zeichen2^[i].ToggleSprite(x,y);
  x := x + (chdata1[(i*4)+3] - chdata1[(i*4)+1])- 1 ;
  end;
  if c=0 then begin;
  if st[li]='1' then begin; i := 1; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])-2; end;
  if st[li]='2' then begin; i := 2; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='3' then begin; i := 3; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='4' then begin; i := 4; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='5' then begin; i := 5; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='6' then begin; i := 6; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='7' then begin; i := 7; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='8' then begin; i := 8; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='9' then begin; i := 9; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='0' then begin; i := 10; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])+1;
   end;
  if st[li]=';' then begin; i := 11; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=':' then begin; i := 12; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=',' then begin; i := 13; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='.' then begin; i := 14; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='-' then begin; i := 15; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='(' then begin; i := 16; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=')' then begin; i := 17; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='=' then begin; i := 18; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='+' then begin; i := 19; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='/' then begin; i := 20; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]) - 8;
  end;
  if st[li]='%' then begin; i := 21; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='&' then begin; i := 22; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 12; end;
  if st[li]='"' then begin; i := 23; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='`' then begin; i := 23; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=chr(39) then begin; i := 23; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]);
  end;
  if st[li]='!' then begin; i := 24; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='?' then begin; i := 25; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='*' then begin; i := 26; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='#' then begin; i := 27; Zeichen^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  end;
  if c=1 then begin;
  if st[li]='1' then begin; i := 1; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])-2;
   end;
  if st[li]='2' then begin; i := 2; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='3' then begin; i := 3; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='4' then begin; i := 4; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='5' then begin; i := 5; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='6' then begin; i := 6; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='7' then begin; i := 7; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='8' then begin; i := 8; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='9' then begin; i := 9; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='0' then begin; i := 10; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])+1;
  end;
  if st[li]=';' then begin; i := 11; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=':' then begin; i := 12; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=',' then begin; i := 13; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='.' then begin; i := 14; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='-' then begin; i := 15; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='(' then begin; i := 16; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=')' then begin; i := 17; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='=' then begin; i := 18; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='+' then begin; i := 19; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='/' then begin; i := 20; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]) - 8;
  end;
  if st[li]='%' then begin; i := 21; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='&' then begin; i := 22; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 12; end;
  if st[li]='"' then begin; i := 23; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='`' then begin; i := 23; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=chr(39) then begin; i := 23; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]);
  end;
  if st[li]='!' then begin; i := 24; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='?' then begin; i := 25; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='*' then begin; i := 26; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='#' then begin; i := 27; Zeichen1^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  end;
  if c=2 then begin;
  if st[li]='1' then begin; i := 1; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])-2;
   end;
  if st[li]='2' then begin; i := 2; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='3' then begin; i := 3; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='4' then begin; i := 4; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='5' then begin; i := 5; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='6' then begin; i := 6; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='7' then begin; i := 7; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='8' then begin; i := 8; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='9' then begin; i := 9; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='0' then begin; i := 10; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1])+1;
  end;
  if st[li]=';' then begin; i := 11; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=':' then begin; i := 12; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=',' then begin; i := 13; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='.' then begin; i := 14; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='-' then begin; i := 15; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='(' then begin; i := 16; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=')' then begin; i := 17; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='=' then begin; i := 18; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='+' then begin; i := 19; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 10; end;
  if st[li]='/' then begin; i := 20; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]) - 8;
  end;
  if st[li]='%' then begin; i := 21; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='&' then begin; i := 22; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 12; end;
  if st[li]='"' then begin; i := 23; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='`' then begin; i := 23; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]=chr(39) then begin; i := 23; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]);
  end;
  if st[li]='!' then begin; i := 24; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='?' then begin; i := 25; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + (chdata3[(i*4)+3] - chdata3[(i*4)+1]); end;
  if st[li]='*' then begin; i := 26; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 11; end;
  if st[li]='#' then begin; i := 27; Zeichen2^[i+26+26].ToggleSprite(x,y); x := x + 11; end;
  end;
  vga.Wait(1);
  vga.WaitRetrace;
 end;
end;


procedure TFont.BoldPrint(st : string; x, y : integer; c : integer);
begin;
Bold:=True;
Font.Print(st, x-3, y, c);
Font.Print(st, x-2, y, c);
Bold:=False;
end;


Destructor TFont.Done;
begin;
for i:=0 to 25 do begin;
Zeichen^[i].Done;
end;
for i:=0 to 25 do begin;
Zeichen^[i+26].Done;
end;
for i:=1 to 26 do begin;
Zeichen^[i+26+26].Done;
end;
for i:=0 to 25 do begin;
Zeichen1^[i].Done;
end;
for i:=0 to 25 do begin;
Zeichen1^[i+26].Done;
end;
for i:=1 to 26 do begin;
Zeichen1^[i+26+26].Done;
end;
for i:=0 to 25 do begin;
Zeichen2^[i].Done;
end;
for i:=0 to 25 do begin;
Zeichen2^[i+26].Done;
end;
for i:=1 to 26 do begin;
Zeichen2^[i+26+26].Done;
end;
Dispose(Zeichen);
Dispose(Zeichen1);
Dispose(Zeichen2);
end;
Begin;
FNT:=True;
End.