.386p
.MODEL TPASCAL
.DATA
 old_int9  dd ?
.CODE
  public Reset_off
  public Reset_on
assume cs:code,ds:data
handler9 proc near              ;neuer Interrupt 9-Handler
  push ax                       ;benutzte Register sichern
  push bx
  push ds
  push es
  mov ax,data                   ;ds laden
  mov ds,ax

  in al,60h                     ;Zeichen von Tastatur lesen in al

  xor bx,bx                     ;es auf Segment 0
  mov es,bx
  mov bl,byte ptr es:[417h]     ;Tastatur-Status in bl laden

  cmp al,83d                    ;Scan-Code der Entf-Taste ?
  jne kein_Reset                ;nein, dann kein Reset

  and bl,0ch                    ;Strg u. Alt maskieren
  cmp bl,0ch                    ;beide gedrckt ?
  jne kein_Reset                ;nein, dann kein Reset

Block:                          ;Reset oder Break, also blockieren
  mov al,20h                    ;EoI an Interrupt-Controller senden
  out 20h,al
  jmp fertig                    ;und Interrupt verlassen

kein_Reset:                     ;kein Reset, jetzt noch Brak prfen
  cmp al,224d                   ;erweiterte Taste ?
  je evtl_Break                 ;ja -> eventuell Break ausgelst
  cmp al,46d                    ;Taste 'C' ?
  jne legal                     ;nein -> legale Taste
evtl_Break:
  test bl,4                     ;Tastatur-Status auf Strg testen
  jne Block                     ;gedrckt, dann blockieren


legal:                          ;legale Taste -> alten Handler aufrufen
  pushf
  call dword ptr [old_int9]     ;Original-Handler aufrufen
fertig:
  pop es
  pop ds                        ;Register zurckholen
  pop bx
  pop ax
  iret
handler9 endp

public Reset_off
Reset_off proc pascal
  mov ax,data                   ;ds laden
  mov ds,ax

  mov ax,3509h                  ;alten Interrupt-Vektor lesen
  int 21h
  mov word ptr old_int9,bx      ;und speichern
  mov word ptr old_int9 + 2, es

  push ds                       ;ds sichern
  mov ax,cs                     ;mit cs laden
  mov ds,ax
  mov dx,offset handler9        ;auch Offset des Handlers laden
  mov ax,2509h                  ;Vektor setzen
  int 21h
  pop ds
Reset_off endp


public Reset_on
Reset_on proc pascal
  push ds
  lds dx,old_int9               ;alten Vektor wieder setzen
  mov ax,2509h
  int 21h
  pop ds
Reset_on endp

end
