#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <netdb.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/tiuser.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <arpa/inet.h>
#include <rpc/types.h>
#include <rpc/auth.h>
#include <rpc/rpc_msg.h>
#include <pcap.h>

#if HAVE_CONFIG_H
#include "config.h"
#endif

#if !defined TRUE
#define TRUE 1
#endif

#if !defined FALSE
#define FALSE 0
#endif

static char *option_interface = NULL;
static int option_verbose     = FALSE;
           
static int global_argc;
static char **global_argv;

const int snaplen = BUFSIZ;

static void usage( void )
{
    printf( "\n"
	    "usage: %s <options>\n"
	    "\n"
	    "options: -h (help; this short summary of options)\n"
	    "         -v (verbose display)\n"
	    "         -i interface (network interface, default %s)\n"
	    "\n",
	    global_argv[0],
	    option_interface ); 

    exit( 1 );
}

static void parse_argv( void )
{
    int i;

    for( i = 1 ; i < global_argc ; ++i )
    {
	char *opt = global_argv[i];

	if( !strcmp( opt, "-h" ) )
	    usage();

        if( !strcmp( opt, "-i" ) )
	{
	    char *arg = global_argv[++i];

	    option_interface = strdup( arg );

	    if( option_verbose )
		printf( "parsed -i ==> option_interface = %s\n",
			option_interface );
       
	    continue;
        }

	if( !strcmp( opt, "-v" ) )
	{ 
	    option_verbose = TRUE; 

	    if( option_verbose )
		printf( "parsed -v ==> option_verbose = TRUE\n" );

	    continue; 
	}
    }
}

#define NULL_HDRLEN	4
#define PPP_HDRLEN	4

static pcap_t *pd = NULL;

static RETSIGTYPE callback( u_char *user, 
                            const struct pcap_pkthdr *h, 
                            const u_char *p )
{
    const u_char *packet;
    static struct ip *ip = NULL;
    static struct udphdr *udphdr = NULL;
    static struct rpc_msg *rpc_msg = NULL;
    static u_char fh[32];
    int i;
    
    if( !ip )
    { 
        ip = malloc( sizeof( struct ip ) ); 
        udphdr = malloc( sizeof( struct udphdr ) ); 
        rpc_msg = malloc( sizeof( struct rpc_msg ) );
 
        if( !(ip && udphdr && rpc_msg) ) 
        { printf( "malloc() failed!\n" ); exit( 1 ); }
    }
         
    switch( pcap_datalink( pd ) )
    {
        case DLT_NULL:   packet = p + NULL_HDRLEN; break;
        case DLT_PPP:    packet = p + PPP_HDRLEN; break;
        case DLT_EN10MB: packet = p + sizeof( struct ether_header ); break;
        case DLT_SLIP:
        case DLT_FDDI:
        default:         printf( "datalinktype not yet supported! sorry!\n" );
                         exit( 1 );
    }

    memcpy( ip, packet, sizeof( struct ip ) );

    if( ip->ip_p != IPPROTO_UDP )
        return;

    memcpy( udphdr, packet + (ip->ip_hl<<2), sizeof( struct udphdr) );
        
    if( ntohs( udphdr->uh_dport ) != 2049 ) 
        return;

    memcpy( rpc_msg, 
            packet + (ip->ip_hl<<2) + sizeof( struct udphdr),
            sizeof( struct rpc_msg ) );
   
    if( ntohl( rpc_msg->rm_call.cb_proc ) != 0x10 )
        return;

    memcpy( fh, 
            packet + (ip->ip_hl<<2) + sizeof( struct udphdr) +
                                      sizeof( struct rpc_msg ) + 20,
            32 );
            
    printf( "%s --> ", inet_ntoa( ip->ip_src ) );
    printf( "%s:", inet_ntoa( ip->ip_dst ) );
    
    for( i = 0 ; i < 32 ; ++i )
        printf( " %02x", fh[i] );
        
    printf( "\n" );
    
#if 0
{
   int i;
   u_short ihl;
   u_char *udphdr, *rpcmsg, *callbody;
   u_char *data;
   u_char *buf = packet;

   data = (u_char *)callbody + 0x40; 

      /* Discard requests that have cookie != 0 */
   if ((data[32] != 0) || (data[33] != 0) || 
       (data[34] != 0) || (data[35] != 0))
      return;

   printf("%d.%d.%d.%d -> %d.%d.%d.%d : ", buf[26], buf[27], buf[28], buf[29],
      buf[30], buf[31], buf[32], buf[33]);
  
   for(i=0; i < 0x20; i++) {
      printf("%02x ", data[i]);
      /* if ((i % 16) == 15) printf("\n"); */
   }
   printf("\n");
} 
#endif
}

static void print_header( void )
{
    printf( "\n"
	    "Sniffhandle - A portable NFS Filehandle sniffer\n"
	    "===============================================\n"
	    "\n"
	    "Copyright 1995 by Stefan Schmidt <schmidts@informatik.tu-muenchen.de>\n"
	    "\n"
	    "no warranties, use at your own risk, author may not be made responsible\n"
	    "for any harm, damage, lost of information. for educational purposes only.\n"
	    "\n" );
}
static RETSIGTYPE die( int x )
{
    if( pd )
        pcap_close( pd );
        
    exit( 1 );
}

int main( int argc, char *argv[] )
{
    char buf[BUFSIZ];
    char errbuf[PCAP_ERRBUF_SIZE];
    
    print_header();
    option_interface = pcap_lookupdev( errbuf );
    global_argc = argc; global_argv = argv;
    parse_argv();
    
    signal( SIGINT, die );
    signal( SIGKILL, die );
    signal( SIGTERM, die );
    signal( SIGQUIT, die );
    
#if defined __svr4__
    pd = pcap_open_live( option_interface, snaplen, TRUE, 1, errbuf );
#else
    pd = pcap_open_live( option_interface, snaplen, TRUE, 10, errbuf );
#endif

    if( !pd ) 
    { fprintf( stderr, "pcap_open_live() failed: %s\n", errbuf ); exit( 1 ); }
    
    pcap_loop( pd, -1, callback, buf );
    
    die( 0 );
    
    return 0;
}