;
;		GIF encoder
;		Copyright (c) 1989 Alchemy Mindworks Inc.
;		Based on LZCOMP.ASM by Tom Pfau
;

VERSION		EQU	1			;VERSION
SUBVERSION	EQU	0			;SUBVERSION

BUFFERSIZE	EQU	255
MAXMAX		EQU	4096			;MAX CODE + 1

STRUCTSIZE	EQU	32

HASHFIRST	EQU	0			;OFFSETS INTO HASH TABLE
HASHNEXT	EQU	2			;...ENTRY
HASHCHAR	EQU	4

_AOFF		EQU	6			;FAR STACK OFFSET

;THIS MACRO FETCHES THE DATA SEGEMENT
DATASEG		MACRO
		PUSH	AX
		MOV	AX,_DATA
		MOV	DS,AX
		POP	AX
		ENDM

;THIS MACRO FETCHES THE EXTRA SEGEMENT
EXTRASEG	MACRO
		PUSH	AX
		MOV	AX,_DATA
		MOV	ES,AX
		POP	AX
		ENDM

GIFENC_TEXT	SEGMENT BYTE PUBLIC 'CODE'
		ASSUME	CS:GIFENC_TEXT,DS:_DATA

;THIS FUNCTION PACKS A RAW IMAGE FILE INTO A GIF FILE
;		CALLED AS
;		PackGIF(gd);
;		GIFDATA *gd
;
;		return codes 	0 ok
;                               1 error creating file
;				2 error writing header
;				3 error writing data/footer
;				4 error closing file

		PUBLIC	_PackGIF
_PackGIF	PROC	FAR
		PUSH	BP
	 	MOV	BP,SP

		MOV	DI,OFFSET STARTINIT	;ZERO OUT ALL THE BYTES
		MOV	AX,_DATA		;IN THE INITIALIZED DATA
		MOV	ES,AX			;AREA. THIS IS A LOT FASTER
		MOV	CX,ENDINIT - STARTINIT	;THAN RE-INITIALIZING
		CLD				;THE PERTINENT BUFFERS ONE
		MOV	AL,0			;AT A TIME IF THE CODE IS
	REPNE	STOSB				;CALLED MULTIPLE TIMES.

		MOV	SI,[BP + _AOFF + 0]	;OFFSET OF STRUCT
		MOV	DS,[BP + _AOFF + 2]     ;SEGMENT OF STRUCT

		EXTRASEG                        ;POINT TO LOCAL
		MOV	DI,OFFSET GIFSTRUCT	;STRUCT BUFFER
		MOV	CX,STRUCTSIZE
		CLD
	REPNE	MOVSB				;MOVE THE STRUCT

		DATASEG

		MOV	CX,BITS			;GET NUMBER OF BITS
		MOV	AX,1            	;AND WORK OUT
		SHL	AX,CL       		;NUMBER OF COLOURS

		MOV	CLEAR,AX		;WHICH IS CLEAR CODE
		INC	AX                      ;PLUS ONE
		MOV	EOI,AX			;IS GET EOI CODE
		INC	AX                      ;PLUS ONE
		MOV	FIRSTFREE,AX		;IS FIRST FREE POSITION

		CALL	FCREATE			;CREATE THE FILE
		JNC	PACK1 			;CHECK FOR ERROR
      		MOV	AX,0001H		;ERROR CODE
		JMP	PACKX			;AND LEAVE

PACK1:		CALL	HEADER			;WRITE THE GIF HEADER
		JNC	PACK2			;CHECK FOR ERROR
		CALL	FCLOSE			;CLOSE FILE
		MOV	AX,0002H		;ERROR CODE
		JMP	PACKX			;SCOOT

PACK2:		CALL	COMPRESS		;WRITE THE GIF DATA
		CALL	FOOTER			;CLEAN UP
		JNC	PACK3			;CHECK FOR ERROR
		CALL	FCLOSE			;CLOSE FILE
		MOV	AX,0003H		;ERROR CODE
		JMP	PACKX

PACK3:		CALL    FCLOSE			;CLOSE THE FILE
		JNC	PACK4			;CHECK FOR ERROR
		MOV	AX,0004H		;ERROR CODE
		JMP	PACKX			;SCOOT

PACK4:		MOV	AX,0			;NO ERROR - WE'RE LAUGHING

PACKX:		POP	BP
		RET
_PackGIF	ENDP

;WRITE THE GIF HEADER
HEADER		PROC	NEAR

		MOV	DX,OFFSET GIFHEAD
		MOV	CX,6
		CALL	FWRITE			;WRITE 'GIF87a'
                MOV	AX,SCREENWIDE
		CALL	FPUTW			;WRITE SCREEN WIDE
		MOV	AX,SCREENDEEP
		CALL	FPUTW			;WRITE SCREEN DEEP
		MOV	AX,BITS
		DEC	AX
		OR	AL,90H
                CALL	FPUTC			;WRITE GLOBAL FLAG
		MOV	AX,BACKGROUND
		CALL	FPUTC			;WRITE BACKGROUND
		MOV	AL,00H
		CALL	FPUTC			;WRITE DUMMY BYTE

		MOV	AX,1			;SIZE OF GLOBAL
		MOV	CX,BITS			;...COLOUR MAP IS
		SHL	AX,CL			;...2^BITS
		MOV	CX,3			;...TIMES THREE
		MUL	CX

		MOV	CX,AX
		MOV     DX,PALETTEOFF
                PUSH	DS
		MOV	DS,PALETTESEG
		CALL	FWRITE                  ;WRITE GLOBAL PALETTE
		POP	DS

		MOV	AL,','
		CALL	FPUTC			;WRITE IMAGE BLOCK
		MOV	AX,IMAGELEFT
		CALL	FPUTW			;WRITE UPPER X
		MOV	AX,IMAGETOP
		CALL	FPUTW			;WRITE UPPER Y
		MOV	AX,IMAGEWIDE
		CALL	FPUTW			;WRITE IMAGE WIDTH
		MOV	AX,IMAGEDEEP
		CALL	FPUTW			;WRITE IMAGE DEPTH

		MOV	AX,BITS
		DEC	AX
		CALL	FPUTC			;WRITE GLOBAL FLAG

		MOV	AX,BITS			;WRITE INITIAL CODE SIZE
		CALL	FPUTC
		RET
HEADER		ENDP

;TIDY UP AFTER THE GIF FILE DATA HAS BEEN WRITTEN
FOOTER		PROC	NEAR
                MOV	AL,0
		CALL	FPUTC           	;WRITE ZERO LENGTH BLOCK
		MOV	AL,3BH
		CALL	FPUTC			;WRITE END OF FILE MARKER
		RET
FOOTER		ENDP

;COMPRESS THE FILE POINTED TO BY IMAGESEG:IMAGEOFF
COMPRESS	PROC	NEAR
		CALL	INIT_TABLE		;INITIALIZE THE TABLE
		MOV	AX,CLEAR		;WRITE A CLEAR CODE
		CALL	WRITE_CODE
		CALL	FGETCH			;READ FIRST CHAR
L4:		XOR	AH,AH			;TURN CHAR INTO CODE
L4A:		MOV	PREFIXCODE,AX		;SET PREFIX CODE
		CALL	FGETCH			;READ NEXT CHAR
		JC	L17			;CARRY MEANS NO MORE BYTES
		MOV	THISBYTE,AL		;SAVE CHAR IN K
		MOV	BX,PREFIXCODE		;GET PREFIX CODE
		CALL	LOOKUP_CODE		;SEE IF THIS PAIR IN TABLE
		JNC	L4A			;NC MEANS YES, NEW CODE IN AX
		CALL	ADD_CODE		;ADD PAIR TO TABLE
		PUSH	BX			;SAVE NEW CODE
		MOV	AX,PREFIXCODE		;WRITE OLD PREFIX CODE
		CALL	WRITE_CODE
		POP	BX
		MOV	AL,THISBYTE		;GET LAST CHAR
		CMP	BX,MAXCODE		;EXCEED CODE SIZE?
		JL	L4			;LESS MEANS NO
		CMP	NBITS,12		;CURRENTLY LESS THAN 12 BITS?
		JL	L14			;YES
		MOV	AX,CLEAR		;WRITE A CLEAR CODE
		CALL	WRITE_CODE
		CALL	INIT_TABLE		;REINIT TABLE
		MOV	AL,THISBYTE		;GET LAST CHAR
		JMP	L4			;START OVER

L14:		INC	NBITS			;INCREASE NUMBER OF BITS
		SHL	MAXCODE,1		;DOUBLE MAX CODE SIZE
		JMP	L4			;GET NEXT CHAR

L17:		MOV	AX,PREFIXCODE		;WRITE LAST CODE
		CALL	WRITE_CODE
		MOV	AX,EOI			;WRITE EOI CODE
		CALL	WRITE_CODE
		MOV	AX,BITOFFSET		;MAKE SURE BUFFER IS FLUSHED
		CMP	AX,0                    ;TO THE FILE
		JE	L18
		MOV	CX,8			;CONVERT BITS TO BYTES
		XOR	DX,DX
		DIV	CX
		OR	DX,DX			;IF EXTRA BITS, MAKE SURE THEY
		JE	L17A			;GET WRITTEN
		INC	AX
L17A:		CALL	FLUSH
L18:		RET
COMPRESS	ENDP

;INITIALIZE THE TABLE
INIT_TABLE	PROC	NEAR

		MOV	AX,BITS			;INITIAL NUMBER OF BITS IS
		INC	AX			;THE CODE SIZE PLUS ONE
		MOV	NBITS,AX

		MOV	AX,CLEAR                ;THE INITIAL MAXIMUM CODE IS
		SHL	AX,1			;TWICE THE MAXIMUM NUMBER
		MOV	MAXCODE,AX		;OF COLOURS

		MOV	AX,CLEAR		;CLEAR FIRST ENTRIES
		PUSH	ES			;SAVE SEG REG
		EXTRASEG
		MOV	CX,5			;SIZE OF HASH STRUCT
		MUL	CX
		MOV	CX,AX
		MOV	AX,-1			;UNUSED ENTRY FLAG
		MOV	DI,OFFSET HASH		;POINT TO FIRST ENTRY
	REP	STOSW				;CLEAR IT OUT
		POP	ES
		MOV	AX,FIRSTFREE
		MOV     FREECODE,AX
		RET
INIT_TABLE	ENDP

;WRITE ONE CODE
WRITE_CODE	PROC	NEAR
		PUSH	AX			;SAVE CODE
		MOV	AX,BITOFFSET		;GET BIT OFFSET
		MOV	CX,NBITS		;ADJUST BIT OFFSET BY CODE SIZE
		ADD	BITOFFSET,CX
		MOV	CX,8			;CONVERT BIT OFFSET TO BYTE OFFSET
		XOR	DX,DX
		DIV	CX
		CMP	AX,BUFFERSIZE-4		;APPROACHING END OF BUFFER?
		JL	WC1			;LESS MEANS NO
		CALL	FLUSH			;OTHERWISE WRITE THE BUFFER
		PUSH	DX			;DX CONTAINS OFFSET WITHIN BYTE
		ADD	DX,NBITS		;ADJUST BY CODE SIZE
		MOV	BITOFFSET,DX		;NEW BIT OFFSET
		POP	DX			;RESTORE DX
		ADD	AX,OFFSET OUTPUTDATA	;POINT TO LAST BYTE
		MOV	SI,AX			;PUT IN SI
		MOV	AL,BYTE PTR [SI]	;MOVE BYTE TO FIRST POSITION
		MOV	OUTPUTDATA,AL
		XOR	AX,AX			;BYTE OFFSET OF ZERO
WC1:		ADD	AX,OFFSET OUTPUTDATA	;POINT INTO BUFFER
		MOV	DI,AX			;DESTINATION
		POP	AX			;RESTORE CODE
		MOV	CX,DX			;OFFSET WITHIN BYTE
		XOR	DX,DX			;DX WILL CATCH BITS ROTATED OUT
		JCXZ	WC3			;IF OFFSET IN BYTE IS ZERO, SKIP SHIFT
WC2:		SHL	AX,1			;ROTATE CODE
		RCL	DX,1
		LOOP	WC2
		OR	AL,BYTE PTR [DI]	;GRAB BITS CURRENTLY IN BUFFER
WC3:            PUSH	ES
		EXTRASEG
		STOSW				;SAVE DATA
		MOV	AL,DL			;GRAB EXTRA BITS
		STOSB				;AND SAVE
		POP	ES
		RET
WRITE_CODE	ENDP

FLUSH		PROC	NEAR
		PUSH	AX			;SAVE ALL REGISTERS
		PUSH	BX			;AX CONTAINS NUMBER
		PUSH	CX			;OF BYTES TO WRITE
		PUSH	DX

		MOV	ONEBYTE,AL		;SAVE INDEX

		MOV	BX,HANDLE               ;WRITE THE BUFFER PLUS
                MOV	DX,OFFSET ONEBYTE	;THE INDEX BYTE... THE
		MOV	CX,AX			;GIF STANDARD LIKES
		INC	CX			;LITTLE CHUNKS OF DATA
		MOV	AX,4000H		;STORED LIKE PASCAL
		INT	21H			;STRINGS

		POP	DX
		POP	CX
		POP	BX
		POP	AX
		RET
FLUSH		ENDP

;READ ONE BYTE FROM THE RAW DATA
FGETCH		PROC	NEAR

		CMP	SIZEMSB,0       	;IF THE COUNTER IS ZERO
		JNE	FGETCH0			;WE'RE DONE
		CMP	SIZELSB,0
		JNE	FGETCH0

		STC                     	;END OF IMAGE - GO HOME
		RET

FGETCH0:	PUSH	ES			;OTHERWISE
		PUSH	SI
		MOV	ES,IMAGESEG		;POINT TO THE NEXT BYTE
		MOV	SI,IMAGEOFF
		MOV	AL,ES:[SI]		;FETCH IT
		POP	SI
		POP	ES
		INC	IMAGEOFF		;DO 32 BIT INCREMENT
		JNZ	FGETCH1			;... IF OFFSET WRAPS,
		ADD	IMAGESEG,4096		;... INCREMENT SEGMENT

FGETCH1:        CMP	SIZELSB,0		;DO 32 BIT DECREMENT OF
		JE	FGETCH2			;... SIZE COUNTER FOR
		DEC	SIZELSB			;... THE NEXT CALL
		JMP	FGETCH3

FGETCH2:	DEC	SIZEMSB
		DEC	SIZELSB

FGETCH3:	CLC				;SIGNAL THIS BYTE IS GOOD
		RET
FGETCH		ENDP

;FIND THE CODE IN THE TABLE
LOOKUP_CODE	PROC	NEAR
		CALL	INDEX			;CONVERT CODE TO ADDRESS
		MOV	DI,0			;FLAG
		CMP	BYTE PTR [SI + HASHFIRST],-1 ;IN USE?
		JE	GC4			;EQUAL MEANS NO
		INC	DI			;SET FLAG
		MOV	BX,[SI + HASHFIRST]	;GET FIRST ENTRY
GC2:		CALL	INDEX			;CONVERT CODE TO ADDRESS
		CMP	[SI + HASHCHAR],AL 	;IS CHAR THE SAME?
		JNE	GC3			;NE MEANS NO
		CLC				;SUCCESS
		MOV	AX,BX			;PUT FOUND CODE IN AX
		RET				;DONE
GC3:		CMP	WORD PTR [SI + HASHNEXT],-1 ;MORE LEFT WITH THIS PREFIX
		JE	GC4			;EQUAL MEANS NO
		MOV	BX,[SI + HASHNEXT]	;GET NEXT CODE
		JMP	GC2			;TRY AGAIN
GC4:		STC				;NOT FOUND
		RET				;DONE
LOOKUP_CODE	ENDP

;CONVERT INDEX TO ADDRESS - QUICKLY
INDEX		PROC	NEAR
		MOV	SI,BX			;SI = BX * 5 (5 BYTE STRUCT)
		SHL	SI,1			;SI = BX * 2 * 2 + BX
		SHL	SI,1
		ADD	SI,BX
		ADD	SI,OFFSET HASH		;PLUS START OF TABLE
		RET
INDEX		ENDP

;ADD A CODE TO THE TABLE
ADD_CODE	PROC	NEAR
		MOV	BX,FREECODE		;GET CODE TO USE
		CMP	DI,0			;FIRST USE OF THIS PREFIX?
		JE	AC1			;EQUAL MEANS YES
		MOV	[SI + HASHNEXT],BX	;POINT LAST USE TO NEW ENTRY
		JMP	AC2
AC1:		MOV	[SI + HASHFIRST],BX	;POINT FIRST USE TO NEW ENTRY
AC2:		CMP	BX,MAXMAX		;HAVE WE REACHED CODE LIMIT?
		JE	AC3			;EQUAL MEANS YES, JUST RETURN
		CALL	INDEX			;GET ADDRESS OF NEW ENTRY
		MOV	WORD PTR [SI + HASHFIRST],-1 ;INITIALIZE POINTERS
		MOV	WORD PTR [SI + HASHNEXT],-1
		MOV	[SI + HASHCHAR],AL	;SAVE SUFFIX CHAR
		INC	FREECODE		;ADJUST NEXT CODE
AC3:		RET
ADD_CODE	ENDP

;THIS ROUTINE CREATES AN EMPTY GIF FILE BASED ON PATH - CARRY=0 IF OK
FCREATE		PROC	NEAR
		PUSH	DS
		MOV	DX,PATHOFF
		MOV	DS,PATHSEG

		MOV	AX,3C00H		;DOS OPEN FILE FUNCTION
		MOV	CX,0000H
		INT	21H
		POP	DS
		MOV	HANDLE,AX
		RET
FCREATE		ENDP

;THIS ROUTINE WRITES CX BYTES AT DS:DX TO THE FILE
FWRITE		PROC	NEAR
		PUSH	DS
		DATASEG
		MOV	BX,HANDLE
		POP	DS
		MOV	AX,4000H
		INT	21H
		RET
FWRITE		ENDP

;THIS ROUTINE WRITES ONE BYTE IN AL TO THE FILE
FPUTC		PROC	NEAR
		MOV	ONEBYTE,AL
		MOV	AX,4000H
		MOV	BX,HANDLE
		MOV	CX,0001H
		MOV	DX,OFFSET ONEBYTE
		INT	21H
		RET
FPUTC		ENDP

;THIS ROUTINE WRITES ONE WORD IN AX TO THE FILE
FPUTW		PROC	NEAR
		PUSH	AX
		CALL	FPUTC
		POP	AX
		MOV	AL,AH
		CALL	FPUTC
		RET
FPUTW		ENDP

;THIS ROUTINE CLOSES THE GIF FILE
FCLOSE		PROC	NEAR
		MOV	AX,3E00H		;DOS CLOSE FILE FUNCTION
                MOV	BX,HANDLE
		INT	21H
		RET
FCLOSE		ENDP

GIFENC_TEXT	ENDS

DGROUP		GROUP	_DATA,_BSS
_DATA		SEGMENT WORD PUBLIC 'DATA'

;		PUBLIC _COPYRIGHT
GIFHEAD		DB	'GIF87a'		;HEADER FOR A GIF FILE

STARTINIT	LABEL	BYTE			;START OF INITIALIZED AREA

GIFSTRUCT	LABEL	BYTE                    ;THIS IS WHERE THE STRUCT
SCREENWIDE   	DW      ?			;...PASSED TO PackGIF GETS
SCREENDEEP	DW      ?			;...STORED... EVERYTHING
IMAGELEFT	DW	?			;...WINDS UP ASSOCIATED
IMAGETOP	DW	?			;...WITH CONVENIENT LABELS
IMAGEWIDE	DW	?
IMAGEDEEP	DW	?
BACKGROUND	DW	?
BITS		DW	?
SIZELSB		DW	?
SIZEMSB		DW	?
PALETTEOFF	DW	?
PALETTESEG	DW	?
IMAGEOFF	DW	?
IMAGESEG	DW	?
PATHOFF		DW	?
PATHSEG		DW	?

CLEAR		DW	0
EOI		DW	0
FIRSTFREE	DW	0
PREFIXCODE	DW	0
FREECODE	DW	0
MAXCODE		DW	0
NBITS		DW	0
THISBYTE	DB	0
BITOFFSET	DW	0
HANDLE		DW	0

ONEBYTE		DB	0                       ;OUTPUT INDEX
OUTPUTDATA	DB	BUFFERSIZE DUP (0)	;OUTPUT BUFFER

HASH		DB	20480 DUP (0)		;HASHING TABLE
ENDINIT		LABEL	BYTE			;END OF INITIALIZED AREA

_COPYRIGHT	DB	'This program incoporates code which is ',0
		DB	'proprietory to Alchemy Mindworks Inc., ',0
		DB	'P.O. Box 313, Markham Ontario L3P 3J8. ',0
		DB	'GIF and "Graphics Interchange Format" ',0
		DB	'are trademarks (tm) of CompuServe ',0
		DB	'Incorporated, an H&R Block Company.',0
		DB	0

_DATA		ENDS

_BSS		SEGMENT WORD PUBLIC 'BSS'
_BSS		ENDS
		END
