// this is released as public domain
// it is _NOT_ an example of my programming skillz

#include <windows.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "waveout.h"

#define DEV_FREQ            44100

#define OSC_PHASING_DELAY   1
#define OSC_PHASING_DECAY   0.6f
#define WAVE_LENGTH         65536

#define BASE_FREQ 13.75f
#define OCT_1 1.0f
#define OCT_2 2.0f
#define OCT_3 4.0f
#define OCT_4 8.0f
#define OCT_5 16.0f
#define OCT_6 32.0f
#define OCT_7 64.0f
#define OCT_8 128.0f
#define OCT_9 256.0f
#define NOTE_A 1.0f
#define NOTE_A2 1.0594f
#define NOTE_H 1.1224f
#define NOTE_C 1.1892f
#define NOTE_C2 1.2599f
#define NOTE_D 1.3348f
#define NOTE_D2 1.4142f
#define NOTE_E 1.4983f
#define NOTE_F 1.5874f
#define NOTE_F2 1.6817f
#define NOTE_G 1.7817f
#define NOTE_G2 1.8877f

#define rand_a 16807         /* multiplier */
#define rand_m 2147483647L   /* 2**31 - 1 */
#define rand_q 127773L       /* m div a */
#define rand_r 2836          /* m mod a */

long nextlongrand(long seed)
{
      unsigned long lo, hi;

      lo = rand_a * (long)(seed & 0xFFFF);
      hi = rand_a * (long)((unsigned long)seed >> 16);
      lo += (hi & 0x7FFF) << 16;
      if (lo > rand_m)
      {
            lo &= rand_m;
            ++lo;
      }
      lo += hi >> 15;
      if (lo > rand_m)
      {
            lo &= rand_m;
            ++lo;
      }
      return (long)lo;
}

static long randomnum = 1;

long get_rand(void)
{
      return randomnum = nextlongrand(randomnum);
}

float get_randfloat(void)
{
	float num=(float)get_rand();
	num*=(float)1/131072;
	num-=(long)num;
	return num*2-1;
}

float square[WAVE_LENGTH];
float sawtooth[WAVE_LENGTH];
float sine[WAVE_LENGTH];
//float noise[WAVE_LENGTH];
float fatbass[WAVE_LENGTH];

float trance_std[WAVE_LENGTH];
float trance_fun[WAVE_LENGTH];

typedef struct lowpass_s {
	float out, strength;
} lowpass_t;

typedef struct reverb_partial_s {
	float out[DEV_FREQ];
	int pos1, pos2;
	float decay;
	lowpass_t lp;
} reverb_partial_t;

typedef struct reverb_s {
	reverb_partial_t rev[3];
} reverb_t;

typedef struct osc_s {
	float freq;
	float vol;
	float *smp1, *smp2, *smp3;
	float relfreq1, relfreq2, relfreq3;
	float vol1, vol2, vol3;
	int   pos1, pos2, pos3;
	float phbuf[OSC_PHASING_DELAY];
	int   phbufpos;
	float phpos, phspd, phdecay;
	float dist;
	reverb_t rev;
	lowpass_t lp;
} osc_t;

typedef struct bass_s {
	float vol, env;
	float pos, freq;
} bass_t;

typedef struct snare_s {
	float vol, env;
	float pos, freq;
} snare_t;

typedef struct osc_note_s {
	short freq;
	char vol;
} osc_note_t;

typedef struct rhythm_note_s {
	char bass;
	char snare;
	char delay;
} rhythm_row_t;

typedef struct row_s {
	osc_note_t osc1, osc2;
	char delay;
} synth_row_t;

typedef struct player_s {
	rhythm_row_t *rhythm;
	int rhythm_length;
	int rhythm_pos;
	int rhythm_delay;
	synth_row_t *synth;
	int synth_length;
	int synth_pos;
	int synth_delay;

	float bps;

	int left;
} player_t;

osc_t osc1, osc2;

bass_t bass;
snare_t snare;


rhythm_row_t rhythm[] = {
	{100,   0,  1},
	{  0,   0,  1},
	{100,   0,  1},
	{  0,   0,  1},

	{  0, 100,  1},
	{  0,   0,  1},
	{  0,   0,  1},
	{  0,   0,  1},

	{100,   0,  1},
	{100,   0,  1},
	{  0,   0,  1},
	{  0,   0,  1},

	{  0, 100,  1},
	{  0,   0,  1},
	{100,   0,  1},
	{  0,   0,  1},
};

synth_row_t synth[] = {
	{BASE_FREQ*OCT_4*NOTE_C2, 40, BASE_FREQ*OCT_3*NOTE_F2, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{BASE_FREQ*OCT_4*NOTE_A,  40, 0,                       40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{BASE_FREQ*OCT_4*NOTE_H,  40, 0,                       40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{BASE_FREQ*OCT_3*NOTE_G2, 40, 0,                       40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   0},
	{                      0,  2,                       0,  2,   0},
	{                      0, 40,                       0, 40,   1},
	{                      0,  2,                       0,  2,   1},
};
player_t player = {
	rhythm, 16, 0, 0, // rhythm stuff
	synth, 96, 0, 0, // synth stuff
	19.0f, // bps
	0, // "left"
};





void
clear(float *buf, int num)
{
	while(num)
	{
		buf[num] = 0;
		num--;
	}
}

float
lerp(float a, float b, float t)
{
	return a+(b-a)*t;
}

float
spline(float a, float b, float c, float t)
{
	return lerp(lerp(a, b, t), lerp(b, c, t), t);
}

void
init_wave_forms()
{
	int i;

	for(i = 0; i < WAVE_LENGTH; i++)
	{
		square[i]   = i < WAVE_LENGTH * 0.5f ? -1.0f : 1.0f;
		sawtooth[i] = 1.0f - i * (2.0f/WAVE_LENGTH);
		sine[i]     = (float)sin(i * (3.1415926535897932f * 2.0f / WAVE_LENGTH ));
		sine[i]     = sine[i];
		{
			if (i < WAVE_LENGTH >> 3)
			{
				fatbass[i] = i * (4.0f/WAVE_LENGTH);
			}
			else if (i < (WAVE_LENGTH >> 3) * 3)
			{
				fatbass[i] = spline(0.5f, 1.0f, 0.5f, ((float)i / WAVE_LENGTH - 0.125f) * 4.0f);
			}
			else if (i < (WAVE_LENGTH >> 3) * 5)
			{
				fatbass[i] = 0.5f - ((float)i / WAVE_LENGTH - 0.375f) * 4.0f;
			}
			else if (i < (WAVE_LENGTH >> 3) * 7)
			{
				fatbass[i] = spline(-0.5f, -1.0f, -0.5f, ((float)i / WAVE_LENGTH - 0.625f) * 4.0f);
			}
			else
			{
				fatbass[i] = -0.5f + ((float)i / WAVE_LENGTH - 0.875f) * 4.0f;
			}
		}

//		noise[i]    = 0; // who cares
	}
}

void
lowpass_init(lowpass_t *low, float strength)
{
	low->out = 0;
	low->strength = strength;
}

__inline float
lowpass_apply(lowpass_t *low, float val)
{
	return low->out = low->out * low->strength + (1 - low->strength) * val;
}

void
reverb_partial_init(reverb_partial_t *rev, float delay, float decay, float hfdamp)
{
	rev->pos1 = 0;
	rev->pos2 = (int)(-delay * DEV_FREQ) + DEV_FREQ;
	rev->decay = decay;
	clear(rev->out, DEV_FREQ);
	lowpass_init(&rev->lp, hfdamp);
}

__inline float
reverb_partial_apply(reverb_partial_t *rev, float val)
{
	float ret;

	ret = val + lowpass_apply(&rev->lp, rev->out[rev->pos2] * rev->decay);

	rev->out[rev->pos1] = ret;

	rev->pos1++;
	rev->pos2++;

	if (rev->pos1 >= DEV_FREQ) rev->pos1 = 0;
	if (rev->pos2 >= DEV_FREQ) rev->pos2 = 0;

	return ret;
}

void
reverb_init(reverb_t *rev, float length, float hfdamp)
{
	const float	delay[3] =
	{ 0.005f, 0.02f, 0.1f };
	int i;

	for(i = 0; i < 3; i++)
	{
		reverb_partial_init(&rev->rev[i], delay[i], (float)pow(10, -3 * delay[i] / length), hfdamp);
	}
}

__inline float
reverb_apply(reverb_t *rev, float val)
{
	val = reverb_partial_apply(rev->rev + 0, val) +
	      reverb_partial_apply(rev->rev + 1, val) +
	      reverb_partial_apply(rev->rev + 2, val);

	return val * 0.333f;
}

void
osc_init(osc_t *osc)
{
	osc->freq = 1;
	osc->vol  = 0;
	osc->pos1 = 0;
	osc->pos2 = 0;
	osc->pos3 = 0;
	osc->smp1 = sine;
	osc->smp2 = sine;
	osc->smp3 = sine;
	osc->vol1 = 0.0f;
	osc->vol2 = 0.0f;
	osc->vol3 = 0.0f;
	osc->relfreq1 = 1.0f;
	osc->relfreq2 = 1.0f;
	osc->relfreq3 = 1.0f;
	clear(osc->phbuf, OSC_PHASING_DELAY);
	osc->phbufpos = 0;
	osc->phpos = 0;
	osc->phspd = 0.28f;
	osc->phdecay = OSC_PHASING_DECAY;
	osc->dist = 0;
	reverb_init(&osc->rev, 0.0f, 0.8f);
	lowpass_init(&osc->lp, 0.0f);
}

void
osc_play(float *buffer, int num, osc_t *osc)
{
	int speed1, speed2, speed3;
	float vol1, vol2, vol3;
	float phspeed, out;
	float k;

	if (osc->vol == 0)
	{
		return;
	}

	speed1 = (int) (WAVE_LENGTH * osc->freq * osc->relfreq1 / DEV_FREQ);
	speed2 = (int) (WAVE_LENGTH * osc->freq * osc->relfreq2 / DEV_FREQ);
	speed3 = (int) (WAVE_LENGTH * osc->freq * osc->relfreq3 / DEV_FREQ);
	phspeed= osc->phspd / DEV_FREQ;

	vol1   = osc->vol * osc->vol1;
	vol2   = osc->vol * osc->vol2;
	vol3   = osc->vol * osc->vol3;

	k = 2.0f * osc->dist / (1.0f - osc->dist);

	while(num--)
	{
		out = osc->smp1[osc->pos1] * vol1 +
			  osc->smp2[osc->pos2] * vol2 +
			  osc->smp3[osc->pos3] * vol3;

		out = (1 + k) * out / (1 + k * (float)fabs(out));

		out += sine[(int)(osc->phpos*WAVE_LENGTH)&(WAVE_LENGTH-1)] *
			   osc->phdecay *osc->phbuf[osc->phbufpos] ;

		out = lowpass_apply(&osc->lp, out);

		out = reverb_apply(&osc->rev, out);

		*buffer += out;

		osc->phbuf[osc->phbufpos] = out;

		osc->phpos += phspeed;
		osc->phpos -= (int)osc->phpos;

		osc->phbufpos++;
		osc->pos1 += speed1;
		osc->pos2 += speed2;
		osc->pos3 += speed3;

		if (osc->phbufpos >= OSC_PHASING_DELAY) osc->phbufpos = 0;
		osc->pos1 = osc->pos1 & (WAVE_LENGTH - 1);
		osc->pos2 = osc->pos2 & (WAVE_LENGTH - 1);
		osc->pos3 = osc->pos3 & (WAVE_LENGTH - 1);

		buffer++;
	}
}

void
bass_init(bass_t *bass)
{
	bass->freq = 0.0f;
	bass->pos  = 0.0f;
	bass->vol  = 0.0f;
	bass->env  = 0.0;
}

void
bass_reset(bass_t *bass, float vol)
{
	bass->freq = (300.0f/DEV_FREQ)*2*3.1415926f;
	bass->pos  = 0.0f;
	bass->vol  = vol;
	bass->env  = 1.0f;
}

void
bass_play(float *buffer, int num, bass_t *bass)
{
	while(num--)
	{
		*buffer += bass->vol * bass->env * fatbass[((int)(bass->pos*WAVE_LENGTH/3.1415926535897f*0.5f))&(WAVE_LENGTH-1)];
		bass->pos += bass->freq + (200.0f/DEV_FREQ);
		bass->freq *= 0.9995f;
		bass->env *= 0.9999f;
		buffer++;
	}
}

void
snare_init(snare_t *snare)
{
	snare->freq = 0.0f;
	snare->pos  = 0.0f;
	snare->vol  = 0.0f;
	snare->env  = 0.0f;
}

void
snare_reset(snare_t *snare, float vol)
{
	snare->freq = 0;//(100.0f/DEV_FREQ);
	snare->pos  = 0.0f;
	snare->vol  = vol;
	snare->env  = 1.0f;
}

void
snare_play(float *buffer, int num, snare_t *snare)
{

	while(num--)
	{
		*buffer += snare->vol * snare->env * 
			       (sine[((int)(snare->pos*WAVE_LENGTH))&(WAVE_LENGTH-1)]
				   + get_randfloat());
		snare->pos += snare->freq + (200.0f/DEV_FREQ);
		snare->freq *= 0.997f;
		snare->env *= 0.9994f;
		buffer++;
	}
}

void
update()
{
	synth_row_t *srow;
	rhythm_row_t *rrow;

	if (player.synth_delay)
	{
		player.synth_delay--;
	}
	else
	{
		srow = &player.synth[player.synth_pos];

		player.synth_delay = srow->delay;

		if (srow->osc1.freq)
		{
			osc1.freq = srow->osc1.freq;
		}

		if (srow->osc1.vol >= 0)
		{
			osc1.vol = srow->osc1.vol * 0.015625f;
		}

		if (srow->osc2.freq)
		{
			osc2.freq = srow->osc2.freq;
		}

		if (srow->osc2.vol >= 0)
		{
			osc2.vol = srow->osc2.vol * 0.015625f;
		}

		if (++player.synth_pos >= player.synth_length)
		{
			player.synth_pos = 0;
		}
	}

	if (player.rhythm_delay)
	{
		player.rhythm_delay--;
	}
	else
	{
		rrow = &player.rhythm[player.rhythm_pos];

		player.rhythm_delay = rrow->delay;

		if (rrow->bass)
		{
			bass_reset(&bass, rrow->bass * 0.015625f);
		}

		if (rrow->snare)
		{
			snare_reset(&snare, rrow->snare * 0.015625f);
		}

		if (++player.rhythm_pos >= player.rhythm_length)
		{
			player.rhythm_pos = 0;
		}
	}
}

void
play(float *buffer, int length)
{
	int buffer_pos;
	int left;

	buffer_pos = 0;

	for(left = 0; left < length; left++)
	{
		buffer[left]=0;
	}

	while(buffer_pos < length)
	{
		if (!player.left)
		{
			update();
			player.left = (int)((double)DEV_FREQ / player.bps);
		}

		left = min(player.left, length - buffer_pos);
		osc_play(buffer, left, &osc1);
		osc_play(buffer, left, &osc2);
		bass_play(buffer, left, &bass);
		snare_play(buffer, left, &snare);
		buffer += left;
		buffer_pos += left;
		player.left -= left;
	}
}

void
ad_env(float *sample, int length, float amp, float attack,
		 float full, float decay)
{
	float time, timestep;
	float inv;
	float *end=sample+length;
	int ll;

	time    = 1 / (attack + full + decay);

	attack *= time;
	full   *= time;
	decay  *= time;

	time=0;
	timestep=1/(float)length;
	ll=(int)(attack/timestep);
	inv=1/attack;
	for(;ll-->0;sample+=1)
	{
		(*sample)=time*inv*amp;
		time+=timestep;
	}

	ll=(int)(full/timestep);
	for(;ll-->0;sample+=1)
		(*sample)=amp;

	time=0;
	ll=(int)(decay/timestep);
	inv=1/decay;
	for(;ll-->0;sample+=1)
	{
		(*sample)=amp-time*inv*amp;
		time+=timestep;
	}
}


void
init()
{
	init_wave_forms();
	bass_init(&bass);
	snare_init(&snare);
	osc_init(&osc1);
	osc_init(&osc2);

	osc1.freq = 440;
	osc1.vol  = 0.0f;
	osc1.smp1 = sawtooth;
	osc1.smp2 = sawtooth;
	osc1.smp3 = square;
	osc1.vol1 = 0.5f;
	osc1.vol2 = 0.5f;
	osc1.vol3 = 0.5f;
	osc1.relfreq1 = 2.0f;
	osc1.relfreq2 = 4.0f;
	osc1.relfreq3 = 2.0f;
	osc1.dist = 0.4f;
	osc1.lp.strength = 0.0f;

	osc2 = osc1;
}

convert(float *buf1, short *buf2, float vol, int num)
{
	float out;

	while(num)
	{
		out = buf1[num] * vol * 32768.0f;
		if (out > 32767) out = 32767;
		if (out < -32768) out = -32768;
		buf2[num] = (short) out;
		num--;
	}
}

void
main()
{
	short *buffer1;
	float *buffer2;

	AUDIO_Init();
	if (!AUDIO_Open(44100, 16, 1, 1024*1024))
	{
		printf("error while initializing waveout\n");
		return;
	}

	buffer1 = (short*) malloc(4*AUDIO_GetWriteLength());
	buffer2 = (float*) malloc(8*AUDIO_GetWriteLength());

	init();

	while(!kbhit())
	{
		if (AUDIO_Ready())
		{
			play(buffer2, AUDIO_GetWriteLength());
			convert(buffer2, buffer1, 0.2f, AUDIO_GetWriteLength());
			AUDIO_Write(buffer1);
		}
		Sleep(2);
	}

	AUDIO_Kill();
}