#include "uminimod.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int     smp_num;

i16     smp_vol[]={256};
i32     smp_length[]={15000};
double  smp_loop_beg[]={-1};
float   smp_freq[]={44100};
float   *smp_data[]={0};
i8      smp_env_num[]={1};
i8      smp_env_sus[]={19};
u16     smp_env_pnt[][MAX_ENV_PNT]={{0x00ff,0,0,0,0,0}};
i8      smp_rel_note[]={0};

i32     ch_num=1;
i8      pat_num=1;
i8      pat_length[1]={64};
u16     *pat_data[1];
i8      order_length=1;
i8      order[]={0};
i8      order_restart=0;

i8      bpm_def=125;
i8      spd_def=6;

i16     vol=128;

u16 pattern1[]=
{
	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400,

	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400,

	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400,

	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400,

	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400,

	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400,

	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400,

	0x7020,
	0xC400,
	0xC400,
	0xC400,
	0x7020,
	0xC400,
	0xC400,
	0xC400
};

void
clear(float *buf, int num)
{
	while(num)
	{
		buf[num] = 0;
		num--;
	}
}

float
spline(float b, float t)
{
	return 2*b*(t-t*t);
}

void
ad_env(float *sample, int length, int ch, float amp, float attack, float decay)
{
	float time, timestep;
	float inv;
	float *end=sample+length;
	int ll;

	time    = 1 / (attack + decay);

	attack *= time;
	decay  *= time;

	time=0;
	timestep=1/(float)length;
	ll=(int)(attack/timestep);
	inv=1/attack;
	for(;ll-->0;sample+=ch)
	{
		(*sample)*=time*inv*amp;
		time+=timestep;
	}

	time=0;
	ll=(int)(decay/timestep);
	inv=1/decay;
	for(;ll-->0;sample+=ch)
	{
		(*sample)*=amp-time*inv*amp;
		time+=timestep;
	}
}

void
distort2(float *sample, int ch, int length, float amount)
{
	float *sampleend=sample+ch*length;
	float k=2*amount/(1-amount);

	for(;sample<sampleend;sample+=ch)
	{
		(*sample)=(float)((1+k)*(*sample)/(1+k*fabs(*sample)));
	}
}

void
song_init()
{
	i32 i;
	float pos, freq;

	smp_data[0]=malloc(15001*sizeof(float)*2);
	pos = 0;
	freq = 200.0f/DEV_FREQ;

	for(i=0; i < 15001; i++)
	{
		{
			if (pos <= 0.5f)
			{
				smp_data[0][i*2] = spline(1.0f, pos * 2.0f);
			}
			else
			{
				smp_data[0][i*2] = spline(-1.0f, (pos - 0.5f) * 2.0f);
			}
		}
		smp_data[0][i*2+1]=smp_data[0][i*2];
		pos += freq + (45.0f/44100);
		freq *= 0.9994f;
		pos = pos - (int)pos;
	}

	smp_data[0][15000]=0;

	ad_env(smp_data[0], 15002, 2, 4, 3, 170);
	ad_env(smp_data[0]+1, 15002, 2, 4, 3, 170);

	distort2(smp_data[0], 1, 30002, 0.5f);

	pat_data[0]=pattern1;
}