//
//          ,  .
//  ,s;`         ',
//.$$'              .
// S,
//     ` ~ ~  ~  ~~"s.
//.ss,               $SS,    h     i     n     e
//'$$$,             ,$$'
// `$$,.         .,$$`
//    `"+ , . , +"`
//
//
//
// _______________________________________________________________________________________
//
// This file was last changed on     : 2000-11-09
// Revision (please increase number) : A1
// (Only increase A if it's not backwards complient.)
// _______________________________________________________________________________________

#ifndef __sbase_h
#define __sbase_h

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "slist.h"
#include "shine.h"
#include "sfont.h"
#include "splugin.h"
#include "sscheduler.h"
#include "simage.h"
#include "slib.h"

//________________________________________________________________________________________________________________________________________________________________________

const cMaxLineWidth = 1024;     // Maximum width of a line in the article file, everything after this column wont be shown.
const cBorders = 16;            // Border in pixels, (should not be changed). For images, plugins etc.
const cScrollWidth = 16;        // Scrollbar width (in pixels)
const cScrollHeight = 16;       // Scrollbar height (in pixels)

extern float fontZoom;          // Scale of fontsize..

//________________________________________________________________________________________________________________________________________________________________________

// All images, plugins etc has areas.
// No text are allowed to be drawn inside areas.
class shineArea {
	private:
	public:
		shineArea* pNext;
		shineArea* pPrev;
		int x1,x2,y1,y2;
		bool inverted;
};

//________________________________________________________________________________________________________________________________________________________________________

// Struct used while drawing an article..
struct shineStatus {
	long  textColor;
	long  backColor;
	long  linkColor;
	char  fontName[cMaxLineWidth];
	int   fontWidth;
	int   fontHeight;
	bool  fontItalic;
	bool  fontUnderline;
	int   fontWeight;

	char  linkName[256];
	RECT  linkArea;

	int   tableYStart;
	int	  tableCols;
	int	  tableColCount;
	int	  tableOriginalX1;
	int	  tableOriginalX2;
};

//________________________________________________________________________________________________________________________________________________________________________

// A text row/word. All words in shine are saved in a linked list.
class shineRow {
	private:
		char row[cMaxLineWidth];
	public:
		shineRow* pNext;
		shineRow* pPrev;
		int xpos, ypos;
		int width, height;

		shineStatus Status;
		
		void setText( char* text );
		char* getText();
};

//________________________________________________________________________________________________________________________________________________________________________

// Area/Textlink..
class shineLink {
	private:
		RECT linkArea;
		char linkName[256];
	public:
		shineLink* pNext;
		shineLink* pPrev;
		void setLink( char* name, RECT area );
		char* getLink();
		RECT getArea();
};

//________________________________________________________________________________________________________________________________________________________________________

// Plugin control thread class.
static shineScheduler oScheduler;

// Main class.
class shineArticle {
	private:
		char* data;                    // Raw data, as read in from file (or archive)
		char* rows;                    // Data sorted into rows.

		// Linked lists of items..
		shineList<shineRow>    oRows;
		shineList<shineArea>   oAreas;
		shineList<shineImage>  oImages;
		shineList<shineLink>   oLinks;
		shineList<shinePlugin> oPlugins;

		shineImage	   backgroundImage;
		shineLibrary*  poLibrary;      // Archive class

		// Shine skin data:
		long ImageLoadingPlugin[50*50];
		long ImageScrollBar[cScrollWidth*3];
		long ImageScrollBarTop[cScrollWidth*3];
		long ImageScrollBarBot[cScrollWidth*3];
		long ImageScrollArrowUp[cScrollWidth*cScrollHeight];
		long ImageScrollArrowDown[cScrollWidth*cScrollHeight];
		long ImageScrollArrowUpPressed[cScrollWidth*cScrollHeight];
		long ImageScrollArrowDownPressed[cScrollWidth*cScrollHeight];

		// Scrollbar
		int barStart;
		int barEnd;

		// Internal data
		int dataLength;
		int numRows;
		int height;
		int IDCounter;

		// Font class
		shineFont oFont;

		shineStatus currentStatus;

		void formatArticle();
		void preProcess();
		bool parse( char* tag, int* textX, int* textY );
		void addArea( int x1, int y1, int x2, int y2, bool inverted );
		void initPlugin( char* filename, char* param, char* link, int xpos, int ypos, int width, int height, int interval );

	public:
		void musicLoad( char* filename );
		void musicStop();
		void musicResume();
		void musicInit();
		void musicDeInit();
		void musicGetLeft();
		void musicGetRigth();
		void musicGetVolume();

		void volumeInc();
		void volumeDec();
		void volumeSet( int vol );
		void drawScrollBar( int start, int end, int pressed );
		int  getScrollStart();
		int  getScrollEnd();

		void LoadShineData();

		void setLibrary( shineLibrary *poLib );

		void load( char* filename );
		void draw( int x1, int y1, int x2, int y2, HDC hdc, int yScroll, int thisScroll );
		shineLink* checkLink( int mousex, int mousey, int yScroll, char button );
		int getHeight();
		
		shineLink oPluginLink;

		shineArticle();
		~shineArticle();
};

//________________________________________________________________________________________________________________________________________________________________________

void shineLog( int row, char* sourceFile, int Level, char* format, ... );
void shineLogEnable();
void shineLogDisable();
int stringCompare( char* str1, char* str2, int len );

//________________________________________________________________________________________________________________________________________________________________________

#endif