	.286
	.model tiny
	.stack 100h

.code
start:	mov	ax,0B800H
	mov	es,ax
	push	cs
	pop	ds
	call	cls
	call	cursoff
	call	initab
	call	showpage

mainlp:	call	keypress
	jnz	mainlp
	call	cls
	call	curson

	mov	ax,4c00h
	int	21h

raz1:	mov	ax,25
	jmp	endraz
raz2:	mov	ax,69
	jmp	endraz
raz3:	mov	ax,80
	jmp	endraz
raz4:	mov	ax,116
	jmp	endraz
raz5:	mov	ax,154
	jmp	endraz
raz6:	mov	ax,164
	jmp	endraz
raz7:	mov	ax,177

endraz:	mov	curline,ax
	call	cls
	call	showpage
	jmp	end2

keypress	proc
	xor	ax,ax
	int	16H
	cmp	ax,18432
	jz	keyup
;------------ r a z d e l y ---------
	cmp	ax,561
	jz	raz1
	cmp	ax,818
	jz	raz2
	cmp	ax,1075
	jz	raz3
	cmp	ax,1332
	jz	raz4
	cmp	ax,1589
	jz	raz5
	cmp	ax,1846
	jz	raz6
	cmp	ax,2103
	jz	raz7
;-------------------------------------
	cmp	ax,11875
	jz	colourz
	cmp	ax,20480
	jz	keydn
	cmp	ax,18688
	jz	keypgup
	cmp	ax,20736
	jz	keypgdn
	cmp	ax,18176
	jz	keyhome
	cmp	ax,20224
	jz	keyend
	cmp	ax,283
	jz	keyesc
	jmp	end2

keyesc:	xor	ax,ax
endprc:	or	ax,ax
	ret

colourz:	mov	al,cs:cflag
	xor	al,1
	mov	cs:cflag,al
	call	showpage
	jmp	end2

keydn:	mov	ax,curline
	add	ax,025
	cmp	ax,[lines]
	jnc	end2
	add	word ptr curline,1
end1:	call	showpage
end2:	mov	ax,1
	jmp	endprc

keyup:	mov	ax,curline
	or	ax,ax
	jz	end2
	dec	ax
	mov	curline,ax
	jmp	end1

keypgdn:mov	ax,curline
	add	ax,24
	mov	bx,lines
	sub	bx,25
	cmp	ax,bx
	jc	kkk
	mov	ax,bx
kkk:	mov	curline,ax
	jmp	end1

keypgup:mov	ax,curline
	sub	ax,25
	jnc	mmm
	xor	ax,ax
mmm:	mov	curline,ax
	jmp	end1

keyhome:xor	ax,ax
	mov	curline,ax
	jmp	end1

keyend:	mov	ax,lines
	sub	ax,25
	mov	curline,ax
	jmp	end1

keypress	endp

showpage	proc
	call	retrace
	mov	ax,curline
	add	ax,ax
	lea	si,eoltab
	add	si,ax
	mov	si,[si]
	cld
	xor	di,di
shlp0:	mov	cx,050H
shlp1:	lodsb
	cmp	al,0DH
	jnz	tabs
	jmp	nextline
tabs:	cmp	al,9
	jnz	gfx
	mov	al,20H
	mov	ah,txtatr
shlp2:	stosw
	dec	cx
	mov	bx,cx
	and	bx,7
	jnz	shlp2
	inc	cx
	loop	shlp1
gfx:	cmp	al,027
	jnz	tex
	lodsb
	cmp	al,105
	jz	ch_ink
	cmp	al,112
	jz	ch_paper
	cmp	al,97
	jz	ch_atr
	cmp	al,115
	jnz	tex
; gfx line
	lodsb
	push	cx
	mov	cl,al
	xor	ch,ch
	push	cx
	rep	movsw
	pop	ax
	pop	cx
	sub	cx,ax
	or	cx,cx
	jnz	lalala
	lodsb
	jmp	nextline
lalala:	inc	cx
	jmp	nxtsym
ch_ink:	lodsb
	mov	ah,txtatr
	and	ah,0f0h
	or	ah,al
	call	nosym
	mov	txtatr,ah
	jmp	lalala;nxtsym
ch_paper:	lodsb
	mov	ah,txtatr
	and	ah,08fh
	or	ah,al
	call	nosym
	mov	txtatr,ah
	jmp	nxtsym
ch_atr:	lodsb
	mov	ah,al
	call	nosym
	mov	txtatr,ah
	jmp	nxtsym
tex:	mov	ah,txtatr
	stosw
nxtsym:	dec 	cx
	jz	nextline
	jmp	shlp1
nextline:lodsb
	or	cx,cx
	jz	endaga
	mov	al,20H
	mov	ah,txtatr
	rep	stosw
endaga:	mov	al,[si]
	cmp	al,0FFh
	jz	endt
	cmp	di,4000
	jnc	endt
	jmp	shlp0
endt:	ret
void:	mov	ax,[lines]
	sub	ax,25
	mov	[curline],ax
	ret
txtatr	label	byte
	db	0fh
showpage	endp

nosym:	mov	al,cs:cflag
	or	al,al
	jz	hueta
	mov	ah,0FH
hueta:	ret

retrace	proc
	mov	dx,03dah
rlp1:	in	al,dx
	test	al,8
	jnz	rlp1
rlp2:	in	al,dx
	test	al,8
	jz	rlp2
	ret
retrace	endp

initab	proc
	push	es
	push	ds
	pop	es
	lea	si,lame
	lea	di,eoltab
inilp1:	mov	ax,si
	stosw
	add	lines,1
inilp2:	lodsb
	cmp	al,1bh
	jnz	eolin
	lodsb
	cmp	al,115
	jnz	eolin
	lodsb
	xor	ah,ah
	add	ax,ax
	add	si,ax
	jmp 	inilp2
eolin:	cmp 	al,105
	jnz	eolin2
	lodsb
	jmp	inilp2
eolin2:	cmp	al,0AH
	jnz	inilp2
	mov	al,[si]
	cmp	al,0ffh
	jnz	inilp1
	pop	es
	ret
initab	endp

crstyp	label	word
	dw	0

cursoff	proc
	mov	ax, 03h
	mov	bh, 00h
	int	10h
	mov	crstyp, cx
	mov	ah, 01h
	mov	cx, 65535
	int	10h
	ret
cursoff	endp

curson	proc
	mov	ah, 01h
	mov	cx, crstyp
	int	10h
	ret
curson	endp

cls	proc
	mov	ax,0F20H
	xor	di,di
	cld
	mov	cx,2000
	rep	stosw
	ret
cls	endp

cflag	label	byte
	db	0
eoltab	label	word
	dw	768 dup (?)
lines	label	word
	dw	0
curline	label	word
	dw	0
	include	text.inc
	db	0FFH
end
