DOSSEG

.MODEL SMALL
.STACK 256

Page_Addr       equ 0A000h
Buff_Size       equ 50000

.DATA

Handle       dw (?)          ; Filehandle zum Zugriff auf Datei
Header       db 128 dup (?)  ; Buffer fr Header
RepeatCount  db (?)          ; Wiederholungszaehler
BytesRead    dw (?)          ; Lnge der gelesenen Daten in Byte
Video_Offset dw (?)          ; Offset-Addy vom ViedeoRam
DatenPuffer  db Buff_Size dup (?) ; Tab fr gelesene Bytes
Palette      db 768 dup (?)
DateiName    db 'test.pcx',0

.CODE

SHOWPCX320x200x256 PROC
  lea dx,DateiName
  mov ax,3d00h
  int 21h                    ; Datei ffnen
  mov Handle,ax              ; FileHandle nach Handle

  mov ax,3F00h
  mov bx,Handle
  mov cx,128
  lea dx,Header
  int 21h                    ; Header auslesen

  mov Video_Offset,0
  mov repeatCount,0

Schleife:
  mov ax,3F00h
  mov bx,Handle
  mov cx,Buff_Size
  lea dx,DatenPuffer
  int 21h                    ; 50000b aus PCX-File lesen
  jc  Ende                   ; Wenn Fehler aufgetreten -> Ende
  cmp ax,0
  je  MakePalette            ;0 Byte gelesen -> Ende
  mov BytesRead,ax
  call Decode                ;Gelesene Bytes decodieren
  jmp Schleife

MakePalette:
  mov ah,42h
  mov al,02h
  mov bx,Handle
  mov cx,0
  mov dx,0
  int 21h                    ;Laenge der Datei bestimmen

  sub ax,768                 ;DWord (DX:AX) um 768 erniedrigen
  jnc nextpal
  sub dx,1

nextpal:
  mov cx,dx
  mov dx,ax
  mov ah,42h
  mov al,00h
  mov bx,Handle
  int 21h                    ;FilePointer 768b vor Ende setzen

  mov ah,3Fh
  mov bx,Handle
  mov cx,768
  lea dx,Palette
  int 21h                    ; 768b aus File lesen (in Palette)

  lea bx,Palette
  mov cx,768
decrease:
  mov ah,[bx]
  shr ah,2
  mov [bx],ah
  inc bx
  loop decrease              ;Alle Farbeintrge durch 4 teilen

  mov ah,10h
  mov al,12h
  mov bx,0
  mov cx,256
  mov dx,Seg Palette
  mov es,dx
  lea dx,Palette
  int 10h                    ;256 Farben setzen

DateiSchliessen:
  mov ah,3Eh           
  mov bx,Handle
  int 21h                    ; Datei schlieen

ENDE:
 ret
ShowPCX320x200x256 ENDP

Decode Proc
    mov ax, Page_Addr        ; Video-Segment nach AX
    mov es, ax               ; Video-Segment nach ES
    mov di, Video_Offset     ; Video_Offset nach DI
    xor cx, cx               ; CX auf null
    mov cl, RepeatCount      ; Anzahl der Wiederholungen nach CL
    mov bx, BytesRead        ; Anzahl der gelesenen Bytes nach BX
    lea si, DatenPuffer      ; Offset von DatenPuffer nach SI
    add bx, si               ; Offset-Ende vom Puffer in BX
    cld                      ; Lsche DF - INC DI (stosb/lodsb)

checkbyte:
    cmp si, bx               ; Noch Daten da?
    je exit                  ; Wenn nicht : EXIT
    lodsb                    ; Lade nchstes Byte nach AL
    cmp cl, 0                ; Wiederholungsschleife ?
    jne WriteByte            ; Wenn ja : WriteByte
    cmp al, 11000000b        ; Sonst prfe BIT 7+6 (> 192)
    jb VorWriteByte          ; Nicht gesetzt -> VorWriteByte
    and al, 00111111b        ; BIT 0-5 : Wiederholungszhler
    mov cl, al               ; Wiederholungsanzahl nach CL
    jmp checkbyte            ; Prfe nchste Data

VorWriteByte:
    mov cl,1

WriteByte:
    stosb                    ; AL in VideoSpeicher, INC DI

    cmp di,64000
    je Exit                  ; Wenn 64000 Punkte gesetzt wurden,
                             ; nchstes Fenster einblenden
    loop writebyte

    jmp checkbyte            ; Prfe nchste Data

exit:
    mov Video_Offset, di
    mov repeatcount, cl
    ret                      ;Werte zwischenspeichern und zurck
Decode Endp


Beginn:
  mov ax,@Data
  mov ds,ax                  ; DS = Datensegment
  mov ax,0013h
  int 10h                    ; Modus 320x200x256
  call ShowPCX320x200x256    ; PCX-Bild darstellen
  mov ah,01h
  int 21h                    ; Auf Taste warten
  mov ax,0003h
  int 10h                    ; Text-Modus
  mov ah,4ch
  int 21h                    ; Programmende
END Beginn
