PROGRAM SetVESAPixel;

USES CRT,DOS,Time;

TYPE Zeiger = RECORD
      Offset,Segment : WORD;
     END;

VAR Regs            : Registers;
    i,j,xAufloesung : WORD;
    Granu           : LONGINT;
    Puffer          : ARRAY[0..255] OF BYTE;
    FensterProc     : Zeiger;
    Zeit,Zeit2      : REAL;

{$L VesaPix.obj}
 PROCEDURE InitSetVESAPixASM;               EXTERNAL;
 PROCEDURE SetVESAPixASM(x,y,Farbe : WORD); EXTERNAL;

PROCEDURE SetVESAPixPascal(x,y : LONGINT; Farbe : BYTE);
VAR Anzahl : WORD;
    Offset : LONGINT;
BEGIN
 Offset := y * xAufloesung + x;   {Offset berechnen}
 Anzahl := Offset DIV Granu;      {Wie oft mu Fenster verschoben werden?}
 Offset := Offset MOD Granu;      {Neuer Offset im verschobenen Fenster}
{ WITH Regs DO BEGIN
  AX := $4F05;
  BX := $0000;
  DX := Anzahl;
  INTR($10,Regs);
 END;}
  ASM
   XOR BX,BX
   MOV DX,Anzahl
   CALL DWORD PTR FensterProc;
  END;
  MEM[$A000:Offset] := Farbe;
END;

PROCEDURE InitSetVESAPixPascal;
BEGIN
 WITH Regs DO BEGIN
  AX := $4F03;
  INTR($10,Regs);     {Liefert VESAModus in BX zurck}
  CX := BX;           {Vesa-Modus nach CX}
  ES := Seg(Puffer);  {Segment von Puffer nach ES}
  DI := Ofs(Puffer);  {Offset von Puffer nach DI}
  AX := $4F01;        {Vesa-Infos holen}
  INTR($10,Regs);     {und in ES:DI/Puffer ablegen}
  xAufloesung := Puffer[$13] * 256 + Puffer[$12];
  Granu       := (Puffer[$05] * 256 + Puffer[$04]) SHL 10;
                      {Granu = Granu * 1024}
  FensterProc.Offset  := Puffer[$0D] * 256 + Puffer[$0C];
  FensterProc.Segment := Puffer[$0F] * 256 + Puffer[$0E];
                      {Offset+Segment der Routine zum
                                   Fensterverschieben}
 END;
END;

BEGIN
 ClrScr;
 GotoXY(10,10);
 Write('Zuerst die Pascalroutine!');
 ReadLn;
 WITH Regs DO BEGIN
  AX := $4F02;
  BX := $101;         {Modus : 101h/480x640x256}
  INTR($10,Regs);     {Initialisiere VESA-Modus}
 END;

 InitSetVESAPixPascal;
 Zeit := Timer;
  FOR j := 0 TO 479 DO
   FOR i := 0 TO 639 DO
    SetVESAPixPascal(i,j,4);
 Zeit := Timer - Zeit;

 Regs.AX := $0003;
 INTR($10,Regs);     {Zurck in den Textmodus}
 GotoXY(10,10);
 Write('Nun kommt die Assembler-Routine!');
 ReadLn;
 WITH Regs DO BEGIN
  AX := $4F02;
  BX := $101;         {Modus : 101h/640x480x256}
  INTR($10,Regs);     {Initialisiere VESA-Modus}
 END;

 InitSetVESAPixASM;
 Zeit2 := Timer;
  FOR j := 0 TO 479 DO
   FOR i := 0 TO 639 DO
    SetVESAPixASM(i,j,4);
 Zeit2 := Timer - Zeit2;
 Regs.AX := $0003;
 INTR($10,Regs);     {Zurck in den Textmodus}
 GotoXY(10,10);
  WriteLn('Pascal-Zeit   : ',Zeit:1:2);
 GotoXY(10,11);
  Write  ('Assembler-Zeit: ',Zeit2:1:2);
 ReadLn;
END.