#include "Renderer.h"

HINSTANCE	hinstance = NULL;
HWND		hwnd = NULL;
bool		done = false;
CRenderer	Renderer;

void	ErrorMessage( const char* Text ){
	MessageBox( NULL, Text, "Error", MB_OK );
}

LRESULT CALLBACK WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam ){
	switch ( uMsg ){
		case WM_SYSCOMMAND:
			switch (wParam)
			{
				case SC_SCREENSAVE:
				case SC_MONITORPOWER:
				return 0;
			}
			break;
		case WM_SIZE:
			Renderer.OnResize( LOWORD(lParam),HIWORD(lParam));
			break;
		case WM_CLOSE:
			PostQuitMessage(0);
			return 0;
		case WM_KEYDOWN:
			if ( wParam == 27 ) PostQuitMessage( 0 );
			return 0;
	}
	return DefWindowProc( hWnd, uMsg, wParam, lParam );
}

bool DestroyMainWindow(){
	bool b_result = true;
	ChangeDisplaySettings( NULL, 0 );
	ShowCursor( true );
	if ( !DestroyWindow( hwnd ) ){
		b_result = false;
	}
	hwnd = NULL;
	if ( !UnregisterClass( "water",hinstance) ){
		b_result = false;
	}
	hinstance = NULL;
	return b_result;
}

bool	CreateMainWindow(){
	WNDCLASS				wc;
	DWORD					wnd_ex_style;
	DWORD					wnd_style;
	RECT					wnd_rect;
	wnd_rect.left			= 64;
	wnd_rect.right			= 640;
	wnd_rect.top			= 64;
	wnd_rect.bottom			= 480;

	hinstance				= GetModuleHandle( NULL );
	wc.style				= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc			= (WNDPROC)WndProc;
	wc.cbClsExtra			= 0;
	wc.cbWndExtra			= 0;
	wc.hInstance			= hinstance;
	wc.hIcon				= LoadIcon( hinstance, IDI_APPLICATION );
	wc.hCursor				= LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground		= NULL;
	wc.lpszMenuName			= NULL;
	wc.lpszClassName		= "water";
	if ( !RegisterClass( &wc ) ){
		return false;
	}
/*	if ( b_fullscreen ){
		DEVMODE					scr_set;
		scr_set.dmSize			= sizeof( scr_set );
		scr_set.dmPelsWidth		= 640;
		scr_set.dmPelsHeight	= 480;
		scr_set.dmBitsPerPel	= 32;
		scr_set.dmFields		= DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
		if ( ChangeDisplaySettings( &scr_set, CDS_FULLSCREEN ) != DISP_CHANGE_SUCCESSFUL ){
			return false;
		}
	}
	if ( b_fullscreen ){
		ShowCursor( false );
		wnd_ex_style			= WS_EX_APPWINDOW;
		wnd_style				= WS_POPUP;
	}else{*/
		wnd_ex_style			= WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
		wnd_style				= WS_OVERLAPPEDWINDOW;
//	}
	AdjustWindowRectEx( &wnd_rect, wnd_style, FALSE, wnd_ex_style );

	if ( !( hwnd = CreateWindowEx( wnd_ex_style, "water", "GLSL water",
			wnd_style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, 0, 0,
			wnd_rect.right - wnd_rect.left,
			wnd_rect.bottom - wnd_rect.top,
			NULL, NULL, hinstance, NULL ) ) ){
		DestroyMainWindow();
		return false;
	}
	SetForegroundWindow( hwnd );
	ShowWindow( hwnd, SW_SHOW );
	SetFocus( hwnd );
	return true;
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG msg;
	if ( !CreateMainWindow() ){
		ErrorMessage( "Can't create window" );
		PostQuitMessage( 1 );
	}
	if ( !Renderer.Init( hwnd ) ){
		ErrorMessage( "Can't initialize render" );
		PostQuitMessage( 1 );
	}
	Renderer.OnResize( 640, 480 );
	if ( !Renderer.LoadResources() ) ErrorMessage( "Error(s) loading resources" );
	while( !done ){
		if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) ){
			if ( msg.message == WM_QUIT ){
				done = true;
			}else{
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
		}else{
			Sleep( 10 );
			Renderer.RenderScene();
		}
	}
	Renderer.Deinit();
	DestroyMainWindow();
	return 0;
}
