#pragma once

#include <windows.h>
#include <math.h>
#include <gl/glu.h>
#include "glext.h"
#include "il.h"
#include "ilu.h"
#include "ilut.h"

typedef unsigned int			uint;
typedef unsigned short			ushort;
typedef unsigned char			byte;
typedef unsigned __int64		uint64;

class	float3{
public:
	union{
		struct{
			float x, y, z;
		};
		float _p[3];
	};
	void	Set( float _x, float _y, float _z ){
		x=_x; y=_y; z=_z;
	}
	float	Length(){
		return sqrtf( x*x + y*y + z*z );
	}
	float3&	Normalize(){
		float Len = Length();
		if ( Len == 0.0f ) Len = 1.0f;
		float il = 1.0f / Len;
		x *= il;
		y *= il;
		z *= il;
		return *this;
	}
	float3 Inversed(){
		return float3( -x,-y,-z );
	}
	float3(){
		x = y = z = 0;
	}
	float3( float _x, float _y, float _z ){
		Set( _x, _y, _z );
	}
};

class float2{
public:
	union{
		struct{
			float	x, y;
		};
		float _p[ 2 ];
	};
	float2 set( float xx, float yy ){
		x = xx; y = yy;
		return *this;
	}
	float2(){
		x = y = 0;
	}
	float2( float xx, float yy ){
		set( xx, yy );
	}
};
