#pragma once

#include "Extensions.h"

class	CShader{
protected:
	GLhandleARB		ProgramObject;
	GLhandleARB		VertexShader;
	GLhandleARB		FragmentShader;
	const char*		VertexCode;
	const char*		FragmentCode;
	float			TimePos;
	void			CheckErrors( GLhandleARB h, GLenum param );
public:
	float			TimeSpeed;
	bool			Compile( const char* vp, const char* fp );
	void			Bind( float DeltaTime );
	void			Unbind();
	void			Unload();
	CShader(){
		TimeSpeed		= 1.0f;
		TimePos			= 0.0f;
		ProgramObject	= NULL;
		VertexShader	= NULL;
		FragmentShader	= NULL;
		VertexCode		= NULL;
		FragmentCode	= NULL;
	}
	virtual ~CShader(){
		Unload();
	}
};
