#pragma once

#include "Map.h"
#include "Mesh.h"
#include "Water.h"
#include "Timer.h"

struct	CCamera{
	float3		Pos;
	float3		Target;
	void		Apply();
	void		ApplyReflected();
	CCamera(){}
	~CCamera(){}
};

class	CRenderer{
private:
	static const double ClipReflect[];
	static const double ClipRefract[];
	int			ScrWidth;
	int			ScrHeight;
	float		DeltaTime;
	HWND		hWND;
	HDC			hDC;
	HGLRC		hRC;
	CCamera		Camera;
	CMap		ReflectMap;
	CMap		RefractMap;
	CMap		IslandMap;
	CMap		SkyMap;
	CMap		NormalMap;
	CMap		BiplaneMap;
	CWater		Water;
	CMesh		Island;
	CMesh		Bottom;
	CMesh		Sky;
	CMesh		Biplane;
	CTimer		SyncTimer;
	bool		ExistsExtension( const char* Ext );
	bool		InitExtensions();
public:
	bool		LoadResources();
	bool		Init( HWND hwnd );
	void		Deinit();
	void		RenderObjects();
	void		RenderScene();
	void		RenderToReflectMap();
	void		RenderToRefractMap();
	void		RefreshViewport();
	void		OnResize( int Width, int Height );
	CRenderer(){
		hWND = NULL;
		hDC = NULL;
		hRC = NULL;
		ScrWidth = 0;
		ScrHeight = 0;
		DeltaTime = 0;
		Camera.Pos.Set( 0, 0.5f, 3.5f );
		Camera.Target.Set( 0.2f, 0, 0.4f );
	}
	~CRenderer(){
		Deinit();
	}
};
