#pragma once

#include "Types.h"

struct	Vertex{
	float3		Coord;
	float3		Normal;
	float2		UV;
};

class	CMesh{
protected:
	int			VerticesCount;
	int			IndicesCount;
	GLuint		ID[2];
	Vertex*		Vertices;
	uint*		Indices;
	void		Alloc();
	void		Upload();
	void		Unload();
public:
	bool		Load3ds( const char* Name );
	void		Free();
	void		Render();
	CMesh(){
		ID[0] = ID[1] = 0;
		VerticesCount = IndicesCount = 0;
		Vertices = NULL;
		Indices = NULL;
	}
	virtual ~CMesh(){
		Free();
	}
};
