#include "Main.h"
#include "ShaderObject.h"

ShaderObject::ShaderObject(GLhandleARB handle)
: m_Handle(handle)
{

}

ShaderObject::~ShaderObject()
{
  glDeleteObjectARB(m_Handle);
}

void ShaderObject::SourceFromFile(ifstream& file)
{
  char temp[1024];
  vector<string>      source;
  vector<const char*> sourcePointer;
  vector<int>         sourceLength;
  while(!file.eof())
  {
    file.getline(temp, 1023);
    source.push_back(temp);
  }
  for(vector<string>::iterator i = source.begin(); i != source.end(); i++)
  {
    sourcePointer.push_back(i->c_str());
    sourceLength.push_back(i->size());
  }
  glShaderSourceARB(m_Handle, source.size(), &*sourcePointer.begin(), &*sourceLength.begin());
}

void ShaderObject::Compile()
{
  glCompileShaderARB(m_Handle);
}