#include "vector.h"

#include <cmath>
#include <cstdio>


/**
 *	Normalize the vector `input` and return result in `normalize`
 */
void vec_normalize(vector3 &normalize, vector3 const &input) {

	// calculate vector length
	float length = 
		sqrt(
			input.x * input.x + 
			input.y * input.y + 
			input.z * input.z
		);
	
	// normalize vector
	normalize.x = input.x / length;
	normalize.y = input.y / length;
	normalize.z = input.z / length;
}


/** 
 *	Determine the direction vector of `from` to `to` (normalized)
 */
void vec_direction_vector(vector3 &dVec, vector3 const &from, vector3 const &to) {
	vector3 v;
	
	v.x = from.x - to.x;
	v.y = from.y - to.y;
	v.z = from.z - to.z;
	
	vec_normalize(dVec, v);
}

float vec_dotproduct(vector3 const &a, vector3 const &b) {
	
	return 
		a.x * b.x + 
		a.y * b.y + 
		a.z * b.z;
}


/**
 *	Calculate the length of a vector
 */
float vec_length(vector3 const &vec) {
	return sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
}
